/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.map;

import com.questdb.ql.map.ColumnTypeResolver;
import com.questdb.ql.map.DirectMap;
import com.questdb.ql.map.DirectMapEntry;
import com.questdb.ql.map.DirectMapValues;
import com.questdb.ql.map.TypeListResolver;
import com.questdb.std.Chars;
import com.questdb.std.IntList;
import com.questdb.std.Numbers;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DirectMapTest {
    private static final IntList COLUMN_TYPES = new IntList();
    private static final IntList KEY_TYPES = new IntList();
    private static final ColumnTypeResolver KEY_RESOLVER = new TypeListResolver().of(KEY_TYPES);
    private static final ColumnTypeResolver VALUE_RESOLVER = new TypeListResolver().of(COLUMN_TYPES);

    @BeforeClass
    public static void setUp() {
        COLUMN_TYPES.add(3);
        COLUMN_TYPES.add(4);
        COLUMN_TYPES.add(2);
        COLUMN_TYPES.add(1);
        COLUMN_TYPES.add(6);
        COLUMN_TYPES.add(5);
        KEY_TYPES.add(7);
        KEY_TYPES.add(4);
        KEY_TYPES.add(0);
        KEY_TYPES.add(3);
        KEY_TYPES.add(2);
        KEY_TYPES.add(1);
        KEY_TYPES.add(6);
        KEY_TYPES.add(5);
        KEY_TYPES.add(4);
        KEY_TYPES.add(7);
        KEY_TYPES.add(1);
    }

    @Test
    public void testAllKeysAndCursor() {
        Rnd rnd = new Rnd();
        int addressSize = 0x200000;
        long address = Unsafe.malloc((long)0x200000L);
        int tmpSize = 140;
        long tmp = Unsafe.malloc((long)140L);
        DirectMap map = new DirectMap(1024, KEY_RESOLVER, VALUE_RESOLVER);
        StringSink sink = new StringSink();
        HashMap<String, MapValue> hashMap = new HashMap<String, MapValue>();
        for (int i = 0; i < 1000; ++i) {
            sink.clear();
            DirectMap.KeyWriter w = map.keyWriter();
            long l = address;
            CharSequence cs = rnd.nextChars(rnd.nextInt() % 64);
            long l2 = rnd.nextLong();
            boolean b = rnd.nextBoolean();
            int ii = rnd.nextInt();
            short s = (short)rnd.nextInt();
            byte by = (byte)rnd.nextInt();
            double d = rnd.nextDouble();
            float f = rnd.nextFloat();
            CharSequence s2 = rnd.nextBoolean() ? null : cs;
            w.put(tmp, Chars.strcpyw((CharSequence)cs, (long)tmp));
            w.putLong(l2);
            w.putBool(b);
            w.putInt(ii);
            w.putShort(s);
            w.putByte(by);
            w.putDouble(d);
            w.putFloat(f);
            w.putLong(l2);
            w.putStr(s2);
            w.putByte(by);
            long l = DirectMapTest.put(l, cs);
            l = DirectMapTest.put(l, l2);
            l = DirectMapTest.put(l, b);
            l = DirectMapTest.put(l, ii);
            l = DirectMapTest.put(l, s);
            l = DirectMapTest.put(l, by);
            l = DirectMapTest.put(l, d);
            l = DirectMapTest.put(l, f);
            l = DirectMapTest.put(l, l2);
            l = DirectMapTest.put(l, s2);
            l = DirectMapTest.put(l, by);
            MapValue v = new MapValue();
            DirectMapValues values = map.getOrCreateValues();
            v.i = rnd.nextPositiveInt();
            values.putInt(0, v.i);
            v.l = rnd.nextPositiveLong();
            values.putLong(1, v.l);
            v.s = (short)rnd.nextInt();
            values.putShort(2, v.s);
            v.bt = (byte)rnd.nextInt();
            values.putByte(3, v.bt);
            v.d = rnd.nextDouble();
            values.putDouble(4, v.d);
            v.f = rnd.nextFloat();
            values.putFloat(5, v.f);
            hashMap.put(DirectMapTest.toStr(sink, address, l), v);
        }
        Assert.assertEquals((long)hashMap.size(), (long)map.size());
        HashMap<Long, MapValue> rowidMap = new HashMap<Long, MapValue>();
        for (DirectMapEntry directMapEntry : map) {
            long p = address;
            CharSequence csA = directMapEntry.getFlyweightStr(6);
            CharSequence csB = directMapEntry.getFlyweightStrB(6);
            TestUtils.assertEquals(csA, csB);
            p = DirectMapTest.put(p, csA);
            p = DirectMapTest.put(p, directMapEntry.getLong(7));
            p = DirectMapTest.put(p, directMapEntry.getBool(8));
            p = DirectMapTest.put(p, directMapEntry.getInt(9));
            p = DirectMapTest.put(p, directMapEntry.getShort(10));
            p = DirectMapTest.put(p, directMapEntry.get(11));
            p = DirectMapTest.put(p, directMapEntry.getDouble(12));
            p = DirectMapTest.put(p, directMapEntry.getFloat(13));
            p = DirectMapTest.put(p, directMapEntry.getDate(14));
            String s = directMapEntry.getStr(15);
            p = DirectMapTest.put(p, s);
            sink.clear();
            directMapEntry.getStr(15, (CharSink)sink);
            if (s == null) {
                Assert.assertEquals((long)0L, (long)sink.length());
                Assert.assertEquals((long)-1L, (long)directMapEntry.getStrLen(15));
            } else {
                TestUtils.assertEquals((CharSequence)s, (CharSequence)sink);
                Assert.assertEquals((long)s.length(), (long)directMapEntry.getStrLen(15));
            }
            p = DirectMapTest.put(p, directMapEntry.get(16));
            sink.clear();
            MapValue v = (MapValue)hashMap.get(DirectMapTest.toStr(sink, address, p));
            Assert.assertEquals((long)v.i, (long)directMapEntry.getInt(0));
            Assert.assertEquals((long)v.l, (long)directMapEntry.getLong(1));
            Assert.assertEquals((long)v.s, (long)directMapEntry.getShort(2));
            Assert.assertEquals((long)v.bt, (long)directMapEntry.get(3));
            Assert.assertEquals((double)v.d, (double)directMapEntry.getDouble(4), (double)1.0E-9);
            Assert.assertEquals((float)v.f, (float)directMapEntry.getFloat(5), (float)1.0E-10f);
            rowidMap.put(directMapEntry.getRowId(), v);
        }
        for (Map.Entry entry : rowidMap.entrySet()) {
            DirectMapEntry e = map.entryAt(((Long)entry.getKey()).longValue());
            MapValue v = (MapValue)entry.getValue();
            Assert.assertEquals((long)v.i, (long)e.getInt(0));
            Assert.assertEquals((long)v.l, (long)e.getLong(1));
            Assert.assertEquals((long)v.s, (long)e.getShort(2));
            Assert.assertEquals((long)v.bt, (long)e.get(3));
            Assert.assertEquals((double)v.d, (double)e.getDouble(4), (double)1.0E-9);
            Assert.assertEquals((float)v.f, (float)e.getFloat(5), (float)1.0E-10f);
        }
        map.clear();
        Assert.assertEquals((long)0L, (long)map.size());
        int count = 0;
        for (DirectMapEntry ignored : map) {
            ++count;
        }
        Assert.assertEquals((long)0L, (long)count);
        map.close();
        Unsafe.free((long)address, (long)0x200000L);
        Unsafe.free((long)tmp, (long)140L);
    }

    @Test
    public void testValuesReadWrite() {
        DirectMap map = new DirectMap(1024, KEY_RESOLVER, VALUE_RESOLVER);
        HashMap<String, MapValue> hashMap = new HashMap<String, MapValue>();
        Rnd rnd = new Rnd();
        int n = 1000;
        for (int i = 0; i < n; ++i) {
            DirectMap.KeyWriter w = map.keyWriter();
            String s = rnd.nextString(rnd.nextPositiveInt() % 32);
            w.putStr((CharSequence)s);
            MapValue v = new MapValue();
            DirectMapValues values = map.getOrCreateValues();
            v.i = rnd.nextPositiveInt();
            values.putInt(0, v.i);
            v.l = rnd.nextPositiveLong();
            values.putLong(1, v.l);
            v.s = (short)rnd.nextInt();
            values.putShort(2, v.s);
            v.bt = (byte)rnd.nextInt();
            values.putByte(3, v.bt);
            v.d = rnd.nextDouble();
            values.putDouble(4, v.d);
            v.f = rnd.nextFloat();
            values.putFloat(5, v.f);
            hashMap.put(s, v);
        }
        for (Map.Entry me : hashMap.entrySet()) {
            DirectMap.KeyWriter kw = map.keyWriter();
            kw.putStr((CharSequence)me.getKey());
            DirectMapValues values = map.getValues();
            Assert.assertNotNull((Object)values);
            MapValue v = (MapValue)me.getValue();
            Assert.assertEquals((long)v.i, (long)values.getInt(0));
            Assert.assertEquals((long)v.l, (long)values.getLong(1));
            Assert.assertEquals((long)v.s, (long)values.getShort(2));
            Assert.assertEquals((long)v.bt, (long)values.getByte(3));
            Assert.assertEquals((double)v.d, (double)values.getDouble(4), (double)1.0E-9);
            Assert.assertEquals((float)v.f, (float)values.getFloat(5), (float)1.0E-10f);
        }
        map.close();
    }

    private static long put(long address, CharSequence cs) {
        if (cs == null) {
            return address;
        }
        return address + (long)Chars.strcpyw((CharSequence)cs, (long)address);
    }

    private static long put(long address, long value) {
        Unsafe.getUnsafe().putLong(address, value);
        return address + 8L;
    }

    private static String toStr(StringSink s, long lo, long hi) {
        for (long p = lo; p < hi; ++p) {
            Numbers.appendHex((CharSink)s, (int)Unsafe.getUnsafe().getByte(p));
        }
        return s.toString();
    }

    private static long put(long address, boolean value) {
        Unsafe.getUnsafe().putByte(address, (byte)(value ? 1 : 0));
        return address + 1L;
    }

    private static long put(long address, int value) {
        Unsafe.getUnsafe().putInt(address, value);
        return address + 4L;
    }

    private static long put(long address, byte value) {
        Unsafe.getUnsafe().putByte(address, value);
        return address + 1L;
    }

    private static long put(long address, double value) {
        Unsafe.getUnsafe().putDouble(address, value);
        return address + 1L;
    }

    private static long put(long address, float value) {
        Unsafe.getUnsafe().putFloat(address, value);
        return address + 1L;
    }

    private static class MapValue {
        byte bt;
        double d;
        float f;
        int i;
        long l;
        short s;

        private MapValue() {
        }
    }
}

