/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.join;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.std.Rnd;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.AbstractTest;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MultiColumnJoinTest
extends AbstractTest {
    @Before
    public void setUp() throws Exception {
        this.getFactory().getConfiguration().exists((CharSequence)"");
        try (JournalWriter a = this.getFactory().writer((MetadataBuilder)new JournalStructure("a").$int("x").$str("y").$double("amount").$());
             JournalWriter b = this.getFactory().writer((MetadataBuilder)new JournalStructure("b").$int("x").$str("y").$str("name").$());){
            Rnd rnd = new Rnd();
            for (int i = 0; i < 10; ++i) {
                int x = rnd.nextInt();
                String y = rnd.nextString(rnd.nextPositiveInt() % 15);
                JournalEntryWriter ewa = a.entryWriter();
                JournalEntryWriter ewb = b.entryWriter();
                ewa.putInt(0, x);
                ewa.putStr(1, (CharSequence)y);
                ewa.putDouble(2, rnd.nextDouble());
                ewa.append();
                ewb.putInt(0, x);
                ewb.putStr(1, (CharSequence)y);
                ewb.putStr(2, rnd.nextChars(rnd.nextPositiveInt() % 20));
                ewb.append();
            }
        }
    }

    @Test
    public void testJoinOnThreeFields() throws Exception {
        String expected = "-1148479920\tJWC\t-1024.000000000000\t-1148479920\tJWC\tHYRXPEHNRXG\n339631474\tXUXIBBT\t981.018066406250\t339631474\tXUXIBBT\tWFFYU\n-1125169127\tYYQ\t0.000006369316\t-1125169127\tYYQ\t\n1699553881\tOWLPDXYSBEOUOJ\t0.169966913760\t1699553881\tOWLPDXYSBEOUOJ\tUEDRQQULOFJGETJR\n326010667\tSRYR\t695.796875000000\t326010667\tSRYR\tTMHGOOZZVDZJMYI\n1985398001\tX\t-1024.000000000000\t1985398001\tX\tICWEKGHVU\n532665695\tDO\t632.921875000000\t532665695\tDO\tDYY\n114747951\tGQOLYXWC\t0.000229079233\t114747951\tGQOLYXWC\t\n1254404167\tWDSWUGSHOLNVTI\t770.359375000000\t1254404167\tWDSWUGSHOLNVTI\tXIOVIKJSMSSUQSRLTKV\n-2080340570\tJO\t0.555824235082\t-2080340570\tJO\tHZEPIHVLTOVLJU\n";
        this.assertThat("-1148479920\tJWC\t-1024.000000000000\t-1148479920\tJWC\tHYRXPEHNRXG\n339631474\tXUXIBBT\t981.018066406250\t339631474\tXUXIBBT\tWFFYU\n-1125169127\tYYQ\t0.000006369316\t-1125169127\tYYQ\t\n1699553881\tOWLPDXYSBEOUOJ\t0.169966913760\t1699553881\tOWLPDXYSBEOUOJ\tUEDRQQULOFJGETJR\n326010667\tSRYR\t695.796875000000\t326010667\tSRYR\tTMHGOOZZVDZJMYI\n1985398001\tX\t-1024.000000000000\t1985398001\tX\tICWEKGHVU\n532665695\tDO\t632.921875000000\t532665695\tDO\tDYY\n114747951\tGQOLYXWC\t0.000229079233\t114747951\tGQOLYXWC\t\n1254404167\tWDSWUGSHOLNVTI\t770.359375000000\t1254404167\tWDSWUGSHOLNVTI\tXIOVIKJSMSSUQSRLTKV\n-2080340570\tJO\t0.555824235082\t-2080340570\tJO\tHZEPIHVLTOVLJU\n", "a join b on (x,y)");
    }

    @Test
    public void testNonLiteral() {
        try {
            this.expectFailure("a join b on (1+2)");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)14L, (long)QueryError.getPosition());
        }
    }
}

