/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.collections;

import com.questdb.ql.join.asof.FreeList;
import org.junit.Assert;
import org.junit.Test;

public class FreeListTest {
    @Test
    public void testFindAndRemove() {
        FreeList list = new FreeList();
        list.add(100000L, 11);
        list.add(200000L, 7);
        list.add(300000L, 13);
        list.add(400000L, 15);
        list.add(500000L, 10);
        Assert.assertEquals((long)-1L, (long)list.findAndRemove(20));
        Assert.assertEquals((Object)"FreeList{sizes=[7,10,11,13,15], offsets=[200000,500000,100000,300000,400000], maxSize=15}", (Object)list.toString());
        Assert.assertEquals((long)500000L, (long)list.findAndRemove(10));
        Assert.assertEquals((Object)"FreeList{sizes=[7,11,13,15], offsets=[200000,100000,300000,400000], maxSize=15}", (Object)list.toString());
        Assert.assertEquals((long)200000L, (long)list.findAndRemove(6));
        Assert.assertEquals((Object)"FreeList{sizes=[11,13,15], offsets=[100000,300000,400000], maxSize=15}", (Object)list.toString());
        Assert.assertEquals((long)100000L, (long)list.findAndRemove(10));
        Assert.assertEquals((Object)"FreeList{sizes=[13,15], offsets=[300000,400000], maxSize=15}", (Object)list.toString());
        Assert.assertEquals((long)400000L, (long)list.findAndRemove(15));
        Assert.assertEquals((long)-1L, (long)list.findAndRemove(14));
        Assert.assertEquals((long)300000L, (long)list.findAndRemove(13));
        Assert.assertEquals((long)-1L, (long)list.findAndRemove(15));
        Assert.assertEquals((Object)"FreeList{sizes=[], offsets=[], maxSize=13}", (Object)list.toString());
        Assert.assertEquals((long)-1L, (long)list.findAndRemove(10));
        Assert.assertEquals((Object)"FreeList{sizes=[], offsets=[], maxSize=-1}", (Object)list.toString());
        list.add(13000L, 20);
        Assert.assertEquals((long)13000L, (long)list.findAndRemove(15));
        Assert.assertEquals((Object)"FreeList{sizes=[], offsets=[], maxSize=20}", (Object)list.toString());
    }

    @Test
    public void testSimple() {
        FreeList list = new FreeList();
        list.add(100000L, 11);
        list.add(200000L, 7);
        list.add(300000L, 14);
        list.add(400000L, 15);
        list.add(500000L, 10);
        Assert.assertEquals((Object)"FreeList{sizes=[7,10,11,14,15], offsets=[200000,500000,100000,300000,400000], maxSize=15}", (Object)list.toString());
    }
}

