/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.AbstractAllTypeTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PrevAnalyticFunctionTest
extends AbstractAllTypeTest {
    private static final String expected = "-1148479920\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n1548800833\tKK\t2016-05-01T10:22:00.000Z\tNaN\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1548800833\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t73575701\n1868723706\tAX\t2016-05-01T10:25:00.000Z\tNaN\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t1868723706\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t1326447242\n806715481\tAX\t2016-05-01T10:28:00.000Z\t-1191262516\n1569490116\tXX\t2016-05-01T10:29:00.000Z\tNaN\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t-1148479920\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-1436881714\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1569490116\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t806715481\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t1125579207\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1432278050\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t1530831067\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t-1844391305\n1404198\tXX\t2016-05-01T10:38:00.000Z\t-1532328444\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t-85170055\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t-1125169127\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t1404198\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t-1975183723\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t-409854405\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t-2119387831\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t1699553881\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-1101822104\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t-422941535\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t1253890363\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t-547127752\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-2132716300\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t264240638\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t-303295973\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t1890602616\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t-483853667\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t68265578\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t-461611463\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t-2002373666\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t-2144581835\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t1232884790\n936627841\tKK\t2016-05-01T11:00:00.000Z\t2031014705\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t936627841\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t458818940\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-667031149\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t1637847416\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1418341054\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t-1787109293\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t-2034804966\n636045524\tAX\t2016-05-01T11:08:00.000Z\t-1515787781\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t636045524\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-1575135393\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t161592763\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t-372268574\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t-1299391311\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t-1538602195\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t1857212401\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t-10505757\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t-1819240775\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1566901076\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t-1201923128\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t1196016669\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t-443320374\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t-1582495445\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t532665695\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t-45567293\n114747951\tAX\t2016-05-01T11:25:00.000Z\t1234796102\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t114747951\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-916132123\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t-1794809330\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-373499303\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t1876812930\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-731466113\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t-1723887671\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t-2075675260\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t-882371473\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t-712702244\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t1795359355\n865832060\tXX\t2016-05-01T11:37:00.000Z\t-1172180184\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t-1768335227\n838743782\tAX\t2016-05-01T11:39:00.000Z\t1235206821\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t-1966408995\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t838743782\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t-876466531\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t1107889075\n519895483\tAX\t2016-05-01T11:44:00.000Z\t-618037497\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t-68027832\n602835017\tAX\t2016-05-01T11:46:00.000Z\t519895483\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t602835017\n614536941\tXX\t2016-05-01T11:48:00.000Z\t865832060\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t-2111250190\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t-2043803188\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t-2088317486\n116799613\tKK\t2016-05-01T11:52:00.000Z\t-283321892\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t1658228795\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t116799613\n1015055928\tXX\t2016-05-01T11:55:00.000Z\t614536941\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1238491107\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t1598679468\n-805434743\tAX\t2016-05-01T11:58:00.000Z\t1362833895\n-640305320\tKK\t2016-05-01T11:59:00.000Z\t-636975106\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\t1100812407\n";

    @BeforeClass
    public static void setup() {
        FACTORY_CONTAINER.getFactory().getConfiguration().exists((CharSequence)"");
    }

    @Test
    public void testAggregationContext() {
        try {
            this.expectFailure("select sym, sum(d) x, prev(x) over() from abc");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)22L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBoolOrdered() throws Exception {
        String expected = "8920866532787660373\ttrue\t2016-05-01T10:21:00.000Z\ttrue\n-6943924477733600060\tfalse\t2016-05-01T10:22:00.000Z\tfalse\n-6856503215590263904\tfalse\t2016-05-01T10:23:00.000Z\tfalse\n8416773233910814357\tfalse\t2016-05-01T10:24:00.000Z\tfalse\n7199909180655756830\ttrue\t2016-05-01T10:25:00.000Z\tfalse\n6270672455202306717\ttrue\t2016-05-01T10:26:00.000Z\ttrue\n-6253307669002054137\tfalse\t2016-05-01T10:27:00.000Z\tfalse\n7392877322819819290\ttrue\t2016-05-01T10:28:00.000Z\ttrue\n-7316123607359392486\tfalse\t2016-05-01T10:29:00.000Z\tfalse\n-3107239868490395663\tfalse\t2016-05-01T10:30:00.000Z\tfalse\n-7387846268299105911\tfalse\t2016-05-01T10:31:00.000Z\ttrue\n7122109662042058469\tfalse\t2016-05-01T10:32:00.000Z\ttrue\n-6626590012581323602\tfalse\t2016-05-01T10:33:00.000Z\tfalse\n8611582118025429627\tfalse\t2016-05-01T10:34:00.000Z\tfalse\n-8082754367165748693\ttrue\t2016-05-01T10:35:00.000Z\tfalse\n6574958665733670985\ttrue\t2016-05-01T10:36:00.000Z\ttrue\n3446015290144635451\ttrue\t2016-05-01T10:37:00.000Z\tfalse\n8889492928577876455\ttrue\t2016-05-01T10:38:00.000Z\tfalse\n8152044974329490473\tfalse\t2016-05-01T10:39:00.000Z\ttrue\n-6071768268784020226\tfalse\t2016-05-01T10:40:00.000Z\tfalse\n";
        this.assertThat("8920866532787660373\ttrue\t2016-05-01T10:21:00.000Z\ttrue\n-6943924477733600060\tfalse\t2016-05-01T10:22:00.000Z\tfalse\n-6856503215590263904\tfalse\t2016-05-01T10:23:00.000Z\tfalse\n8416773233910814357\tfalse\t2016-05-01T10:24:00.000Z\tfalse\n7199909180655756830\ttrue\t2016-05-01T10:25:00.000Z\tfalse\n6270672455202306717\ttrue\t2016-05-01T10:26:00.000Z\ttrue\n-6253307669002054137\tfalse\t2016-05-01T10:27:00.000Z\tfalse\n7392877322819819290\ttrue\t2016-05-01T10:28:00.000Z\ttrue\n-7316123607359392486\tfalse\t2016-05-01T10:29:00.000Z\tfalse\n-3107239868490395663\tfalse\t2016-05-01T10:30:00.000Z\tfalse\n-7387846268299105911\tfalse\t2016-05-01T10:31:00.000Z\ttrue\n7122109662042058469\tfalse\t2016-05-01T10:32:00.000Z\ttrue\n-6626590012581323602\tfalse\t2016-05-01T10:33:00.000Z\tfalse\n8611582118025429627\tfalse\t2016-05-01T10:34:00.000Z\tfalse\n-8082754367165748693\ttrue\t2016-05-01T10:35:00.000Z\tfalse\n6574958665733670985\ttrue\t2016-05-01T10:36:00.000Z\ttrue\n3446015290144635451\ttrue\t2016-05-01T10:37:00.000Z\tfalse\n8889492928577876455\ttrue\t2016-05-01T10:38:00.000Z\tfalse\n8152044974329490473\tfalse\t2016-05-01T10:39:00.000Z\ttrue\n-6071768268784020226\tfalse\t2016-05-01T10:40:00.000Z\tfalse\n", "select l, boo, timestamp , prev(boo) over (order by l) from abc");
        this.assertThat("8920866532787660373\ttrue\t2016-05-01T10:21:00.000Z\ttrue\n-6943924477733600060\tfalse\t2016-05-01T10:22:00.000Z\tfalse\n-6856503215590263904\tfalse\t2016-05-01T10:23:00.000Z\tfalse\n8416773233910814357\tfalse\t2016-05-01T10:24:00.000Z\tfalse\n7199909180655756830\ttrue\t2016-05-01T10:25:00.000Z\tfalse\n6270672455202306717\ttrue\t2016-05-01T10:26:00.000Z\ttrue\n-6253307669002054137\tfalse\t2016-05-01T10:27:00.000Z\tfalse\n7392877322819819290\ttrue\t2016-05-01T10:28:00.000Z\ttrue\n-7316123607359392486\tfalse\t2016-05-01T10:29:00.000Z\tfalse\n-3107239868490395663\tfalse\t2016-05-01T10:30:00.000Z\tfalse\n-7387846268299105911\tfalse\t2016-05-01T10:31:00.000Z\ttrue\n7122109662042058469\tfalse\t2016-05-01T10:32:00.000Z\ttrue\n-6626590012581323602\tfalse\t2016-05-01T10:33:00.000Z\tfalse\n8611582118025429627\tfalse\t2016-05-01T10:34:00.000Z\tfalse\n-8082754367165748693\ttrue\t2016-05-01T10:35:00.000Z\tfalse\n6574958665733670985\ttrue\t2016-05-01T10:36:00.000Z\ttrue\n3446015290144635451\ttrue\t2016-05-01T10:37:00.000Z\tfalse\n8889492928577876455\ttrue\t2016-05-01T10:38:00.000Z\tfalse\n8152044974329490473\tfalse\t2016-05-01T10:39:00.000Z\ttrue\n-6071768268784020226\tfalse\t2016-05-01T10:40:00.000Z\tfalse\n", "select l, boo, timestamp , prev(boo) over (order by l) from '*!*abc'");
    }

    @Test
    public void testBoolean() throws Exception {
        String expected = "true\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:22:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:24:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:25:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:26:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:29:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:30:00.000Z\ttrue\nfalse\tXX\t2016-05-01T10:31:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:33:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:35:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:36:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:37:00.000Z\ttrue\ntrue\tAX\t2016-05-01T10:38:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:39:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:40:00.000Z\tfalse\n";
        this.assertThat("true\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:22:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:24:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:25:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:26:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:29:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:30:00.000Z\ttrue\nfalse\tXX\t2016-05-01T10:31:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:33:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:35:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:36:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:37:00.000Z\ttrue\ntrue\tAX\t2016-05-01T10:38:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:39:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:40:00.000Z\tfalse\n", "select boo, str, timestamp , prev(boo) over (partition by str) from abc");
        this.assertThat("true\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:22:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:24:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:25:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:26:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:29:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:30:00.000Z\ttrue\nfalse\tXX\t2016-05-01T10:31:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:33:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:35:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:36:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:37:00.000Z\ttrue\ntrue\tAX\t2016-05-01T10:38:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:39:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:40:00.000Z\tfalse\n", "select boo, str, timestamp , prev(boo) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testBoolean2() throws Exception {
        String expected = "true\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:22:00.000Z\ttrue\nfalse\tKK\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:24:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:25:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:26:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:29:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:30:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:31:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:33:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:35:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:36:00.000Z\ttrue\ntrue\tXX\t2016-05-01T10:37:00.000Z\ttrue\ntrue\tAX\t2016-05-01T10:38:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:39:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:40:00.000Z\tfalse\n";
        this.assertThat("true\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:22:00.000Z\ttrue\nfalse\tKK\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:24:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:25:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:26:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:29:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:30:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:31:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:33:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:35:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:36:00.000Z\ttrue\ntrue\tXX\t2016-05-01T10:37:00.000Z\ttrue\ntrue\tAX\t2016-05-01T10:38:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:39:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:40:00.000Z\tfalse\n", "select boo, str, timestamp , prev(boo) over () from abc");
        this.assertThat("true\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:22:00.000Z\ttrue\nfalse\tKK\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:24:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:25:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:26:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:29:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:30:00.000Z\tfalse\nfalse\tXX\t2016-05-01T10:31:00.000Z\tfalse\nfalse\tKK\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\t2016-05-01T10:33:00.000Z\tfalse\nfalse\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\t2016-05-01T10:35:00.000Z\tfalse\ntrue\tAX\t2016-05-01T10:36:00.000Z\ttrue\ntrue\tXX\t2016-05-01T10:37:00.000Z\ttrue\ntrue\tAX\t2016-05-01T10:38:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:39:00.000Z\ttrue\nfalse\tBZ\t2016-05-01T10:40:00.000Z\tfalse\n", "select boo, str, timestamp , prev(boo) over () from '*!*abc'");
    }

    @Test
    public void testByte() throws Exception {
        String expected = "21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-60\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-95\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t21\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t53\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t-40\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t77\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-120\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t-34\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-69\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-126\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-55\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t-77\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t-83\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-72\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-114\n";
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-60\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-95\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t21\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t53\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t-40\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t77\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-120\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t-34\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-69\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-126\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-55\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t-77\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t-83\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-72\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-114\n", "select b, str, sym, timestamp , prev(b) over (partition by str) from abc");
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-60\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-95\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t21\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t53\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t-40\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t77\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-120\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t-34\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-69\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-126\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-55\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t-77\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t-83\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-72\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-114\n", "select b, str, sym, timestamp , prev(b) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testByte2() throws Exception {
        String expected = "21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t-120\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t-34\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-60\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-95\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-40\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t53\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t77\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-69\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-15\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t-126\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-114\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-55\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-72\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-77\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t-83\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t-36\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-102\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-114\n";
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t-120\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t-34\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-60\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-95\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-40\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t53\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t77\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-69\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-15\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t-126\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-114\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-55\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-72\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-77\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t-83\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t-36\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-102\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-114\n", "select b, str, sym, timestamp , prev(b) over () from abc");
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t-120\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t-34\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-60\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-95\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-40\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t53\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t77\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-69\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-15\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t-126\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-114\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-55\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-72\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-77\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t-83\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t-36\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-102\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-114\n", "select b, str, sym, timestamp , prev(b) over () from '*!*abc'");
    }

    @Test
    public void testByteOrdered() throws Exception {
        String expected = "8920866532787660373\t21\t2016-05-01T10:21:00.000Z\t-102\n-6943924477733600060\t-120\t2016-05-01T10:22:00.000Z\t-69\n-6856503215590263904\t-34\t2016-05-01T10:23:00.000Z\t-120\n8416773233910814357\t-60\t2016-05-01T10:24:00.000Z\t-114\n7199909180655756830\t-95\t2016-05-01T10:25:00.000Z\t-114\n6270672455202306717\t-40\t2016-05-01T10:26:00.000Z\t-36\n-6253307669002054137\t53\t2016-05-01T10:27:00.000Z\t-55\n7392877322819819290\t77\t2016-05-01T10:28:00.000Z\t-95\n-7316123607359392486\t-69\t2016-05-01T10:29:00.000Z\t-126\n-3107239868490395663\t-15\t2016-05-01T10:30:00.000Z\t70\n-7387846268299105911\t-126\t2016-05-01T10:31:00.000Z\t-77\n7122109662042058469\t-114\t2016-05-01T10:32:00.000Z\t-83\n-6626590012581323602\t-55\t2016-05-01T10:33:00.000Z\t-34\n8611582118025429627\t-72\t2016-05-01T10:34:00.000Z\t-60\n-8082754367165748693\t-77\t2016-05-01T10:35:00.000Z\t0\n6574958665733670985\t-83\t2016-05-01T10:36:00.000Z\t-40\n3446015290144635451\t-36\t2016-05-01T10:37:00.000Z\t-15\n8889492928577876455\t-102\t2016-05-01T10:38:00.000Z\t-72\n8152044974329490473\t-114\t2016-05-01T10:39:00.000Z\t77\n-6071768268784020226\t70\t2016-05-01T10:40:00.000Z\t53\n";
        this.assertThat("8920866532787660373\t21\t2016-05-01T10:21:00.000Z\t-102\n-6943924477733600060\t-120\t2016-05-01T10:22:00.000Z\t-69\n-6856503215590263904\t-34\t2016-05-01T10:23:00.000Z\t-120\n8416773233910814357\t-60\t2016-05-01T10:24:00.000Z\t-114\n7199909180655756830\t-95\t2016-05-01T10:25:00.000Z\t-114\n6270672455202306717\t-40\t2016-05-01T10:26:00.000Z\t-36\n-6253307669002054137\t53\t2016-05-01T10:27:00.000Z\t-55\n7392877322819819290\t77\t2016-05-01T10:28:00.000Z\t-95\n-7316123607359392486\t-69\t2016-05-01T10:29:00.000Z\t-126\n-3107239868490395663\t-15\t2016-05-01T10:30:00.000Z\t70\n-7387846268299105911\t-126\t2016-05-01T10:31:00.000Z\t-77\n7122109662042058469\t-114\t2016-05-01T10:32:00.000Z\t-83\n-6626590012581323602\t-55\t2016-05-01T10:33:00.000Z\t-34\n8611582118025429627\t-72\t2016-05-01T10:34:00.000Z\t-60\n-8082754367165748693\t-77\t2016-05-01T10:35:00.000Z\t0\n6574958665733670985\t-83\t2016-05-01T10:36:00.000Z\t-40\n3446015290144635451\t-36\t2016-05-01T10:37:00.000Z\t-15\n8889492928577876455\t-102\t2016-05-01T10:38:00.000Z\t-72\n8152044974329490473\t-114\t2016-05-01T10:39:00.000Z\t77\n-6071768268784020226\t70\t2016-05-01T10:40:00.000Z\t53\n", "select l, b, timestamp , prev(b) over (order by l) from abc");
        this.assertThat("8920866532787660373\t21\t2016-05-01T10:21:00.000Z\t-102\n-6943924477733600060\t-120\t2016-05-01T10:22:00.000Z\t-69\n-6856503215590263904\t-34\t2016-05-01T10:23:00.000Z\t-120\n8416773233910814357\t-60\t2016-05-01T10:24:00.000Z\t-114\n7199909180655756830\t-95\t2016-05-01T10:25:00.000Z\t-114\n6270672455202306717\t-40\t2016-05-01T10:26:00.000Z\t-36\n-6253307669002054137\t53\t2016-05-01T10:27:00.000Z\t-55\n7392877322819819290\t77\t2016-05-01T10:28:00.000Z\t-95\n-7316123607359392486\t-69\t2016-05-01T10:29:00.000Z\t-126\n-3107239868490395663\t-15\t2016-05-01T10:30:00.000Z\t70\n-7387846268299105911\t-126\t2016-05-01T10:31:00.000Z\t-77\n7122109662042058469\t-114\t2016-05-01T10:32:00.000Z\t-83\n-6626590012581323602\t-55\t2016-05-01T10:33:00.000Z\t-34\n8611582118025429627\t-72\t2016-05-01T10:34:00.000Z\t-60\n-8082754367165748693\t-77\t2016-05-01T10:35:00.000Z\t0\n6574958665733670985\t-83\t2016-05-01T10:36:00.000Z\t-40\n3446015290144635451\t-36\t2016-05-01T10:37:00.000Z\t-15\n8889492928577876455\t-102\t2016-05-01T10:38:00.000Z\t-72\n8152044974329490473\t-114\t2016-05-01T10:39:00.000Z\t77\n-6071768268784020226\t70\t2016-05-01T10:40:00.000Z\t53\n", "select l, b, timestamp , prev(b) over (order by l) from '*!*abc'");
    }

    @Test
    public void testColumnNameGeneration() throws Exception {
        this.assertThat("str\tsym\ttimestamp\tcol0\nBZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(sym) over () from abc", true);
    }

    @Test
    public void testCompilation() throws Exception {
        this.assertThat(expected, "select i, str, timestamp, prev(i) over (partition by str) from xyz");
    }

    @Test
    public void testCompileNonPart() throws Exception {
        String expected = "-1148479920\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n1548800833\tKK\t2016-05-01T10:22:00.000Z\t-1148479920\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1548800833\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t73575701\n1868723706\tAX\t2016-05-01T10:25:00.000Z\t1326447242\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t1868723706\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t-1191262516\n806715481\tAX\t2016-05-01T10:28:00.000Z\t-1436881714\n1569490116\tXX\t2016-05-01T10:29:00.000Z\t806715481\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t1569490116\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-409854405\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1530831067\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t-1532328444\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t1125579207\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1432278050\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t-85170055\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t-1844391305\n1404198\tXX\t2016-05-01T10:38:00.000Z\t-1101822104\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t1404198\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t-1125169127\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t-1975183723\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t1232884790\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t-2119387831\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t1699553881\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t1253890363\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-422941535\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t-547127752\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t-303295973\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t-2132716300\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-461611463\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t264240638\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t-483853667\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t1890602616\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t68265578\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t-2002373666\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t458818940\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t-2144581835\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t-1418341054\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t2031014705\n936627841\tKK\t2016-05-01T11:00:00.000Z\t-1575135393\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t936627841\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t-667031149\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-2034804966\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t1637847416\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1819240775\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t-1787109293\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t-1515787781\n636045524\tAX\t2016-05-01T11:08:00.000Z\t161592763\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t636045524\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-1538602195\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t-372268574\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t-1299391311\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t-10505757\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t1857212401\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t-443320374\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t1196016669\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t-1566901076\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1201923128\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t1876812930\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t-1582495445\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t532665695\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t1234796102\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t-45567293\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t-373499303\n114747951\tAX\t2016-05-01T11:25:00.000Z\t-916132123\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t114747951\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-1794809330\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t-731466113\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-882371473\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t-1723887671\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-1172180184\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t-2075675260\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t-712702244\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t-1768335227\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t1235206821\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t1795359355\n865832060\tXX\t2016-05-01T11:37:00.000Z\t-876466531\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t865832060\n838743782\tAX\t2016-05-01T11:39:00.000Z\t-1966408995\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t838743782\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t1107889075\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t-618037497\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t-2043803188\n519895483\tAX\t2016-05-01T11:44:00.000Z\t-68027832\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t519895483\n602835017\tAX\t2016-05-01T11:46:00.000Z\t-2088317486\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t602835017\n614536941\tXX\t2016-05-01T11:48:00.000Z\t-2111250190\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t614536941\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t1598679468\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t1658228795\n116799613\tKK\t2016-05-01T11:52:00.000Z\t-283321892\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t116799613\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t1238491107\n1015055928\tXX\t2016-05-01T11:55:00.000Z\t-636975106\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1015055928\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t1100812407\n-805434743\tAX\t2016-05-01T11:58:00.000Z\t1362833895\n-640305320\tKK\t2016-05-01T11:59:00.000Z\t-805434743\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\t-640305320\n";
        this.assertThat("-1148479920\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n1548800833\tKK\t2016-05-01T10:22:00.000Z\t-1148479920\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1548800833\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t73575701\n1868723706\tAX\t2016-05-01T10:25:00.000Z\t1326447242\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t1868723706\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t-1191262516\n806715481\tAX\t2016-05-01T10:28:00.000Z\t-1436881714\n1569490116\tXX\t2016-05-01T10:29:00.000Z\t806715481\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t1569490116\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-409854405\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1530831067\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t-1532328444\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t1125579207\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1432278050\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t-85170055\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t-1844391305\n1404198\tXX\t2016-05-01T10:38:00.000Z\t-1101822104\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t1404198\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t-1125169127\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t-1975183723\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t1232884790\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t-2119387831\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t1699553881\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t1253890363\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-422941535\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t-547127752\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t-303295973\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t-2132716300\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-461611463\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t264240638\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t-483853667\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t1890602616\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t68265578\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t-2002373666\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t458818940\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t-2144581835\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t-1418341054\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t2031014705\n936627841\tKK\t2016-05-01T11:00:00.000Z\t-1575135393\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t936627841\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t-667031149\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-2034804966\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t1637847416\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1819240775\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t-1787109293\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t-1515787781\n636045524\tAX\t2016-05-01T11:08:00.000Z\t161592763\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t636045524\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-1538602195\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t-372268574\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t-1299391311\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t-10505757\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t1857212401\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t-443320374\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t1196016669\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t-1566901076\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1201923128\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t1876812930\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t-1582495445\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t532665695\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t1234796102\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t-45567293\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t-373499303\n114747951\tAX\t2016-05-01T11:25:00.000Z\t-916132123\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t114747951\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-1794809330\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t-731466113\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-882371473\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t-1723887671\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-1172180184\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t-2075675260\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t-712702244\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t-1768335227\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t1235206821\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t1795359355\n865832060\tXX\t2016-05-01T11:37:00.000Z\t-876466531\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t865832060\n838743782\tAX\t2016-05-01T11:39:00.000Z\t-1966408995\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t838743782\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t1107889075\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t-618037497\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t-2043803188\n519895483\tAX\t2016-05-01T11:44:00.000Z\t-68027832\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t519895483\n602835017\tAX\t2016-05-01T11:46:00.000Z\t-2088317486\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t602835017\n614536941\tXX\t2016-05-01T11:48:00.000Z\t-2111250190\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t614536941\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t1598679468\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t1658228795\n116799613\tKK\t2016-05-01T11:52:00.000Z\t-283321892\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t116799613\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t1238491107\n1015055928\tXX\t2016-05-01T11:55:00.000Z\t-636975106\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1015055928\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t1100812407\n-805434743\tAX\t2016-05-01T11:58:00.000Z\t1362833895\n-640305320\tKK\t2016-05-01T11:59:00.000Z\t-805434743\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\t-640305320\n", "select i, str, timestamp, prev(i) over () from xyz");
        this.assertThat("-1148479920\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n1548800833\tKK\t2016-05-01T10:22:00.000Z\t-1148479920\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1548800833\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t73575701\n1868723706\tAX\t2016-05-01T10:25:00.000Z\t1326447242\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t1868723706\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t-1191262516\n806715481\tAX\t2016-05-01T10:28:00.000Z\t-1436881714\n1569490116\tXX\t2016-05-01T10:29:00.000Z\t806715481\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t1569490116\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-409854405\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1530831067\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t-1532328444\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t1125579207\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1432278050\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t-85170055\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t-1844391305\n1404198\tXX\t2016-05-01T10:38:00.000Z\t-1101822104\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t1404198\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t-1125169127\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t-1975183723\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t1232884790\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t-2119387831\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t1699553881\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t1253890363\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-422941535\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t-547127752\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t-303295973\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t-2132716300\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-461611463\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t264240638\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t-483853667\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t1890602616\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t68265578\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t-2002373666\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t458818940\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t-2144581835\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t-1418341054\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t2031014705\n936627841\tKK\t2016-05-01T11:00:00.000Z\t-1575135393\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t936627841\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t-667031149\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-2034804966\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t1637847416\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1819240775\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t-1787109293\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t-1515787781\n636045524\tAX\t2016-05-01T11:08:00.000Z\t161592763\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t636045524\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-1538602195\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t-372268574\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t-1299391311\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t-10505757\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t1857212401\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t-443320374\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t1196016669\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t-1566901076\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1201923128\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t1876812930\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t-1582495445\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t532665695\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t1234796102\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t-45567293\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t-373499303\n114747951\tAX\t2016-05-01T11:25:00.000Z\t-916132123\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t114747951\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-1794809330\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t-731466113\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-882371473\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t-1723887671\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-1172180184\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t-2075675260\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t-712702244\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t-1768335227\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t1235206821\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t1795359355\n865832060\tXX\t2016-05-01T11:37:00.000Z\t-876466531\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t865832060\n838743782\tAX\t2016-05-01T11:39:00.000Z\t-1966408995\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t838743782\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t1107889075\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t-618037497\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t-2043803188\n519895483\tAX\t2016-05-01T11:44:00.000Z\t-68027832\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t519895483\n602835017\tAX\t2016-05-01T11:46:00.000Z\t-2088317486\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t602835017\n614536941\tXX\t2016-05-01T11:48:00.000Z\t-2111250190\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t614536941\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t1598679468\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t1658228795\n116799613\tKK\t2016-05-01T11:52:00.000Z\t-283321892\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t116799613\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t1238491107\n1015055928\tXX\t2016-05-01T11:55:00.000Z\t-636975106\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1015055928\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t1100812407\n-805434743\tAX\t2016-05-01T11:58:00.000Z\t1362833895\n-640305320\tKK\t2016-05-01T11:59:00.000Z\t-805434743\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\t-640305320\n", "select i, str, timestamp, prev(i) over () from '*!*xyz'");
    }

    @Test
    public void testDate() throws Exception {
        String expected = "277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t-268695905-10-25T00:06:37.492Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t217217443-02-16T18:39:59.220Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t277433687-10-12T08:51:21.932Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t231478896-06-17T12:18:04.767Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t263840408-06-11T18:15:05.778Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t220352915-01-17T00:08:45.841Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t-284210729-04-16T06:37:25.107Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t-142145720-12-30T10:07:22.984Z\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t-230266796-08-17T22:57:03.970Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t18125533-09-05T04:06:38.086Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-201714876-08-10T10:14:48.134Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-253361973-02-05T02:07:37.180Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t-225086326-11-23T21:53:40.936Z\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t252677978-05-07T03:29:33.753Z\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-180947413-05-05T10:19:58.733Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t167791211-12-09T07:52:02.538Z\n";
        this.assertThat("277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t-268695905-10-25T00:06:37.492Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t217217443-02-16T18:39:59.220Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t277433687-10-12T08:51:21.932Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t231478896-06-17T12:18:04.767Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t263840408-06-11T18:15:05.778Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t220352915-01-17T00:08:45.841Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t-284210729-04-16T06:37:25.107Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t-142145720-12-30T10:07:22.984Z\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t-230266796-08-17T22:57:03.970Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t18125533-09-05T04:06:38.086Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-201714876-08-10T10:14:48.134Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-253361973-02-05T02:07:37.180Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t-225086326-11-23T21:53:40.936Z\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t252677978-05-07T03:29:33.753Z\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-180947413-05-05T10:19:58.733Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t167791211-12-09T07:52:02.538Z\n", "select date, str, sym, timestamp , prev(date) over (partition by str) from abc");
        this.assertThat("277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t-268695905-10-25T00:06:37.492Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t217217443-02-16T18:39:59.220Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t277433687-10-12T08:51:21.932Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t231478896-06-17T12:18:04.767Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t263840408-06-11T18:15:05.778Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t220352915-01-17T00:08:45.841Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t-284210729-04-16T06:37:25.107Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t-142145720-12-30T10:07:22.984Z\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t-230266796-08-17T22:57:03.970Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t18125533-09-05T04:06:38.086Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-201714876-08-10T10:14:48.134Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-253361973-02-05T02:07:37.180Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t-225086326-11-23T21:53:40.936Z\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t252677978-05-07T03:29:33.753Z\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-180947413-05-05T10:19:58.733Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t167791211-12-09T07:52:02.538Z\n", "select date, str, sym, timestamp , prev(date) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testDate2() throws Exception {
        String expected = "277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t277433687-10-12T08:51:21.932Z\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t-284210729-04-16T06:37:25.107Z\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t-142145720-12-30T10:07:22.984Z\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t-268695905-10-25T00:06:37.492Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t217217443-02-16T18:39:59.220Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t263840408-06-11T18:15:05.778Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t231478896-06-17T12:18:04.767Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t220352915-01-17T00:08:45.841Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-230266796-08-17T22:57:03.970Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t18125533-09-05T04:06:38.086Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t-201714876-08-10T10:14:48.134Z\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t132059357-01-03T08:27:45.836Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-253361973-02-05T02:07:37.180Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-180947413-05-05T10:19:58.733Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-225086326-11-23T21:53:40.936Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t252677978-05-07T03:29:33.753Z\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t-244304870-03-25T17:50:45.758Z\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-196068605-07-20T05:32:43.747Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t167791211-12-09T07:52:02.538Z\n";
        this.assertThat("277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t277433687-10-12T08:51:21.932Z\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t-284210729-04-16T06:37:25.107Z\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t-142145720-12-30T10:07:22.984Z\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t-268695905-10-25T00:06:37.492Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t217217443-02-16T18:39:59.220Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t263840408-06-11T18:15:05.778Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t231478896-06-17T12:18:04.767Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t220352915-01-17T00:08:45.841Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-230266796-08-17T22:57:03.970Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t18125533-09-05T04:06:38.086Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t-201714876-08-10T10:14:48.134Z\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t132059357-01-03T08:27:45.836Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-253361973-02-05T02:07:37.180Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-180947413-05-05T10:19:58.733Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-225086326-11-23T21:53:40.936Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t252677978-05-07T03:29:33.753Z\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t-244304870-03-25T17:50:45.758Z\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-196068605-07-20T05:32:43.747Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t167791211-12-09T07:52:02.538Z\n", "select date, str, sym, timestamp , prev(date) over () from abc");
        this.assertThat("277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t277433687-10-12T08:51:21.932Z\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t-284210729-04-16T06:37:25.107Z\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t-142145720-12-30T10:07:22.984Z\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t-268695905-10-25T00:06:37.492Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t217217443-02-16T18:39:59.220Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t263840408-06-11T18:15:05.778Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t231478896-06-17T12:18:04.767Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t220352915-01-17T00:08:45.841Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-230266796-08-17T22:57:03.970Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t18125533-09-05T04:06:38.086Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t-201714876-08-10T10:14:48.134Z\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t132059357-01-03T08:27:45.836Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-253361973-02-05T02:07:37.180Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-180947413-05-05T10:19:58.733Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-225086326-11-23T21:53:40.936Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t252677978-05-07T03:29:33.753Z\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t-244304870-03-25T17:50:45.758Z\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-196068605-07-20T05:32:43.747Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t167791211-12-09T07:52:02.538Z\n", "select date, str, sym, timestamp , prev(date) over () from '*!*abc'");
    }

    @Test
    public void testDateOrdered() throws Exception {
        String expected = "8920866532787660373\t277433687-10-12T08:51:21.932Z\t2016-05-01T10:21:00.000Z\t-196068605-07-20T05:32:43.747Z\n-6943924477733600060\t-284210729-04-16T06:37:25.107Z\t2016-05-01T10:22:00.000Z\t-230266796-08-17T22:57:03.970Z\n-6856503215590263904\t-142145720-12-30T10:07:22.984Z\t2016-05-01T10:23:00.000Z\t-284210729-04-16T06:37:25.107Z\n8416773233910814357\t-268695905-10-25T00:06:37.492Z\t2016-05-01T10:24:00.000Z\t167791211-12-09T07:52:02.538Z\n7199909180655756830\t217217443-02-16T18:39:59.220Z\t2016-05-01T10:25:00.000Z\t132059357-01-03T08:27:45.836Z\n6270672455202306717\t263840408-06-11T18:15:05.778Z\t2016-05-01T10:26:00.000Z\t-244304870-03-25T17:50:45.758Z\n-6253307669002054137\t231478896-06-17T12:18:04.767Z\t2016-05-01T10:27:00.000Z\t-253361973-02-05T02:07:37.180Z\n7392877322819819290\t220352915-01-17T00:08:45.841Z\t2016-05-01T10:28:00.000Z\t217217443-02-16T18:39:59.220Z\n-7316123607359392486\t-230266796-08-17T22:57:03.970Z\t2016-05-01T10:29:00.000Z\t-201714876-08-10T10:14:48.134Z\n-3107239868490395663\t18125533-09-05T04:06:38.086Z\t2016-05-01T10:30:00.000Z\t-56977607-10-20T13:10:29.515Z\n-7387846268299105911\t-201714876-08-10T10:14:48.134Z\t2016-05-01T10:31:00.000Z\t-225086326-11-23T21:53:40.936Z\n7122109662042058469\t132059357-01-03T08:27:45.836Z\t2016-05-01T10:32:00.000Z\t252677978-05-07T03:29:33.753Z\n-6626590012581323602\t-253361973-02-05T02:07:37.180Z\t2016-05-01T10:33:00.000Z\t-142145720-12-30T10:07:22.984Z\n8611582118025429627\t-180947413-05-05T10:19:58.733Z\t2016-05-01T10:34:00.000Z\t-268695905-10-25T00:06:37.492Z\n-8082754367165748693\t-225086326-11-23T21:53:40.936Z\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\t252677978-05-07T03:29:33.753Z\t2016-05-01T10:36:00.000Z\t263840408-06-11T18:15:05.778Z\n3446015290144635451\t-244304870-03-25T17:50:45.758Z\t2016-05-01T10:37:00.000Z\t18125533-09-05T04:06:38.086Z\n8889492928577876455\t-196068605-07-20T05:32:43.747Z\t2016-05-01T10:38:00.000Z\t-180947413-05-05T10:19:58.733Z\n8152044974329490473\t167791211-12-09T07:52:02.538Z\t2016-05-01T10:39:00.000Z\t220352915-01-17T00:08:45.841Z\n-6071768268784020226\t-56977607-10-20T13:10:29.515Z\t2016-05-01T10:40:00.000Z\t231478896-06-17T12:18:04.767Z\n";
        this.assertThat("8920866532787660373\t277433687-10-12T08:51:21.932Z\t2016-05-01T10:21:00.000Z\t-196068605-07-20T05:32:43.747Z\n-6943924477733600060\t-284210729-04-16T06:37:25.107Z\t2016-05-01T10:22:00.000Z\t-230266796-08-17T22:57:03.970Z\n-6856503215590263904\t-142145720-12-30T10:07:22.984Z\t2016-05-01T10:23:00.000Z\t-284210729-04-16T06:37:25.107Z\n8416773233910814357\t-268695905-10-25T00:06:37.492Z\t2016-05-01T10:24:00.000Z\t167791211-12-09T07:52:02.538Z\n7199909180655756830\t217217443-02-16T18:39:59.220Z\t2016-05-01T10:25:00.000Z\t132059357-01-03T08:27:45.836Z\n6270672455202306717\t263840408-06-11T18:15:05.778Z\t2016-05-01T10:26:00.000Z\t-244304870-03-25T17:50:45.758Z\n-6253307669002054137\t231478896-06-17T12:18:04.767Z\t2016-05-01T10:27:00.000Z\t-253361973-02-05T02:07:37.180Z\n7392877322819819290\t220352915-01-17T00:08:45.841Z\t2016-05-01T10:28:00.000Z\t217217443-02-16T18:39:59.220Z\n-7316123607359392486\t-230266796-08-17T22:57:03.970Z\t2016-05-01T10:29:00.000Z\t-201714876-08-10T10:14:48.134Z\n-3107239868490395663\t18125533-09-05T04:06:38.086Z\t2016-05-01T10:30:00.000Z\t-56977607-10-20T13:10:29.515Z\n-7387846268299105911\t-201714876-08-10T10:14:48.134Z\t2016-05-01T10:31:00.000Z\t-225086326-11-23T21:53:40.936Z\n7122109662042058469\t132059357-01-03T08:27:45.836Z\t2016-05-01T10:32:00.000Z\t252677978-05-07T03:29:33.753Z\n-6626590012581323602\t-253361973-02-05T02:07:37.180Z\t2016-05-01T10:33:00.000Z\t-142145720-12-30T10:07:22.984Z\n8611582118025429627\t-180947413-05-05T10:19:58.733Z\t2016-05-01T10:34:00.000Z\t-268695905-10-25T00:06:37.492Z\n-8082754367165748693\t-225086326-11-23T21:53:40.936Z\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\t252677978-05-07T03:29:33.753Z\t2016-05-01T10:36:00.000Z\t263840408-06-11T18:15:05.778Z\n3446015290144635451\t-244304870-03-25T17:50:45.758Z\t2016-05-01T10:37:00.000Z\t18125533-09-05T04:06:38.086Z\n8889492928577876455\t-196068605-07-20T05:32:43.747Z\t2016-05-01T10:38:00.000Z\t-180947413-05-05T10:19:58.733Z\n8152044974329490473\t167791211-12-09T07:52:02.538Z\t2016-05-01T10:39:00.000Z\t220352915-01-17T00:08:45.841Z\n-6071768268784020226\t-56977607-10-20T13:10:29.515Z\t2016-05-01T10:40:00.000Z\t231478896-06-17T12:18:04.767Z\n", "select l, date, timestamp , prev(date) over (order by l) from abc");
        this.assertThat("8920866532787660373\t277433687-10-12T08:51:21.932Z\t2016-05-01T10:21:00.000Z\t-196068605-07-20T05:32:43.747Z\n-6943924477733600060\t-284210729-04-16T06:37:25.107Z\t2016-05-01T10:22:00.000Z\t-230266796-08-17T22:57:03.970Z\n-6856503215590263904\t-142145720-12-30T10:07:22.984Z\t2016-05-01T10:23:00.000Z\t-284210729-04-16T06:37:25.107Z\n8416773233910814357\t-268695905-10-25T00:06:37.492Z\t2016-05-01T10:24:00.000Z\t167791211-12-09T07:52:02.538Z\n7199909180655756830\t217217443-02-16T18:39:59.220Z\t2016-05-01T10:25:00.000Z\t132059357-01-03T08:27:45.836Z\n6270672455202306717\t263840408-06-11T18:15:05.778Z\t2016-05-01T10:26:00.000Z\t-244304870-03-25T17:50:45.758Z\n-6253307669002054137\t231478896-06-17T12:18:04.767Z\t2016-05-01T10:27:00.000Z\t-253361973-02-05T02:07:37.180Z\n7392877322819819290\t220352915-01-17T00:08:45.841Z\t2016-05-01T10:28:00.000Z\t217217443-02-16T18:39:59.220Z\n-7316123607359392486\t-230266796-08-17T22:57:03.970Z\t2016-05-01T10:29:00.000Z\t-201714876-08-10T10:14:48.134Z\n-3107239868490395663\t18125533-09-05T04:06:38.086Z\t2016-05-01T10:30:00.000Z\t-56977607-10-20T13:10:29.515Z\n-7387846268299105911\t-201714876-08-10T10:14:48.134Z\t2016-05-01T10:31:00.000Z\t-225086326-11-23T21:53:40.936Z\n7122109662042058469\t132059357-01-03T08:27:45.836Z\t2016-05-01T10:32:00.000Z\t252677978-05-07T03:29:33.753Z\n-6626590012581323602\t-253361973-02-05T02:07:37.180Z\t2016-05-01T10:33:00.000Z\t-142145720-12-30T10:07:22.984Z\n8611582118025429627\t-180947413-05-05T10:19:58.733Z\t2016-05-01T10:34:00.000Z\t-268695905-10-25T00:06:37.492Z\n-8082754367165748693\t-225086326-11-23T21:53:40.936Z\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\t252677978-05-07T03:29:33.753Z\t2016-05-01T10:36:00.000Z\t263840408-06-11T18:15:05.778Z\n3446015290144635451\t-244304870-03-25T17:50:45.758Z\t2016-05-01T10:37:00.000Z\t18125533-09-05T04:06:38.086Z\n8889492928577876455\t-196068605-07-20T05:32:43.747Z\t2016-05-01T10:38:00.000Z\t-180947413-05-05T10:19:58.733Z\n8152044974329490473\t167791211-12-09T07:52:02.538Z\t2016-05-01T10:39:00.000Z\t220352915-01-17T00:08:45.841Z\n-6071768268784020226\t-56977607-10-20T13:10:29.515Z\t2016-05-01T10:40:00.000Z\t231478896-06-17T12:18:04.767Z\n", "select l, date, timestamp , prev(date) over (order by l) from '*!*abc'");
    }

    @Test
    public void testDouble() throws Exception {
        String expected = "1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.000000567185\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-512.000000000000\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t1.050231933594\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.332301996648\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.675451681018\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.000001752813\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t566.734375000000\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.000013792171\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.000076281818\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.000000005555\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.000002473130\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000020896\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.000000014643\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\t512.000000000000\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.007371325744\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-842.000000000000\n";
        this.assertThat("1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.000000567185\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-512.000000000000\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t1.050231933594\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.332301996648\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.675451681018\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.000001752813\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t566.734375000000\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.000013792171\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.000076281818\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.000000005555\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.000002473130\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000020896\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.000000014643\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\t512.000000000000\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.007371325744\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-842.000000000000\n", "select d, str, sym, timestamp , prev(d) over (partition by str) from abc");
        this.assertThat("1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.000000567185\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-512.000000000000\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t1.050231933594\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.332301996648\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.675451681018\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.000001752813\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t566.734375000000\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.000013792171\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.000076281818\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.000000005555\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.000002473130\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000020896\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.000000014643\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\t512.000000000000\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.007371325744\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-842.000000000000\n", "select d, str, sym, timestamp , prev(d) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testDouble2() throws Exception {
        String expected = "1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\t1.050231933594\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\t566.734375000000\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.000013792171\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.000000567185\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-512.000000000000\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.675451681018\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.332301996648\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.000001752813\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.000076281818\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.000000005555\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.000002473130\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t632.921875000000\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.000000020896\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.007371325744\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000014643\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\t512.000000000000\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\t864.000000000000\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.000000157437\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-842.000000000000\n";
        this.assertThat("1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\t1.050231933594\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\t566.734375000000\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.000013792171\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.000000567185\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-512.000000000000\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.675451681018\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.332301996648\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.000001752813\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.000076281818\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.000000005555\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.000002473130\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t632.921875000000\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.000000020896\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.007371325744\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000014643\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\t512.000000000000\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\t864.000000000000\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.000000157437\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-842.000000000000\n", "select d, str, sym, timestamp , prev(d) over () from abc");
        this.assertThat("1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\t1.050231933594\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\t566.734375000000\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.000013792171\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.000000567185\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-512.000000000000\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.675451681018\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.332301996648\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.000001752813\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.000076281818\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.000000005555\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.000002473130\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t632.921875000000\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.000000020896\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.007371325744\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000014643\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\t512.000000000000\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\t864.000000000000\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.000000157437\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\t-842.000000000000\n", "select d, str, sym, timestamp , prev(d) over () from '*!*abc'");
    }

    @Test
    public void testDoubleOrdered() throws Exception {
        String expected = "8920866532787660373\t1.050231933594\t2016-05-01T10:21:00.000Z\t0.000000157437\n-6943924477733600060\t566.734375000000\t2016-05-01T10:22:00.000Z\t0.000076281818\n-6856503215590263904\t0.000013792171\t2016-05-01T10:23:00.000Z\t566.734375000000\n8416773233910814357\t0.000000567185\t2016-05-01T10:24:00.000Z\t-842.000000000000\n7199909180655756830\t-512.000000000000\t2016-05-01T10:25:00.000Z\t632.921875000000\n6270672455202306717\t0.675451681018\t2016-05-01T10:26:00.000Z\t864.000000000000\n-6253307669002054137\t0.332301996648\t2016-05-01T10:27:00.000Z\t0.000000020896\n7392877322819819290\t0.000001752813\t2016-05-01T10:28:00.000Z\t-512.000000000000\n-7316123607359392486\t0.000076281818\t2016-05-01T10:29:00.000Z\t0.000002473130\n-3107239868490395663\t0.000000005555\t2016-05-01T10:30:00.000Z\t0.000032060649\n-7387846268299105911\t0.000002473130\t2016-05-01T10:31:00.000Z\t0.000000014643\n7122109662042058469\t632.921875000000\t2016-05-01T10:32:00.000Z\t512.000000000000\n-6626590012581323602\t0.000000020896\t2016-05-01T10:33:00.000Z\t0.000013792171\n8611582118025429627\t0.007371325744\t2016-05-01T10:34:00.000Z\t0.000000567185\n-8082754367165748693\t0.000000014643\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t512.000000000000\t2016-05-01T10:36:00.000Z\t0.675451681018\n3446015290144635451\t864.000000000000\t2016-05-01T10:37:00.000Z\t0.000000005555\n8889492928577876455\t0.000000157437\t2016-05-01T10:38:00.000Z\t0.007371325744\n8152044974329490473\t-842.000000000000\t2016-05-01T10:39:00.000Z\t0.000001752813\n-6071768268784020226\t0.000032060649\t2016-05-01T10:40:00.000Z\t0.332301996648\n";
        this.assertThat("8920866532787660373\t1.050231933594\t2016-05-01T10:21:00.000Z\t0.000000157437\n-6943924477733600060\t566.734375000000\t2016-05-01T10:22:00.000Z\t0.000076281818\n-6856503215590263904\t0.000013792171\t2016-05-01T10:23:00.000Z\t566.734375000000\n8416773233910814357\t0.000000567185\t2016-05-01T10:24:00.000Z\t-842.000000000000\n7199909180655756830\t-512.000000000000\t2016-05-01T10:25:00.000Z\t632.921875000000\n6270672455202306717\t0.675451681018\t2016-05-01T10:26:00.000Z\t864.000000000000\n-6253307669002054137\t0.332301996648\t2016-05-01T10:27:00.000Z\t0.000000020896\n7392877322819819290\t0.000001752813\t2016-05-01T10:28:00.000Z\t-512.000000000000\n-7316123607359392486\t0.000076281818\t2016-05-01T10:29:00.000Z\t0.000002473130\n-3107239868490395663\t0.000000005555\t2016-05-01T10:30:00.000Z\t0.000032060649\n-7387846268299105911\t0.000002473130\t2016-05-01T10:31:00.000Z\t0.000000014643\n7122109662042058469\t632.921875000000\t2016-05-01T10:32:00.000Z\t512.000000000000\n-6626590012581323602\t0.000000020896\t2016-05-01T10:33:00.000Z\t0.000013792171\n8611582118025429627\t0.007371325744\t2016-05-01T10:34:00.000Z\t0.000000567185\n-8082754367165748693\t0.000000014643\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t512.000000000000\t2016-05-01T10:36:00.000Z\t0.675451681018\n3446015290144635451\t864.000000000000\t2016-05-01T10:37:00.000Z\t0.000000005555\n8889492928577876455\t0.000000157437\t2016-05-01T10:38:00.000Z\t0.007371325744\n8152044974329490473\t-842.000000000000\t2016-05-01T10:39:00.000Z\t0.000001752813\n-6071768268784020226\t0.000032060649\t2016-05-01T10:40:00.000Z\t0.332301996648\n", "select l, d, timestamp , prev(d) over (order by l) from abc");
        this.assertThat("8920866532787660373\t1.050231933594\t2016-05-01T10:21:00.000Z\t0.000000157437\n-6943924477733600060\t566.734375000000\t2016-05-01T10:22:00.000Z\t0.000076281818\n-6856503215590263904\t0.000013792171\t2016-05-01T10:23:00.000Z\t566.734375000000\n8416773233910814357\t0.000000567185\t2016-05-01T10:24:00.000Z\t-842.000000000000\n7199909180655756830\t-512.000000000000\t2016-05-01T10:25:00.000Z\t632.921875000000\n6270672455202306717\t0.675451681018\t2016-05-01T10:26:00.000Z\t864.000000000000\n-6253307669002054137\t0.332301996648\t2016-05-01T10:27:00.000Z\t0.000000020896\n7392877322819819290\t0.000001752813\t2016-05-01T10:28:00.000Z\t-512.000000000000\n-7316123607359392486\t0.000076281818\t2016-05-01T10:29:00.000Z\t0.000002473130\n-3107239868490395663\t0.000000005555\t2016-05-01T10:30:00.000Z\t0.000032060649\n-7387846268299105911\t0.000002473130\t2016-05-01T10:31:00.000Z\t0.000000014643\n7122109662042058469\t632.921875000000\t2016-05-01T10:32:00.000Z\t512.000000000000\n-6626590012581323602\t0.000000020896\t2016-05-01T10:33:00.000Z\t0.000013792171\n8611582118025429627\t0.007371325744\t2016-05-01T10:34:00.000Z\t0.000000567185\n-8082754367165748693\t0.000000014643\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t512.000000000000\t2016-05-01T10:36:00.000Z\t0.675451681018\n3446015290144635451\t864.000000000000\t2016-05-01T10:37:00.000Z\t0.000000005555\n8889492928577876455\t0.000000157437\t2016-05-01T10:38:00.000Z\t0.007371325744\n8152044974329490473\t-842.000000000000\t2016-05-01T10:39:00.000Z\t0.000001752813\n-6071768268784020226\t0.000032060649\t2016-05-01T10:40:00.000Z\t0.332301996648\n", "select l, d, timestamp , prev(d) over (order by l) from '*!*abc'");
    }

    @Test
    public void testFloat() throws Exception {
        String expected = "0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.0204\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.4848\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.6235\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.5725\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.2969\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.5967\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.7780\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.5509\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.1609\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.3509\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.7274\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.5433\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.6746\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\t0.8217\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.5442\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0.1168\n";
        this.assertThat("0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.0204\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.4848\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.6235\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.5725\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.2969\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.5967\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.7780\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.5509\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.1609\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.3509\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.7274\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.5433\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.6746\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\t0.8217\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.5442\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0.1168\n", "select f, str, sym, timestamp , prev(f) over (partition by str) from abc");
        this.assertThat("0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.0204\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.4848\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.6235\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.5725\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.2969\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.5967\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.7780\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.5509\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.1609\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.3509\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.7274\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.5433\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.6746\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\t0.8217\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.5442\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0.1168\n", "select f, str, sym, timestamp , prev(f) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testFloat2() throws Exception {
        String expected = "0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.6235\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\t0.7780\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.5509\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.0204\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.4848\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.2969\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.5725\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.5967\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.1609\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.3509\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.7274\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.5619\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.5433\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.5442\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.6746\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.8217\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\t0.3591\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.6827\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0.1168\n";
        this.assertThat("0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.6235\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\t0.7780\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.5509\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.0204\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.4848\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.2969\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.5725\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.5967\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.1609\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.3509\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.7274\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.5619\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.5433\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.5442\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.6746\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.8217\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\t0.3591\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.6827\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0.1168\n", "select f, str, sym, timestamp , prev(f) over () from abc");
        this.assertThat("0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.6235\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\t0.7780\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.5509\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.0204\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.4848\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.2969\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.5725\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.5967\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.1609\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.3509\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\t0.7274\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.5619\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.5433\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.5442\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.6746\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\t0.8217\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\t0.3591\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.6827\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0.1168\n", "select f, str, sym, timestamp , prev(f) over () from '*!*abc'");
    }

    @Test
    public void testFloatOrdered() throws Exception {
        String expected = "8920866532787660373\t0.6235\t2016-05-01T10:21:00.000Z\t0.6827\n-6943924477733600060\t0.7780\t2016-05-01T10:22:00.000Z\t0.1609\n-6856503215590263904\t0.5509\t2016-05-01T10:23:00.000Z\t0.7780\n8416773233910814357\t0.0204\t2016-05-01T10:24:00.000Z\t0.1168\n7199909180655756830\t0.4848\t2016-05-01T10:25:00.000Z\t0.5619\n6270672455202306717\t0.2969\t2016-05-01T10:26:00.000Z\t0.3591\n-6253307669002054137\t0.5725\t2016-05-01T10:27:00.000Z\t0.5433\n7392877322819819290\t0.5967\t2016-05-01T10:28:00.000Z\t0.4848\n-7316123607359392486\t0.1609\t2016-05-01T10:29:00.000Z\t0.7274\n-3107239868490395663\t0.3509\t2016-05-01T10:30:00.000Z\t0.4967\n-7387846268299105911\t0.7274\t2016-05-01T10:31:00.000Z\t0.6746\n7122109662042058469\t0.5619\t2016-05-01T10:32:00.000Z\t0.8217\n-6626590012581323602\t0.5433\t2016-05-01T10:33:00.000Z\t0.5509\n8611582118025429627\t0.5442\t2016-05-01T10:34:00.000Z\t0.0204\n-8082754367165748693\t0.6746\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t0.8217\t2016-05-01T10:36:00.000Z\t0.2969\n3446015290144635451\t0.3591\t2016-05-01T10:37:00.000Z\t0.3509\n8889492928577876455\t0.6827\t2016-05-01T10:38:00.000Z\t0.5442\n8152044974329490473\t0.1168\t2016-05-01T10:39:00.000Z\t0.5967\n-6071768268784020226\t0.4967\t2016-05-01T10:40:00.000Z\t0.5725\n";
        this.assertThat("8920866532787660373\t0.6235\t2016-05-01T10:21:00.000Z\t0.6827\n-6943924477733600060\t0.7780\t2016-05-01T10:22:00.000Z\t0.1609\n-6856503215590263904\t0.5509\t2016-05-01T10:23:00.000Z\t0.7780\n8416773233910814357\t0.0204\t2016-05-01T10:24:00.000Z\t0.1168\n7199909180655756830\t0.4848\t2016-05-01T10:25:00.000Z\t0.5619\n6270672455202306717\t0.2969\t2016-05-01T10:26:00.000Z\t0.3591\n-6253307669002054137\t0.5725\t2016-05-01T10:27:00.000Z\t0.5433\n7392877322819819290\t0.5967\t2016-05-01T10:28:00.000Z\t0.4848\n-7316123607359392486\t0.1609\t2016-05-01T10:29:00.000Z\t0.7274\n-3107239868490395663\t0.3509\t2016-05-01T10:30:00.000Z\t0.4967\n-7387846268299105911\t0.7274\t2016-05-01T10:31:00.000Z\t0.6746\n7122109662042058469\t0.5619\t2016-05-01T10:32:00.000Z\t0.8217\n-6626590012581323602\t0.5433\t2016-05-01T10:33:00.000Z\t0.5509\n8611582118025429627\t0.5442\t2016-05-01T10:34:00.000Z\t0.0204\n-8082754367165748693\t0.6746\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t0.8217\t2016-05-01T10:36:00.000Z\t0.2969\n3446015290144635451\t0.3591\t2016-05-01T10:37:00.000Z\t0.3509\n8889492928577876455\t0.6827\t2016-05-01T10:38:00.000Z\t0.5442\n8152044974329490473\t0.1168\t2016-05-01T10:39:00.000Z\t0.5967\n-6071768268784020226\t0.4967\t2016-05-01T10:40:00.000Z\t0.5725\n", "select l, f, timestamp , prev(f) over (order by l) from abc");
        this.assertThat("8920866532787660373\t0.6235\t2016-05-01T10:21:00.000Z\t0.6827\n-6943924477733600060\t0.7780\t2016-05-01T10:22:00.000Z\t0.1609\n-6856503215590263904\t0.5509\t2016-05-01T10:23:00.000Z\t0.7780\n8416773233910814357\t0.0204\t2016-05-01T10:24:00.000Z\t0.1168\n7199909180655756830\t0.4848\t2016-05-01T10:25:00.000Z\t0.5619\n6270672455202306717\t0.2969\t2016-05-01T10:26:00.000Z\t0.3591\n-6253307669002054137\t0.5725\t2016-05-01T10:27:00.000Z\t0.5433\n7392877322819819290\t0.5967\t2016-05-01T10:28:00.000Z\t0.4848\n-7316123607359392486\t0.1609\t2016-05-01T10:29:00.000Z\t0.7274\n-3107239868490395663\t0.3509\t2016-05-01T10:30:00.000Z\t0.4967\n-7387846268299105911\t0.7274\t2016-05-01T10:31:00.000Z\t0.6746\n7122109662042058469\t0.5619\t2016-05-01T10:32:00.000Z\t0.8217\n-6626590012581323602\t0.5433\t2016-05-01T10:33:00.000Z\t0.5509\n8611582118025429627\t0.5442\t2016-05-01T10:34:00.000Z\t0.0204\n-8082754367165748693\t0.6746\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t0.8217\t2016-05-01T10:36:00.000Z\t0.2969\n3446015290144635451\t0.3591\t2016-05-01T10:37:00.000Z\t0.3509\n8889492928577876455\t0.6827\t2016-05-01T10:38:00.000Z\t0.5442\n8152044974329490473\t0.1168\t2016-05-01T10:39:00.000Z\t0.5967\n-6071768268784020226\t0.4967\t2016-05-01T10:40:00.000Z\t0.5725\n", "select l, f, timestamp , prev(f) over (order by l) from '*!*abc'");
    }

    @Test
    public void testImplicitOrderFromSubQueryOnRenamedColumn() throws Exception {
        String expected = "BZ\tBZ\t\t2016-05-01T10:21:00.000Z\nBZ\tXX\tBZ\t2016-05-01T10:22:00.000Z\nXX\tKK\t\t2016-05-01T10:23:00.000Z\nXX\tAX\tKK\t2016-05-01T10:24:00.000Z\nXX\tAX\tAX\t2016-05-01T10:25:00.000Z\nBZ\tAX\tXX\t2016-05-01T10:26:00.000Z\nXX\tBZ\tAX\t2016-05-01T10:27:00.000Z\nKK\tBZ\t\t2016-05-01T10:28:00.000Z\nKK\tAX\tBZ\t2016-05-01T10:29:00.000Z\nAX\tBZ\t\t2016-05-01T10:30:00.000Z\nKK\tXX\tAX\t2016-05-01T10:31:00.000Z\nAX\tKK\tBZ\t2016-05-01T10:32:00.000Z\nAX\tAX\tKK\t2016-05-01T10:33:00.000Z\nBZ\tBZ\tAX\t2016-05-01T10:34:00.000Z\nAX\tXX\tAX\t2016-05-01T10:35:00.000Z\nAX\tAX\tXX\t2016-05-01T10:36:00.000Z\nKK\tXX\tXX\t2016-05-01T10:37:00.000Z\nAX\tAX\tAX\t2016-05-01T10:38:00.000Z\nBZ\tBZ\tBZ\t2016-05-01T10:39:00.000Z\nAX\tBZ\tAX\t2016-05-01T10:40:00.000Z\n";
        this.assertThat("BZ\tBZ\t\t2016-05-01T10:21:00.000Z\nBZ\tXX\tBZ\t2016-05-01T10:22:00.000Z\nXX\tKK\t\t2016-05-01T10:23:00.000Z\nXX\tAX\tKK\t2016-05-01T10:24:00.000Z\nXX\tAX\tAX\t2016-05-01T10:25:00.000Z\nBZ\tAX\tXX\t2016-05-01T10:26:00.000Z\nXX\tBZ\tAX\t2016-05-01T10:27:00.000Z\nKK\tBZ\t\t2016-05-01T10:28:00.000Z\nKK\tAX\tBZ\t2016-05-01T10:29:00.000Z\nAX\tBZ\t\t2016-05-01T10:30:00.000Z\nKK\tXX\tAX\t2016-05-01T10:31:00.000Z\nAX\tKK\tBZ\t2016-05-01T10:32:00.000Z\nAX\tAX\tKK\t2016-05-01T10:33:00.000Z\nBZ\tBZ\tAX\t2016-05-01T10:34:00.000Z\nAX\tXX\tAX\t2016-05-01T10:35:00.000Z\nAX\tAX\tXX\t2016-05-01T10:36:00.000Z\nKK\tXX\tXX\t2016-05-01T10:37:00.000Z\nAX\tAX\tAX\t2016-05-01T10:38:00.000Z\nBZ\tBZ\tBZ\t2016-05-01T10:39:00.000Z\nAX\tBZ\tAX\t2016-05-01T10:40:00.000Z\n", "select sym, str, prev(str) over (partition by sym order by x), x from (select timestamp x, sym, str from (abc order by timestamp))");
        this.assertPlan2("{\n  \"op\": \"SelectedColumnsRecordSource\",\n  \"src\": {\n    \"op\": \"CachedRowAnalyticRecordSource\",\n    \"functions\": 1,\n    \"orderedSources\": 1,\n    \"src\": {\n      \"op\": \"SelectedColumnsRecordSource\",\n      \"src\": {\n        \"op\": \"RBTreeSortedRecordSource\",\n        \"byRowId\": true,\n        \"src\": {\n          \"op\": \"JournalRecordSource\",\n          \"psrc\": {\n            \"op\": \"JournalPartitionSource\",\n            \"journal\": \"abc\"\n          },\n          \"rsrc\": {\n            \"op\": \"AllRowSource\"\n          }\n        }\n      }\n    }\n  }\n}", "select sym, str, prev(str) over (partition by sym order by x), x from (select timestamp x, sym, str from (abc order by timestamp))");
    }

    @Test
    public void testImplicitOrderSimple() throws Exception {
        this.assertPlan2("{\n  \"op\": \"RBTreeSortedRecordSource\",\n  \"byRowId\": false,\n  \"src\": {\n    \"op\": \"SelectedColumnsRecordSource\",\n    \"src\": {\n      \"op\": \"CachedRowAnalyticRecordSource\",\n      \"functions\": 1,\n      \"orderedSources\": 1,\n      \"src\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"abc\"\n        },\n        \"rsrc\": {\n          \"op\": \"AllRowSource\"\n        }\n      }\n    }\n  }\n}", "select sym, str, prev(str) over (partition by sym order by timestamp), timestamp from abc order by timestamp");
    }

    @Test
    public void testIntOrdered() throws Exception {
        String expected = "8920866532787660373\t-1148479920\t2016-05-01T10:21:00.000Z\t-1383560599\n-6943924477733600060\t-2041844972\t2016-05-01T10:22:00.000Z\t-1787109293\n-6856503215590263904\t-1532328444\t2016-05-01T10:23:00.000Z\t-2041844972\n8416773233910814357\t-1153445279\t2016-05-01T10:24:00.000Z\t1751526583\n7199909180655756830\t1699553881\t2016-05-01T10:25:00.000Z\t-572338288\n6270672455202306717\t2006313928\t2016-05-01T10:26:00.000Z\t1598679468\n-6253307669002054137\t-2002373666\t2016-05-01T10:27:00.000Z\t-731466113\n7392877322819819290\t-296610933\t2016-05-01T10:28:00.000Z\t1699553881\n-7316123607359392486\t-1787109293\t2016-05-01T10:29:00.000Z\t-1566901076\n-3107239868490395663\t-235358133\t2016-05-01T10:30:00.000Z\t-1475953213\n-7387846268299105911\t-1566901076\t2016-05-01T10:31:00.000Z\t-1966408995\n7122109662042058469\t-572338288\t2016-05-01T10:32:00.000Z\t1335037859\n-6626590012581323602\t-731466113\t2016-05-01T10:33:00.000Z\t-1532328444\n8611582118025429627\t-1389094446\t2016-05-01T10:34:00.000Z\t-1153445279\n-8082754367165748693\t-1966408995\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t1335037859\t2016-05-01T10:36:00.000Z\t2006313928\n3446015290144635451\t1598679468\t2016-05-01T10:37:00.000Z\t-235358133\n8889492928577876455\t-1383560599\t2016-05-01T10:38:00.000Z\t-1389094446\n8152044974329490473\t1751526583\t2016-05-01T10:39:00.000Z\t-296610933\n-6071768268784020226\t-1475953213\t2016-05-01T10:40:00.000Z\t-2002373666\n";
        this.assertThat("8920866532787660373\t-1148479920\t2016-05-01T10:21:00.000Z\t-1383560599\n-6943924477733600060\t-2041844972\t2016-05-01T10:22:00.000Z\t-1787109293\n-6856503215590263904\t-1532328444\t2016-05-01T10:23:00.000Z\t-2041844972\n8416773233910814357\t-1153445279\t2016-05-01T10:24:00.000Z\t1751526583\n7199909180655756830\t1699553881\t2016-05-01T10:25:00.000Z\t-572338288\n6270672455202306717\t2006313928\t2016-05-01T10:26:00.000Z\t1598679468\n-6253307669002054137\t-2002373666\t2016-05-01T10:27:00.000Z\t-731466113\n7392877322819819290\t-296610933\t2016-05-01T10:28:00.000Z\t1699553881\n-7316123607359392486\t-1787109293\t2016-05-01T10:29:00.000Z\t-1566901076\n-3107239868490395663\t-235358133\t2016-05-01T10:30:00.000Z\t-1475953213\n-7387846268299105911\t-1566901076\t2016-05-01T10:31:00.000Z\t-1966408995\n7122109662042058469\t-572338288\t2016-05-01T10:32:00.000Z\t1335037859\n-6626590012581323602\t-731466113\t2016-05-01T10:33:00.000Z\t-1532328444\n8611582118025429627\t-1389094446\t2016-05-01T10:34:00.000Z\t-1153445279\n-8082754367165748693\t-1966408995\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t1335037859\t2016-05-01T10:36:00.000Z\t2006313928\n3446015290144635451\t1598679468\t2016-05-01T10:37:00.000Z\t-235358133\n8889492928577876455\t-1383560599\t2016-05-01T10:38:00.000Z\t-1389094446\n8152044974329490473\t1751526583\t2016-05-01T10:39:00.000Z\t-296610933\n-6071768268784020226\t-1475953213\t2016-05-01T10:40:00.000Z\t-2002373666\n", "select l, i, timestamp , prev(i) over (order by l) from abc");
        this.assertThat("8920866532787660373\t-1148479920\t2016-05-01T10:21:00.000Z\t-1383560599\n-6943924477733600060\t-2041844972\t2016-05-01T10:22:00.000Z\t-1787109293\n-6856503215590263904\t-1532328444\t2016-05-01T10:23:00.000Z\t-2041844972\n8416773233910814357\t-1153445279\t2016-05-01T10:24:00.000Z\t1751526583\n7199909180655756830\t1699553881\t2016-05-01T10:25:00.000Z\t-572338288\n6270672455202306717\t2006313928\t2016-05-01T10:26:00.000Z\t1598679468\n-6253307669002054137\t-2002373666\t2016-05-01T10:27:00.000Z\t-731466113\n7392877322819819290\t-296610933\t2016-05-01T10:28:00.000Z\t1699553881\n-7316123607359392486\t-1787109293\t2016-05-01T10:29:00.000Z\t-1566901076\n-3107239868490395663\t-235358133\t2016-05-01T10:30:00.000Z\t-1475953213\n-7387846268299105911\t-1566901076\t2016-05-01T10:31:00.000Z\t-1966408995\n7122109662042058469\t-572338288\t2016-05-01T10:32:00.000Z\t1335037859\n-6626590012581323602\t-731466113\t2016-05-01T10:33:00.000Z\t-1532328444\n8611582118025429627\t-1389094446\t2016-05-01T10:34:00.000Z\t-1153445279\n-8082754367165748693\t-1966408995\t2016-05-01T10:35:00.000Z\tNaN\n6574958665733670985\t1335037859\t2016-05-01T10:36:00.000Z\t2006313928\n3446015290144635451\t1598679468\t2016-05-01T10:37:00.000Z\t-235358133\n8889492928577876455\t-1383560599\t2016-05-01T10:38:00.000Z\t-1389094446\n8152044974329490473\t1751526583\t2016-05-01T10:39:00.000Z\t-296610933\n-6071768268784020226\t-1475953213\t2016-05-01T10:40:00.000Z\t-2002373666\n", "select l, i, timestamp , prev(i) over (order by l) from '*!*abc'");
    }

    @Test
    public void testLong() throws Exception {
        String expected = "8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t8416773233910814357\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t7199909180655756830\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t8920866532787660373\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-6253307669002054137\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t6270672455202306717\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t7392877322819819290\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-6943924477733600060\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\t-6856503215590263904\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t-7316123607359392486\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-3107239868490395663\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t-7387846268299105911\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t-6626590012581323602\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\t-8082754367165748693\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\t6574958665733670985\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t8611582118025429627\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\t8152044974329490473\n";
        this.assertThat("8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t8416773233910814357\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t7199909180655756830\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t8920866532787660373\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-6253307669002054137\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t6270672455202306717\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t7392877322819819290\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-6943924477733600060\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\t-6856503215590263904\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t-7316123607359392486\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-3107239868490395663\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t-7387846268299105911\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t-6626590012581323602\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\t-8082754367165748693\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\t6574958665733670985\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t8611582118025429627\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\t8152044974329490473\n", "select l, str, sym, timestamp , prev(l) over (partition by str) from abc");
        this.assertThat("8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\tNaN\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\tNaN\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\tNaN\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t8416773233910814357\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t7199909180655756830\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t8920866532787660373\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-6253307669002054137\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t6270672455202306717\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t7392877322819819290\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-6943924477733600060\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\t-6856503215590263904\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t-7316123607359392486\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-3107239868490395663\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t-7387846268299105911\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t-6626590012581323602\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\t-8082754367165748693\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\t6574958665733670985\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t8611582118025429627\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\t8152044974329490473\n", "select l, str, sym, timestamp , prev(l) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testLong2() throws Exception {
        String expected = "8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\t8920866532787660373\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\t-6943924477733600060\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\t-6856503215590263904\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t8416773233910814357\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t7199909180655756830\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t6270672455202306717\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-6253307669002054137\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t7392877322819819290\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-7316123607359392486\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-3107239868490395663\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\t-7387846268299105911\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t7122109662042058469\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-6626590012581323602\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t8611582118025429627\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t-8082754367165748693\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\t6574958665733670985\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\t3446015290144635451\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t8889492928577876455\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\t8152044974329490473\n";
        this.assertThat("8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\t8920866532787660373\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\t-6943924477733600060\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\t-6856503215590263904\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t8416773233910814357\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t7199909180655756830\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t6270672455202306717\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-6253307669002054137\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t7392877322819819290\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-7316123607359392486\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-3107239868490395663\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\t-7387846268299105911\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t7122109662042058469\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-6626590012581323602\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t8611582118025429627\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t-8082754367165748693\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\t6574958665733670985\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\t3446015290144635451\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t8889492928577876455\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\t8152044974329490473\n", "select l, str, sym, timestamp , prev(l) over () from abc");
        this.assertThat("8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tNaN\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\t8920866532787660373\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\t-6943924477733600060\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\t-6856503215590263904\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t8416773233910814357\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t7199909180655756830\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t6270672455202306717\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-6253307669002054137\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t7392877322819819290\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-7316123607359392486\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-3107239868490395663\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\t-7387846268299105911\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t7122109662042058469\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-6626590012581323602\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t8611582118025429627\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t-8082754367165748693\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\t6574958665733670985\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\t3446015290144635451\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t8889492928577876455\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\t8152044974329490473\n", "select l, str, sym, timestamp , prev(l) over () from '*!*abc'");
    }

    @Test
    public void testLongOrdered() throws Exception {
        String expected = "8920866532787660373\t-1148479920\t2016-05-01T10:21:00.000Z\t8416773233910814357\n-6943924477733600060\t-2041844972\t2016-05-01T10:22:00.000Z\tNaN\n-6856503215590263904\t-1532328444\t2016-05-01T10:23:00.000Z\t-7387846268299105911\n8416773233910814357\t-1153445279\t2016-05-01T10:24:00.000Z\t8889492928577876455\n7199909180655756830\t1699553881\t2016-05-01T10:25:00.000Z\t3446015290144635451\n6270672455202306717\t2006313928\t2016-05-01T10:26:00.000Z\t8152044974329490473\n-6253307669002054137\t-2002373666\t2016-05-01T10:27:00.000Z\t-6943924477733600060\n7392877322819819290\t-296610933\t2016-05-01T10:28:00.000Z\t7122109662042058469\n-7316123607359392486\t-1787109293\t2016-05-01T10:29:00.000Z\t-8082754367165748693\n-3107239868490395663\t-235358133\t2016-05-01T10:30:00.000Z\t7392877322819819290\n-7387846268299105911\t-1566901076\t2016-05-01T10:31:00.000Z\t-7316123607359392486\n7122109662042058469\t-572338288\t2016-05-01T10:32:00.000Z\t-6626590012581323602\n-6626590012581323602\t-731466113\t2016-05-01T10:33:00.000Z\t8920866532787660373\n8611582118025429627\t-1389094446\t2016-05-01T10:34:00.000Z\t-6071768268784020226\n-8082754367165748693\t-1966408995\t2016-05-01T10:35:00.000Z\t-6253307669002054137\n6574958665733670985\t1335037859\t2016-05-01T10:36:00.000Z\t-3107239868490395663\n3446015290144635451\t1598679468\t2016-05-01T10:37:00.000Z\t6574958665733670985\n8889492928577876455\t-1383560599\t2016-05-01T10:38:00.000Z\t8611582118025429627\n8152044974329490473\t1751526583\t2016-05-01T10:39:00.000Z\t7199909180655756830\n-6071768268784020226\t-1475953213\t2016-05-01T10:40:00.000Z\t-6856503215590263904\n";
        this.assertThat("8920866532787660373\t-1148479920\t2016-05-01T10:21:00.000Z\t8416773233910814357\n-6943924477733600060\t-2041844972\t2016-05-01T10:22:00.000Z\tNaN\n-6856503215590263904\t-1532328444\t2016-05-01T10:23:00.000Z\t-7387846268299105911\n8416773233910814357\t-1153445279\t2016-05-01T10:24:00.000Z\t8889492928577876455\n7199909180655756830\t1699553881\t2016-05-01T10:25:00.000Z\t3446015290144635451\n6270672455202306717\t2006313928\t2016-05-01T10:26:00.000Z\t8152044974329490473\n-6253307669002054137\t-2002373666\t2016-05-01T10:27:00.000Z\t-6943924477733600060\n7392877322819819290\t-296610933\t2016-05-01T10:28:00.000Z\t7122109662042058469\n-7316123607359392486\t-1787109293\t2016-05-01T10:29:00.000Z\t-8082754367165748693\n-3107239868490395663\t-235358133\t2016-05-01T10:30:00.000Z\t7392877322819819290\n-7387846268299105911\t-1566901076\t2016-05-01T10:31:00.000Z\t-7316123607359392486\n7122109662042058469\t-572338288\t2016-05-01T10:32:00.000Z\t-6626590012581323602\n-6626590012581323602\t-731466113\t2016-05-01T10:33:00.000Z\t8920866532787660373\n8611582118025429627\t-1389094446\t2016-05-01T10:34:00.000Z\t-6071768268784020226\n-8082754367165748693\t-1966408995\t2016-05-01T10:35:00.000Z\t-6253307669002054137\n6574958665733670985\t1335037859\t2016-05-01T10:36:00.000Z\t-3107239868490395663\n3446015290144635451\t1598679468\t2016-05-01T10:37:00.000Z\t6574958665733670985\n8889492928577876455\t-1383560599\t2016-05-01T10:38:00.000Z\t8611582118025429627\n8152044974329490473\t1751526583\t2016-05-01T10:39:00.000Z\t7199909180655756830\n-6071768268784020226\t-1475953213\t2016-05-01T10:40:00.000Z\t-6856503215590263904\n", "select l, i, timestamp , prev(l) over (order by i) from abc");
        this.assertThat("8920866532787660373\t-1148479920\t2016-05-01T10:21:00.000Z\t8416773233910814357\n-6943924477733600060\t-2041844972\t2016-05-01T10:22:00.000Z\tNaN\n-6856503215590263904\t-1532328444\t2016-05-01T10:23:00.000Z\t-7387846268299105911\n8416773233910814357\t-1153445279\t2016-05-01T10:24:00.000Z\t8889492928577876455\n7199909180655756830\t1699553881\t2016-05-01T10:25:00.000Z\t3446015290144635451\n6270672455202306717\t2006313928\t2016-05-01T10:26:00.000Z\t8152044974329490473\n-6253307669002054137\t-2002373666\t2016-05-01T10:27:00.000Z\t-6943924477733600060\n7392877322819819290\t-296610933\t2016-05-01T10:28:00.000Z\t7122109662042058469\n-7316123607359392486\t-1787109293\t2016-05-01T10:29:00.000Z\t-8082754367165748693\n-3107239868490395663\t-235358133\t2016-05-01T10:30:00.000Z\t7392877322819819290\n-7387846268299105911\t-1566901076\t2016-05-01T10:31:00.000Z\t-7316123607359392486\n7122109662042058469\t-572338288\t2016-05-01T10:32:00.000Z\t-6626590012581323602\n-6626590012581323602\t-731466113\t2016-05-01T10:33:00.000Z\t8920866532787660373\n8611582118025429627\t-1389094446\t2016-05-01T10:34:00.000Z\t-6071768268784020226\n-8082754367165748693\t-1966408995\t2016-05-01T10:35:00.000Z\t-6253307669002054137\n6574958665733670985\t1335037859\t2016-05-01T10:36:00.000Z\t-3107239868490395663\n3446015290144635451\t1598679468\t2016-05-01T10:37:00.000Z\t6574958665733670985\n8889492928577876455\t-1383560599\t2016-05-01T10:38:00.000Z\t8611582118025429627\n8152044974329490473\t1751526583\t2016-05-01T10:39:00.000Z\t7199909180655756830\n-6071768268784020226\t-1475953213\t2016-05-01T10:40:00.000Z\t-6856503215590263904\n", "select l, i, timestamp , prev(l) over (order by i) from '*!*abc'");
    }

    @Test
    public void testMultipleNoPart() throws Exception {
        String expected = "str\tsym\ttimestamp\tcol0\tcol1\nBZ\tBZ\t2016-05-01T10:21:00.000Z\t\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\tAX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\tBZ\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\tXX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\tBZ\n";
        this.assertThat("str\tsym\ttimestamp\tcol0\tcol1\nBZ\tBZ\t2016-05-01T10:21:00.000Z\t\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\tAX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\tBZ\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\tXX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\tBZ\n", "select str, sym, timestamp , prev(sym) over(), prev(str) over () from abc", true);
        this.assertThat("str\tsym\ttimestamp\tcol0\tcol1\nBZ\tBZ\t2016-05-01T10:21:00.000Z\t\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\tAX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\tBZ\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\tXX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\tBZ\n", "select str, sym, timestamp , prev(sym) over(), prev(str) over () from '*!*abc'", true);
    }

    @Test
    public void testNoArg() {
        try {
            this.expectFailure("select str, prev() rank over(partition by str) from 'abc'");
        }
        catch (ParserException e) {
            TestUtils.assertEquals((CharSequence)"Unknown function", QueryError.getMessage());
        }
    }

    @Test
    public void testNoRowIdPlan() throws Exception {
        String expected = "{\n  \"op\": \"SelectedColumnsRecordSource\",\n  \"src\": {\n    \"op\": \"AnalyticRecordSource\",\n    \"functions\": 1,\n    \"src\": {\n      \"op\": \"NoRowIdRecordSource\",\n      \"src\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"abc\"\n        },\n        \"rsrc\": {\n          \"op\": \"AllRowSource\"\n        }\n      }\n    }\n  }\n}";
        this.assertPlan2("{\n  \"op\": \"SelectedColumnsRecordSource\",\n  \"src\": {\n    \"op\": \"AnalyticRecordSource\",\n    \"functions\": 1,\n    \"src\": {\n      \"op\": \"NoRowIdRecordSource\",\n      \"src\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"abc\"\n        },\n        \"rsrc\": {\n          \"op\": \"AllRowSource\"\n        }\n      }\n    }\n  }\n}", "select str, sym, timestamp , prev(sym) over () from '*!*abc'");
    }

    @Test
    public void testNonPartSymbolBehaviour() throws Exception {
        PrevAnalyticFunctionTest.assertSymbol("select str, sym, timestamp , prev(sym) over () from abc", 3);
    }

    @Test
    public void testOrderBySymbolBehaviour() throws Exception {
        PrevAnalyticFunctionTest.assertSymbol("select str, sym, timestamp , prev(sym) x over (partition by str) from abc order by x", 3);
    }

    @Test
    public void testOrderedSymbolBehaviour() throws Exception {
        PrevAnalyticFunctionTest.assertSymbol("select l, sym, timestamp , prev(sym) over (order by l) from abc", 3);
    }

    @Test
    public void testPlan() throws Exception {
        this.assertPlan2("{\n  \"op\": \"SelectedColumnsRecordSource\",\n  \"src\": {\n    \"op\": \"AnalyticRecordSource\",\n    \"functions\": 1,\n    \"src\": {\n      \"op\": \"JournalRecordSource\",\n      \"psrc\": {\n        \"op\": \"JournalPartitionSource\",\n        \"journal\": \"abc\"\n      },\n      \"rsrc\": {\n        \"op\": \"AllRowSource\"\n      }\n    }\n  }\n}", "select sym, prev(d) over() from abc");
    }

    @Test
    public void testPrevMixed() throws Exception {
        String expected = "8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\t\tAX\n-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\tBZ\tKK\n-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\tBZ\tBZ\n8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\tXX\tBZ\n7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\n6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\n-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\n7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\tXX\n-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tKK\tKK\n-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\n-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tAX\tAX\n7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tKK\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tAX\tXX\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\tXX\n-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\tBZ\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\tBZ\n3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tKK\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tAX\tKK\n-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tBZ\tXX\n";
        this.assertThat("8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\t\tAX\n-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\tBZ\tKK\n-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\tBZ\tBZ\n8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\tXX\tBZ\n7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\n6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\n-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\n7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\tXX\n-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tKK\tKK\n-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\n-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tAX\tAX\n7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tKK\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tAX\tXX\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\tXX\n-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\tBZ\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\tBZ\n3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tKK\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tAX\tKK\n-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tBZ\tXX\n", "select l, sym, timestamp , prev(sym) over(), prev(sym) over (order by l) from abc");
        this.assertThat("8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\t\tAX\n-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\tBZ\tKK\n-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\tBZ\tBZ\n8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\tXX\tBZ\n7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\n6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\n-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\n7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\tXX\n-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tKK\tKK\n-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\n-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tAX\tAX\n7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tKK\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tAX\tXX\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\tXX\n-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\tBZ\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\tBZ\n3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tKK\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tAX\tKK\n-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tBZ\tXX\n", "select l, sym, timestamp , prev(sym) over(), prev(sym) over (order by l) from '*!*abc'");
    }

    @Test
    public void testPrevMixed2() throws Exception {
        String expected = "BZ\t8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\t\tAX\nXX\t-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\t\tKK\nKK\t-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\t\tBZ\nAX\t8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\t\tBZ\nAX\t7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\nAX\t6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\nBZ\t-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\nBZ\t7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\tXX\nAX\t-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tBZ\tKK\nBZ\t-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\nXX\t-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tBZ\tAX\nKK\t7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tXX\tAX\nAX\t-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tKK\tXX\nBZ\t8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\tXX\nXX\t-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\tKK\t\nAX\t6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\tBZ\nXX\t3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\nAX\t8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tAX\tBZ\nBZ\t8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tBZ\tKK\nBZ\t-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tBZ\tXX\n";
        this.assertThat("BZ\t8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\t\tAX\nXX\t-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\t\tKK\nKK\t-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\t\tBZ\nAX\t8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\t\tBZ\nAX\t7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\nAX\t6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\nBZ\t-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\nBZ\t7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\tXX\nAX\t-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tBZ\tKK\nBZ\t-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\nXX\t-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tBZ\tAX\nKK\t7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tXX\tAX\nAX\t-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tKK\tXX\nBZ\t8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\tXX\nXX\t-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\tKK\t\nAX\t6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\tBZ\nXX\t3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\nAX\t8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tAX\tBZ\nBZ\t8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tBZ\tKK\nBZ\t-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tBZ\tXX\n", "select str, l, sym, timestamp , prev(sym) over(partition by str), prev(sym) over (order by l) from abc");
        this.assertThat("BZ\t8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\t\tAX\nXX\t-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\t\tKK\nKK\t-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\t\tBZ\nAX\t8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\t\tBZ\nAX\t7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tXX\tAX\nAX\t6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\nBZ\t-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tBZ\tAX\nBZ\t7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\tXX\nAX\t-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tBZ\tKK\nBZ\t-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tKK\tAX\nXX\t-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tBZ\tAX\nKK\t7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tXX\tAX\nAX\t-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tKK\tXX\nBZ\t8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\tXX\nXX\t-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\tKK\t\nAX\t6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\tBZ\nXX\t3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\tAX\nAX\t8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tAX\tBZ\nBZ\t8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tBZ\tKK\nBZ\t-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tBZ\tXX\n", "select str, l, sym, timestamp , prev(sym) over(partition by str), prev(sym) over (order by l) from '*!*abc'");
    }

    @Test
    public void testPrevNextMixed() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\t\tKK\nKK\tXX\t2016-05-01T10:23:00.000Z\t\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\t\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\tKK\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\tAX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\tBZ\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\t\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\t\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\t\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\t\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\t\tKK\nKK\tXX\t2016-05-01T10:23:00.000Z\t\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\t\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\tKK\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\tAX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\tBZ\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\t\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\t\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\t\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\t\n", "select str, sym, timestamp , prev(sym) over(partition by str), next(sym) over (partition by str) from abc");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\t\tKK\nKK\tXX\t2016-05-01T10:23:00.000Z\t\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\t\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\tKK\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\tKK\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\tAX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\tBZ\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\t\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\t\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\t\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\t\n", "select str, sym, timestamp , prev(sym) over(partition by str), next(sym) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testShort() throws Exception {
        String expected = "-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-19496\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-22934\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-26951\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-24357\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t21781\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-19136\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15331\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-4874\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-20409\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t25974\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t5869\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-29572\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n";
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-19496\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-22934\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-26951\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-24357\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t21781\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-19136\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15331\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-4874\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-20409\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t25974\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t5869\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-29572\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n", "select sho, str, sym, timestamp , prev(sho) over (partition by str) from abc");
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-19496\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-22934\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-26951\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-24357\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t21781\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-19136\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15331\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-4874\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-20409\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t25974\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t5869\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-29572\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n", "select sho, str, sym, timestamp , prev(sho) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testShort2() throws Exception {
        String expected = "-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-19496\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-24357\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t21781\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-22934\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-26951\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-19136\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-15331\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-4874\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t25102\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-20409\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-29572\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t25974\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t5869\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t-22894\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-18600\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n";
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-19496\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-24357\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t21781\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-22934\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-26951\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-19136\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-15331\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-4874\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t25102\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-20409\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-29572\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t25974\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t5869\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t-22894\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-18600\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n", "select sho, str, sym, timestamp , prev(sho) over () from abc");
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-19496\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-24357\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t21781\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-22934\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-26951\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-19136\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-15331\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-4874\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t25102\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-20409\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-29572\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t25974\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t5869\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t-22894\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-18600\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n", "select sho, str, sym, timestamp , prev(sho) over () from '*!*abc'");
    }

    @Test
    public void testShortAliased() throws Exception {
        String expected = "sho\tstr\tsym\ttimestamp\tblah\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-19496\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-22934\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-26951\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-24357\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t21781\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-19136\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15331\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-4874\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-20409\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t25974\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t5869\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-29572\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n";
        this.assertThat("sho\tstr\tsym\ttimestamp\tblah\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-19496\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-22934\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-26951\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-24357\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t21781\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-19136\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15331\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-4874\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-20409\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t25974\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t5869\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-29572\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n", "select sho, str, sym, timestamp , prev(sho) blah over (partition by str) from abc", true);
        this.assertThat("sho\tstr\tsym\ttimestamp\tblah\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t0\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t0\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-19127\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-15458\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-19496\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-391\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-22934\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-26951\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t-24357\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t21781\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-19136\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-15331\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-4874\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-20409\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t25974\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t5869\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-29572\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t11755\n", "select sho, str, sym, timestamp , prev(sho) blah over (partition by str) from '*!*abc'", true);
    }

    @Test
    public void testShortOrdered() throws Exception {
        String expected = "8920866532787660373\t-19496\t2016-05-01T10:21:00.000Z\t-18600\n-6943924477733600060\t-24357\t2016-05-01T10:22:00.000Z\t-19136\n-6856503215590263904\t21781\t2016-05-01T10:23:00.000Z\t-24357\n8416773233910814357\t-19127\t2016-05-01T10:24:00.000Z\t11755\n7199909180655756830\t-15458\t2016-05-01T10:25:00.000Z\t25102\n6270672455202306717\t-22934\t2016-05-01T10:26:00.000Z\t-22894\n-6253307669002054137\t-391\t2016-05-01T10:27:00.000Z\t-20409\n7392877322819819290\t-26951\t2016-05-01T10:28:00.000Z\t-15458\n-7316123607359392486\t-19136\t2016-05-01T10:29:00.000Z\t-4874\n-3107239868490395663\t-15331\t2016-05-01T10:30:00.000Z\t-24455\n-7387846268299105911\t-4874\t2016-05-01T10:31:00.000Z\t25974\n7122109662042058469\t25102\t2016-05-01T10:32:00.000Z\t5869\n-6626590012581323602\t-20409\t2016-05-01T10:33:00.000Z\t21781\n8611582118025429627\t-29572\t2016-05-01T10:34:00.000Z\t-19127\n-8082754367165748693\t25974\t2016-05-01T10:35:00.000Z\t0\n6574958665733670985\t5869\t2016-05-01T10:36:00.000Z\t-22934\n3446015290144635451\t-22894\t2016-05-01T10:37:00.000Z\t-15331\n8889492928577876455\t-18600\t2016-05-01T10:38:00.000Z\t-29572\n8152044974329490473\t11755\t2016-05-01T10:39:00.000Z\t-26951\n-6071768268784020226\t-24455\t2016-05-01T10:40:00.000Z\t-391\n";
        this.assertThat("8920866532787660373\t-19496\t2016-05-01T10:21:00.000Z\t-18600\n-6943924477733600060\t-24357\t2016-05-01T10:22:00.000Z\t-19136\n-6856503215590263904\t21781\t2016-05-01T10:23:00.000Z\t-24357\n8416773233910814357\t-19127\t2016-05-01T10:24:00.000Z\t11755\n7199909180655756830\t-15458\t2016-05-01T10:25:00.000Z\t25102\n6270672455202306717\t-22934\t2016-05-01T10:26:00.000Z\t-22894\n-6253307669002054137\t-391\t2016-05-01T10:27:00.000Z\t-20409\n7392877322819819290\t-26951\t2016-05-01T10:28:00.000Z\t-15458\n-7316123607359392486\t-19136\t2016-05-01T10:29:00.000Z\t-4874\n-3107239868490395663\t-15331\t2016-05-01T10:30:00.000Z\t-24455\n-7387846268299105911\t-4874\t2016-05-01T10:31:00.000Z\t25974\n7122109662042058469\t25102\t2016-05-01T10:32:00.000Z\t5869\n-6626590012581323602\t-20409\t2016-05-01T10:33:00.000Z\t21781\n8611582118025429627\t-29572\t2016-05-01T10:34:00.000Z\t-19127\n-8082754367165748693\t25974\t2016-05-01T10:35:00.000Z\t0\n6574958665733670985\t5869\t2016-05-01T10:36:00.000Z\t-22934\n3446015290144635451\t-22894\t2016-05-01T10:37:00.000Z\t-15331\n8889492928577876455\t-18600\t2016-05-01T10:38:00.000Z\t-29572\n8152044974329490473\t11755\t2016-05-01T10:39:00.000Z\t-26951\n-6071768268784020226\t-24455\t2016-05-01T10:40:00.000Z\t-391\n", "select l, sho, timestamp , prev(sho) over (order by l) from abc");
        this.assertThat("8920866532787660373\t-19496\t2016-05-01T10:21:00.000Z\t-18600\n-6943924477733600060\t-24357\t2016-05-01T10:22:00.000Z\t-19136\n-6856503215590263904\t21781\t2016-05-01T10:23:00.000Z\t-24357\n8416773233910814357\t-19127\t2016-05-01T10:24:00.000Z\t11755\n7199909180655756830\t-15458\t2016-05-01T10:25:00.000Z\t25102\n6270672455202306717\t-22934\t2016-05-01T10:26:00.000Z\t-22894\n-6253307669002054137\t-391\t2016-05-01T10:27:00.000Z\t-20409\n7392877322819819290\t-26951\t2016-05-01T10:28:00.000Z\t-15458\n-7316123607359392486\t-19136\t2016-05-01T10:29:00.000Z\t-4874\n-3107239868490395663\t-15331\t2016-05-01T10:30:00.000Z\t-24455\n-7387846268299105911\t-4874\t2016-05-01T10:31:00.000Z\t25974\n7122109662042058469\t25102\t2016-05-01T10:32:00.000Z\t5869\n-6626590012581323602\t-20409\t2016-05-01T10:33:00.000Z\t21781\n8611582118025429627\t-29572\t2016-05-01T10:34:00.000Z\t-19127\n-8082754367165748693\t25974\t2016-05-01T10:35:00.000Z\t0\n6574958665733670985\t5869\t2016-05-01T10:36:00.000Z\t-22934\n3446015290144635451\t-22894\t2016-05-01T10:37:00.000Z\t-15331\n8889492928577876455\t-18600\t2016-05-01T10:38:00.000Z\t-29572\n8152044974329490473\t11755\t2016-05-01T10:39:00.000Z\t-26951\n-6071768268784020226\t-24455\t2016-05-01T10:40:00.000Z\t-391\n", "select l, sho, timestamp , prev(sho) over (order by l) from '*!*abc'");
    }

    @Test
    public void testStr() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n", "select str, sym, timestamp , prev(str) over (partition by sym) from abc");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n", "select str, sym, timestamp , prev(str) over (partition by sym) from '*!*abc'");
        this.assertString("select str, sym, timestamp , prev(str) over (partition by sym) from abc", 3);
        this.assertString("select str, sym, timestamp , prev(str) over (partition by sym) from '*!*abc'", 3);
    }

    @Test
    public void testStr2() throws Exception {
        String expected = "21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\tXX\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\tKK\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\tAX\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\tAX\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\tBZ\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\tAX\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\tXX\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\tKK\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\tXX\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\tAX\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\tXX\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n";
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\tXX\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\tKK\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\tAX\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\tAX\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\tBZ\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\tAX\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\tXX\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\tKK\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\tXX\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\tAX\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\tXX\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select b, str, sym, timestamp , prev(str) over () from abc");
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\tXX\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\tKK\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\tAX\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\tAX\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\tBZ\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\tAX\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\tXX\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\tKK\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\tXX\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\tAX\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\tXX\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select b, str, sym, timestamp , prev(str) over () from '*!*abc'");
        this.assertString("select b, str, sym, timestamp , prev(str) over () from '*!*abc'", 4);
        this.assertString("select b, str, sym, timestamp , prev(str) over () from abc", 4);
    }

    @Test
    public void testStrNoRowId() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n", "select str, sym, timestamp , prev(str) over (partition by sym) from '*!*abc'");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n", "select str, sym, timestamp , prev(str) over (partition by sym) from abc");
        this.assertString("select str, sym, timestamp , prev(str) over (partition by sym) from '*!*abc'", 3);
        this.assertString("select str, sym, timestamp , prev(str) over (partition by sym) from abc", 3);
    }

    @Test
    public void testStrNonPart() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tAX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\tBZ\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tAX\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tXX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tAX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\tBZ\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tAX\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tXX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(str) over () from abc");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tAX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\tBZ\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tAX\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tXX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(str) over () from '*!*abc'");
    }

    @Test
    public void testStrOrdered() throws Exception {
        String expected = "8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\tAX\n-6943924477733600060\tXX\t2016-05-01T10:22:00.000Z\tAX\n-6856503215590263904\tKK\t2016-05-01T10:23:00.000Z\tXX\n8416773233910814357\tAX\t2016-05-01T10:24:00.000Z\tBZ\n7199909180655756830\tAX\t2016-05-01T10:25:00.000Z\tKK\n6270672455202306717\tAX\t2016-05-01T10:26:00.000Z\tXX\n-6253307669002054137\tBZ\t2016-05-01T10:27:00.000Z\tAX\n7392877322819819290\tBZ\t2016-05-01T10:28:00.000Z\tAX\n-7316123607359392486\tAX\t2016-05-01T10:29:00.000Z\tXX\n-3107239868490395663\tBZ\t2016-05-01T10:30:00.000Z\tBZ\n-7387846268299105911\tXX\t2016-05-01T10:31:00.000Z\tXX\n7122109662042058469\tKK\t2016-05-01T10:32:00.000Z\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tKK\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\n-8082754367165748693\tXX\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\n3446015290144635451\tXX\t2016-05-01T10:37:00.000Z\tBZ\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tBZ\n-6071768268784020226\tBZ\t2016-05-01T10:40:00.000Z\tBZ\n";
        this.assertThat("8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\tAX\n-6943924477733600060\tXX\t2016-05-01T10:22:00.000Z\tAX\n-6856503215590263904\tKK\t2016-05-01T10:23:00.000Z\tXX\n8416773233910814357\tAX\t2016-05-01T10:24:00.000Z\tBZ\n7199909180655756830\tAX\t2016-05-01T10:25:00.000Z\tKK\n6270672455202306717\tAX\t2016-05-01T10:26:00.000Z\tXX\n-6253307669002054137\tBZ\t2016-05-01T10:27:00.000Z\tAX\n7392877322819819290\tBZ\t2016-05-01T10:28:00.000Z\tAX\n-7316123607359392486\tAX\t2016-05-01T10:29:00.000Z\tXX\n-3107239868490395663\tBZ\t2016-05-01T10:30:00.000Z\tBZ\n-7387846268299105911\tXX\t2016-05-01T10:31:00.000Z\tXX\n7122109662042058469\tKK\t2016-05-01T10:32:00.000Z\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tKK\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\n-8082754367165748693\tXX\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\n3446015290144635451\tXX\t2016-05-01T10:37:00.000Z\tBZ\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tBZ\n-6071768268784020226\tBZ\t2016-05-01T10:40:00.000Z\tBZ\n", "select l, str, timestamp , prev(str) over (order by l) from abc");
        this.assertThat("8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\tAX\n-6943924477733600060\tXX\t2016-05-01T10:22:00.000Z\tAX\n-6856503215590263904\tKK\t2016-05-01T10:23:00.000Z\tXX\n8416773233910814357\tAX\t2016-05-01T10:24:00.000Z\tBZ\n7199909180655756830\tAX\t2016-05-01T10:25:00.000Z\tKK\n6270672455202306717\tAX\t2016-05-01T10:26:00.000Z\tXX\n-6253307669002054137\tBZ\t2016-05-01T10:27:00.000Z\tAX\n7392877322819819290\tBZ\t2016-05-01T10:28:00.000Z\tAX\n-7316123607359392486\tAX\t2016-05-01T10:29:00.000Z\tXX\n-3107239868490395663\tBZ\t2016-05-01T10:30:00.000Z\tBZ\n-7387846268299105911\tXX\t2016-05-01T10:31:00.000Z\tXX\n7122109662042058469\tKK\t2016-05-01T10:32:00.000Z\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tKK\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tAX\n-8082754367165748693\tXX\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tAX\n3446015290144635451\tXX\t2016-05-01T10:37:00.000Z\tBZ\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tBZ\n-6071768268784020226\tBZ\t2016-05-01T10:40:00.000Z\tBZ\n", "select l, str, timestamp , prev(str) over (order by l) from '*!*abc'");
        this.assertString("select l, str, timestamp , prev(str) over (order by l) from abc", 3);
        this.assertPlan2("{\n  \"op\": \"SelectedColumnsRecordSource\",\n  \"src\": {\n    \"op\": \"CachedAnalyticRecordSource\",\n    \"functions\": 1,\n    \"orderedSources\": 1,\n    \"src\": {\n      \"op\": \"NoRowIdRecordSource\",\n      \"src\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"abc\"\n        },\n        \"rsrc\": {\n          \"op\": \"AllRowSource\"\n        }\n      }\n    }\n  }\n}", "select l, str, timestamp , prev(str) over (order by l) from '*!*abc'");
    }

    @Test
    public void testStrPartitionedOrdered() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n", "select str, sym, timestamp , prev(str) over (partition by sym order by timestamp) from abc");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tKK\nAX\tXX\t2016-05-01T10:25:00.000Z\tAX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tAX\nBZ\tKK\t2016-05-01T10:28:00.000Z\t\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\t\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tXX\nXX\tKK\t2016-05-01T10:37:00.000Z\tXX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tAX\n", "select str, sym, timestamp , prev(str) over (partition by sym order by timestamp) from '*!*abc'");
        this.assertString("select str, sym, timestamp , prev(str) over (partition by sym order by timestamp) from abc", 3);
        this.assertString("select str, sym, timestamp , prev(str) over (partition by sym order by timestamp) from '*!*abc'", 3);
    }

    @Test
    public void testSymNonPart() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(sym) over () from abc");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(sym) over () from '*!*abc'");
    }

    @Test
    public void testSymOrdered() throws Exception {
        String expected = "8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\tAX\n-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\tKK\n-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\tBZ\n8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\tBZ\n7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tAX\n6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tKK\n-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tAX\n7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\n-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tKK\n-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tAX\n-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tAX\n7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tXX\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tXX\n-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tBZ\n3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tKK\n-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tXX\n";
        this.assertThat("8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\tAX\n-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\tKK\n-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\tBZ\n8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\tBZ\n7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tAX\n6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tKK\n-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tAX\n7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\n-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tKK\n-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tAX\n-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tAX\n7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tXX\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tXX\n-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tBZ\n3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tKK\n-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tXX\n", "select l, sym, timestamp , prev(sym) over (order by l) from abc");
        this.assertThat("8920866532787660373\tBZ\t2016-05-01T10:21:00.000Z\tAX\n-6943924477733600060\tBZ\t2016-05-01T10:22:00.000Z\tKK\n-6856503215590263904\tXX\t2016-05-01T10:23:00.000Z\tBZ\n8416773233910814357\tXX\t2016-05-01T10:24:00.000Z\tBZ\n7199909180655756830\tXX\t2016-05-01T10:25:00.000Z\tAX\n6270672455202306717\tBZ\t2016-05-01T10:26:00.000Z\tKK\n-6253307669002054137\tXX\t2016-05-01T10:27:00.000Z\tAX\n7392877322819819290\tKK\t2016-05-01T10:28:00.000Z\tXX\n-7316123607359392486\tKK\t2016-05-01T10:29:00.000Z\tKK\n-3107239868490395663\tAX\t2016-05-01T10:30:00.000Z\tAX\n-7387846268299105911\tKK\t2016-05-01T10:31:00.000Z\tAX\n7122109662042058469\tAX\t2016-05-01T10:32:00.000Z\tAX\n-6626590012581323602\tAX\t2016-05-01T10:33:00.000Z\tXX\n8611582118025429627\tBZ\t2016-05-01T10:34:00.000Z\tXX\n-8082754367165748693\tAX\t2016-05-01T10:35:00.000Z\t\n6574958665733670985\tAX\t2016-05-01T10:36:00.000Z\tBZ\n3446015290144635451\tKK\t2016-05-01T10:37:00.000Z\tAX\n8889492928577876455\tAX\t2016-05-01T10:38:00.000Z\tBZ\n8152044974329490473\tBZ\t2016-05-01T10:39:00.000Z\tKK\n-6071768268784020226\tAX\t2016-05-01T10:40:00.000Z\tXX\n", "select l, sym, timestamp , prev(sym) over (order by l) from '*!*abc'");
    }

    @Test
    public void testSymbol() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\t\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\t\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\t\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\t\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(sym) over (partition by str) from abc");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\t\nKK\tXX\t2016-05-01T10:23:00.000Z\t\nAX\tXX\t2016-05-01T10:24:00.000Z\t\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(sym) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testSymbol2() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(sym) over () from abc");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tBZ\nKK\tXX\t2016-05-01T10:23:00.000Z\tBZ\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tKK\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tKK\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tBZ\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tKK\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\tBZ\n", "select str, sym, timestamp , prev(sym) over () from '*!*abc'");
        PrevAnalyticFunctionTest.assertSymbol("select str, sym, timestamp , prev(sym) over () from abc", 3);
        PrevAnalyticFunctionTest.assertSymbol("select str, sym, timestamp , prev(sym) over () from '*!*abc'", 3);
    }

    @Test
    public void testSymbolBehaviour() throws Exception {
        PrevAnalyticFunctionTest.assertSymbol("select str, sym, timestamp , prev(sym) over (partition by str) from abc", 3);
        PrevAnalyticFunctionTest.assertSymbol("select str, sym, timestamp , prev(sym) over (partition by str) from abc", 1);
    }

    @Test
    public void testSymbolSubQuery() throws Exception {
        String expectd = "str\tsym\tp\nBZ\tBZ\t\nXX\tBZ\t\nKK\tXX\t\nAX\tXX\t\nAX\tXX\tXX\nAX\tBZ\tXX\nBZ\tXX\tBZ\nBZ\tKK\tXX\nAX\tKK\tBZ\nBZ\tAX\tKK\nXX\tKK\tBZ\nKK\tAX\tXX\nAX\tAX\tKK\nBZ\tBZ\tAX\nXX\tAX\tKK\nAX\tAX\tAX\nXX\tKK\tAX\nAX\tAX\tAX\nBZ\tBZ\tBZ\nBZ\tAX\tBZ\n";
        this.assertThat("str\tsym\tp\nBZ\tBZ\t\nXX\tBZ\t\nKK\tXX\t\nAX\tXX\t\nAX\tXX\tXX\nAX\tBZ\tXX\nBZ\tXX\tBZ\nBZ\tKK\tXX\nAX\tKK\tBZ\nBZ\tAX\tKK\nXX\tKK\tBZ\nKK\tAX\tXX\nAX\tAX\tKK\nBZ\tBZ\tAX\nXX\tAX\tKK\nAX\tAX\tAX\nXX\tKK\tAX\nAX\tAX\tAX\nBZ\tBZ\tBZ\nBZ\tAX\tBZ\n", "select str, sym, p from (select str, sym, timestamp , prev(sym) p over (partition by str) from abc)", true);
        this.assertThat("str\tsym\tp\nBZ\tBZ\t\nXX\tBZ\t\nKK\tXX\t\nAX\tXX\t\nAX\tXX\tXX\nAX\tBZ\tXX\nBZ\tXX\tBZ\nBZ\tKK\tXX\nAX\tKK\tBZ\nBZ\tAX\tKK\nXX\tKK\tBZ\nKK\tAX\tXX\nAX\tAX\tKK\nBZ\tBZ\tAX\nXX\tAX\tKK\nAX\tAX\tAX\nXX\tKK\tAX\nAX\tAX\tAX\nBZ\tBZ\tBZ\nBZ\tAX\tBZ\n", "select str, sym, p from (select str, sym, timestamp , prev(sym) p over (partition by str) from '*!*abc')", true);
    }

    @Test
    public void testVirtualColumn() throws Exception {
        String expected = "str\tboo\tcol0\tf\td\tcol1\nBZ\ttrue\t1.673692762852\t0.6235\t1.050231933594\tfalse\nXX\tfalse\t567.512389898300\t0.7780\t566.734375000000\tfalse\nKK\tfalse\t0.550908231392\t0.5509\t0.000013792171\tfalse\nAX\tfalse\t0.020375759351\t0.0204\t0.000000567185\tfalse\nAX\ttrue\t-511.515212714672\t0.4848\t-512.000000000000\tfalse\nAX\ttrue\t0.972335502505\t0.2969\t0.675451681018\ttrue\nBZ\tfalse\t0.904826603830\t0.5725\t0.332301996648\ttrue\nBZ\ttrue\t0.596724832495\t0.5967\t0.000001752813\tfalse\nAX\tfalse\t0.161007094177\t0.1609\t0.000076281818\ttrue\nBZ\tfalse\t0.350913291764\t0.3509\t0.000000005555\ttrue\nXX\tfalse\t0.727417677178\t0.7274\t0.000002473130\tfalse\nKK\tfalse\t633.483788669109\t0.5619\t632.921875000000\tfalse\nAX\tfalse\t0.543259224330\t0.5433\t0.000000020896\tfalse\nBZ\tfalse\t0.551534552826\t0.5442\t0.007371325744\tfalse\nXX\ttrue\t0.674562766890\t0.6746\t0.000000014643\tfalse\nAX\ttrue\t512.821699082851\t0.8217\t512.000000000000\tfalse\nXX\ttrue\t864.359103977680\t0.3591\t864.000000000000\ttrue\nAX\ttrue\t0.682714500508\t0.6827\t0.000000157437\ttrue\nBZ\tfalse\t-841.883159995079\t0.1168\t-842.000000000000\tfalse\nBZ\tfalse\t0.496688359286\t0.4967\t0.000032060649\tfalse\n";
        this.assertThat("str\tboo\tcol0\tf\td\tcol1\nBZ\ttrue\t1.673692762852\t0.6235\t1.050231933594\tfalse\nXX\tfalse\t567.512389898300\t0.7780\t566.734375000000\tfalse\nKK\tfalse\t0.550908231392\t0.5509\t0.000013792171\tfalse\nAX\tfalse\t0.020375759351\t0.0204\t0.000000567185\tfalse\nAX\ttrue\t-511.515212714672\t0.4848\t-512.000000000000\tfalse\nAX\ttrue\t0.972335502505\t0.2969\t0.675451681018\ttrue\nBZ\tfalse\t0.904826603830\t0.5725\t0.332301996648\ttrue\nBZ\ttrue\t0.596724832495\t0.5967\t0.000001752813\tfalse\nAX\tfalse\t0.161007094177\t0.1609\t0.000076281818\ttrue\nBZ\tfalse\t0.350913291764\t0.3509\t0.000000005555\ttrue\nXX\tfalse\t0.727417677178\t0.7274\t0.000002473130\tfalse\nKK\tfalse\t633.483788669109\t0.5619\t632.921875000000\tfalse\nAX\tfalse\t0.543259224330\t0.5433\t0.000000020896\tfalse\nBZ\tfalse\t0.551534552826\t0.5442\t0.007371325744\tfalse\nXX\ttrue\t0.674562766890\t0.6746\t0.000000014643\tfalse\nAX\ttrue\t512.821699082851\t0.8217\t512.000000000000\tfalse\nXX\ttrue\t864.359103977680\t0.3591\t864.000000000000\ttrue\nAX\ttrue\t0.682714500508\t0.6827\t0.000000157437\ttrue\nBZ\tfalse\t-841.883159995079\t0.1168\t-842.000000000000\tfalse\nBZ\tfalse\t0.496688359286\t0.4967\t0.000032060649\tfalse\n", "select str, boo, f+d, f, d , prev(boo) over (partition by str) from abc", true);
        this.assertThat("str\tboo\tcol0\tf\td\tcol1\nBZ\ttrue\t1.673692762852\t0.6235\t1.050231933594\tfalse\nXX\tfalse\t567.512389898300\t0.7780\t566.734375000000\tfalse\nKK\tfalse\t0.550908231392\t0.5509\t0.000013792171\tfalse\nAX\tfalse\t0.020375759351\t0.0204\t0.000000567185\tfalse\nAX\ttrue\t-511.515212714672\t0.4848\t-512.000000000000\tfalse\nAX\ttrue\t0.972335502505\t0.2969\t0.675451681018\ttrue\nBZ\tfalse\t0.904826603830\t0.5725\t0.332301996648\ttrue\nBZ\ttrue\t0.596724832495\t0.5967\t0.000001752813\tfalse\nAX\tfalse\t0.161007094177\t0.1609\t0.000076281818\ttrue\nBZ\tfalse\t0.350913291764\t0.3509\t0.000000005555\ttrue\nXX\tfalse\t0.727417677178\t0.7274\t0.000002473130\tfalse\nKK\tfalse\t633.483788669109\t0.5619\t632.921875000000\tfalse\nAX\tfalse\t0.543259224330\t0.5433\t0.000000020896\tfalse\nBZ\tfalse\t0.551534552826\t0.5442\t0.007371325744\tfalse\nXX\ttrue\t0.674562766890\t0.6746\t0.000000014643\tfalse\nAX\ttrue\t512.821699082851\t0.8217\t512.000000000000\tfalse\nXX\ttrue\t864.359103977680\t0.3591\t864.000000000000\ttrue\nAX\ttrue\t0.682714500508\t0.6827\t0.000000157437\ttrue\nBZ\tfalse\t-841.883159995079\t0.1168\t-842.000000000000\tfalse\nBZ\tfalse\t0.496688359286\t0.4967\t0.000032060649\tfalse\n", "select str, boo, f+d, f, d , prev(boo) over (partition by str) from '*!*abc'", true);
    }

    @Test
    public void testWrongColumnInFunc() {
        try {
            this.expectFailure("select str, sym, timestamp , prev(symx) over (partition by str) from abc");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)34L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testWrongColumnInPartition() {
        try {
            this.expectFailure("select str, sym, timestamp , prev(sym) over (partition by strx) from abc");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)58L, (long)QueryError.getPosition());
        }
    }
}

