/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.AbstractAllTypeTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class NextAnalyticFunctionTest
extends AbstractAllTypeTest {
    private static final String expected = "-1148479920\tBZ\t2016-05-01T10:21:00.000Z\t-409854405\n1548800833\tKK\t2016-05-01T10:22:00.000Z\t73575701\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1326447242\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t-1436881714\n1868723706\tAX\t2016-05-01T10:25:00.000Z\t-1191262516\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t806715481\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t1530831067\n806715481\tAX\t2016-05-01T10:28:00.000Z\t1125579207\n1569490116\tXX\t2016-05-01T10:29:00.000Z\t-1532328444\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t1699553881\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-1844391305\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1404198\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t-1432278050\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t-85170055\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1125169127\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t-1101822104\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t-547127752\n1404198\tXX\t2016-05-01T10:38:00.000Z\t1232884790\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t-1975183723\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t-2119387831\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t-1575135393\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t1253890363\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t-422941535\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t-2132716300\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t-303295973\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-461611463\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t1890602616\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t264240638\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t-2144581835\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-483853667\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t-2002373666\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t68265578\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t458818940\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t-1418341054\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t-2034804966\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t2031014705\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t-1787109293\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t936627841\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t-372268574\n936627841\tKK\t2016-05-01T11:00:00.000Z\t-667031149\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t1637847416\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t161592763\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-1819240775\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t-1201923128\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1515787781\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t636045524\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t-1299391311\n636045524\tAX\t2016-05-01T11:08:00.000Z\t-1538602195\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t-443320374\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-10505757\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t1857212401\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t-1566901076\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t1196016669\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t1234796102\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t532665695\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t1876812930\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t-1582495445\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1172180184\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t-45567293\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t-373499303\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t114747951\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t-916132123\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t-1723887671\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t-731466113\n114747951\tAX\t2016-05-01T11:25:00.000Z\t-1794809330\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t-882371473\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-2075675260\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t1235206821\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-712702244\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t865832060\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-1768335227\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t1795359355\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t-1966408995\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t838743782\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t-876466531\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t-2043803188\n865832060\tXX\t2016-05-01T11:37:00.000Z\t614536941\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t1107889075\n838743782\tAX\t2016-05-01T11:39:00.000Z\t-618037497\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t-68027832\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t519895483\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t1658228795\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t-2088317486\n519895483\tAX\t2016-05-01T11:44:00.000Z\t602835017\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t-283321892\n602835017\tAX\t2016-05-01T11:46:00.000Z\t-2111250190\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t1598679468\n614536941\tXX\t2016-05-01T11:48:00.000Z\t1015055928\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t1362833895\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t1238491107\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t116799613\n116799613\tKK\t2016-05-01T11:52:00.000Z\t-636975106\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t1100812407\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t-640305320\n1015055928\tXX\t2016-05-01T11:55:00.000Z\tNaN\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1751526583\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t-805434743\n-805434743\tAX\t2016-05-01T11:58:00.000Z\tNaN\n-640305320\tKK\t2016-05-01T11:59:00.000Z\tNaN\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\tNaN\n";

    @Test
    public void testAnalyticSymbolBehaviour() throws Exception {
        NextAnalyticFunctionTest.assertSymbol("select l, str, sym, timestamp , next(sym) over (partition by str) from abc", 4);
        NextAnalyticFunctionTest.assertSymbol("select l, str, sym, timestamp , next(sym) over (partition by str) from '*!*abc'", 4);
    }

    @Test
    public void testBoolean() throws Exception {
        String expected = "true\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\tBZ\t2016-05-01T10:22:00.000Z\tfalse\nfalse\tKK\tXX\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\tXX\t2016-05-01T10:24:00.000Z\ttrue\ntrue\tAX\tXX\t2016-05-01T10:25:00.000Z\ttrue\ntrue\tAX\tBZ\t2016-05-01T10:26:00.000Z\tfalse\nfalse\tBZ\tXX\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\tKK\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\tKK\t2016-05-01T10:29:00.000Z\tfalse\nfalse\tBZ\tAX\t2016-05-01T10:30:00.000Z\tfalse\nfalse\tXX\tKK\t2016-05-01T10:31:00.000Z\ttrue\nfalse\tKK\tAX\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\tAX\t2016-05-01T10:33:00.000Z\ttrue\nfalse\tBZ\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\tAX\t2016-05-01T10:35:00.000Z\ttrue\ntrue\tAX\tAX\t2016-05-01T10:36:00.000Z\ttrue\ntrue\tXX\tKK\t2016-05-01T10:37:00.000Z\tfalse\ntrue\tAX\tAX\t2016-05-01T10:38:00.000Z\tfalse\nfalse\tBZ\tBZ\t2016-05-01T10:39:00.000Z\tfalse\nfalse\tBZ\tAX\t2016-05-01T10:40:00.000Z\tfalse\n";
        this.assertThat("true\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\tBZ\t2016-05-01T10:22:00.000Z\tfalse\nfalse\tKK\tXX\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\tXX\t2016-05-01T10:24:00.000Z\ttrue\ntrue\tAX\tXX\t2016-05-01T10:25:00.000Z\ttrue\ntrue\tAX\tBZ\t2016-05-01T10:26:00.000Z\tfalse\nfalse\tBZ\tXX\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\tKK\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\tKK\t2016-05-01T10:29:00.000Z\tfalse\nfalse\tBZ\tAX\t2016-05-01T10:30:00.000Z\tfalse\nfalse\tXX\tKK\t2016-05-01T10:31:00.000Z\ttrue\nfalse\tKK\tAX\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\tAX\t2016-05-01T10:33:00.000Z\ttrue\nfalse\tBZ\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\tAX\t2016-05-01T10:35:00.000Z\ttrue\ntrue\tAX\tAX\t2016-05-01T10:36:00.000Z\ttrue\ntrue\tXX\tKK\t2016-05-01T10:37:00.000Z\tfalse\ntrue\tAX\tAX\t2016-05-01T10:38:00.000Z\tfalse\nfalse\tBZ\tBZ\t2016-05-01T10:39:00.000Z\tfalse\nfalse\tBZ\tAX\t2016-05-01T10:40:00.000Z\tfalse\n", "select boo, str, sym, timestamp , next(boo) over (partition by str) from abc");
        this.assertThat("true\tBZ\tBZ\t2016-05-01T10:21:00.000Z\tfalse\nfalse\tXX\tBZ\t2016-05-01T10:22:00.000Z\tfalse\nfalse\tKK\tXX\t2016-05-01T10:23:00.000Z\tfalse\nfalse\tAX\tXX\t2016-05-01T10:24:00.000Z\ttrue\ntrue\tAX\tXX\t2016-05-01T10:25:00.000Z\ttrue\ntrue\tAX\tBZ\t2016-05-01T10:26:00.000Z\tfalse\nfalse\tBZ\tXX\t2016-05-01T10:27:00.000Z\ttrue\ntrue\tBZ\tKK\t2016-05-01T10:28:00.000Z\tfalse\nfalse\tAX\tKK\t2016-05-01T10:29:00.000Z\tfalse\nfalse\tBZ\tAX\t2016-05-01T10:30:00.000Z\tfalse\nfalse\tXX\tKK\t2016-05-01T10:31:00.000Z\ttrue\nfalse\tKK\tAX\t2016-05-01T10:32:00.000Z\tfalse\nfalse\tAX\tAX\t2016-05-01T10:33:00.000Z\ttrue\nfalse\tBZ\tBZ\t2016-05-01T10:34:00.000Z\tfalse\ntrue\tXX\tAX\t2016-05-01T10:35:00.000Z\ttrue\ntrue\tAX\tAX\t2016-05-01T10:36:00.000Z\ttrue\ntrue\tXX\tKK\t2016-05-01T10:37:00.000Z\tfalse\ntrue\tAX\tAX\t2016-05-01T10:38:00.000Z\tfalse\nfalse\tBZ\tBZ\t2016-05-01T10:39:00.000Z\tfalse\nfalse\tBZ\tAX\t2016-05-01T10:40:00.000Z\tfalse\n", "select boo, str, sym, timestamp , next(boo) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testByte() throws Exception {
        String expected = "21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t53\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-126\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t-114\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t-95\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-40\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-69\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t77\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t-55\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-72\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-77\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-83\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-114\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-36\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-102\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t70\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n";
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t53\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-126\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t-114\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t-95\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-40\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-69\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t77\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t-55\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-72\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-77\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-83\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-114\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-36\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-102\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t70\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select b, str, sym, timestamp , next(b) over (partition by str) from abc");
        this.assertThat("21\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t53\n-120\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-126\n-34\tKK\tXX\t2016-05-01T10:23:00.000Z\t-114\n-60\tAX\tXX\t2016-05-01T10:24:00.000Z\t-95\n-95\tAX\tXX\t2016-05-01T10:25:00.000Z\t-40\n-40\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-69\n53\tBZ\tXX\t2016-05-01T10:27:00.000Z\t77\n77\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15\n-69\tAX\tKK\t2016-05-01T10:29:00.000Z\t-55\n-15\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-72\n-126\tXX\tKK\t2016-05-01T10:31:00.000Z\t-77\n-114\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-55\tAX\tAX\t2016-05-01T10:33:00.000Z\t-83\n-72\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-114\n-77\tXX\tAX\t2016-05-01T10:35:00.000Z\t-36\n-83\tAX\tAX\t2016-05-01T10:36:00.000Z\t-102\n-36\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-102\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n-114\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t70\n70\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select b, str, sym, timestamp , next(b) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testCompilation() throws Exception {
        this.assertThat(expected, "select i, str, timestamp, next(i) over (partition by str) from xyz");
    }

    @Test
    public void testCompileNonPart() throws Exception {
        String expected = "-1148479920\tBZ\t2016-05-01T10:21:00.000Z\t1548800833\n1548800833\tKK\t2016-05-01T10:22:00.000Z\t73575701\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1326447242\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t1868723706\n1868723706\tAX\t2016-05-01T10:25:00.000Z\t-1191262516\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t-1436881714\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t806715481\n806715481\tAX\t2016-05-01T10:28:00.000Z\t1569490116\n1569490116\tXX\t2016-05-01T10:29:00.000Z\t-409854405\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t1530831067\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-1532328444\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1125579207\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t-1432278050\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t-85170055\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1844391305\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t-1101822104\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t1404198\n1404198\tXX\t2016-05-01T10:38:00.000Z\t-1125169127\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t-1975183723\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t1232884790\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t-2119387831\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t1699553881\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t1253890363\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t-422941535\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t-547127752\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-303295973\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t-2132716300\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t-461611463\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t264240638\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-483853667\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t1890602616\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t68265578\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t-2002373666\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t458818940\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t-2144581835\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t-1418341054\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t2031014705\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t-1575135393\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t936627841\n936627841\tKK\t2016-05-01T11:00:00.000Z\t-667031149\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t-2034804966\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t1637847416\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-1819240775\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t-1787109293\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1515787781\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t161592763\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t636045524\n636045524\tAX\t2016-05-01T11:08:00.000Z\t-1538602195\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t-372268574\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-1299391311\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t-10505757\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t1857212401\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t-443320374\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t1196016669\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t-1566901076\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t-1201923128\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t1876812930\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1582495445\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t532665695\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t1234796102\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t-45567293\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t-373499303\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t-916132123\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t114747951\n114747951\tAX\t2016-05-01T11:25:00.000Z\t-1794809330\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t-731466113\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-882371473\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t-1723887671\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-1172180184\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t-2075675260\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-712702244\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t-1768335227\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t1235206821\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t1795359355\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t-876466531\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t865832060\n865832060\tXX\t2016-05-01T11:37:00.000Z\t-1966408995\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t838743782\n838743782\tAX\t2016-05-01T11:39:00.000Z\t1107889075\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t-618037497\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t-2043803188\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t-68027832\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t519895483\n519895483\tAX\t2016-05-01T11:44:00.000Z\t-2088317486\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t602835017\n602835017\tAX\t2016-05-01T11:46:00.000Z\t-2111250190\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t614536941\n614536941\tXX\t2016-05-01T11:48:00.000Z\t1598679468\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t1658228795\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t-283321892\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t116799613\n116799613\tKK\t2016-05-01T11:52:00.000Z\t1238491107\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t-636975106\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t1015055928\n1015055928\tXX\t2016-05-01T11:55:00.000Z\t1100812407\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1362833895\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t-805434743\n-805434743\tAX\t2016-05-01T11:58:00.000Z\t-640305320\n-640305320\tKK\t2016-05-01T11:59:00.000Z\t1751526583\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\tNaN\n";
        this.assertThat("-1148479920\tBZ\t2016-05-01T10:21:00.000Z\t1548800833\n1548800833\tKK\t2016-05-01T10:22:00.000Z\t73575701\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1326447242\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t1868723706\n1868723706\tAX\t2016-05-01T10:25:00.000Z\t-1191262516\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t-1436881714\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t806715481\n806715481\tAX\t2016-05-01T10:28:00.000Z\t1569490116\n1569490116\tXX\t2016-05-01T10:29:00.000Z\t-409854405\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t1530831067\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-1532328444\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1125579207\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t-1432278050\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t-85170055\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1844391305\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t-1101822104\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t1404198\n1404198\tXX\t2016-05-01T10:38:00.000Z\t-1125169127\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t-1975183723\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t1232884790\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t-2119387831\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t1699553881\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t1253890363\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t-422941535\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t-547127752\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-303295973\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t-2132716300\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t-461611463\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t264240638\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-483853667\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t1890602616\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t68265578\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t-2002373666\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t458818940\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t-2144581835\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t-1418341054\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t2031014705\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t-1575135393\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t936627841\n936627841\tKK\t2016-05-01T11:00:00.000Z\t-667031149\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t-2034804966\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t1637847416\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-1819240775\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t-1787109293\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1515787781\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t161592763\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t636045524\n636045524\tAX\t2016-05-01T11:08:00.000Z\t-1538602195\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t-372268574\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-1299391311\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t-10505757\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t1857212401\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t-443320374\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t1196016669\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t-1566901076\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t-1201923128\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t1876812930\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1582495445\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t532665695\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t1234796102\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t-45567293\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t-373499303\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t-916132123\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t114747951\n114747951\tAX\t2016-05-01T11:25:00.000Z\t-1794809330\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t-731466113\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-882371473\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t-1723887671\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-1172180184\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t-2075675260\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-712702244\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t-1768335227\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t1235206821\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t1795359355\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t-876466531\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t865832060\n865832060\tXX\t2016-05-01T11:37:00.000Z\t-1966408995\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t838743782\n838743782\tAX\t2016-05-01T11:39:00.000Z\t1107889075\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t-618037497\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t-2043803188\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t-68027832\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t519895483\n519895483\tAX\t2016-05-01T11:44:00.000Z\t-2088317486\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t602835017\n602835017\tAX\t2016-05-01T11:46:00.000Z\t-2111250190\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t614536941\n614536941\tXX\t2016-05-01T11:48:00.000Z\t1598679468\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t1658228795\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t-283321892\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t116799613\n116799613\tKK\t2016-05-01T11:52:00.000Z\t1238491107\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t-636975106\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t1015055928\n1015055928\tXX\t2016-05-01T11:55:00.000Z\t1100812407\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1362833895\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t-805434743\n-805434743\tAX\t2016-05-01T11:58:00.000Z\t-640305320\n-640305320\tKK\t2016-05-01T11:59:00.000Z\t1751526583\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\tNaN\n", "select i, str, timestamp, next(i) over () from xyz");
        this.assertThat("-1148479920\tBZ\t2016-05-01T10:21:00.000Z\t1548800833\n1548800833\tKK\t2016-05-01T10:22:00.000Z\t73575701\n73575701\tKK\t2016-05-01T10:23:00.000Z\t1326447242\n1326447242\tKK\t2016-05-01T10:24:00.000Z\t1868723706\n1868723706\tAX\t2016-05-01T10:25:00.000Z\t-1191262516\n-1191262516\tAX\t2016-05-01T10:26:00.000Z\t-1436881714\n-1436881714\tKK\t2016-05-01T10:27:00.000Z\t806715481\n806715481\tAX\t2016-05-01T10:28:00.000Z\t1569490116\n1569490116\tXX\t2016-05-01T10:29:00.000Z\t-409854405\n-409854405\tBZ\t2016-05-01T10:30:00.000Z\t1530831067\n1530831067\tKK\t2016-05-01T10:31:00.000Z\t-1532328444\n-1532328444\tXX\t2016-05-01T10:32:00.000Z\t1125579207\n1125579207\tAX\t2016-05-01T10:33:00.000Z\t-1432278050\n-1432278050\tAX\t2016-05-01T10:34:00.000Z\t-85170055\n-85170055\tAX\t2016-05-01T10:35:00.000Z\t-1844391305\n-1844391305\tKK\t2016-05-01T10:36:00.000Z\t-1101822104\n-1101822104\tKK\t2016-05-01T10:37:00.000Z\t1404198\n1404198\tXX\t2016-05-01T10:38:00.000Z\t-1125169127\n-1125169127\tAX\t2016-05-01T10:39:00.000Z\t-1975183723\n-1975183723\tAX\t2016-05-01T10:40:00.000Z\t1232884790\n1232884790\tXX\t2016-05-01T10:41:00.000Z\t-2119387831\n-2119387831\tAX\t2016-05-01T10:42:00.000Z\t1699553881\n1699553881\tBZ\t2016-05-01T10:43:00.000Z\t1253890363\n1253890363\tAX\t2016-05-01T10:44:00.000Z\t-422941535\n-422941535\tBZ\t2016-05-01T10:45:00.000Z\t-547127752\n-547127752\tKK\t2016-05-01T10:46:00.000Z\t-303295973\n-303295973\tBZ\t2016-05-01T10:47:00.000Z\t-2132716300\n-2132716300\tAX\t2016-05-01T10:48:00.000Z\t-461611463\n-461611463\tKK\t2016-05-01T10:49:00.000Z\t264240638\n264240638\tAX\t2016-05-01T10:50:00.000Z\t-483853667\n-483853667\tAX\t2016-05-01T10:51:00.000Z\t1890602616\n1890602616\tBZ\t2016-05-01T10:52:00.000Z\t68265578\n68265578\tBZ\t2016-05-01T10:53:00.000Z\t-2002373666\n-2002373666\tAX\t2016-05-01T10:54:00.000Z\t458818940\n458818940\tBZ\t2016-05-01T10:55:00.000Z\t-2144581835\n-2144581835\tKK\t2016-05-01T10:56:00.000Z\t-1418341054\n-1418341054\tAX\t2016-05-01T10:57:00.000Z\t2031014705\n2031014705\tKK\t2016-05-01T10:58:00.000Z\t-1575135393\n-1575135393\tXX\t2016-05-01T10:59:00.000Z\t936627841\n936627841\tKK\t2016-05-01T11:00:00.000Z\t-667031149\n-667031149\tKK\t2016-05-01T11:01:00.000Z\t-2034804966\n-2034804966\tBZ\t2016-05-01T11:02:00.000Z\t1637847416\n1637847416\tKK\t2016-05-01T11:03:00.000Z\t-1819240775\n-1819240775\tKK\t2016-05-01T11:04:00.000Z\t-1787109293\n-1787109293\tAX\t2016-05-01T11:05:00.000Z\t-1515787781\n-1515787781\tAX\t2016-05-01T11:06:00.000Z\t161592763\n161592763\tBZ\t2016-05-01T11:07:00.000Z\t636045524\n636045524\tAX\t2016-05-01T11:08:00.000Z\t-1538602195\n-1538602195\tAX\t2016-05-01T11:09:00.000Z\t-372268574\n-372268574\tXX\t2016-05-01T11:10:00.000Z\t-1299391311\n-1299391311\tBZ\t2016-05-01T11:11:00.000Z\t-10505757\n-10505757\tXX\t2016-05-01T11:12:00.000Z\t1857212401\n1857212401\tBZ\t2016-05-01T11:13:00.000Z\t-443320374\n-443320374\tAX\t2016-05-01T11:14:00.000Z\t1196016669\n1196016669\tBZ\t2016-05-01T11:15:00.000Z\t-1566901076\n-1566901076\tXX\t2016-05-01T11:16:00.000Z\t-1201923128\n-1201923128\tKK\t2016-05-01T11:17:00.000Z\t1876812930\n1876812930\tXX\t2016-05-01T11:18:00.000Z\t-1582495445\n-1582495445\tKK\t2016-05-01T11:19:00.000Z\t532665695\n532665695\tBZ\t2016-05-01T11:20:00.000Z\t1234796102\n1234796102\tAX\t2016-05-01T11:21:00.000Z\t-45567293\n-45567293\tKK\t2016-05-01T11:22:00.000Z\t-373499303\n-373499303\tBZ\t2016-05-01T11:23:00.000Z\t-916132123\n-916132123\tKK\t2016-05-01T11:24:00.000Z\t114747951\n114747951\tAX\t2016-05-01T11:25:00.000Z\t-1794809330\n-1794809330\tAX\t2016-05-01T11:26:00.000Z\t-731466113\n-731466113\tKK\t2016-05-01T11:27:00.000Z\t-882371473\n-882371473\tAX\t2016-05-01T11:28:00.000Z\t-1723887671\n-1723887671\tBZ\t2016-05-01T11:29:00.000Z\t-1172180184\n-1172180184\tXX\t2016-05-01T11:30:00.000Z\t-2075675260\n-2075675260\tKK\t2016-05-01T11:31:00.000Z\t-712702244\n-712702244\tBZ\t2016-05-01T11:32:00.000Z\t-1768335227\n-1768335227\tKK\t2016-05-01T11:33:00.000Z\t1235206821\n1235206821\tAX\t2016-05-01T11:34:00.000Z\t1795359355\n1795359355\tBZ\t2016-05-01T11:35:00.000Z\t-876466531\n-876466531\tBZ\t2016-05-01T11:36:00.000Z\t865832060\n865832060\tXX\t2016-05-01T11:37:00.000Z\t-1966408995\n-1966408995\tKK\t2016-05-01T11:38:00.000Z\t838743782\n838743782\tAX\t2016-05-01T11:39:00.000Z\t1107889075\n1107889075\tKK\t2016-05-01T11:40:00.000Z\t-618037497\n-618037497\tAX\t2016-05-01T11:41:00.000Z\t-2043803188\n-2043803188\tBZ\t2016-05-01T11:42:00.000Z\t-68027832\n-68027832\tKK\t2016-05-01T11:43:00.000Z\t519895483\n519895483\tAX\t2016-05-01T11:44:00.000Z\t-2088317486\n-2088317486\tKK\t2016-05-01T11:45:00.000Z\t602835017\n602835017\tAX\t2016-05-01T11:46:00.000Z\t-2111250190\n-2111250190\tAX\t2016-05-01T11:47:00.000Z\t614536941\n614536941\tXX\t2016-05-01T11:48:00.000Z\t1598679468\n1598679468\tAX\t2016-05-01T11:49:00.000Z\t1658228795\n1658228795\tBZ\t2016-05-01T11:50:00.000Z\t-283321892\n-283321892\tKK\t2016-05-01T11:51:00.000Z\t116799613\n116799613\tKK\t2016-05-01T11:52:00.000Z\t1238491107\n1238491107\tBZ\t2016-05-01T11:53:00.000Z\t-636975106\n-636975106\tKK\t2016-05-01T11:54:00.000Z\t1015055928\n1015055928\tXX\t2016-05-01T11:55:00.000Z\t1100812407\n1100812407\tBZ\t2016-05-01T11:56:00.000Z\t1362833895\n1362833895\tAX\t2016-05-01T11:57:00.000Z\t-805434743\n-805434743\tAX\t2016-05-01T11:58:00.000Z\t-640305320\n-640305320\tKK\t2016-05-01T11:59:00.000Z\t1751526583\n1751526583\tBZ\t2016-05-01T12:00:00.000Z\tNaN\n", "select i, str, timestamp, next(i) over () from '*!*xyz'");
    }

    @Test
    public void testDate() throws Exception {
        String expected = "277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t231478896-06-17T12:18:04.767Z\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-201714876-08-10T10:14:48.134Z\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t132059357-01-03T08:27:45.836Z\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t217217443-02-16T18:39:59.220Z\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t263840408-06-11T18:15:05.778Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-230266796-08-17T22:57:03.970Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t220352915-01-17T00:08:45.841Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t18125533-09-05T04:06:38.086Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t-253361973-02-05T02:07:37.180Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-180947413-05-05T10:19:58.733Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t-225086326-11-23T21:53:40.936Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t252677978-05-07T03:29:33.753Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t167791211-12-09T07:52:02.538Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-244304870-03-25T17:50:45.758Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-196068605-07-20T05:32:43.747Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-56977607-10-20T13:10:29.515Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t\n";
        this.assertThat("277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t231478896-06-17T12:18:04.767Z\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-201714876-08-10T10:14:48.134Z\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t132059357-01-03T08:27:45.836Z\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t217217443-02-16T18:39:59.220Z\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t263840408-06-11T18:15:05.778Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-230266796-08-17T22:57:03.970Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t220352915-01-17T00:08:45.841Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t18125533-09-05T04:06:38.086Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t-253361973-02-05T02:07:37.180Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-180947413-05-05T10:19:58.733Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t-225086326-11-23T21:53:40.936Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t252677978-05-07T03:29:33.753Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t167791211-12-09T07:52:02.538Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-244304870-03-25T17:50:45.758Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-196068605-07-20T05:32:43.747Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-56977607-10-20T13:10:29.515Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t\n", "select date, str, sym, timestamp , next(date) over (partition by str) from abc");
        this.assertThat("277433687-10-12T08:51:21.932Z\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t231478896-06-17T12:18:04.767Z\n-284210729-04-16T06:37:25.107Z\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-201714876-08-10T10:14:48.134Z\n-142145720-12-30T10:07:22.984Z\tKK\tXX\t2016-05-01T10:23:00.000Z\t132059357-01-03T08:27:45.836Z\n-268695905-10-25T00:06:37.492Z\tAX\tXX\t2016-05-01T10:24:00.000Z\t217217443-02-16T18:39:59.220Z\n217217443-02-16T18:39:59.220Z\tAX\tXX\t2016-05-01T10:25:00.000Z\t263840408-06-11T18:15:05.778Z\n263840408-06-11T18:15:05.778Z\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-230266796-08-17T22:57:03.970Z\n231478896-06-17T12:18:04.767Z\tBZ\tXX\t2016-05-01T10:27:00.000Z\t220352915-01-17T00:08:45.841Z\n220352915-01-17T00:08:45.841Z\tBZ\tKK\t2016-05-01T10:28:00.000Z\t18125533-09-05T04:06:38.086Z\n-230266796-08-17T22:57:03.970Z\tAX\tKK\t2016-05-01T10:29:00.000Z\t-253361973-02-05T02:07:37.180Z\n18125533-09-05T04:06:38.086Z\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-180947413-05-05T10:19:58.733Z\n-201714876-08-10T10:14:48.134Z\tXX\tKK\t2016-05-01T10:31:00.000Z\t-225086326-11-23T21:53:40.936Z\n132059357-01-03T08:27:45.836Z\tKK\tAX\t2016-05-01T10:32:00.000Z\t\n-253361973-02-05T02:07:37.180Z\tAX\tAX\t2016-05-01T10:33:00.000Z\t252677978-05-07T03:29:33.753Z\n-180947413-05-05T10:19:58.733Z\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t167791211-12-09T07:52:02.538Z\n-225086326-11-23T21:53:40.936Z\tXX\tAX\t2016-05-01T10:35:00.000Z\t-244304870-03-25T17:50:45.758Z\n252677978-05-07T03:29:33.753Z\tAX\tAX\t2016-05-01T10:36:00.000Z\t-196068605-07-20T05:32:43.747Z\n-244304870-03-25T17:50:45.758Z\tXX\tKK\t2016-05-01T10:37:00.000Z\t\n-196068605-07-20T05:32:43.747Z\tAX\tAX\t2016-05-01T10:38:00.000Z\t\n167791211-12-09T07:52:02.538Z\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-56977607-10-20T13:10:29.515Z\n-56977607-10-20T13:10:29.515Z\tBZ\tAX\t2016-05-01T10:40:00.000Z\t\n", "select date, str, sym, timestamp , next(date) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testDifferentOrderByRowId() throws Exception {
        String result = "sho\tstr\tsym\ttimestamp\tblah\tcol0\tcol1\tcol2\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-24357\tXX\tXX\t-20409\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21781\tKK\tKK\t-391\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-19127\tAX\tAX\t-24455\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\tXX\tXX\t-19496\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\tBZ\tBZ\t11755\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-391\tKK\tKK\t0\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\tKK\tKK\t25974\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-19136\tAX\tAX\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-15331\tAX\tAX\t-4874\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-4874\tBZ\tBZ\t5869\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25102\tAX\tAX\t21781\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-20409\t\t\t-26951\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-29572\tAX\tAX\t25102\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t25974\tBZ\tBZ\t-18600\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t5869\tKK\tKK\t-19136\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-22894\tAX\tAX\t-22894\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t-18600\t\t\t-15458\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t11755\t\t\t-19127\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\tAX\tAX\t-22934\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\t\t\t-29572\n";
        this.assertThat("sho\tstr\tsym\ttimestamp\tblah\tcol0\tcol1\tcol2\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-24357\tXX\tXX\t-20409\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21781\tKK\tKK\t-391\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-19127\tAX\tAX\t-24455\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\tXX\tXX\t-19496\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\tBZ\tBZ\t11755\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-391\tKK\tKK\t0\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\tKK\tKK\t25974\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-19136\tAX\tAX\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-15331\tAX\tAX\t-4874\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-4874\tBZ\tBZ\t5869\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25102\tAX\tAX\t21781\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-20409\t\t\t-26951\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-29572\tAX\tAX\t25102\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t25974\tBZ\tBZ\t-18600\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t5869\tKK\tKK\t-19136\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-22894\tAX\tAX\t-22894\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t-18600\t\t\t-15458\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t11755\t\t\t-19127\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\tAX\tAX\t-22934\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\t\t\t-29572\n", "select sho, str, sym, timestamp, next(sho) blah over (order by timestamp), next(sym) over (partition by str order by timestamp), next(sym) over (partition by str), next(sho) over (order by i) from '*!*abc'", true);
    }

    @Test
    public void testDouble() throws Exception {
        String expected = "1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0.332301996648\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.000002473130\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\t632.921875000000\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\t-512.000000000000\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.675451681018\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.000076281818\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.000001752813\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.000000005555\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.000000020896\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.007371325744\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.000000014643\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t512.000000000000\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-842.000000000000\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t864.000000000000\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000157437\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.000032060649\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n";
        this.assertThat("1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0.332301996648\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.000002473130\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\t632.921875000000\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\t-512.000000000000\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.675451681018\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.000076281818\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.000001752813\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.000000005555\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.000000020896\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.007371325744\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.000000014643\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t512.000000000000\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-842.000000000000\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t864.000000000000\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000157437\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.000032060649\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n", "select d, str, sym, timestamp , next(d) over (partition by str) from abc");
        this.assertThat("1.050231933594\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0.332301996648\n566.734375000000\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.000002473130\n0.000013792171\tKK\tXX\t2016-05-01T10:23:00.000Z\t632.921875000000\n0.000000567185\tAX\tXX\t2016-05-01T10:24:00.000Z\t-512.000000000000\n-512.000000000000\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.675451681018\n0.675451681018\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.000076281818\n0.332301996648\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.000001752813\n0.000001752813\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.000000005555\n0.000076281818\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.000000020896\n0.000000005555\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.007371325744\n0.000002473130\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.000000014643\n632.921875000000\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n0.000000020896\tAX\tAX\t2016-05-01T10:33:00.000Z\t512.000000000000\n0.007371325744\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t-842.000000000000\n0.000000014643\tXX\tAX\t2016-05-01T10:35:00.000Z\t864.000000000000\n512.000000000000\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.000000157437\n864.000000000000\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n0.000000157437\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n-842.000000000000\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.000032060649\n0.000032060649\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n", "select d, str, sym, timestamp , next(d) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testFloat() throws Exception {
        String expected = "0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0.5725\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.7274\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\t0.5619\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.4848\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.2969\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.1609\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.5967\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.3509\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.5433\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.5442\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.6746\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.8217\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.1168\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.3591\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.6827\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.4967\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n";
        this.assertThat("0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0.5725\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.7274\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\t0.5619\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.4848\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.2969\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.1609\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.5967\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.3509\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.5433\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.5442\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.6746\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.8217\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.1168\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.3591\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.6827\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.4967\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n", "select f, str, sym, timestamp , next(f) over (partition by str) from abc");
        this.assertThat("0.6235\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t0.5725\n0.7780\tXX\tBZ\t2016-05-01T10:22:00.000Z\t0.7274\n0.5509\tKK\tXX\t2016-05-01T10:23:00.000Z\t0.5619\n0.0204\tAX\tXX\t2016-05-01T10:24:00.000Z\t0.4848\n0.4848\tAX\tXX\t2016-05-01T10:25:00.000Z\t0.2969\n0.2969\tAX\tBZ\t2016-05-01T10:26:00.000Z\t0.1609\n0.5725\tBZ\tXX\t2016-05-01T10:27:00.000Z\t0.5967\n0.5967\tBZ\tKK\t2016-05-01T10:28:00.000Z\t0.3509\n0.1609\tAX\tKK\t2016-05-01T10:29:00.000Z\t0.5433\n0.3509\tBZ\tAX\t2016-05-01T10:30:00.000Z\t0.5442\n0.7274\tXX\tKK\t2016-05-01T10:31:00.000Z\t0.6746\n0.5619\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n0.5433\tAX\tAX\t2016-05-01T10:33:00.000Z\t0.8217\n0.5442\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t0.1168\n0.6746\tXX\tAX\t2016-05-01T10:35:00.000Z\t0.3591\n0.8217\tAX\tAX\t2016-05-01T10:36:00.000Z\t0.6827\n0.3591\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n0.6827\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n0.1168\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t0.4967\n0.4967\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n", "select f, str, sym, timestamp , next(f) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testLong() throws Exception {
        String expected = "8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-6253307669002054137\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-7387846268299105911\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\t7122109662042058469\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\t7199909180655756830\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t6270672455202306717\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-7316123607359392486\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t7392877322819819290\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-3107239868490395663\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t-6626590012581323602\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t8611582118025429627\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-8082754367165748693\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t6574958665733670985\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t8152044974329490473\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t3446015290144635451\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t8889492928577876455\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-6071768268784020226\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n";
        this.assertThat("8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-6253307669002054137\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-7387846268299105911\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\t7122109662042058469\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\t7199909180655756830\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t6270672455202306717\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-7316123607359392486\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t7392877322819819290\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-3107239868490395663\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t-6626590012581323602\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t8611582118025429627\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-8082754367165748693\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t6574958665733670985\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t8152044974329490473\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t3446015290144635451\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t8889492928577876455\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-6071768268784020226\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n", "select l, str, sym, timestamp , next(l) over (partition by str) from abc");
        this.assertThat("8920866532787660373\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-6253307669002054137\n-6943924477733600060\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-7387846268299105911\n-6856503215590263904\tKK\tXX\t2016-05-01T10:23:00.000Z\t7122109662042058469\n8416773233910814357\tAX\tXX\t2016-05-01T10:24:00.000Z\t7199909180655756830\n7199909180655756830\tAX\tXX\t2016-05-01T10:25:00.000Z\t6270672455202306717\n6270672455202306717\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-7316123607359392486\n-6253307669002054137\tBZ\tXX\t2016-05-01T10:27:00.000Z\t7392877322819819290\n7392877322819819290\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-3107239868490395663\n-7316123607359392486\tAX\tKK\t2016-05-01T10:29:00.000Z\t-6626590012581323602\n-3107239868490395663\tBZ\tAX\t2016-05-01T10:30:00.000Z\t8611582118025429627\n-7387846268299105911\tXX\tKK\t2016-05-01T10:31:00.000Z\t-8082754367165748693\n7122109662042058469\tKK\tAX\t2016-05-01T10:32:00.000Z\tNaN\n-6626590012581323602\tAX\tAX\t2016-05-01T10:33:00.000Z\t6574958665733670985\n8611582118025429627\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t8152044974329490473\n-8082754367165748693\tXX\tAX\t2016-05-01T10:35:00.000Z\t3446015290144635451\n6574958665733670985\tAX\tAX\t2016-05-01T10:36:00.000Z\t8889492928577876455\n3446015290144635451\tXX\tKK\t2016-05-01T10:37:00.000Z\tNaN\n8889492928577876455\tAX\tAX\t2016-05-01T10:38:00.000Z\tNaN\n8152044974329490473\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-6071768268784020226\n-6071768268784020226\tBZ\tAX\t2016-05-01T10:40:00.000Z\tNaN\n", "select l, str, sym, timestamp , next(l) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testNoArg() {
        try {
            this.expectFailure("select str, next() rank over(partition by str) from 'abc'");
        }
        catch (ParserException e) {
            TestUtils.assertEquals((CharSequence)"Unknown function", QueryError.getMessage());
        }
    }

    @Test
    public void testNonPartAnalyticSymbolBehaviour() throws Exception {
        NextAnalyticFunctionTest.assertSymbol("select l, str, sym, timestamp , next(sym) over () from abc", 4);
    }

    @Test
    public void testPlan() throws Exception {
        this.assertPlan2("{\n  \"op\": \"SelectedColumnsRecordSource\",\n  \"src\": {\n    \"op\": \"CachedRowAnalyticRecordSource\",\n    \"functions\": 1,\n    \"orderedSources\": 1,\n    \"src\": {\n      \"op\": \"JournalRecordSource\",\n      \"psrc\": {\n        \"op\": \"JournalPartitionSource\",\n        \"journal\": \"abc\"\n      },\n      \"rsrc\": {\n        \"op\": \"AllRowSource\"\n      }\n    }\n  }\n}", "select str, sym, timestamp , next(sym) over (partition by str) from abc");
    }

    @Test
    public void testShort() throws Exception {
        String expected = "-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n";
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select sho, str, sym, timestamp , next(sho) over (partition by str) from abc");
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select sho, str, sym, timestamp , next(sho) over (partition by str) from '*!*abc'");
    }

    @Test
    public void testShort2() throws Exception {
        String expected = "-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-24357\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21781\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-19127\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-391\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-19136\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-15331\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-4874\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25102\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-20409\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-29572\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t25974\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t5869\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-22894\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t-18600\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t11755\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n";
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-24357\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21781\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-19127\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-391\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-19136\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-15331\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-4874\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25102\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-20409\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-29572\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t25974\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t5869\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-22894\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t-18600\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t11755\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select sho, str, sym, timestamp , next(sho) over () from abc");
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-24357\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21781\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-19127\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-391\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-19136\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-15331\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-4874\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25102\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-20409\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-29572\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t25974\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t5869\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-22894\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t-18600\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t11755\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select sho, str, sym, timestamp , next(sho) over () from '*!*abc'");
    }

    @Test
    public void testShortAliased() throws Exception {
        String expected = "sho\tstr\tsym\ttimestamp\tblah\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n";
        this.assertThat("sho\tstr\tsym\ttimestamp\tblah\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select sho, str, sym, timestamp , next(sho) blah over (partition by str) from abc", true);
        this.assertThat("sho\tstr\tsym\ttimestamp\tblah\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\n", "select sho, str, sym, timestamp , next(sho) blah over (partition by str) from '*!*abc'", true);
    }

    @Test
    public void testStr() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\tAX\nKK\tXX\t2016-05-01T10:23:00.000Z\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\tAX\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tBZ\nBZ\tXX\t2016-05-01T10:27:00.000Z\t\nBZ\tKK\t2016-05-01T10:28:00.000Z\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tXX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tXX\nKK\tAX\t2016-05-01T10:32:00.000Z\tAX\nAX\tAX\t2016-05-01T10:33:00.000Z\tXX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\t\nAX\tAX\t2016-05-01T10:38:00.000Z\tBZ\nBZ\tBZ\t2016-05-01T10:39:00.000Z\t\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\tAX\nKK\tXX\t2016-05-01T10:23:00.000Z\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\tAX\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tBZ\nBZ\tXX\t2016-05-01T10:27:00.000Z\t\nBZ\tKK\t2016-05-01T10:28:00.000Z\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tXX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tXX\nKK\tAX\t2016-05-01T10:32:00.000Z\tAX\nAX\tAX\t2016-05-01T10:33:00.000Z\tXX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\t\nAX\tAX\t2016-05-01T10:38:00.000Z\tBZ\nBZ\tBZ\t2016-05-01T10:39:00.000Z\t\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\n", "select str, sym, timestamp , next(str) over (partition by sym) from 'abc'");
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\tAX\nKK\tXX\t2016-05-01T10:23:00.000Z\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\tAX\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tBZ\nBZ\tXX\t2016-05-01T10:27:00.000Z\t\nBZ\tKK\t2016-05-01T10:28:00.000Z\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tXX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tXX\nKK\tAX\t2016-05-01T10:32:00.000Z\tAX\nAX\tAX\t2016-05-01T10:33:00.000Z\tXX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\t\nAX\tAX\t2016-05-01T10:38:00.000Z\tBZ\nBZ\tBZ\t2016-05-01T10:39:00.000Z\t\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\n", "select str, sym, timestamp , next(str) over (partition by sym) from '*!*abc'");
    }

    @Test
    public void testStreamingAndTwoPass() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\tXX\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tKK\t\nKK\tXX\t2016-05-01T10:23:00.000Z\tAX\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\t\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tKK\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tKK\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tAX\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tAX\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tBZ\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\t\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tBZ\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\t\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\t\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\tBZ\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\tXX\t\nXX\tBZ\t2016-05-01T10:22:00.000Z\tKK\t\nKK\tXX\t2016-05-01T10:23:00.000Z\tAX\t\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\t\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\tXX\nAX\tBZ\t2016-05-01T10:26:00.000Z\tKK\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tKK\tBZ\nBZ\tKK\t2016-05-01T10:28:00.000Z\tAX\tXX\nAX\tKK\t2016-05-01T10:29:00.000Z\tAX\tBZ\nBZ\tAX\t2016-05-01T10:30:00.000Z\tBZ\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\tBZ\nKK\tAX\t2016-05-01T10:32:00.000Z\t\tXX\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\tKK\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tBZ\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\t\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\t\tAX\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\tBZ\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\tBZ\n", "select str, sym, timestamp , next(sym) over (partition by str), prev(sym) over (partition by str) from abc");
    }

    @Test
    public void testSymNonPart() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\tBZ\nXX\tBZ\t2016-05-01T10:22:00.000Z\tXX\nKK\tXX\t2016-05-01T10:23:00.000Z\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tKK\nBZ\tKK\t2016-05-01T10:28:00.000Z\tKK\nAX\tKK\t2016-05-01T10:29:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tAX\nAX\tAX\t2016-05-01T10:33:00.000Z\tBZ\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tKK\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tBZ\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\tBZ\nXX\tBZ\t2016-05-01T10:22:00.000Z\tXX\nKK\tXX\t2016-05-01T10:23:00.000Z\tXX\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tXX\nBZ\tXX\t2016-05-01T10:27:00.000Z\tKK\nBZ\tKK\t2016-05-01T10:28:00.000Z\tKK\nAX\tKK\t2016-05-01T10:29:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tKK\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\tAX\nAX\tAX\t2016-05-01T10:33:00.000Z\tBZ\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tAX\nXX\tAX\t2016-05-01T10:35:00.000Z\tAX\nAX\tAX\t2016-05-01T10:36:00.000Z\tKK\nXX\tKK\t2016-05-01T10:37:00.000Z\tAX\nAX\tAX\t2016-05-01T10:38:00.000Z\tBZ\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\n", "select str, sym, timestamp , next(sym) over () from abc");
    }

    @Test
    public void testSymbol() throws Exception {
        String expected = "BZ\tBZ\t2016-05-01T10:21:00.000Z\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\tKK\nKK\tXX\t2016-05-01T10:23:00.000Z\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tKK\nBZ\tXX\t2016-05-01T10:27:00.000Z\tKK\nBZ\tKK\t2016-05-01T10:28:00.000Z\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tBZ\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\t\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\t\nAX\tAX\t2016-05-01T10:38:00.000Z\t\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\n";
        this.assertThat("BZ\tBZ\t2016-05-01T10:21:00.000Z\tXX\nXX\tBZ\t2016-05-01T10:22:00.000Z\tKK\nKK\tXX\t2016-05-01T10:23:00.000Z\tAX\nAX\tXX\t2016-05-01T10:24:00.000Z\tXX\nAX\tXX\t2016-05-01T10:25:00.000Z\tBZ\nAX\tBZ\t2016-05-01T10:26:00.000Z\tKK\nBZ\tXX\t2016-05-01T10:27:00.000Z\tKK\nBZ\tKK\t2016-05-01T10:28:00.000Z\tAX\nAX\tKK\t2016-05-01T10:29:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:30:00.000Z\tBZ\nXX\tKK\t2016-05-01T10:31:00.000Z\tAX\nKK\tAX\t2016-05-01T10:32:00.000Z\t\nAX\tAX\t2016-05-01T10:33:00.000Z\tAX\nBZ\tBZ\t2016-05-01T10:34:00.000Z\tBZ\nXX\tAX\t2016-05-01T10:35:00.000Z\tKK\nAX\tAX\t2016-05-01T10:36:00.000Z\tAX\nXX\tKK\t2016-05-01T10:37:00.000Z\t\nAX\tAX\t2016-05-01T10:38:00.000Z\t\nBZ\tBZ\t2016-05-01T10:39:00.000Z\tAX\nBZ\tAX\t2016-05-01T10:40:00.000Z\t\n", "select str, sym, timestamp , next(sym) over (partition by str) from abc");
    }

    @Test
    public void testTwoSameOrder() throws Exception {
        String result = "sho\tstr\tsym\ttimestamp\tblah\tcol0\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-24357\tBZ\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21781\tXX\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-19127\tXX\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\tXX\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\tBZ\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-391\tXX\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\tKK\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-19136\tKK\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-15331\tAX\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-4874\tKK\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25102\tAX\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-20409\tAX\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-29572\tBZ\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t25974\tAX\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t5869\tAX\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-22894\tKK\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t-18600\tAX\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t11755\tBZ\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\tAX\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\t\n";
        this.assertThat("sho\tstr\tsym\ttimestamp\tblah\tcol0\n-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-24357\tBZ\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t21781\tXX\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t-19127\tXX\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\tXX\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\tBZ\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-391\tXX\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\tKK\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-19136\tKK\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-15331\tAX\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-4874\tKK\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25102\tAX\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t-20409\tAX\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t-29572\tBZ\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t25974\tAX\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t5869\tAX\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-22894\tKK\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t-18600\tAX\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t11755\tBZ\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\tAX\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\t\n", "select sho, str, sym, timestamp, next(sho) blah over (order by timestamp), next(sym) over () from '*!*abc'", true);
    }

    @Test
    public void testTwoSameOrderByRowId() throws Exception {
        String result = "-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\tXX\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\tKK\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\tAX\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\tXX\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\tBZ\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\tKK\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\tKK\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\tAX\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\tAX\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\tBZ\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\tAX\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\t\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\tAX\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\tBZ\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\tKK\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\tAX\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\t\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\t\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\tAX\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\t\n";
        this.assertThat("-19496\tBZ\tBZ\t2016-05-01T10:21:00.000Z\t-391\tXX\n-24357\tXX\tBZ\t2016-05-01T10:22:00.000Z\t-4874\tKK\n21781\tKK\tXX\t2016-05-01T10:23:00.000Z\t25102\tAX\n-19127\tAX\tXX\t2016-05-01T10:24:00.000Z\t-15458\tXX\n-15458\tAX\tXX\t2016-05-01T10:25:00.000Z\t-22934\tBZ\n-22934\tAX\tBZ\t2016-05-01T10:26:00.000Z\t-19136\tKK\n-391\tBZ\tXX\t2016-05-01T10:27:00.000Z\t-26951\tKK\n-26951\tBZ\tKK\t2016-05-01T10:28:00.000Z\t-15331\tAX\n-19136\tAX\tKK\t2016-05-01T10:29:00.000Z\t-20409\tAX\n-15331\tBZ\tAX\t2016-05-01T10:30:00.000Z\t-29572\tBZ\n-4874\tXX\tKK\t2016-05-01T10:31:00.000Z\t25974\tAX\n25102\tKK\tAX\t2016-05-01T10:32:00.000Z\t0\t\n-20409\tAX\tAX\t2016-05-01T10:33:00.000Z\t5869\tAX\n-29572\tBZ\tBZ\t2016-05-01T10:34:00.000Z\t11755\tBZ\n25974\tXX\tAX\t2016-05-01T10:35:00.000Z\t-22894\tKK\n5869\tAX\tAX\t2016-05-01T10:36:00.000Z\t-18600\tAX\n-22894\tXX\tKK\t2016-05-01T10:37:00.000Z\t0\t\n-18600\tAX\tAX\t2016-05-01T10:38:00.000Z\t0\t\n11755\tBZ\tBZ\t2016-05-01T10:39:00.000Z\t-24455\tAX\n-24455\tBZ\tAX\t2016-05-01T10:40:00.000Z\t0\t\n", "select sho, str, sym, timestamp, next(sho) blah over (partition by str order by timestamp), next(sym) over (partition by str order by timestamp) from abc");
    }

    @Test
    public void testTwoSameOrderByRowIdSymbolBehaviour() throws Exception {
        NextAnalyticFunctionTest.assertSymbol("select sho, str, sym, timestamp, next(sho) blah over (partition by str order by timestamp), next(sym) over (partition by str order by timestamp) from abc", 2);
        NextAnalyticFunctionTest.assertSymbol("select sho, str, sym, timestamp, next(sho) blah over (partition by str order by timestamp), next(sym) over (partition by str order by timestamp) from abc", 5);
    }

    @Test
    public void testTwoSameOrderBySymbolBehaviour() throws Exception {
        NextAnalyticFunctionTest.assertSymbol("select sho, str, sym, timestamp, next(sho) blah over (partition by str order by timestamp), next(sym) over (partition by str order by timestamp) from '*!*abc'", 2);
        NextAnalyticFunctionTest.assertSymbol("select sho, str, sym, timestamp, next(sho) blah over (partition by str order by timestamp), next(sym) over (partition by str order by timestamp) from '*!*abc'", 5);
    }

    @Test
    public void testWrongColumnInFunc() {
        try {
            this.expectFailure("select str, sym, timestamp , next(symx) over (partition by str) from abc");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)34L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testWrongColumnInPartition() {
        try {
            this.expectFailure("select str, sym, timestamp , next(sym) over (partition by strx) from abc");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)58L, (long)QueryError.getPosition());
        }
    }
}

