/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.analytic;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.AbstractAllTypeTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Test;

public class DenseRankAnalyticFunctionTest
extends AbstractAllTypeTest {
    @Test
    public void testRank() throws Exception {
        this.assertThat("5\ttrue\tAX\t2016-05-01T10:26:00.000Z\n6\tfalse\tBZ\t2016-05-01T10:27:00.000Z\n7\ttrue\tBZ\t2016-05-01T10:28:00.000Z\n8\tfalse\tAX\t2016-05-01T10:29:00.000Z\n9\tfalse\tBZ\t2016-05-01T10:30:00.000Z\n", "select dense_rank() x over(), boo, str, timestamp from 'abc' limit 5,10");
    }

    @Test
    public void testRankOrdered() throws Exception {
        this.assertThat("15\tBZ\t1.050231933594\n17\tXX\t566.734375000000\n9\tKK\t0.000013792171\n6\tAX\t0.000000567185\n1\tAX\t-512.000000000000\n14\tAX\t0.675451681018\n13\tBZ\t0.332301996648\n7\tBZ\t0.000001752813\n11\tAX\t0.000076281818\n2\tBZ\t0.000000005555\n8\tXX\t0.000002473130\n18\tKK\t632.921875000000\n4\tAX\t0.000000020896\n12\tBZ\t0.007371325744\n3\tXX\t0.000000014643\n16\tAX\t512.000000000000\n19\tXX\t864.000000000000\n5\tAX\t0.000000157437\n0\tBZ\t-842.000000000000\n10\tBZ\t0.000032060649\n", "select dense_rank() x over(order by d), str, d from abc");
    }

    @Test
    public void testRankOrderedPartitioned() throws Exception {
        this.assertThat("BZ\t0\nXX\t0\nKK\t0\nAX\t0\nAX\t1\nAX\t2\nBZ\t1\nBZ\t2\nAX\t3\nBZ\t3\nXX\t1\nKK\t1\nAX\t4\nBZ\t4\nXX\t2\nAX\t5\nXX\t3\nAX\t6\nBZ\t5\nBZ\t6\n", "select str, dense_rank() rank over(partition by str order by timestamp) from 'abc'");
    }

    @Test
    public void testRankPartitioned() throws Exception {
        this.assertThat("BZ\t0\nXX\t0\nKK\t0\nAX\t0\nAX\t1\nAX\t2\nBZ\t1\nBZ\t2\nAX\t3\nBZ\t3\nXX\t1\nKK\t1\nAX\t4\nBZ\t4\nXX\t2\nAX\t5\nXX\t3\nAX\t6\nBZ\t5\nBZ\t6\n", "select str, dense_rank() rank over(partition by str) from 'abc'");
    }

    @Test
    public void testRankWithArg() {
        try {
            this.expectFailure("select str, dense_rank(sym) rank over(partition by str) from 'abc'");
        }
        catch (ParserException e) {
            TestUtils.assertEquals((CharSequence)"Unknown function", QueryError.getMessage());
        }
    }
}

