/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql.aggregation;

import com.questdb.ql.aggregation.SamplerFactory;
import com.questdb.ql.aggregation.TimestampSampler;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SamplerTest {
    private final StringSink sink = new StringSink();

    @Before
    public void setUp() {
        this.sink.clear();
    }

    @Test
    public void testDays() throws Exception {
        TimestampSampler sampler = SamplerFactory.from((CharSequence)"2d");
        Assert.assertNotNull((Object)sampler);
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)sampler.resample(DateFormatUtils.parseDateTime((CharSequence)"2015-04-03T09:04:45.000Z")));
        TestUtils.assertEquals((CharSequence)"2015-04-03T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testHours() throws Exception {
        TimestampSampler sampler = SamplerFactory.from((CharSequence)"3h");
        Assert.assertNotNull((Object)sampler);
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)sampler.resample(DateFormatUtils.parseDateTime((CharSequence)"2015-04-10T10:04:45.000Z")));
        TestUtils.assertEquals((CharSequence)"2015-04-10T09:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testInvalidQualifier() {
        Assert.assertNull((Object)SamplerFactory.from((CharSequence)"2z"));
    }

    @Test
    public void testMinutes() throws Exception {
        TimestampSampler sampler = SamplerFactory.from((CharSequence)"3m");
        Assert.assertNotNull((Object)sampler);
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)sampler.resample(DateFormatUtils.parseDateTime((CharSequence)"2015-04-10T10:04:45.000Z")));
        TestUtils.assertEquals((CharSequence)"2015-04-10T10:03:00.000Z", (CharSequence)this.sink);
        this.sink.clear();
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)sampler.resample(DateFormatUtils.parseDateTime((CharSequence)"2015-04-10T10:07:15.000Z")));
        TestUtils.assertEquals((CharSequence)"2015-04-10T10:06:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testMonths() throws Exception {
        TimestampSampler sampler = SamplerFactory.from((CharSequence)"3M");
        Assert.assertNotNull((Object)sampler);
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)sampler.resample(DateFormatUtils.parseDateTime((CharSequence)"2015-07-03T09:04:45.000Z")));
        TestUtils.assertEquals((CharSequence)"2015-07-01T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testNoQualifier() {
        Assert.assertNull((Object)SamplerFactory.from((CharSequence)"2"));
    }

    @Test
    public void testSeconds() throws Exception {
        TimestampSampler sampler = SamplerFactory.from((CharSequence)"15s");
        Assert.assertNotNull((Object)sampler);
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)sampler.resample(DateFormatUtils.parseDateTime((CharSequence)"2015-04-10T10:04:48.100Z")));
        TestUtils.assertEquals((CharSequence)"2015-04-10T10:04:45.000Z", (CharSequence)this.sink);
        this.sink.clear();
    }

    @Test
    public void testYear() throws Exception {
        TimestampSampler sampler = SamplerFactory.from((CharSequence)"Y");
        Assert.assertNotNull((Object)sampler);
        DateFormatUtils.appendDateTime((CharSink)this.sink, (long)sampler.resample(DateFormatUtils.parseDateTime((CharSequence)"2015-07-03T09:04:45.000Z")));
        TestUtils.assertEquals((CharSequence)"2015-01-01T00:00:00.000Z", (CharSequence)this.sink);
    }

    @Test
    public void testYears() {
        Assert.assertNull((Object)SamplerFactory.from((CharSequence)"2Y"));
    }
}

