/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.col.DoubleRecordSourceColumn;
import com.questdb.ql.ops.constant.DoubleConstant;
import com.questdb.ql.ops.plus.AddDoubleOperator;
import com.questdb.ql.select.SelectedColumnsRecordSource;
import com.questdb.ql.virtual.VirtualColumnRecordSource;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.AbstractTest;
import org.junit.Assert;
import org.junit.Test;

public class VirtualColumnTest
extends AbstractTest {
    @Test
    public void testPlusDouble() throws Exception {
        try (JournalWriter w = this.getFactory().writer((MetadataBuilder)new JournalStructure("xyz"){
            {
                this.$str("ccy");
                this.$double("bid");
            }
        });){
            Rnd rnd = new Rnd();
            for (int i = 0; i < 100; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putStr(0, (CharSequence)rnd.nextString(10));
                ew.putDouble(1, rnd.nextDouble());
                ew.append();
            }
            w.commit();
            StringSink sink = new StringSink();
            RecordSourcePrinter p = new RecordSourcePrinter((CharSink)sink);
            BootstrapEnv env = new BootstrapEnv();
            env.configuration = new ServerConfiguration();
            final AddDoubleOperator plus = (AddDoubleOperator)AddDoubleOperator.FACTORY.newInstance(0, env);
            plus.setName("plus");
            plus.setLhs((VirtualColumn)new DoubleRecordSourceColumn(w.getMetadata().getColumnIndex((CharSequence)"bid"), 0));
            plus.setRhs((VirtualColumn)new DoubleConstant(12.5, 0));
            try (VirtualColumnRecordSource src = new VirtualColumnRecordSource(this.compile("xyz"), (ObjList)new ObjList<VirtualColumn>(){
                {
                    this.add(plus);
                }
            });){
                p.print((RecordSource)src, (ReaderFactory)this.getFactory());
                String expected = "VTJWCPSWHY\t-104.021850585938\t-91.521850585938\nPEHNRXGZSX\t0.000020634160\t12.500020634160\nIBBTGPGWFF\t0.000000567185\t12.500000567185\nDEYYQEHBHF\t0.000000401164\t12.500000401164\nLPDXYSBEOU\t384.072387695313\t396.572387695313\nSHRUEDRQQU\t109.355468750000\t121.855468750000\nFJGETJRSZS\t198.750000000000\t211.250000000000\nRFBVTMHGOO\t172.796875000000\t185.296875000000\nVDZJMYICCX\t-1024.000000000000\t-1011.500000000000\nUICWEKGHVU\t0.000425009843\t12.500425009843\nDOTSEDYYCT\t557.000000000000\t569.500000000000\nOLYXWCKYLS\t0.000553289865\t12.500553289865\nDSWUGSHOLN\t-1013.467773437500\t-1000.967773437500\nIQBZXIOVIK\t512.000000000000\t524.500000000000\nMSSUQSRLTK\t0.000000776007\t12.500000776007\nSJOJIPHZEP\t174.774871826172\t187.274871826172\nVLTOVLJUML\t-77.428833007813\t-64.928833007813\nHMLLEOYPHR\t0.000327562877\t12.500327562877\nZIMNZZRMFM\t238.632812500000\t251.132812500000\nZGHWVDKFLO\t0.000102697388\t12.500102697388\nOXPKRGIIHY\t128.000000000000\t140.500000000000\nOQMYSSMPGL\t-144.421875000000\t-131.921875000000\nHNZHZSQLDG\t832.000000000000\t844.500000000000\nGIFOUSZMZV\t-200.000000000000\t-187.500000000000\nBNDCQCEHNO\t2.602588653564\t15.102588653564\nELLKKHTWNW\t0.000969694171\t12.500969694171\nFLRBROMNXK\t0.000000548919\t12.500000548919\nZULIGYVFZF\t-327.250000000000\t-314.750000000000\nZLUOGXHFVW\t0.000002116648\t12.500002116648\nSRGOONFCLT\t310.101058959961\t322.601058959961\nKFMQNTOGMX\t0.000012478828\t12.500012478828\nLGMXSLUQDY\t0.000013214448\t12.500013214448\nHNIMYFFDTN\t0.000000001910\t12.500000001910\nFLPBNHGZWW\t695.173828125000\t707.673828125000\nNGTNLEGPUH\t0.205350898206\t12.705350898206\nUGGLNYRZLC\t638.000000000000\t650.500000000000\nMIGQZVKHTL\t0.000000040298\t12.500000040298\nSLQVFGPPRG\t-1024.000000000000\t-1011.500000000000\nBHYSBQYMIZ\t5.336447119713\t17.836447119713\nVTNPIWZNFK\t0.000000012570\t12.500000012570\nVMCGFNWGRM\t-128.000000000000\t-115.500000000000\nGIJYDVRVNG\t0.000000052204\t12.500000052204\nEQODRZEIWF\t-31.000000000000\t-18.500000000000\nKYHQQUWQOE\t880.000000000000\t892.500000000000\nNEBQQEMXDK\t25.839271545410\t38.339271545410\nJCTIZKYFLU\t768.000000000000\t780.500000000000\nQSNPXMKJSM\t0.004184104619\t12.504184104619\nXEYVTUPDHH\t845.823730468750\t858.323730468750\nIWHPZRHHMG\t37.350353240967\t49.850353240967\nYYFLSVIHDW\t-400.000000000000\t-387.500000000000\nEVMLKCJBEV\t0.000000914462\t12.500000914462\nHLIHYBTVZN\t0.000001439041\t12.500001439041\nNXFSUWPNXH\t-199.648437500000\t-187.148437500000\nTZODWKOCPF\t0.002563251997\t12.502563251997\nPVKNCBWLNL\t0.397523656487\t12.897523656487\nWQXYPOVFDB\t8.950848102570\t21.450848102570\nNIJEEHRUGP\t448.000000000000\t460.500000000000\nBTKVSBEGMI\t391.000000000000\t403.500000000000\nNLKFNUHNRJ\t0.000000048669\t12.500000048669\nBWVLOMPBET\t0.000038398017\t12.500038398017\nKRIVOCUGPU\t2.929819107056\t15.429819107056\nFIVQFNIZOS\t815.000000000000\t827.500000000000\nSEPGIUQZHE\t0.017051883508\t12.517051883508\nQHNOJIGFIN\t601.087127685547\t613.587127685547\nQVZWEVQTQO\t-492.000000000000\t-479.500000000000\nXTPNHTDCEB\t-966.000000000000\t-953.500000000000\nXBBZVRLPTY\t70.810325622559\t83.310325622559\nGYFUXCDKDW\t0.000837845349\t12.500837845349\nDXCBJFRPXZ\t0.000008696692\t12.500008696692\nXUNYQXTGNJ\t6.359375000000\t18.859375000000\nLLEYMIWTCW\t792.242187500000\t804.742187500000\nORGFIEVMKP\t-726.000000000000\t-713.500000000000\nGPYKKBMQMU\t0.000000000000\t12.500000000000\nCIHCNPUGJO\t-762.240234375000\t-749.740234375000\nEUKWMDNZZB\t0.000000031117\t12.500000031117\nKOJSOLDYRO\t552.000000000000\t564.500000000000\nPUNRPSMIFD\t73.947616577148\t86.447616577148\nDKOEZBRQSQ\t-736.000000000000\t-723.500000000000\nDIHHNSSTCR\t0.000002963134\t12.500002963134\nPVQFULMERT\t0.000005817310\t12.500005817310\nQBUYZVQQHS\t0.000000011688\t12.500000011688\nPZPBHLNEJR\t-1003.625000000000\t-991.125000000000\nIKDISGQFYQ\t351.509208679199\t364.009208679199\nGPZNYVLTPK\t0.000702012621\t12.500702012621\nQFNPOYNNCT\t0.000445737198\t12.500445737198\nNSXHHDILEL\t0.001584486396\t12.501584486396\nMMZSCJOUOU\t642.865234375000\t655.365234375000\nENFELWWRSL\t-934.268554687500\t-921.768554687500\nQHGJBFQBBK\t103.908081054688\t116.408081054688\nJZZYNPPBXB\t-944.000000000000\t-931.500000000000\nRIIYMHOWKC\t0.000000542615\t12.500000542615\nZNLCNGZTOY\t0.000080315222\t12.500080315222\nXRSFPVRQLG\t0.000000093226\t12.500000093226\nONNLITWGLF\t0.000000000000\t12.500000000000\nQWPKLHTIIG\t-783.750000000000\t-771.250000000000\nYYPDVRGRQG\t0.000376001219\t12.500376001219\nPHKOWBVDEG\t0.000002666791\t12.500002666791\nXGZMDJTHMH\t-670.500000000000\t-658.000000000000\nVZHCNXZEQG\t-524.507812500000\t-512.007812500000\nLUCFTLNKYT\t0.000000001835\t12.500000001835\n";
                Assert.assertEquals((Object)"VTJWCPSWHY\t-104.021850585938\t-91.521850585938\nPEHNRXGZSX\t0.000020634160\t12.500020634160\nIBBTGPGWFF\t0.000000567185\t12.500000567185\nDEYYQEHBHF\t0.000000401164\t12.500000401164\nLPDXYSBEOU\t384.072387695313\t396.572387695313\nSHRUEDRQQU\t109.355468750000\t121.855468750000\nFJGETJRSZS\t198.750000000000\t211.250000000000\nRFBVTMHGOO\t172.796875000000\t185.296875000000\nVDZJMYICCX\t-1024.000000000000\t-1011.500000000000\nUICWEKGHVU\t0.000425009843\t12.500425009843\nDOTSEDYYCT\t557.000000000000\t569.500000000000\nOLYXWCKYLS\t0.000553289865\t12.500553289865\nDSWUGSHOLN\t-1013.467773437500\t-1000.967773437500\nIQBZXIOVIK\t512.000000000000\t524.500000000000\nMSSUQSRLTK\t0.000000776007\t12.500000776007\nSJOJIPHZEP\t174.774871826172\t187.274871826172\nVLTOVLJUML\t-77.428833007813\t-64.928833007813\nHMLLEOYPHR\t0.000327562877\t12.500327562877\nZIMNZZRMFM\t238.632812500000\t251.132812500000\nZGHWVDKFLO\t0.000102697388\t12.500102697388\nOXPKRGIIHY\t128.000000000000\t140.500000000000\nOQMYSSMPGL\t-144.421875000000\t-131.921875000000\nHNZHZSQLDG\t832.000000000000\t844.500000000000\nGIFOUSZMZV\t-200.000000000000\t-187.500000000000\nBNDCQCEHNO\t2.602588653564\t15.102588653564\nELLKKHTWNW\t0.000969694171\t12.500969694171\nFLRBROMNXK\t0.000000548919\t12.500000548919\nZULIGYVFZF\t-327.250000000000\t-314.750000000000\nZLUOGXHFVW\t0.000002116648\t12.500002116648\nSRGOONFCLT\t310.101058959961\t322.601058959961\nKFMQNTOGMX\t0.000012478828\t12.500012478828\nLGMXSLUQDY\t0.000013214448\t12.500013214448\nHNIMYFFDTN\t0.000000001910\t12.500000001910\nFLPBNHGZWW\t695.173828125000\t707.673828125000\nNGTNLEGPUH\t0.205350898206\t12.705350898206\nUGGLNYRZLC\t638.000000000000\t650.500000000000\nMIGQZVKHTL\t0.000000040298\t12.500000040298\nSLQVFGPPRG\t-1024.000000000000\t-1011.500000000000\nBHYSBQYMIZ\t5.336447119713\t17.836447119713\nVTNPIWZNFK\t0.000000012570\t12.500000012570\nVMCGFNWGRM\t-128.000000000000\t-115.500000000000\nGIJYDVRVNG\t0.000000052204\t12.500000052204\nEQODRZEIWF\t-31.000000000000\t-18.500000000000\nKYHQQUWQOE\t880.000000000000\t892.500000000000\nNEBQQEMXDK\t25.839271545410\t38.339271545410\nJCTIZKYFLU\t768.000000000000\t780.500000000000\nQSNPXMKJSM\t0.004184104619\t12.504184104619\nXEYVTUPDHH\t845.823730468750\t858.323730468750\nIWHPZRHHMG\t37.350353240967\t49.850353240967\nYYFLSVIHDW\t-400.000000000000\t-387.500000000000\nEVMLKCJBEV\t0.000000914462\t12.500000914462\nHLIHYBTVZN\t0.000001439041\t12.500001439041\nNXFSUWPNXH\t-199.648437500000\t-187.148437500000\nTZODWKOCPF\t0.002563251997\t12.502563251997\nPVKNCBWLNL\t0.397523656487\t12.897523656487\nWQXYPOVFDB\t8.950848102570\t21.450848102570\nNIJEEHRUGP\t448.000000000000\t460.500000000000\nBTKVSBEGMI\t391.000000000000\t403.500000000000\nNLKFNUHNRJ\t0.000000048669\t12.500000048669\nBWVLOMPBET\t0.000038398017\t12.500038398017\nKRIVOCUGPU\t2.929819107056\t15.429819107056\nFIVQFNIZOS\t815.000000000000\t827.500000000000\nSEPGIUQZHE\t0.017051883508\t12.517051883508\nQHNOJIGFIN\t601.087127685547\t613.587127685547\nQVZWEVQTQO\t-492.000000000000\t-479.500000000000\nXTPNHTDCEB\t-966.000000000000\t-953.500000000000\nXBBZVRLPTY\t70.810325622559\t83.310325622559\nGYFUXCDKDW\t0.000837845349\t12.500837845349\nDXCBJFRPXZ\t0.000008696692\t12.500008696692\nXUNYQXTGNJ\t6.359375000000\t18.859375000000\nLLEYMIWTCW\t792.242187500000\t804.742187500000\nORGFIEVMKP\t-726.000000000000\t-713.500000000000\nGPYKKBMQMU\t0.000000000000\t12.500000000000\nCIHCNPUGJO\t-762.240234375000\t-749.740234375000\nEUKWMDNZZB\t0.000000031117\t12.500000031117\nKOJSOLDYRO\t552.000000000000\t564.500000000000\nPUNRPSMIFD\t73.947616577148\t86.447616577148\nDKOEZBRQSQ\t-736.000000000000\t-723.500000000000\nDIHHNSSTCR\t0.000002963134\t12.500002963134\nPVQFULMERT\t0.000005817310\t12.500005817310\nQBUYZVQQHS\t0.000000011688\t12.500000011688\nPZPBHLNEJR\t-1003.625000000000\t-991.125000000000\nIKDISGQFYQ\t351.509208679199\t364.009208679199\nGPZNYVLTPK\t0.000702012621\t12.500702012621\nQFNPOYNNCT\t0.000445737198\t12.500445737198\nNSXHHDILEL\t0.001584486396\t12.501584486396\nMMZSCJOUOU\t642.865234375000\t655.365234375000\nENFELWWRSL\t-934.268554687500\t-921.768554687500\nQHGJBFQBBK\t103.908081054688\t116.408081054688\nJZZYNPPBXB\t-944.000000000000\t-931.500000000000\nRIIYMHOWKC\t0.000000542615\t12.500000542615\nZNLCNGZTOY\t0.000080315222\t12.500080315222\nXRSFPVRQLG\t0.000000093226\t12.500000093226\nONNLITWGLF\t0.000000000000\t12.500000000000\nQWPKLHTIIG\t-783.750000000000\t-771.250000000000\nYYPDVRGRQG\t0.000376001219\t12.500376001219\nPHKOWBVDEG\t0.000002666791\t12.500002666791\nXGZMDJTHMH\t-670.500000000000\t-658.000000000000\nVZHCNXZEQG\t-524.507812500000\t-512.007812500000\nLUCFTLNKYT\t0.000000001835\t12.500000001835\n", (Object)sink.toString());
            }
        }
    }

    @Test
    public void testSelectedColumns() throws Exception {
        try (JournalWriter w = this.getFactory().writer((MetadataBuilder)new JournalStructure("xyz"){
            {
                this.$str("ccy");
                this.$double("bid");
            }
        });){
            Rnd rnd = new Rnd();
            for (int i = 0; i < 100; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putStr(0, (CharSequence)rnd.nextString(10));
                ew.putDouble(1, rnd.nextDouble());
                ew.append();
            }
            w.commit();
            StringSink sink = new StringSink();
            RecordSourcePrinter p = new RecordSourcePrinter((CharSink)sink);
            BootstrapEnv env = new BootstrapEnv();
            env.configuration = new ServerConfiguration();
            final AddDoubleOperator plus = (AddDoubleOperator)AddDoubleOperator.FACTORY.newInstance(0, env);
            plus.setName("plus");
            plus.setLhs((VirtualColumn)new DoubleRecordSourceColumn(w.getMetadata().getColumnIndex((CharSequence)"bid"), 0));
            plus.setRhs((VirtualColumn)new DoubleConstant(12.5, 0));
            try (SelectedColumnsRecordSource src = new SelectedColumnsRecordSource((RecordSource)new VirtualColumnRecordSource(this.compile("xyz"), (ObjList)new ObjList<VirtualColumn>(){
                {
                    this.add(plus);
                }
            }), (ObjList)new ObjList<CharSequence>(){
                {
                    this.add("ccy");
                    this.add("plus");
                }
            });){
                p.print((RecordSource)src, (ReaderFactory)this.getFactory());
                String expected = "VTJWCPSWHY\t-91.521850585938\nPEHNRXGZSX\t12.500020634160\nIBBTGPGWFF\t12.500000567185\nDEYYQEHBHF\t12.500000401164\nLPDXYSBEOU\t396.572387695313\nSHRUEDRQQU\t121.855468750000\nFJGETJRSZS\t211.250000000000\nRFBVTMHGOO\t185.296875000000\nVDZJMYICCX\t-1011.500000000000\nUICWEKGHVU\t12.500425009843\nDOTSEDYYCT\t569.500000000000\nOLYXWCKYLS\t12.500553289865\nDSWUGSHOLN\t-1000.967773437500\nIQBZXIOVIK\t524.500000000000\nMSSUQSRLTK\t12.500000776007\nSJOJIPHZEP\t187.274871826172\nVLTOVLJUML\t-64.928833007813\nHMLLEOYPHR\t12.500327562877\nZIMNZZRMFM\t251.132812500000\nZGHWVDKFLO\t12.500102697388\nOXPKRGIIHY\t140.500000000000\nOQMYSSMPGL\t-131.921875000000\nHNZHZSQLDG\t844.500000000000\nGIFOUSZMZV\t-187.500000000000\nBNDCQCEHNO\t15.102588653564\nELLKKHTWNW\t12.500969694171\nFLRBROMNXK\t12.500000548919\nZULIGYVFZF\t-314.750000000000\nZLUOGXHFVW\t12.500002116648\nSRGOONFCLT\t322.601058959961\nKFMQNTOGMX\t12.500012478828\nLGMXSLUQDY\t12.500013214448\nHNIMYFFDTN\t12.500000001910\nFLPBNHGZWW\t707.673828125000\nNGTNLEGPUH\t12.705350898206\nUGGLNYRZLC\t650.500000000000\nMIGQZVKHTL\t12.500000040298\nSLQVFGPPRG\t-1011.500000000000\nBHYSBQYMIZ\t17.836447119713\nVTNPIWZNFK\t12.500000012570\nVMCGFNWGRM\t-115.500000000000\nGIJYDVRVNG\t12.500000052204\nEQODRZEIWF\t-18.500000000000\nKYHQQUWQOE\t892.500000000000\nNEBQQEMXDK\t38.339271545410\nJCTIZKYFLU\t780.500000000000\nQSNPXMKJSM\t12.504184104619\nXEYVTUPDHH\t858.323730468750\nIWHPZRHHMG\t49.850353240967\nYYFLSVIHDW\t-387.500000000000\nEVMLKCJBEV\t12.500000914462\nHLIHYBTVZN\t12.500001439041\nNXFSUWPNXH\t-187.148437500000\nTZODWKOCPF\t12.502563251997\nPVKNCBWLNL\t12.897523656487\nWQXYPOVFDB\t21.450848102570\nNIJEEHRUGP\t460.500000000000\nBTKVSBEGMI\t403.500000000000\nNLKFNUHNRJ\t12.500000048669\nBWVLOMPBET\t12.500038398017\nKRIVOCUGPU\t15.429819107056\nFIVQFNIZOS\t827.500000000000\nSEPGIUQZHE\t12.517051883508\nQHNOJIGFIN\t613.587127685547\nQVZWEVQTQO\t-479.500000000000\nXTPNHTDCEB\t-953.500000000000\nXBBZVRLPTY\t83.310325622559\nGYFUXCDKDW\t12.500837845349\nDXCBJFRPXZ\t12.500008696692\nXUNYQXTGNJ\t18.859375000000\nLLEYMIWTCW\t804.742187500000\nORGFIEVMKP\t-713.500000000000\nGPYKKBMQMU\t12.500000000000\nCIHCNPUGJO\t-749.740234375000\nEUKWMDNZZB\t12.500000031117\nKOJSOLDYRO\t564.500000000000\nPUNRPSMIFD\t86.447616577148\nDKOEZBRQSQ\t-723.500000000000\nDIHHNSSTCR\t12.500002963134\nPVQFULMERT\t12.500005817310\nQBUYZVQQHS\t12.500000011688\nPZPBHLNEJR\t-991.125000000000\nIKDISGQFYQ\t364.009208679199\nGPZNYVLTPK\t12.500702012621\nQFNPOYNNCT\t12.500445737198\nNSXHHDILEL\t12.501584486396\nMMZSCJOUOU\t655.365234375000\nENFELWWRSL\t-921.768554687500\nQHGJBFQBBK\t116.408081054688\nJZZYNPPBXB\t-931.500000000000\nRIIYMHOWKC\t12.500000542615\nZNLCNGZTOY\t12.500080315222\nXRSFPVRQLG\t12.500000093226\nONNLITWGLF\t12.500000000000\nQWPKLHTIIG\t-771.250000000000\nYYPDVRGRQG\t12.500376001219\nPHKOWBVDEG\t12.500002666791\nXGZMDJTHMH\t-658.000000000000\nVZHCNXZEQG\t-512.007812500000\nLUCFTLNKYT\t12.500000001835\n";
                Assert.assertEquals((Object)"VTJWCPSWHY\t-91.521850585938\nPEHNRXGZSX\t12.500020634160\nIBBTGPGWFF\t12.500000567185\nDEYYQEHBHF\t12.500000401164\nLPDXYSBEOU\t396.572387695313\nSHRUEDRQQU\t121.855468750000\nFJGETJRSZS\t211.250000000000\nRFBVTMHGOO\t185.296875000000\nVDZJMYICCX\t-1011.500000000000\nUICWEKGHVU\t12.500425009843\nDOTSEDYYCT\t569.500000000000\nOLYXWCKYLS\t12.500553289865\nDSWUGSHOLN\t-1000.967773437500\nIQBZXIOVIK\t524.500000000000\nMSSUQSRLTK\t12.500000776007\nSJOJIPHZEP\t187.274871826172\nVLTOVLJUML\t-64.928833007813\nHMLLEOYPHR\t12.500327562877\nZIMNZZRMFM\t251.132812500000\nZGHWVDKFLO\t12.500102697388\nOXPKRGIIHY\t140.500000000000\nOQMYSSMPGL\t-131.921875000000\nHNZHZSQLDG\t844.500000000000\nGIFOUSZMZV\t-187.500000000000\nBNDCQCEHNO\t15.102588653564\nELLKKHTWNW\t12.500969694171\nFLRBROMNXK\t12.500000548919\nZULIGYVFZF\t-314.750000000000\nZLUOGXHFVW\t12.500002116648\nSRGOONFCLT\t322.601058959961\nKFMQNTOGMX\t12.500012478828\nLGMXSLUQDY\t12.500013214448\nHNIMYFFDTN\t12.500000001910\nFLPBNHGZWW\t707.673828125000\nNGTNLEGPUH\t12.705350898206\nUGGLNYRZLC\t650.500000000000\nMIGQZVKHTL\t12.500000040298\nSLQVFGPPRG\t-1011.500000000000\nBHYSBQYMIZ\t17.836447119713\nVTNPIWZNFK\t12.500000012570\nVMCGFNWGRM\t-115.500000000000\nGIJYDVRVNG\t12.500000052204\nEQODRZEIWF\t-18.500000000000\nKYHQQUWQOE\t892.500000000000\nNEBQQEMXDK\t38.339271545410\nJCTIZKYFLU\t780.500000000000\nQSNPXMKJSM\t12.504184104619\nXEYVTUPDHH\t858.323730468750\nIWHPZRHHMG\t49.850353240967\nYYFLSVIHDW\t-387.500000000000\nEVMLKCJBEV\t12.500000914462\nHLIHYBTVZN\t12.500001439041\nNXFSUWPNXH\t-187.148437500000\nTZODWKOCPF\t12.502563251997\nPVKNCBWLNL\t12.897523656487\nWQXYPOVFDB\t21.450848102570\nNIJEEHRUGP\t460.500000000000\nBTKVSBEGMI\t403.500000000000\nNLKFNUHNRJ\t12.500000048669\nBWVLOMPBET\t12.500038398017\nKRIVOCUGPU\t15.429819107056\nFIVQFNIZOS\t827.500000000000\nSEPGIUQZHE\t12.517051883508\nQHNOJIGFIN\t613.587127685547\nQVZWEVQTQO\t-479.500000000000\nXTPNHTDCEB\t-953.500000000000\nXBBZVRLPTY\t83.310325622559\nGYFUXCDKDW\t12.500837845349\nDXCBJFRPXZ\t12.500008696692\nXUNYQXTGNJ\t18.859375000000\nLLEYMIWTCW\t804.742187500000\nORGFIEVMKP\t-713.500000000000\nGPYKKBMQMU\t12.500000000000\nCIHCNPUGJO\t-749.740234375000\nEUKWMDNZZB\t12.500000031117\nKOJSOLDYRO\t564.500000000000\nPUNRPSMIFD\t86.447616577148\nDKOEZBRQSQ\t-723.500000000000\nDIHHNSSTCR\t12.500002963134\nPVQFULMERT\t12.500005817310\nQBUYZVQQHS\t12.500000011688\nPZPBHLNEJR\t-991.125000000000\nIKDISGQFYQ\t364.009208679199\nGPZNYVLTPK\t12.500702012621\nQFNPOYNNCT\t12.500445737198\nNSXHHDILEL\t12.501584486396\nMMZSCJOUOU\t655.365234375000\nENFELWWRSL\t-921.768554687500\nQHGJBFQBBK\t116.408081054688\nJZZYNPPBXB\t-931.500000000000\nRIIYMHOWKC\t12.500000542615\nZNLCNGZTOY\t12.500080315222\nXRSFPVRQLG\t12.500000093226\nONNLITWGLF\t12.500000000000\nQWPKLHTIIG\t-771.250000000000\nYYPDVRGRQG\t12.500376001219\nPHKOWBVDEG\t12.500002666791\nXGZMDJTHMH\t-658.000000000000\nVZHCNXZEQG\t-512.007812500000\nLUCFTLNKYT\t12.500000001835\n", (Object)sink.toString());
            }
        }
    }
}

