/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.model.Quote;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.ql.TopRecordSource;
import com.questdb.ql.ops.VirtualColumn;
import com.questdb.ql.ops.constant.LongConstant;
import com.questdb.std.str.CharSink;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TopRecordSourceTest
extends AbstractTest {
    @Before
    public void setUp() throws Exception {
        try (JournalWriter w = this.getFactory().writer(Quote.class, "quote");){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 100000);
        }
    }

    @Test
    public void testBottomSource() throws Exception {
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)this.sink);
        try (TopRecordSource rs = new TopRecordSource(this.compile("quote"), (VirtualColumn)new LongConstant(99997L, 0), (VirtualColumn)new LongConstant(100000L, 0));){
            p.print((RecordSource)rs, (ReaderFactory)this.getFactory());
            String expected = "2013-11-04T10:00:00.000Z\tBT-A.L\t168.000000000000\t0.001307277009\t319936098\t1456039311\tFast trading\tLXE\n2013-11-04T10:00:00.000Z\tAGK.L\t0.000031983279\t878.000000000000\t819380635\t1732419403\tFast trading\tLXE\n2013-11-04T10:00:00.000Z\tHSBA.L\t243.601509094238\t44.582113265991\t532679143\t345298132\tFast trading\tLXE\n";
            Assert.assertEquals((Object)"2013-11-04T10:00:00.000Z\tBT-A.L\t168.000000000000\t0.001307277009\t319936098\t1456039311\tFast trading\tLXE\n2013-11-04T10:00:00.000Z\tAGK.L\t0.000031983279\t878.000000000000\t819380635\t1732419403\tFast trading\tLXE\n2013-11-04T10:00:00.000Z\tHSBA.L\t243.601509094238\t44.582113265991\t532679143\t345298132\tFast trading\tLXE\n", (Object)this.sink.toString());
        }
    }

    @Test
    public void testMiddleSource() throws Exception {
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)this.sink);
        try (TopRecordSource rs = new TopRecordSource(this.compile("quote"), (VirtualColumn)new LongConstant(102L, 0), (VirtualColumn)new LongConstant(112L, 0));){
            p.print((RecordSource)rs, (ReaderFactory)this.getFactory());
            String expected = "2013-09-04T10:00:00.000Z\tTLW.L\t0.003675992833\t0.000000006044\t233699709\t984001343\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tGKN.L\t0.000001392326\t0.000000010696\t1921077830\t83098719\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tHSBA.L\t125.000000000000\t113.359375000000\t347349195\t1619900957\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tTLW.L\t0.000000539488\t1.938893854618\t1012023467\t596418088\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tBP.L\t0.009742939146\t0.000000729716\t952785207\t94086655\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tBT-A.L\t10.085297346115\t0.293467730284\t1376102367\t166757857\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t488.272369384766\t342.142333984375\t1016986855\t1939793032\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tLLOY.L\t601.087127685547\t0.519029200077\t337891645\t1650060090\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t0.025374564342\t0.009976797737\t1448235215\t107181743\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tAGK.L\t335.908935546875\t492.000000000000\t1466344037\t79845289\tFast trading\tLXE\n";
            Assert.assertEquals((Object)"2013-09-04T10:00:00.000Z\tTLW.L\t0.003675992833\t0.000000006044\t233699709\t984001343\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tGKN.L\t0.000001392326\t0.000000010696\t1921077830\t83098719\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tHSBA.L\t125.000000000000\t113.359375000000\t347349195\t1619900957\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tTLW.L\t0.000000539488\t1.938893854618\t1012023467\t596418088\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tBP.L\t0.009742939146\t0.000000729716\t952785207\t94086655\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tBT-A.L\t10.085297346115\t0.293467730284\t1376102367\t166757857\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t488.272369384766\t342.142333984375\t1016986855\t1939793032\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tLLOY.L\t601.087127685547\t0.519029200077\t337891645\t1650060090\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t0.025374564342\t0.009976797737\t1448235215\t107181743\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tAGK.L\t335.908935546875\t492.000000000000\t1466344037\t79845289\tFast trading\tLXE\n", (Object)this.sink.toString());
        }
    }

    @Test
    public void testNoRows() throws Exception {
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)this.sink);
        try (TopRecordSource rs = new TopRecordSource(this.compile("quote"), (VirtualColumn)new LongConstant(99997L, 0), (VirtualColumn)new LongConstant(10L, 0));){
            p.print((RecordSource)rs, (ReaderFactory)this.getFactory());
            Assert.assertEquals((Object)"", (Object)this.sink.toString());
        }
    }

    @Test
    public void testTopSource() throws Exception {
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)this.sink);
        try (TopRecordSource rs = new TopRecordSource(this.compile("quote"), (VirtualColumn)new LongConstant(0L, 0), (VirtualColumn)new LongConstant(10L, 0));){
            p.print((RecordSource)rs, (ReaderFactory)this.getFactory());
            String expected = "2013-09-04T10:00:00.000Z\tBT-A.L\t0.000001189157\t1.050231933594\t1326447242\t948263339\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tADM.L\t104.021850585938\t0.006688738358\t1575378703\t1436881714\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tAGK.L\t879.117187500000\t496.806518554688\t1530831067\t339631474\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t768.000000000000\t0.000020634160\t426455968\t1432278050\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t256.000000000000\t0.000000035797\t1404198\t1153445279\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tWTB.L\t920.625000000000\t0.040750414133\t761275053\t1232884790\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tAGK.L\t512.000000000000\t896.000000000000\t422941535\t113506296\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tRRS.L\t12.923866510391\t0.032379742712\t2006313928\t2132716300\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tBT-A.L\t0.006530375686\t0.000000000000\t1890602616\t2137969456\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t0.000000017324\t720.000000000000\t410717394\t458818940\tFast trading\tLXE\n";
            Assert.assertEquals((Object)"2013-09-04T10:00:00.000Z\tBT-A.L\t0.000001189157\t1.050231933594\t1326447242\t948263339\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tADM.L\t104.021850585938\t0.006688738358\t1575378703\t1436881714\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tAGK.L\t879.117187500000\t496.806518554688\t1530831067\t339631474\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t768.000000000000\t0.000020634160\t426455968\t1432278050\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t256.000000000000\t0.000000035797\t1404198\t1153445279\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tWTB.L\t920.625000000000\t0.040750414133\t761275053\t1232884790\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tAGK.L\t512.000000000000\t896.000000000000\t422941535\t113506296\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tRRS.L\t12.923866510391\t0.032379742712\t2006313928\t2132716300\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tBT-A.L\t0.006530375686\t0.000000000000\t1890602616\t2137969456\tFast trading\tLXE\n2013-09-04T10:00:00.000Z\tABF.L\t0.000000017324\t720.000000000000\t410717394\t458818940\tFast trading\tLXE\n", (Object)this.sink.toString());
        }
    }
}

