/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.parser.sql.QueryError;
import com.questdb.std.Sinkable;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.TestUtils;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class SubqueryOptimiserTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        JournalWriter w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("tab").$sym("id").index().buckets(128).$double("x").$double("y").$int("i1").$int("i2").$ts());
        w.close();
        w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("tex").$sym("id").index().buckets(128).$double("amount").$ts());
        w.close();
    }

    @Before
    public void setUp() {
        sink.clear();
    }

    @Test
    public void testAmbiguousColumn() {
        try {
            this.expectFailure("(((tab order by y) where y = 5) a join tex b on a.id = b.id) a where a.x = 10 and id > 100");
        }
        catch (ParserException e) {
            TestUtils.assertEquals((CharSequence)"Ambiguous column name", QueryError.getMessage());
        }
    }

    @Test
    public void testJoinRecursiveJoinSubQueries() throws Exception {
        sink.put((Sinkable)this.compileSource("(((tab order by y) where y = 5) a join tex b on a.id = b.id) a where a.x = 10 and a.amount > 100"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"HashJoinRecordSource\",\"master\":{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}}},\"slave\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tex\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}},\"joinOn\":[[\"id\"],[\"id\"]]}", (CharSequence)sink);
    }

    @Test
    public void testJoinSubQueries() throws Exception {
        sink.put((Sinkable)this.compileSource("((tab order by y) a join tex b on a.id = b.id) a where a.x = 10 and a.amount > 100"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"HashJoinRecordSource\",\"master\":{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}}},\"slave\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tex\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}},\"joinOn\":[[\"id\"],[\"id\"]]}", (CharSequence)sink);
    }

    @Test
    public void testJoinSubQueryFilter() throws Exception {
        sink.put((Sinkable)this.compileSource("(tab a join tex b on a.id = b.id) a where a.x = 10"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"HashJoinRecordSource\",\"master\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}},\"slave\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tex\"},\"rsrc\":{\"op\":\"AllRowSource\"}},\"joinOn\":[[\"id\"],[\"id\"]]}", (CharSequence)sink);
    }

    @Test
    public void testJoinSubQueryFilter2() throws Exception {
        sink.put((Sinkable)this.compileSource("(tab a join tex b on a.id = b.id) a where a.amount = 10"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"HashJoinRecordSource\",\"master\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"AllRowSource\"}},\"slave\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tex\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}},\"joinOn\":[[\"id\"],[\"id\"]]}", (CharSequence)sink);
    }

    @Test
    public void testOneLevelAliasedSelectedSubQuery() throws Exception {
        sink.put((Sinkable)this.compileSource("(select x from tab order by x) a where a.x = 10"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}}}}", (CharSequence)sink);
    }

    @Test
    public void testOneLevelAliasedSubQuery() throws Exception {
        sink.put((Sinkable)this.compileSource("(tab order by x) a where a.x = 10"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}}}", (CharSequence)sink);
    }

    @Test
    public void testOneLevelSimpleSubQuery() throws Exception {
        sink.put((Sinkable)this.compileSource("(tab order by x) where x = 10"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}}}", (CharSequence)sink);
    }

    @Test
    public void testRecursiveAliasedMixedSubQuery() throws Exception {
        sink.put((Sinkable)this.compileSource("(select y from (select 1+1 y, x from tab order by x) a where a.x = 10) b where b.y > 100"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"FilteredRecordSource\",\"src\":{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"VirtualColumnRecordSource\",\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}}}}},\"filter\":\"y > 100\"}}", (CharSequence)sink);
    }

    @Test
    public void testRecursiveAliasedSubQuery() throws Exception {
        sink.put((Sinkable)this.compileSource("((tab order by x) a where a.x = 10) b where b.y > 100"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}}}", (CharSequence)sink);
    }

    @Test
    public void testSubQueryFilterOnAggregate() throws Exception {
        sink.put((Sinkable)this.compileSource("(select sum(x) k from tab) a where a.k = 10"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"FilteredRecordSource\",\"src\":{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"AggregatedRecordSource\",\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"AllRowSource\"}}}},\"filter\":\"a.k = 10\"}", (CharSequence)sink);
    }

    @Test
    public void testSubQueryFilterOnConstant() throws Exception {
        sink.put((Sinkable)this.compileSource("(select 1 k from tab) a where a.k = 10"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"FilteredRecordSource\",\"src\":{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"VirtualColumnRecordSource\",\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"AllRowSource\"}}}},\"filter\":\"a.k = 10\"}", (CharSequence)sink);
    }
}

