/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalKey;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameJournalTest
extends AbstractTest {
    private static final QueryCompiler compiler = new QueryCompiler();
    private final StringSink sink = new StringSink();
    private final RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)this.sink);

    @Before
    public void setUp() {
        this.sink.clear();
    }

    @Test
    public void testJournalAlreadyOpenButIdle() throws Exception {
        this.createX();
        Factory factory = this.getFactory();
        this.assertJournal(factory, "x");
        this.sink.clear();
        compiler.execute(factory, (CharSequence)"rename table x to y");
        this.assertJournal(factory, "y");
        try {
            factory.reader(new JournalKey("x"));
            Assert.fail();
        }
        catch (JournalException e) {
            Assert.assertEquals((Object)"Journal does not exist", (Object)e.getMessage());
        }
        try {
            compiler.compile(factory, (CharSequence)"x");
            Assert.fail((String)"still exists");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)0L, (long)QueryError.getPosition());
            TestUtils.assertEquals((CharSequence)"Journal does not exist", QueryError.getMessage());
        }
        this.sink.clear();
        this.createX();
        this.assertJournal(factory, "x");
    }

    @Test
    public void testNonLiteralFrom() throws Exception {
        try {
            compiler.execute(this.getFactory(), (CharSequence)"rename table 1+2 to 'c d'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)14L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testNonLiteralTo() throws Exception {
        try {
            compiler.execute(this.getFactory(), (CharSequence)"rename table x to 5+5");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)19L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testReleaseOfJournalInPool() throws Exception {
        this.createX();
        Factory f = this.getFactory();
        this.assertJournal(f, "x");
        this.sink.clear();
        compiler.execute(f, (CharSequence)"rename table x to y");
        this.assertJournal(f, "y");
        this.sink.clear();
        this.createX();
        this.assertJournal(f, "x");
    }

    @Test
    public void testRenameQuoted() throws Exception {
        this.create("'a b'");
        compiler.execute(this.getFactory(), (CharSequence)"rename table 'a b' to 'c d'");
    }

    @Test
    public void testSimpleNonExisting() throws Exception {
        try {
            compiler.execute(this.getFactory(), (CharSequence)"rename table x to y");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)13L, (long)QueryError.getPosition());
            TestUtils.assertEquals((CharSequence)"Journal does not exist", QueryError.getMessage());
        }
    }

    @Test
    public void testSimpleRename() throws Exception {
        this.createX();
        compiler.execute(this.getFactory(), (CharSequence)"rename table x to y");
        this.assertJournal(this.getFactory(), "y");
    }

    private void assertJournal(Factory f, String dest) throws IOException, ParserException {
        try (RecordSource rs = compiler.compile(f, (CharSequence)dest);){
            this.printer.print(rs, (ReaderFactory)f);
            TestUtils.assertEquals((CharSequence)"999\n", (CharSequence)this.sink);
        }
    }

    private void create(String name) throws JournalException, ParserException {
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)("create table " + name + "(a int) record hint 100"));){
            JournalEntryWriter ew = w.entryWriter();
            ew.putInt(0, 999);
            ew.append();
            w.commit();
        }
    }

    private void createX() throws JournalException, ParserException {
        this.create("x");
    }
}

