/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.ql.RecordList;
import com.questdb.ql.RecordSource;
import com.questdb.std.DirectInputStream;
import com.questdb.std.LongList;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.store.JournalWriter;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.RecordMetadata;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.test.tools.AbstractTest;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class RecordListTest
extends AbstractTest {
    private final QueryCompiler compiler = new QueryCompiler();

    @Test
    public void testAllFieldTypesField() throws JournalException, IOException, ParserException {
        this.writeAndReadRecords(this.getFactory().writer(AllFieldTypes.class), 1000, 65536, new RecordGenerator<AllFieldTypes>(){

            @Override
            public void assertRecord(Record value, int i) throws IOException {
                AllFieldTypes expected = this.generate(i);
                int col = 0;
                String failedMsg = "Record " + i;
                Assert.assertEquals((String)failedMsg, (Object)expected.aBool, (Object)value.getBool(col++));
                Assert.assertEquals((String)failedMsg, (Object)expected.aString, (Object)value.getFlyweightStr(col++).toString());
                Assert.assertEquals((String)failedMsg, (long)expected.aByte, (long)value.getByte(col++));
                Assert.assertEquals((String)failedMsg, (long)expected.aShort, (long)value.getShort(col++));
                Assert.assertEquals((String)failedMsg, (long)expected.anInt, (long)value.getInt(col++));
                DirectInputStream binCol = value.getBin(col++);
                byte[] expectedBin = expected.aBinary.array();
                Assert.assertEquals((String)failedMsg, (long)expectedBin.length, (long)binCol.size());
                for (int j = 0; j < expectedBin.length; ++j) {
                    Assert.assertEquals((String)(failedMsg + " byte " + j), (long)expectedBin[j], (long)((byte)binCol.read()));
                }
                Assert.assertEquals((String)failedMsg, (long)expected.aLong, (long)value.getLong(col++));
                Assert.assertEquals((String)failedMsg, (double)expected.aDouble, (double)value.getDouble(col++), (double)1.0E-4);
                Assert.assertEquals((String)failedMsg, (double)expected.aFloat, (double)value.getFloat(col), (double)1.0E-4);
            }

            @Override
            public AllFieldTypes generate(int i) {
                AllFieldTypes af = new AllFieldTypes();
                byte[] bin = new byte[i];
                for (int j = 0; j < i; ++j) {
                    bin[j] = (byte)(j % 255);
                }
                af.aBinary = ByteBuffer.wrap(bin);
                af.aBool = i % 2 == 0;
                af.aByte = (byte)(i % 255);
                af.aDouble = (double)i * Math.PI;
                af.aFloat = (float)(Math.PI / (double)i);
                af.aLong = i * 2;
                af.anInt = i;
                af.aShort = (short)(i / 2);
                StringBuilder sb = new StringBuilder(i);
                for (int j = 0; j < i; ++j) {
                    sb.append((char)j);
                }
                af.aString = sb.toString();
                return af;
            }
        });
    }

    @Test
    public void testBlankList() throws Exception {
        this.writeAndReadRecords(this.getFactory().writer(LongValue.class), 0, 450, new RecordGenerator<LongValue>(){

            @Override
            public void assertRecord(Record value, int i) {
            }

            @Override
            public LongValue generate(int i) {
                return new LongValue(i);
            }
        });
    }

    @Test
    public void testCopyBinToAddress() throws JournalException, IOException, ParserException {
        int pageLen = 0x100000;
        this.writeAndReadRecords(this.getFactory().writer(Binary.class), 1, 0x100000, new RecordGenerator<Binary>(){

            @Override
            public void assertRecord(Record value, int i) {
                DirectInputStream binCol = value.getBin(0);
                Binary expected = this.generate(i);
                Assert.assertEquals((long)expected.aBinary.remaining(), (long)binCol.size());
                RecordListTest.assertEquals(expected.aBinary, binCol);
            }

            @Override
            public Binary generate(int i) {
                Binary af = new Binary();
                byte[] bin = new byte[1048561];
                for (int j = 0; j < bin.length; ++j) {
                    bin[j] = 65;
                }
                af.aBinary = ByteBuffer.wrap(bin);
                return af;
            }
        });
    }

    @Test
    public void testSaveBinOverPageEdge() throws JournalException, IOException, ParserException {
        int pageLen = 100;
        this.writeAndReadRecords(this.getFactory().writer(Binary.class), 1, 100, new RecordGenerator<Binary>(){

            @Override
            public void assertRecord(Record value, int i) throws IOException {
                DirectInputStream binCol = value.getBin(0);
                Binary expected = this.generate(i);
                byte[] expectedBin = expected.aBinary.array();
                Assert.assertEquals((long)expected.aBinary.remaining(), (long)binCol.size());
                for (int j = 0; j < expectedBin.length; ++j) {
                    Assert.assertEquals((long)expectedBin[j], (long)((byte)binCol.read()));
                }
            }

            @Override
            public Binary generate(int i) {
                Binary af = new Binary();
                byte[] bin = new byte[100];
                for (int j = 0; j < bin.length; ++j) {
                    bin[j] = (byte)(j % 255);
                }
                af.aBinary = ByteBuffer.wrap(bin);
                return af;
            }
        });
    }

    @Test
    public void testSaveLongField() throws JournalException, IOException, ParserException {
        this.writeAndReadRecords(this.getFactory().writer(LongValue.class), 100, 450, new RecordGenerator<LongValue>(){

            @Override
            public void assertRecord(Record value, int i) {
                Assert.assertEquals((long)i, (long)value.getLong(0));
            }

            @Override
            public LongValue generate(int i) {
                return new LongValue(i);
            }
        });
    }

    @Test
    public void testSaveNullBinAndStrings() throws JournalException, IOException, ParserException {
        int pageLen = 100;
        this.writeAndReadRecords(this.getFactory().writer(StringLongBinary.class), 3, 100, new RecordGenerator<StringLongBinary>(){

            @Override
            public void assertRecord(Record value, int i) {
                StringLongBinary expected = this.generate(i);
                CharSequence str = value.getFlyweightStr(0);
                if (expected.aString != null || str != null) {
                    Assert.assertEquals((Object)expected.aString, (Object)str.toString());
                }
                Assert.assertEquals((long)expected.aLong, (long)value.getLong(1));
                DirectInputStream binCol = value.getBin(2);
                if (expected.aBinary != null && binCol != null) {
                    byte[] expectedBin = expected.aBinary.array();
                    Assert.assertEquals((long)expectedBin.length, (long)binCol.size());
                }
            }

            @Override
            public StringLongBinary generate(int i) {
                StringLongBinary af = new StringLongBinary();
                af.aLong = i;
                af.aString = i == 0 ? "A" : null;
                af.aBinary = i == 1 ? ByteBuffer.wrap(new byte[2]) : null;
                return af;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertEquals(ByteBuffer expected, DirectInputStream actual) {
        int sz = (int)actual.size();
        long address = Unsafe.malloc((long)sz);
        try {
            long p = address;
            actual.copyTo(address, 0L, (long)sz);
            for (long i = 0L; i < (long)sz; ++i) {
                Assert.assertEquals((long)expected.get(), (long)Unsafe.getUnsafe().getByte(p++));
            }
        }
        finally {
            Unsafe.free((long)address, (long)sz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void writeAndReadRecords(JournalWriter<T> journal, int count, int pageSize, RecordGenerator<T> generator) throws IOException, JournalException, ParserException {
        try {
            for (int i = 0; i < count; ++i) {
                journal.append(generator.generate(i));
            }
            journal.commit();
            try (RecordList records = new RecordList((RecordMetadata)journal.getMetadata(), pageSize);){
                LongList offsets = new LongList();
                try (RecordSource rs = this.compiler.compile(this.getFactory(), (CharSequence)journal.getLocation().getName());){
                    long o = -1L;
                    RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
                    try {
                        for (Record rec : cursor) {
                            o = records.append(rec, o);
                            offsets.add(o);
                        }
                    }
                    finally {
                        cursor.releaseCursor();
                    }
                }
                int i = 0;
                records.toTop();
                while (records.hasNext()) {
                    generator.assertRecord(records.next(), i++);
                }
            }
        }
        finally {
            journal.close();
        }
    }

    private static class StringLongBinary {
        String aString;
        long aLong;
        ByteBuffer aBinary;

        private StringLongBinary() {
        }
    }

    private static class Binary {
        ByteBuffer aBinary;

        private Binary() {
        }
    }

    private static class AllFieldTypes {
        boolean aBool;
        String aString;
        byte aByte;
        short aShort;
        int anInt;
        ByteBuffer aBinary;
        long aLong;
        double aDouble;
        float aFloat;

        private AllFieldTypes() {
        }
    }

    private static class LongValue {
        long value;

        public LongValue() {
        }

        LongValue(long val) {
            this.value = val;
        }
    }

    private static interface RecordGenerator<T> {
        public void assertRecord(Record var1, int var2) throws IOException;

        public T generate(int var1);
    }
}

