/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.parser.sql.QueryError;
import com.questdb.std.Sinkable;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class OrderByOptimiserTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        JournalWriter w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("tab").$sym("id").index().buckets(128).$double("x").$double("y").$int("i1").$int("i2").$ts());
        w.close();
        w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("tex").$sym("id").index().buckets(128).$double("amount").$ts());
        w.close();
        FACTORY_CONTAINER.getFactory().getConfiguration().exists((CharSequence)"");
    }

    @Before
    public void setUp() {
        sink.clear();
    }

    @Test
    public void testLiteralAnalysis() {
        try {
            this.expectFailure("select x,count() from tab order by timestamp");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)35L, (long)QueryError.getPosition());
            TestUtils.assertEquals((CharSequence)"Invalid column: timestamp", QueryError.getMessage());
        }
    }

    @Test
    public void testOrderOnOneLevelSubQuery() throws Exception {
        sink.put((Sinkable)this.compileSource("select x,count() from (tab order by timestamp)"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"AggregatedRecordSource\",\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"AllRowSource\"}}}}", (CharSequence)sink);
    }

    @Test
    public void testOrderOverride() throws Exception {
        sink.put((Sinkable)this.compileSource("select x,count() from ((tab order by y) order by timestamp)"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"AggregatedRecordSource\",\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"AllRowSource\"}}}}", (CharSequence)sink);
    }

    @Test
    public void testRegularOrder() throws Exception {
        sink.put((Sinkable)this.compileSource("select x,y from ((tab order by y) order by timestamp)"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":true,\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"AllRowSource\"}}}}", (CharSequence)sink);
    }

    @Test
    public void testSampleByBackout() throws Exception {
        sink.put((Sinkable)this.compileSource("(select x,count() from (select y, x, count() from (tab order by timestamp) sample by 1M order by y)) where x = 100"));
        TestUtils.assertEquals((CharSequence)"{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"AggregatedRecordSource\",\"src\":{\"op\":\"RBTreeSortedRecordSource\",\"byRowId\":false,\"src\":{\"op\":\"SelectedColumnsRecordSource\",\"src\":{\"op\":\"ResampledRecordSource\",\"src\":{\"op\":\"JournalRecordSource\",\"psrc\":{\"op\":\"JournalPartitionSource\",\"journal\":\"tab\"},\"rsrc\":{\"op\":\"FilteredRowSource\",\"rsrc\":{\"op\":\"AllRowSource\"}}},\"sampler\":{\"op\":\"MonthsSampler\",\"buckets\":1}}}}}}", (CharSequence)sink);
    }
}

