/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.model.Quote;
import com.questdb.ql.JournalPartitionSource;
import com.questdb.ql.JournalRecordSource;
import com.questdb.ql.PartitionSource;
import com.questdb.ql.RowSource;
import com.questdb.ql.latest.HeapMergingRowSource;
import com.questdb.ql.latest.KvIndexSymLookupRowSource;
import com.questdb.ql.latest.MergingRowSource;
import com.questdb.std.NumericException;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalWriter;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MergingRowSourceTest
extends AbstractTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeapMerge() throws JournalException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 100000, DateFormatUtils.parseDateTime((CharSequence)"2014-02-11T00:00:00.000Z"), 10L);
            KvIndexSymLookupRowSource srcA = new KvIndexSymLookupRowSource("sym", "BP.L", true);
            KvIndexSymLookupRowSource srcB = new KvIndexSymLookupRowSource("sym", "WTB.L", true);
            JournalRecordSource rs = new JournalRecordSource((PartitionSource)new JournalPartitionSource(w.getMetadata(), true), (RowSource)new HeapMergingRowSource(new RowSource[]{srcA, srcB}));
            long last = 0L;
            RecordCursor c = rs.prepareCursor((ReaderFactory)this.getFactory());
            try {
                int ts = rs.getMetadata().getColumnIndex((CharSequence)"timestamp");
                while (c.hasNext()) {
                    long r = ((Record)c.next()).getDate(ts);
                    Assert.assertTrue((r > last ? 1 : 0) != 0);
                    last = r;
                }
            }
            finally {
                c.releaseCursor();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMerge() throws JournalException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 100000, DateFormatUtils.parseDateTime((CharSequence)"2014-02-11T00:00:00.000Z"), 10L);
            KvIndexSymLookupRowSource srcA = new KvIndexSymLookupRowSource("sym", "BP.L", true);
            KvIndexSymLookupRowSource srcB = new KvIndexSymLookupRowSource("sym", "WTB.L", true);
            try (JournalRecordSource rs = new JournalRecordSource((PartitionSource)new JournalPartitionSource(w.getMetadata(), true), (RowSource)new MergingRowSource((RowSource)srcA, (RowSource)srcB));){
                long last = 0L;
                RecordCursor c = rs.prepareCursor((ReaderFactory)this.getFactory());
                try {
                    int ts = rs.getMetadata().getColumnIndex((CharSequence)"timestamp");
                    while (c.hasNext()) {
                        long r = ((Record)c.next()).getDate(ts);
                        Assert.assertTrue((r > last ? 1 : 0) != 0);
                        last = r;
                    }
                }
                finally {
                    c.releaseCursor();
                }
            }
        }
    }
}

