/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.model.Album;
import com.questdb.model.Band;
import com.questdb.ql.AllRowSource;
import com.questdb.ql.JournalPartitionSource;
import com.questdb.ql.JournalRecordSource;
import com.questdb.ql.PartitionSource;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.ql.RowSource;
import com.questdb.ql.join.CrossJoinRecordSource;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalConfigurationBuilder;
import com.questdb.test.tools.FactoryContainer;
import com.questdb.test.tools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class JoinStringToSymbolTest {
    @Rule
    public final FactoryContainer factoryContainer = new FactoryContainer(new JournalConfigurationBuilder(){
        {
            this.$(Band.class).$sym("name").index().$sym("type").$bin("image").$ts();
            this.$(Album.class).$str("band").index().$sym("name").index().$ts("releaseDate");
        }
    });
    private JournalWriter<Band> bw;
    private JournalWriter<Album> aw;

    @Before
    public void setUp() throws Exception {
        this.bw = this.getFactory().writer(Band.class);
        this.aw = this.getFactory().writer(Album.class);
    }

    @After
    public void tearDown() {
        this.aw.close();
        this.bw.close();
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyReaderCount());
    }

    @Test
    public void testCrossJoin() throws Exception {
        this.bw.append((Object)new Band().setName("band1").setType("rock").setUrl("http://band1.com"));
        this.bw.append((Object)new Band().setName("band2").setType("hiphop").setUrl("http://band2.com"));
        this.bw.append((Object)new Band().setName("band3").setType("jazz").setUrl("http://band3.com"));
        this.bw.append((Object)new Band().setName("band1").setType("jazz").setUrl("http://new.band1.com"));
        this.bw.commit();
        this.aw.append((Object)new Album().setName("album X").setBand("band1").setGenre("pop"));
        this.aw.append((Object)new Album().setName("album BZ").setBand("band1").setGenre("rock"));
        this.aw.append((Object)new Album().setName("album Y").setBand("band3").setGenre("metal"));
        this.aw.commit();
        StringSink sink = new StringSink();
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)sink);
        try (CrossJoinRecordSource rs = new CrossJoinRecordSource((RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.aw.getMetadata(), false), (RowSource)new AllRowSource()), (RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.bw.getMetadata(), false), (RowSource)new AllRowSource()));){
            p.print((RecordSource)rs, (ReaderFactory)this.getFactory());
        }
        String expected = "band1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://band1.com\trock\t\nband1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband2\thttp://band2.com\thiphop\t\nband1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband3\thttp://band3.com\tjazz\t\nband1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://new.band1.com\tjazz\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://band1.com\trock\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband2\thttp://band2.com\thiphop\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband3\thttp://band3.com\tjazz\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://new.band1.com\tjazz\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://band1.com\trock\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband2\thttp://band2.com\thiphop\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband3\thttp://band3.com\tjazz\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://new.band1.com\tjazz\t\n";
        TestUtils.assertEquals((CharSequence)"band1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://band1.com\trock\t\nband1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband2\thttp://band2.com\thiphop\t\nband1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband3\thttp://band3.com\tjazz\t\nband1\talbum X\tpop\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://new.band1.com\tjazz\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://band1.com\trock\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband2\thttp://band2.com\thiphop\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband3\thttp://band3.com\tjazz\t\nband1\talbum BZ\trock\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://new.band1.com\tjazz\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://band1.com\trock\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband2\thttp://band2.com\thiphop\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband3\thttp://band3.com\tjazz\t\nband3\talbum Y\tmetal\t1970-01-01T00:00:00.000Z\t1970-01-01T00:00:00.000Z\tband1\thttp://new.band1.com\tjazz\t\n", (CharSequence)sink);
    }

    private Factory getFactory() {
        return this.factoryContainer.getFactory();
    }
}

