/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.model.Album;
import com.questdb.model.Band;
import com.questdb.ql.AllRowSource;
import com.questdb.ql.JournalPartitionSource;
import com.questdb.ql.JournalRecordSource;
import com.questdb.ql.PartitionSource;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.ql.RowSource;
import com.questdb.ql.join.HashJoinRecordSource;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.ql.select.SelectedColumnsRecordSource;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.IntList;
import com.questdb.std.ObjList;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalConfigurationBuilder;
import com.questdb.test.tools.FactoryContainer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class HashJoinRecordSourceTest {
    @Rule
    public final FactoryContainer factoryContainer = new FactoryContainer(new JournalConfigurationBuilder(){
        {
            this.$(Band.class).$ts();
            this.$(Album.class).$ts("releaseDate");
        }
    });
    private JournalWriter<Band> bw;
    private JournalWriter<Album> aw;

    @Before
    public void setUp() throws Exception {
        this.bw = this.getFactory().writer(Band.class);
        this.aw = this.getFactory().writer(Album.class);
    }

    @After
    public void tearDown() {
        this.bw.close();
        this.aw.close();
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyReaderCount());
    }

    @Test
    public void testHashJoinJournalRecordSource() throws Exception {
        this.bw.append((Object)new Band().setName("band1").setType("rock").setUrl("http://band1.com"));
        this.bw.append((Object)new Band().setName("band2").setType("blues").setUrl("http://band2.com"));
        this.bw.append((Object)new Band().setName("band3").setType("jazz").setUrl("http://band3.com"));
        this.bw.append((Object)new Band().setName("band1").setType("jazz").setUrl("http://new.band1.com"));
        this.bw.commit();
        this.aw.append((Object)new Album().setName("album X").setBand("band1").setGenre("pop"));
        this.aw.append((Object)new Album().setName("album Y").setBand("band3").setGenre("metal"));
        this.aw.append((Object)new Album().setName("album BZ").setBand("band1").setGenre("rock"));
        this.aw.commit();
        StringSink sink = new StringSink();
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)sink);
        SelectedColumnsRecordSource joinResult = new SelectedColumnsRecordSource((RecordSource)new HashJoinRecordSource((RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.bw.getMetadata(), false), (RowSource)new AllRowSource()), new IntList(){
            {
                this.add(HashJoinRecordSourceTest.this.bw.getMetadata().getColumnIndex((CharSequence)"name"));
            }
        }, (RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.aw.getMetadata(), false), (RowSource)new AllRowSource()), new IntList(){
            {
                this.add(HashJoinRecordSourceTest.this.aw.getMetadata().getColumnIndex((CharSequence)"band"));
            }
        }, false, 0x400000, 0x400000, 0x100000, new RecordKeyCopierCompiler(new BytecodeAssembler())), (ObjList)new ObjList<CharSequence>(){
            {
                this.add("genre");
            }
        });
        p.print((RecordSource)joinResult, (ReaderFactory)this.getFactory());
        Assert.assertEquals((Object)"pop\nrock\nmetal\npop\nrock\n", (Object)sink.toString());
    }

    @Test
    public void testHashJoinRecordSource() throws Exception {
        this.bw.append((Object)new Band().setName("band1").setType("rock").setUrl("http://band1.com"));
        this.bw.append((Object)new Band().setName("band2").setType("blues").setUrl("http://band2.com"));
        this.bw.append((Object)new Band().setName("band3").setType("jazz").setUrl("http://band3.com"));
        this.bw.append((Object)new Band().setName("band1").setType("jazz").setUrl("http://new.band1.com"));
        this.bw.commit();
        this.aw.append((Object)new Album().setName("album X").setBand("band1").setGenre("pop"));
        this.aw.append((Object)new Album().setName("album Y").setBand("band3").setGenre("metal"));
        this.aw.append((Object)new Album().setName("album BZ").setBand("band1").setGenre("rock"));
        this.aw.commit();
        StringSink sink = new StringSink();
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)sink);
        SelectedColumnsRecordSource joinResult = new SelectedColumnsRecordSource((RecordSource)new HashJoinRecordSource((RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.bw.getMetadata(), false), (RowSource)new AllRowSource()), new IntList(){
            {
                this.add(HashJoinRecordSourceTest.this.bw.getMetadata().getColumnIndex((CharSequence)"name"));
            }
        }, (RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.aw.getMetadata(), false), (RowSource)new AllRowSource()), new IntList(){
            {
                this.add(HashJoinRecordSourceTest.this.aw.getMetadata().getColumnIndex((CharSequence)"band"));
            }
        }, false, 0x400000, 0x400000, 0x100000, new RecordKeyCopierCompiler(new BytecodeAssembler())), (ObjList)new ObjList<CharSequence>(){
            {
                this.add("genre");
            }
        });
        p.print((RecordSource)joinResult, (ReaderFactory)this.getFactory());
        Assert.assertEquals((Object)"pop\nrock\nmetal\npop\nrock\n", (Object)sink.toString());
    }

    @Test
    public void testOuterHashJoin() throws Exception {
        this.bw.append((Object)new Band().setName("band1").setType("rock").setUrl("http://band1.com"));
        this.bw.append((Object)new Band().setName("band2").setType("blues").setUrl("http://band2.com"));
        this.bw.append((Object)new Band().setName("band3").setType("jazz").setUrl("http://band3.com"));
        this.bw.append((Object)new Band().setName("band1").setType("jazz").setUrl("http://new.band1.com"));
        this.bw.append((Object)new Band().setName("band5").setType("jazz").setUrl("http://new.band5.com"));
        this.bw.commit();
        this.aw.append((Object)new Album().setName("album X").setBand("band1").setGenre("pop"));
        this.aw.append((Object)new Album().setName("album Y").setBand("band3").setGenre("metal"));
        this.aw.append((Object)new Album().setName("album BZ").setBand("band1").setGenre("rock"));
        this.aw.commit();
        StringSink sink = new StringSink();
        RecordSourcePrinter p = new RecordSourcePrinter((CharSink)sink);
        SelectedColumnsRecordSource joinResult = new SelectedColumnsRecordSource((RecordSource)new HashJoinRecordSource((RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.bw.getMetadata(), false), (RowSource)new AllRowSource()), new IntList(){
            {
                this.add(HashJoinRecordSourceTest.this.bw.getMetadata().getColumnIndex((CharSequence)"name"));
            }
        }, (RecordSource)new JournalRecordSource((PartitionSource)new JournalPartitionSource(this.aw.getMetadata(), false), (RowSource)new AllRowSource()), new IntList(){
            {
                this.add(HashJoinRecordSourceTest.this.aw.getMetadata().getColumnIndex((CharSequence)"band"));
            }
        }, true, 0x400000, 0x400000, 0x100000, new RecordKeyCopierCompiler(new BytecodeAssembler())), (ObjList)new ObjList<CharSequence>(){
            {
                this.add("genre");
                this.add("url");
            }
        });
        p.print((RecordSource)joinResult, (ReaderFactory)this.getFactory());
        Assert.assertEquals((Object)"pop\thttp://band1.com\nrock\thttp://band1.com\n\thttp://band2.com\nmetal\thttp://band3.com\npop\thttp://new.band1.com\nrock\thttp://new.band1.com\n\thttp://new.band5.com\n", (Object)sink.toString());
    }

    private Factory getFactory() {
        return this.factoryContainer.getFactory();
    }
}

