/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.ql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.RecordSource;
import com.questdb.std.ByteBuffers;
import com.questdb.std.DirectInputStream;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.ColumnType;
import com.questdb.store.Files;
import com.questdb.store.Journal;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class DDLTests
extends AbstractTest {
    private static final QueryCompiler compiler = new QueryCompiler();

    @Test
    public void testBadIntBuckets() throws Exception {
        try {
            this.exec("create table x (a INT index buckets -1, b BYTE, t TIMESTAMP, x SYMBOL) partition by MONTH");
            Assert.fail();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCast(int from, int to) throws Exception {
        Rnd rnd;
        int n = 100;
        try (JournalWriter w1 = compiler.createWriter(this.getFactory(), (CharSequence)("create table y (a " + ColumnType.nameOf((int)from) + ") record hint 100"));){
            rnd = new Rnd();
            for (int i = 0; i < n; ++i) {
                JournalEntryWriter ew = w1.entryWriter();
                switch (from) {
                    case 3: {
                        ew.putInt(0, rnd.nextInt());
                        break;
                    }
                    case 4: {
                        ew.putLong(0, rnd.nextLong());
                        break;
                    }
                    case 10: {
                        ew.putDate(0, rnd.nextLong());
                        break;
                    }
                    case 1: {
                        ew.put(0, rnd.nextByte());
                        break;
                    }
                    case 2: {
                        ew.putShort(0, rnd.nextShort());
                        break;
                    }
                    case 5: {
                        ew.putFloat(0, rnd.nextFloat());
                        break;
                    }
                    case 6: {
                        ew.putDouble(0, rnd.nextDouble());
                        break;
                    }
                    case 8: {
                        ew.putSym(0, rnd.nextChars(10));
                        break;
                    }
                    case 7: {
                        ew.putStr(0, rnd.nextChars(10));
                        break;
                    }
                }
                ew.append();
            }
            w1.commit();
        }
        this.exec("create table x as (y), cast(a as " + ColumnType.nameOf((int)to) + ") record hint 100");
        var5_5 = null;
        try (RecordSource rs = compiler.compile(this.getFactory(), (CharSequence)"x");){
            rnd = new Rnd();
            Assert.assertEquals((long)to, (long)rs.getMetadata().getColumnQuick(0).getType());
            RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
            try {
                block103: while (cursor.hasNext()) {
                    switch (from) {
                        case 3: {
                            switch (to) {
                                case 2: {
                                    Assert.assertEquals((long)((short)rnd.nextInt()), (long)((Record)cursor.next()).getShort(0));
                                    continue block103;
                                }
                                case 4: {
                                    Assert.assertEquals((long)rnd.nextInt(), (long)((Record)cursor.next()).getLong(0));
                                    continue block103;
                                }
                                case 1: {
                                    Assert.assertEquals((long)((byte)rnd.nextInt()), (long)((Record)cursor.next()).getByte(0));
                                    continue block103;
                                }
                                case 5: {
                                    Assert.assertEquals((float)rnd.nextInt(), (float)((Record)cursor.next()).getFloat(0), (float)1.0E-9f);
                                    continue block103;
                                }
                                case 6: {
                                    Assert.assertEquals((double)rnd.nextInt(), (double)((Record)cursor.next()).getDouble(0), (double)1.0E-9);
                                    continue block103;
                                }
                                case 10: {
                                    Assert.assertEquals((long)rnd.nextInt(), (long)((Record)cursor.next()).getDate(0));
                                    continue block103;
                                }
                                case 3: {
                                    Assert.assertEquals((long)rnd.nextInt(), (long)((Record)cursor.next()).getInt(0));
                                    continue block103;
                                }
                            }
                            continue block103;
                        }
                        case 4: 
                        case 10: {
                            switch (to) {
                                case 2: {
                                    Assert.assertEquals((long)((short)rnd.nextLong()), (long)((Record)cursor.next()).getShort(0));
                                    continue block103;
                                }
                                case 4: {
                                    Assert.assertEquals((long)rnd.nextLong(), (long)((Record)cursor.next()).getLong(0));
                                    continue block103;
                                }
                                case 1: {
                                    Assert.assertEquals((long)((byte)rnd.nextLong()), (long)((Record)cursor.next()).getByte(0));
                                    continue block103;
                                }
                                case 5: {
                                    Assert.assertEquals((float)rnd.nextLong(), (float)((Record)cursor.next()).getFloat(0), (float)1.0E-9f);
                                    continue block103;
                                }
                                case 6: {
                                    Assert.assertEquals((double)rnd.nextLong(), (double)((Record)cursor.next()).getDouble(0), (double)1.0E-9);
                                    continue block103;
                                }
                                case 10: {
                                    Assert.assertEquals((long)rnd.nextLong(), (long)((Record)cursor.next()).getDate(0));
                                    continue block103;
                                }
                                case 3: {
                                    Assert.assertEquals((long)((int)rnd.nextLong()), (long)((Record)cursor.next()).getInt(0));
                                    continue block103;
                                }
                            }
                            continue block103;
                        }
                        case 1: {
                            switch (to) {
                                case 2: {
                                    Assert.assertEquals((long)rnd.nextByte(), (long)((Record)cursor.next()).getShort(0));
                                    continue block103;
                                }
                                case 4: {
                                    Assert.assertEquals((long)rnd.nextByte(), (long)((Record)cursor.next()).getLong(0));
                                    continue block103;
                                }
                                case 1: {
                                    Assert.assertEquals((long)rnd.nextByte(), (long)((Record)cursor.next()).getByte(0));
                                    continue block103;
                                }
                                case 5: {
                                    Assert.assertEquals((float)rnd.nextByte(), (float)((Record)cursor.next()).getFloat(0), (float)1.0E-9f);
                                    continue block103;
                                }
                                case 6: {
                                    Assert.assertEquals((double)rnd.nextByte(), (double)((Record)cursor.next()).getDouble(0), (double)1.0E-9);
                                    continue block103;
                                }
                                case 10: {
                                    Assert.assertEquals((long)rnd.nextByte(), (long)((Record)cursor.next()).getDate(0));
                                    continue block103;
                                }
                                case 3: {
                                    Assert.assertEquals((long)rnd.nextByte(), (long)((Record)cursor.next()).getInt(0));
                                    continue block103;
                                }
                            }
                            continue block103;
                        }
                        case 2: {
                            switch (to) {
                                case 2: {
                                    Assert.assertEquals((long)rnd.nextShort(), (long)((Record)cursor.next()).getShort(0));
                                    continue block103;
                                }
                                case 4: {
                                    Assert.assertEquals((long)rnd.nextShort(), (long)((Record)cursor.next()).getLong(0));
                                    continue block103;
                                }
                                case 1: {
                                    Assert.assertEquals((long)((byte)rnd.nextShort()), (long)((Record)cursor.next()).getByte(0));
                                    continue block103;
                                }
                                case 5: {
                                    Assert.assertEquals((float)rnd.nextShort(), (float)((Record)cursor.next()).getFloat(0), (float)1.0E-9f);
                                    continue block103;
                                }
                                case 6: {
                                    Assert.assertEquals((double)rnd.nextShort(), (double)((Record)cursor.next()).getDouble(0), (double)1.0E-9);
                                    continue block103;
                                }
                                case 10: {
                                    Assert.assertEquals((long)rnd.nextShort(), (long)((Record)cursor.next()).getDate(0));
                                    continue block103;
                                }
                                case 3: {
                                    Assert.assertEquals((long)rnd.nextShort(), (long)((Record)cursor.next()).getInt(0));
                                    continue block103;
                                }
                            }
                            continue block103;
                        }
                        case 5: {
                            switch (to) {
                                case 2: {
                                    Assert.assertEquals((long)((short)rnd.nextFloat()), (long)((Record)cursor.next()).getShort(0));
                                    continue block103;
                                }
                                case 4: {
                                    Assert.assertEquals((long)((long)rnd.nextFloat()), (long)((Record)cursor.next()).getLong(0));
                                    continue block103;
                                }
                                case 1: {
                                    Assert.assertEquals((long)((byte)rnd.nextFloat()), (long)((Record)cursor.next()).getByte(0));
                                    continue block103;
                                }
                                case 5: {
                                    Assert.assertEquals((float)rnd.nextFloat(), (float)((Record)cursor.next()).getFloat(0), (float)1.0E-9f);
                                    continue block103;
                                }
                                case 6: {
                                    Assert.assertEquals((double)rnd.nextFloat(), (double)((Record)cursor.next()).getDouble(0), (double)1.0E-9);
                                    continue block103;
                                }
                                case 10: {
                                    Assert.assertEquals((long)((long)rnd.nextFloat()), (long)((Record)cursor.next()).getDate(0));
                                    continue block103;
                                }
                                case 3: {
                                    Assert.assertEquals((long)((int)rnd.nextFloat()), (long)((Record)cursor.next()).getInt(0));
                                    continue block103;
                                }
                            }
                            continue block103;
                        }
                        case 6: {
                            switch (to) {
                                case 2: {
                                    Assert.assertEquals((long)((short)rnd.nextDouble()), (long)((Record)cursor.next()).getShort(0));
                                    continue block103;
                                }
                                case 4: {
                                    Assert.assertEquals((long)((long)rnd.nextDouble()), (long)((Record)cursor.next()).getLong(0));
                                    continue block103;
                                }
                                case 1: {
                                    Assert.assertEquals((long)((byte)rnd.nextDouble()), (long)((Record)cursor.next()).getByte(0));
                                    continue block103;
                                }
                                case 5: {
                                    Assert.assertEquals((float)((float)rnd.nextDouble()), (float)((Record)cursor.next()).getFloat(0), (float)1.0E-9f);
                                    continue block103;
                                }
                                case 6: {
                                    Assert.assertEquals((double)rnd.nextDouble(), (double)((Record)cursor.next()).getDouble(0), (double)1.0E-9);
                                    continue block103;
                                }
                                case 10: {
                                    Assert.assertEquals((long)((long)rnd.nextDouble()), (long)((Record)cursor.next()).getDate(0));
                                    continue block103;
                                }
                                case 3: {
                                    Assert.assertEquals((long)((int)rnd.nextDouble()), (long)((Record)cursor.next()).getInt(0));
                                    continue block103;
                                }
                            }
                            continue block103;
                        }
                        case 7: {
                            switch (to) {
                                case 8: {
                                    TestUtils.assertEquals(rnd.nextChars(10), ((Record)cursor.next()).getSym(0));
                                    continue block103;
                                }
                            }
                            TestUtils.assertEquals(rnd.nextChars(10), ((Record)cursor.next()).getFlyweightStr(0));
                            continue block103;
                        }
                        case 8: {
                            switch (to) {
                                case 7: {
                                    TestUtils.assertEquals(rnd.nextChars(10), ((Record)cursor.next()).getFlyweightStr(0));
                                    continue block103;
                                }
                            }
                            TestUtils.assertEquals(rnd.nextChars(10), ((Record)cursor.next()).getSym(0));
                            continue block103;
                        }
                    }
                }
            }
            finally {
                cursor.releaseCursor();
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testCastByteAsByte() throws Exception {
        this.testCast(1, 1);
    }

    @Test
    public void testCastByteAsDate() throws Exception {
        this.testCast(1, 10);
    }

    @Test
    public void testCastByteAsDouble() throws Exception {
        this.testCast(1, 6);
    }

    @Test
    public void testCastByteAsFloat() throws Exception {
        this.testCast(1, 5);
    }

    @Test
    public void testCastByteAsInt() throws Exception {
        this.testCast(1, 3);
    }

    @Test
    public void testCastByteAsLong() throws Exception {
        this.testCast(1, 4);
    }

    @Test
    public void testCastByteAsShort() throws Exception {
        this.testCast(1, 2);
    }

    @Test
    public void testCastDateAsByte() throws Exception {
        this.testCast(10, 1);
    }

    @Test
    public void testCastDateAsDate() throws Exception {
        this.testCast(10, 10);
    }

    @Test
    public void testCastDateAsDouble() throws Exception {
        this.testCast(10, 6);
    }

    @Test
    public void testCastDateAsFloat() throws Exception {
        this.testCast(10, 5);
    }

    @Test
    public void testCastDateAsInt() throws Exception {
        this.testCast(10, 3);
    }

    @Test
    public void testCastDateAsLong() throws Exception {
        this.testCast(10, 4);
    }

    @Test
    public void testCastDateAsShort() throws Exception {
        this.testCast(10, 2);
    }

    @Test
    public void testCastDoubleAsByte() throws Exception {
        this.testCast(6, 1);
    }

    @Test
    public void testCastDoubleAsDate() throws Exception {
        this.testCast(6, 10);
    }

    @Test
    public void testCastDoubleAsDouble() throws Exception {
        this.testCast(6, 6);
    }

    @Test
    public void testCastDoubleAsFloat() throws Exception {
        this.testCast(6, 5);
    }

    @Test
    public void testCastDoubleAsInt() throws Exception {
        this.testCast(6, 3);
    }

    @Test
    public void testCastDoubleAsLong() throws Exception {
        this.testCast(6, 4);
    }

    @Test
    public void testCastDoubleAsShort() throws Exception {
        this.testCast(6, 2);
    }

    @Test
    public void testCastFloatAsByte() throws Exception {
        this.testCast(5, 1);
    }

    @Test
    public void testCastFloatAsDate() throws Exception {
        this.testCast(5, 10);
    }

    @Test
    public void testCastFloatAsDouble() throws Exception {
        this.testCast(5, 6);
    }

    @Test
    public void testCastFloatAsFloat() throws Exception {
        this.testCast(5, 5);
    }

    @Test
    public void testCastFloatAsInt() throws Exception {
        this.testCast(5, 3);
    }

    @Test
    public void testCastFloatAsLong() throws Exception {
        this.testCast(5, 4);
    }

    @Test
    public void testCastFloatAsShort() throws Exception {
        this.testCast(5, 2);
    }

    @Test
    public void testCastIntAsByte() throws Exception {
        this.testCast(3, 1);
    }

    @Test
    public void testCastIntAsDate() throws Exception {
        this.testCast(3, 10);
    }

    @Test
    public void testCastIntAsDouble() throws Exception {
        this.testCast(3, 6);
    }

    @Test
    public void testCastIntAsFloat() throws Exception {
        this.testCast(3, 5);
    }

    @Test
    public void testCastIntAsInt() throws Exception {
        this.testCast(3, 3);
    }

    @Test
    public void testCastIntAsLong() throws Exception {
        this.testCast(3, 4);
    }

    @Test
    public void testCastIntAsShort() throws Exception {
        this.testCast(3, 2);
    }

    @Test
    public void testCastLongAsByte() throws Exception {
        this.testCast(4, 1);
    }

    @Test
    public void testCastLongAsDate() throws Exception {
        this.testCast(4, 10);
    }

    @Test
    public void testCastLongAsDouble() throws Exception {
        this.testCast(4, 6);
    }

    @Test
    public void testCastLongAsFloat() throws Exception {
        this.testCast(4, 5);
    }

    @Test
    public void testCastLongAsInt() throws Exception {
        this.testCast(4, 3);
    }

    @Test
    public void testCastLongAsLong() throws Exception {
        this.testCast(4, 4);
    }

    @Test
    public void testCastLongAsShort() throws Exception {
        this.testCast(4, 2);
    }

    @Test
    public void testCastShortAsByte() throws Exception {
        this.testCast(2, 1);
    }

    @Test
    public void testCastShortAsDate() throws Exception {
        this.testCast(2, 10);
    }

    @Test
    public void testCastShortAsDouble() throws Exception {
        this.testCast(2, 6);
    }

    @Test
    public void testCastShortAsFloat() throws Exception {
        this.testCast(2, 5);
    }

    @Test
    public void testCastShortAsInt() throws Exception {
        this.testCast(2, 3);
    }

    @Test
    public void testCastShortAsLong() throws Exception {
        this.testCast(2, 4);
    }

    @Test
    public void testCastShortAsShort() throws Exception {
        this.testCast(2, 2);
    }

    @Test
    public void testCastStrAsStr() throws Exception {
        this.testCast(7, 7);
    }

    @Test
    public void testCastStrAsSym() throws Exception {
        this.testCast(7, 8);
    }

    @Test
    public void testCastSymAsStr() throws Exception {
        this.testCast(8, 7);
    }

    @Test
    public void testCastSymAsSym() throws Exception {
        this.testCast(8, 8);
    }

    @Test
    public void testCreateAllFieldTypes() throws Exception {
        this.exec("create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING, y BOOLEAN) timestamp(t) partition by MONTH record hint 100");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)12L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)2L, (long)m.getColumn((CharSequence)"c").getType());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"d").getType());
            Assert.assertEquals((long)5L, (long)m.getColumn((CharSequence)"e").getType());
            Assert.assertEquals((long)6L, (long)m.getColumn((CharSequence)"f").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"g").getType());
            Assert.assertEquals((long)9L, (long)m.getColumn((CharSequence)"h").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertEquals((long)0L, (long)m.getColumn((CharSequence)"y").getType());
            Assert.assertEquals((long)8L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateAsSelect() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t)");){
            JournalMetadata m = w.getMetadata();
            Assert.assertEquals((long)11L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)2L, (long)m.getColumn((CharSequence)"c").getType());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"d").getType());
            Assert.assertEquals((long)5L, (long)m.getColumn((CharSequence)"e").getType());
            Assert.assertEquals((long)6L, (long)m.getColumn((CharSequence)"f").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"g").getType());
            Assert.assertEquals((long)9L, (long)m.getColumn((CharSequence)"h").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertEquals((long)8L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)3L, (long)m.getPartitionBy());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAsSelectAll() throws Exception {
        int N = 50;
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING, y BOOLEAN) timestamp(t) record hint 100");){
            Rnd rnd = new Rnd();
            long t = DateFormatUtils.parseDateTime((CharSequence)"2016-01-10T00:00:00.000Z");
            for (int i = 0; i < N; ++i) {
                JournalEntryWriter ew = w.entryWriter(t += 86400000L);
                ew.putInt(0, i);
                ew.put(1, (byte)rnd.nextInt());
                ew.putShort(2, (short)rnd.nextInt());
                ew.putLong(3, rnd.nextLong());
                ew.putFloat(4, rnd.nextFloat());
                ew.putDouble(5, rnd.nextDouble());
                ew.putDate(6, rnd.nextLong());
                ew.putNull(7);
                ew.putSym(9, rnd.nextChars(1));
                ew.putStr(10, rnd.nextChars(10));
                ew.putBool(11, rnd.nextBoolean());
                ew.append();
            }
            w.commit();
        }
        this.exec("create table y as (x) partition by MONTH");
        var3_4 = null;
        try (Journal r = this.getFactory().reader("y");){
            Assert.assertEquals((long)2L, (long)r.getPartitionCount());
        }
        catch (Throwable throwable) {
            var3_4 = throwable;
            throw throwable;
        }
        int count = 0;
        try (RecordSource rs = compiler.compile(this.getFactory(), (CharSequence)"y");){
            RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
            try {
                Rnd rnd = new Rnd();
                while (cursor.hasNext()) {
                    Record rec = (Record)cursor.next();
                    Assert.assertEquals((long)count, (long)rec.getInt(0));
                    Assert.assertEquals((long)((byte)rnd.nextInt()), (long)rec.getByte(1));
                    Assert.assertEquals((long)((short)rnd.nextInt()), (long)rec.getShort(2));
                    Assert.assertEquals((long)rnd.nextLong(), (long)rec.getLong(3));
                    Assert.assertEquals((float)rnd.nextFloat(), (float)rec.getFloat(4), (float)1.0E-5f);
                    Assert.assertEquals((double)rnd.nextDouble(), (double)rec.getDouble(5), (double)1.0E-11);
                    Assert.assertEquals((long)rnd.nextLong(), (long)rec.getDate(6));
                    Assert.assertNull((Object)rec.getBin(7));
                    TestUtils.assertEquals(rnd.nextChars(1), rec.getSym(9));
                    TestUtils.assertEquals(rnd.nextChars(10), rec.getFlyweightStr(10));
                    Assert.assertEquals((Object)rnd.nextBoolean(), (Object)rec.getBool(11));
                    ++count;
                }
            }
            finally {
                cursor.releaseCursor();
            }
        }
    }

    @Test
    public void testCreateAsSelectBadHint() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) record hint 100");
        try {
            this.exec("create table x as (y order by t) record hint 1000000000000000000000000000");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)45L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectBadIndex() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) record hint 100");
        try {
            this.exec("create table x as (y order by t), index(e) record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)40L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectBadIndex2() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) record hint 100");
        try {
            this.exec("create table x as (y order by t), index(e2) record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)40L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectBadTimestamp() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) record hint 100");
        try {
            this.exec("create table x as (y order by t) timestamp(c) partition by MONTH record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)43L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectBadTimestamp2() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) record hint 100");
        try {
            this.exec("create table x as (y order by t) timestamp(c2) partition by MONTH record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)43L, (long)QueryError.getPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCreateAsSelectBin() throws Exception {
        int N = 10000;
        int SZ = 4096;
        ByteBuffer buf = ByteBuffer.allocateDirect(SZ);
        try {
            long addr = ByteBuffers.getAddress((ByteBuffer)buf);
            try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x (a INT, b BINARY)");){
                Rnd rnd = new Rnd();
                for (int i = 0; i < N; ++i) {
                    long p = addr;
                    int n = rnd.nextPositiveInt() % (SZ - 1) / 8;
                    for (int j = 0; j < n; ++j) {
                        Unsafe.getUnsafe().putLong(p, rnd.nextLong());
                        p += 8L;
                    }
                    buf.limit(n * 8);
                    JournalEntryWriter ew = w.entryWriter();
                    ew.putInt(0, i);
                    ew.putBin(1, buf);
                    ew.append();
                    buf.clear();
                }
                w.commit();
            }
            this.exec("create table y as (x)");
            int count = 0;
            try (RecordSource rs = compiler.compile(this.getFactory(), (CharSequence)"y");){
                RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
                try {
                    Rnd rnd = new Rnd();
                    while (cursor.hasNext()) {
                        Record rec = (Record)cursor.next();
                        Assert.assertEquals((long)count, (long)rec.getInt(0));
                        long len = rec.getBinLen(1);
                        DirectInputStream is = rec.getBin(1);
                        is.copyTo(addr, 0L, len);
                        long p = addr;
                        int n = rnd.nextPositiveInt() % (SZ - 1) / 8;
                        for (int j = 0; j < n; ++j) {
                            Assert.assertEquals((long)rnd.nextLong(), (long)Unsafe.getUnsafe().getLong(p));
                            p += 8L;
                        }
                        ++count;
                    }
                }
                finally {
                    cursor.releaseCursor();
                }
            }
            Assert.assertEquals((long)N, (long)count);
        }
        finally {
            ByteBuffers.release((ByteBuffer)buf);
        }
    }

    @Test
    public void testCreateAsSelectCastInconvertible() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try {
            compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t), cast(a as SYMBOL), cast(b as INT)");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)44L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectCastInconvertible2() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try {
            compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t), cast(h as INT), cast(b as INT)");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)44L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectCastMultipleWrong() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try {
            compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t), cast(a as LONG), cast(bz as INT)");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)56L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectCastWrongColumn() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try {
            compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t), cast(ab as LONG)");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)39L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectCastWrongType() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try {
            compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t), cast(a as LONGI)");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)44L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectIndexes() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t), index (a), index(x), index(z)");){
            JournalMetadata m = w.getMetadata();
            Assert.assertEquals((long)11L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)2L, (long)m.getColumn((CharSequence)"c").getType());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"d").getType());
            Assert.assertEquals((long)5L, (long)m.getColumn((CharSequence)"e").getType());
            Assert.assertEquals((long)6L, (long)m.getColumn((CharSequence)"f").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"g").getType());
            Assert.assertEquals((long)9L, (long)m.getColumn((CharSequence)"h").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"x").isIndexed());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"z").isIndexed());
            Assert.assertEquals((long)8L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)3L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateAsSelectLongIndex() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) record hint 100");
        this.exec("create table x as (y order by t), index(d) record hint 100");
    }

    @Test
    public void testCreateAsSelectPartitionBy() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t) partition by MONTH record hint 100");){
            JournalMetadata m = w.getMetadata();
            Assert.assertEquals((long)11L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)2L, (long)m.getColumn((CharSequence)"c").getType());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"d").getType());
            Assert.assertEquals((long)5L, (long)m.getColumn((CharSequence)"e").getType());
            Assert.assertEquals((long)6L, (long)m.getColumn((CharSequence)"f").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"g").getType());
            Assert.assertEquals((long)9L, (long)m.getColumn((CharSequence)"h").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertEquals((long)8L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateAsSelectPartitioned() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t) partition by MONTH record hint 100");){
            JournalMetadata m = w.getMetadata();
            Assert.assertEquals((long)11L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)2L, (long)m.getColumn((CharSequence)"c").getType());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"d").getType());
            Assert.assertEquals((long)5L, (long)m.getColumn((CharSequence)"e").getType());
            Assert.assertEquals((long)6L, (long)m.getColumn((CharSequence)"f").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"g").getType());
            Assert.assertEquals((long)9L, (long)m.getColumn((CharSequence)"h").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertEquals((long)8L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateAsSelectPartitionedMixedCase() throws Exception {
        this.exec("create table y (a INT, b byte, c Short, d long, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t) partition by MONTH record hint 100");){
            JournalMetadata m = w.getMetadata();
            Assert.assertEquals((long)11L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)2L, (long)m.getColumn((CharSequence)"c").getType());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"d").getType());
            Assert.assertEquals((long)5L, (long)m.getColumn((CharSequence)"e").getType());
            Assert.assertEquals((long)6L, (long)m.getColumn((CharSequence)"f").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"g").getType());
            Assert.assertEquals((long)9L, (long)m.getColumn((CharSequence)"h").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertEquals((long)8L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateAsSelectPartitionedNoTimestamp() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) record hint 100");
        try {
            this.exec("create table x as (y order by t) partition by MONTH record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)46L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateAsSelectSymbolCount() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try (JournalWriter w = compiler.createWriter(this.getFactory(), (CharSequence)"create table x as (y order by t), cast(x as SYMBOL count 33), cast(b as INT)");){
            Assert.assertEquals((long)8L, (long)w.getMetadata().getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)63L, (long)w.getMetadata().getColumn((CharSequence)"x").getBucketCount());
        }
    }

    @Test
    public void testCreateAsSelectSymbolCountError() throws Exception {
        this.exec("create table y (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t DATE, x SYMBOL, z STRING) timestamp(t) partition by YEAR record hint 100");
        try {
            this.exec("create table x as (y order by t), cast(x as SYMBOL 33), cast(b as INT)");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)51L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateDefaultPartitionBy() throws Exception {
        this.exec("create table x (a INT index, b BYTE, t DATE, z STRING index buckets 40, l LONG index buckets 500) record hint 100");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)5L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"z").isIndexed());
            Assert.assertEquals((long)63L, (long)m.getColumn((CharSequence)"z").getBucketCount());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"l").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"l").isIndexed());
            Assert.assertEquals((long)511L, (long)m.getColumn((CharSequence)"l").getBucketCount());
            Assert.assertEquals((long)-1L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)3L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateExistingTable() throws Exception {
        this.exec("create table x (a INT index buckets 25, b BYTE, t DATE, x SYMBOL index) timestamp(t) partition by MONTH");
        try {
            this.exec("create table x (a INT index buckets 25, b BYTE, t DATE, x SYMBOL index) timestamp(t) partition by MONTH");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)13L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateFromDefPartitionNoTimestamp() throws Exception {
        try {
            this.exec("create table x (a INT, b BYTE, x SYMBOL), index(a buckets 25), index(x) partition by YEAR record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)85L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateIndexWithSuffix() throws Exception {
        this.exec("create table x (a INT, b BYTE, t DATE, x SYMBOL), index(a buckets 25), index(x) timestamp(t) partition by YEAR record hint 100");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)4L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)31L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"x").isIndexed());
            Assert.assertEquals((long)2L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)2L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateIndexWithSuffixDefaultPartition() throws Exception {
        this.exec("create table x (a INT, b BYTE, t DATE, x SYMBOL), index(a buckets 25), index(x) timestamp(t) record hint 100");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)4L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)31L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"x").isIndexed());
            Assert.assertEquals((long)2L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)3L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateIndexedInt() throws Exception {
        this.exec("create table x (a INT index buckets 25, b BYTE, t DATE, x SYMBOL) timestamp(t) partition by MONTH record hint 100");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)4L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)31L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)2L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateIndexedIntDefaultBuckets() throws Exception {
        this.exec("create table x (a INT index, b BYTE, t DATE, x SYMBOL) timestamp(t) partition by MONTH record hint 100");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)4L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertEquals((long)2L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateIndexedString() throws Exception {
        this.exec("create table x (a INT index, b BYTE, t DATE, z STRING index buckets 40) timestamp(t) partition by MONTH record hint 100");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)4L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"z").isIndexed());
            Assert.assertEquals((long)63L, (long)m.getColumn((CharSequence)"z").getBucketCount());
            Assert.assertEquals((long)2L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateIndexedSymbol() throws Exception {
        this.exec("create table x (a INT index buckets 25, b BYTE, t DATE, x SYMBOL index) timestamp(t) partition by MONTH");
        try (Journal r = this.getFactory().reader("x");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)4L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)31L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)8L, (long)m.getColumn((CharSequence)"x").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"x").isIndexed());
            Assert.assertEquals((long)2L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)1L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateQuotedName() throws Exception {
        this.exec("create table 'a b' (a INT index, b BYTE, t DATE, z STRING index buckets 40, l LONG index buckets 500) record hint 100");
        try (Journal r = this.getFactory().reader("a b");){
            Assert.assertNotNull((Object)r);
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)5L, (long)m.getColumnCount());
            Assert.assertEquals((long)3L, (long)m.getColumn((CharSequence)"a").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"a").isIndexed());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"a").getBucketCount());
            Assert.assertEquals((long)1L, (long)m.getColumn((CharSequence)"b").getType());
            Assert.assertEquals((long)10L, (long)m.getColumn((CharSequence)"t").getType());
            Assert.assertEquals((long)7L, (long)m.getColumn((CharSequence)"z").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"z").isIndexed());
            Assert.assertEquals((long)63L, (long)m.getColumn((CharSequence)"z").getBucketCount());
            Assert.assertEquals((long)4L, (long)m.getColumn((CharSequence)"l").getType());
            Assert.assertTrue((boolean)m.getColumn((CharSequence)"l").isIndexed());
            Assert.assertEquals((long)511L, (long)m.getColumn((CharSequence)"l").getBucketCount());
            Assert.assertEquals((long)-1L, (long)m.getTimestampIndex());
            Assert.assertEquals((long)3L, (long)m.getPartitionBy());
        }
    }

    @Test
    public void testCreateReservedName() throws Exception {
        Files.mkDirsOrException((File)new File(this.getFactory().getConfiguration().getJournalBase(), "x"));
        try {
            this.exec("create table x (a INT, b BYTE, t DATE, x SYMBOL) partition by MONTH");
        }
        catch (ParserException e) {
            TestUtils.assertContains(QueryError.getMessage(), "reserved");
            Assert.assertEquals((long)13L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testCreateSymbolWithCount1() throws Exception {
        try {
            this.exec("create table x (a INT, x SYMBOL count 20, z STRING, y BOOLEAN) timestamp(t) partition by MONTH record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)32L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testInvalidPartitionBy() throws Exception {
        try {
            this.exec("create table x (a INT index, b BYTE, t DATE, z STRING index buckets 40) partition by x record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)85L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testInvalidPartitionBy2() throws Exception {
        try {
            this.exec("create table x (a INT index, b BYTE, t DATE, z STRING index buckets 40) partition by 1 record hint 100");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)85L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testUnsupportedTypeForIndex() throws Exception {
        try {
            this.exec("create table x (a INT, b BYTE, t DATE, x SYMBOL), index(t) partition by YEAR");
            Assert.fail();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }

    private void exec(String ddl) throws JournalException, ParserException {
        compiler.execute(this.getFactory(), (CharSequence)ddl);
    }
}

