/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.printer.converter;

import com.questdb.printer.JournalPrinter;
import com.questdb.printer.converter.AbstractConverter;
import com.questdb.std.Unsafe;
import java.util.regex.Pattern;

public class StripCRLFStringConverter
extends AbstractConverter {
    private static final Pattern CR = Pattern.compile("\n", 16);
    private static final Pattern LF = Pattern.compile("\r", 16);

    public StripCRLFStringConverter(JournalPrinter printer) {
        super(printer);
    }

    @Override
    public void convert(StringBuilder stringBuilder, JournalPrinter.Field field, Object obj) {
        String s = field.getOffset() == -1L ? obj.toString() : (String)Unsafe.getUnsafe().getObject(obj, field.getOffset());
        if (s == null) {
            stringBuilder.append(this.getPrinter().getNullString());
        } else {
            stringBuilder.append(LF.matcher(CR.matcher(s).replaceAll(" ")).replaceAll(""));
        }
    }
}

