/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.printer.converter;

import com.questdb.printer.JournalPrinter;
import com.questdb.printer.converter.Converter;
import com.questdb.std.Unsafe;

public class ScaledDoubleConverter
implements Converter {
    private final int scaleFactor;

    public ScaledDoubleConverter(int scaleFactor) {
        this.scaleFactor = scaleFactor;
    }

    public static void appendTo(StringBuilder builder, double value, int scaleFactor) {
        double d;
        if (value < 0.0) {
            builder.append('-');
            d = -value;
        } else {
            d = value;
        }
        long factor = (long)Math.pow(10.0, scaleFactor);
        long scaled = (long)(d * (double)factor + 0.5);
        int scale = scaleFactor + 1;
        while (factor * 10L <= scaled) {
            factor *= 10L;
            ++scale;
        }
        while (scale > 0) {
            if (scale == scaleFactor) {
                builder.append('.');
            }
            long c = scaled / factor % 10L;
            factor /= 10L;
            builder.append((char)(48L + c));
            --scale;
        }
    }

    @Override
    public void convert(StringBuilder stringBuilder, JournalPrinter.Field field, Object obj) {
        ScaledDoubleConverter.appendTo(stringBuilder, Unsafe.getUnsafe().getDouble(obj, field.getOffset()), this.scaleFactor);
    }
}

