/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.printer.appender;

import com.questdb.printer.appender.Appender;

public class AssertingAppender
implements Appender {
    private final String[] expected;
    private int index;

    public AssertingAppender(String expected) {
        this.expected = expected.split("\n");
    }

    @Override
    public void append(StringBuilder stringBuilder) {
        if (this.index < this.expected.length) {
            String s = stringBuilder.toString();
            if (!this.expected[this.index].equals(s)) {
                throw new AssertionError((Object)("\n\n>>>> Expected [ " + (this.index + 1) + " ]>>>>\n" + this.expected[this.index] + "\n<<<<  Actual  <<<<\n" + s + '\n'));
            }
        } else {
            throw new AssertionError((Object)("!!! Expected " + this.expected.length + " lines, actual " + this.index));
        }
        ++this.index;
    }

    @Override
    public void close() {
        if (this.index < this.expected.length) {
            throw new AssertionError((Object)("!!! Too few rows. Expected " + this.expected.length + ", actual " + this.index));
        }
    }
}

