/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.printer;

import com.questdb.model.Quote;
import com.questdb.model.TestEntity;
import com.questdb.printer.JournalPrinter;
import com.questdb.printer.appender.Appender;
import com.questdb.printer.converter.DateConverter;
import com.questdb.printer.converter.ScaledDoubleConverter;
import com.questdb.printer.converter.StripCRLFStringConverter;
import com.questdb.std.time.DateFormatUtils;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class PrinterTest {
    private final TestAppender testAppender = new TestAppender();

    @Test
    public void testCRLFStripping() {
        try (JournalPrinter printer = new JournalPrinter();){
            printer.setAppender(this.testAppender).setNullString("").types(String.class, TestEntity.class).v(0).c(new StripCRLFStringConverter(printer)).h("Test String").f("bStr").c(new StripCRLFStringConverter(printer)).h("destination");
            printer.out("test string", new TestEntity().setBStr("ok\nbunny"));
            printer.out("test\nstring2\r_good", new TestEntity().setBStr("ok foxy"));
            this.testAppender.assertLine("test string\tok bunny", 0);
            this.testAppender.assertLine("test string2_good\tok foxy", 1);
        }
    }

    @Test
    public void testDateConversion() throws Exception {
        long millis = DateFormatUtils.parseDateTime((CharSequence)"2013-10-11T10:00:00.000Z");
        Quote position1 = new Quote().setBidSize(10).setTimestamp(millis);
        Quote position2 = new Quote().setTimestamp(millis);
        try (JournalPrinter printer = new JournalPrinter();){
            printer.types(Quote.class, Integer.TYPE);
            printer.setAppender(this.testAppender);
            printer.f("timestamp").i(0).h("TimeStamp").c(new DateConverter(printer)).f("bidSize").f("askSize").v(1).h("test");
            printer.header();
            printer.out(position1, 0);
            printer.out(position2, 1);
            this.testAppender.assertLine("TimeStamp\tbidSize\taskSize\ttest", 0);
            this.testAppender.assertLine("2013-10-11T10:00:00.000Z\t10\t0\t0", 1);
            this.testAppender.assertLine("2013-10-11T10:00:00.000Z\t0\t0\t1", 2);
        }
    }

    @Test
    public void testDoublePrinting() {
        for (String s : "-0.000001,0.000009,-0.000010,0.100000,1.100000,10.100000".split(",")) {
            double d = Double.parseDouble(s);
            StringBuilder sb = new StringBuilder();
            ScaledDoubleConverter.appendTo(sb, d, 6);
            Assert.assertEquals((Object)s, (Object)sb.toString());
        }
    }

    private static class TestAppender
    implements Appender {
        private final List<String> output = new ArrayList<String>();

        private TestAppender() {
        }

        @Override
        public void append(StringBuilder stringBuilder) {
            this.output.add(stringBuilder.toString());
        }

        @Override
        public void close() {
            this.output.clear();
        }

        public void assertLine(String expected, int line) {
            Assert.assertTrue((String)("Appender receiver too few lines: " + line + " >= " + this.output.size()), (line < this.output.size() ? 1 : 0) != 0);
            Assert.assertEquals((Object)expected, (Object)this.output.get(line));
        }
    }
}

