/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.printer;

import com.questdb.printer.appender.Appender;
import com.questdb.printer.appender.StdOutAppender;
import com.questdb.printer.converter.BooleanConverter;
import com.questdb.printer.converter.ByteConverter;
import com.questdb.printer.converter.Converter;
import com.questdb.printer.converter.DoubleConverter;
import com.questdb.printer.converter.IntConverter;
import com.questdb.printer.converter.LongConverter;
import com.questdb.printer.converter.ObjectToStringConverter;
import com.questdb.printer.converter.ShortConverter;
import com.questdb.printer.converter.StringConverter;
import com.questdb.std.Unsafe;
import com.questdb.store.JournalRuntimeException;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;

public class JournalPrinter
implements Closeable {
    private static final long OBJECT_VALUE_OFFSET = -1L;
    private final StringBuilder rowBuilder = new StringBuilder();
    private final List<Field> ff = new ArrayList<Field>();
    private Class[] typeTemplate = new Class[0];
    private String delimiter = "\t";
    private Appender appender = StdOutAppender.INSTANCE;
    private String nullString;
    private boolean configured = false;

    @Override
    public void close() {
        this.appender.close();
        this.ff.clear();
        this.configured = false;
    }

    public Field f(String name) {
        Field field = new Field(name, this);
        this.ff.add(field);
        return field;
    }

    public String getNullString() {
        return this.nullString;
    }

    public JournalPrinter setNullString(String forNull) {
        this.nullString = forNull;
        return this;
    }

    public void header() {
        this.rowBuilder.setLength(0);
        for (int i = 0; i < this.ff.size(); ++i) {
            Field f;
            String header;
            if (i > 0) {
                this.rowBuilder.append(this.delimiter);
            }
            if ((header = (f = this.ff.get(i)).header) == null) {
                this.rowBuilder.append(f.name);
                continue;
            }
            this.rowBuilder.append(f.header);
        }
        this.appender.append(this.rowBuilder);
    }

    public void out(Object ... instances) {
        this.configure();
        this.rowBuilder.setLength(0);
        int sz = this.ff.size();
        for (int i = 0; i < sz; ++i) {
            Field f;
            Object instance;
            if (i > 0) {
                this.rowBuilder.append(this.delimiter);
            }
            if ((instance = instances[(f = this.ff.get(i)).typeTemplateIndex]) == null) continue;
            f.converter.convert(this.rowBuilder, f, instances[f.typeTemplateIndex]);
        }
        this.appender.append(this.rowBuilder);
    }

    public JournalPrinter setAppender(Appender appender) {
        this.appender = appender;
        return this;
    }

    public JournalPrinter setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public JournalPrinter types(Class ... clazz) {
        this.typeTemplate = clazz;
        return this;
    }

    public Field v(int typeIndex) {
        Field field = new Field(typeIndex, this);
        this.ff.add(field);
        return field;
    }

    private void configure() {
        if (this.configured) {
            return;
        }
        try {
            int k = this.ff.size();
            for (int i1 = 0; i1 < k; ++i1) {
                Field f = this.ff.get(i1);
                if (f.name == null) {
                    f.fromType = this.getType(f.typeTemplateIndex);
                    f.offset = -1L;
                } else if (f.typeTemplateIndex == -1) {
                    for (int i = 0; i < this.typeTemplate.length; ++i) {
                        Class clazz = this.typeTemplate[i];
                        java.lang.reflect.Field[] declaredFields = clazz.getDeclaredFields();
                        for (int i2 = 0; i2 < declaredFields.length; ++i2) {
                            if (!f.name.equals(declaredFields[i2].getName())) continue;
                            f.fromType = declaredFields[i2].getType();
                            f.typeTemplateIndex = i;
                            break;
                        }
                        if (f.typeTemplateIndex != -1) break;
                    }
                    if (f.typeTemplateIndex == -1) {
                        throw new RuntimeException("No such field: " + f.name);
                    }
                    f.offset = Unsafe.getUnsafe().objectFieldOffset(this.getType(f.typeTemplateIndex).getDeclaredField(f.name));
                } else {
                    Class t = this.getType(f.typeTemplateIndex);
                    f.fromType = t.getDeclaredField(f.name).getType();
                    f.offset = Unsafe.getUnsafe().objectFieldOffset(t.getDeclaredField(f.name));
                }
                this.setConverter(f);
            }
            this.configured = true;
        }
        catch (NoSuchFieldException e) {
            throw new JournalRuntimeException((Throwable)e);
        }
    }

    private Class getType(int typeIndex) {
        if (typeIndex < 0 || typeIndex >= this.typeTemplate.length) {
            throw new JournalRuntimeException("Invalid index: %d", new Object[]{typeIndex});
        }
        return this.typeTemplate[typeIndex];
    }

    private void setConverter(Field f) {
        if (f.converter == null) {
            if (f.offset == -1L) {
                f.converter = new ObjectToStringConverter(this);
            } else if (f.fromType == Integer.TYPE) {
                f.converter = new IntConverter();
            } else if (f.fromType == Long.TYPE) {
                f.converter = new LongConverter();
            } else if (f.fromType == Double.TYPE) {
                f.converter = new DoubleConverter();
            } else if (f.fromType == Boolean.TYPE) {
                f.converter = new BooleanConverter();
            } else if (f.fromType == Byte.TYPE) {
                f.converter = new ByteConverter();
            } else if (f.fromType == String.class) {
                f.converter = new StringConverter(this);
            } else if (f.fromType == Short.TYPE) {
                f.converter = new ShortConverter();
            } else {
                throw new JournalRuntimeException("Unsupported type: " + f.fromType.getName(), new Object[0]);
            }
        }
    }

    public static class Field {
        private final JournalPrinter printer;
        private String header;
        private String name;
        private int typeTemplateIndex = -1;
        private long offset;
        private Class fromType;
        private Converter converter;

        public Field(String name, JournalPrinter printer) {
            this.name = name;
            this.printer = printer;
        }

        public Field(int typeTemplateIndex, JournalPrinter printer) {
            this.typeTemplateIndex = typeTemplateIndex;
            this.printer = printer;
        }

        public Field c(Converter converter) {
            this.converter = converter;
            return this;
        }

        public Field f(String name) {
            return this.printer.f(name);
        }

        public long getOffset() {
            return this.offset;
        }

        public Field h(String header) {
            this.header = header;
            return this;
        }

        public Field i(int instanceIndex) {
            this.typeTemplateIndex = instanceIndex;
            return this;
        }

        public Field v(int typeIndex) {
            return this.printer.v(typeIndex);
        }
    }
}

