/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.parser.sql.QueryError;
import com.questdb.std.Rnd;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ResamplingTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUp() throws Exception {
        JournalEntryWriter w;
        int i;
        int orderId;
        int tsIncrement;
        long timestamp2;
        String[] employees;
        Rnd rnd;
        int recordCount = 10000;
        int employeeCount = 10;
        try (JournalWriter orders = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orders").$int("orderId").$int("customerId").$int("productId").$str("employeeId").$date("orderDate").$int("quantity").$double("price").$float("rate").recordCountHint(recordCount).$());){
            rnd = new Rnd();
            employees = new String[employeeCount];
            for (int i2 = 0; i2 < employees.length; ++i2) {
                employees[i2] = rnd.nextString(9);
            }
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2014-05-04T10:30:00.000Z");
            int tsIncrement2 = 10000;
            int orderId2 = 0;
            for (int i3 = 0; i3 < recordCount; ++i3) {
                JournalEntryWriter w2 = orders.entryWriter();
                w2.putInt(0, ++orderId2);
                w2.putInt(1, rnd.nextPositiveInt() % 500);
                w2.putInt(2, rnd.nextPositiveInt() % 200);
                w2.putStr(3, (CharSequence)employees[rnd.nextPositiveInt() % employeeCount]);
                w2.putDate(4, timestamp += (long)tsIncrement2);
                w2.putInt(5, rnd.nextPositiveInt());
                w2.putDouble(6, rnd.nextDouble());
                w2.putFloat(7, rnd.nextFloat());
                w2.append();
            }
            orders.commit();
        }
        var3_3 = null;
        try (JournalWriter orders2 = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orders2").$int("orderId").$int("customerId").$int("productId").$str("employeeId").$date("orderDate").$int("quantity").$double("price").$float("rate").$date("basketDate").recordCountHint(recordCount).$());){
            rnd = new Rnd();
            employees = new String[employeeCount];
            for (int i4 = 0; i4 < employees.length; ++i4) {
                employees[i4] = rnd.nextString(9);
            }
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2014-05-04T10:30:00.000Z");
            timestamp2 = DateFormatUtils.parseDateTime((CharSequence)"2014-05-03T00:15:00.000Z");
            tsIncrement = 10000;
            orderId = 0;
            for (i = 0; i < recordCount; ++i) {
                w = orders2.entryWriter();
                w.putInt(0, ++orderId);
                w.putInt(1, rnd.nextPositiveInt() % 500);
                w.putInt(2, rnd.nextPositiveInt() % 200);
                w.putStr(3, (CharSequence)employees[rnd.nextPositiveInt() % employeeCount]);
                w.putDate(4, timestamp += (long)tsIncrement);
                w.putInt(5, rnd.nextPositiveInt());
                w.putDouble(6, rnd.nextDouble());
                w.putFloat(7, rnd.nextFloat());
                w.putDate(8, timestamp2 + (long)tsIncrement);
                w.append();
            }
            orders2.commit();
        }
        catch (Throwable rnd2) {
            var3_3 = rnd2;
            throw rnd2;
        }
        orders2 = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orders4").$int("orderId").$int("customerId").$int("productId").$sym("employeeId").$date("orderDate").$int("quantity").$double("price").$float("rate").$ts("basketDate").recordCountHint(recordCount).$());
        var3_3 = null;
        try {
            rnd = new Rnd();
            employees = new String[employeeCount];
            for (int i5 = 0; i5 < employees.length; ++i5) {
                employees[i5] = rnd.nextString(9);
            }
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2014-05-04T10:30:00.000Z");
            timestamp2 = DateFormatUtils.parseDateTime((CharSequence)"2014-05-03T00:15:00.000Z");
            tsIncrement = 10000;
            orderId = 0;
            for (i = 0; i < recordCount; ++i) {
                w = orders2.entryWriter();
                w.putInt(0, ++orderId);
                w.putInt(1, rnd.nextPositiveInt() % 500);
                w.putInt(2, rnd.nextPositiveInt() % 200);
                w.putSym(3, (CharSequence)employees[rnd.nextPositiveInt() % employeeCount]);
                w.putDate(4, timestamp += (long)tsIncrement);
                w.putInt(5, rnd.nextPositiveInt());
                w.putDouble(6, rnd.nextDouble());
                w.putFloat(7, rnd.nextFloat());
                w.putDate(8, timestamp2 + (long)tsIncrement);
                w.append();
            }
            orders2.commit();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (orders2 != null) {
                if (var3_3 != null) {
                    try {
                        orders2.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    orders2.close();
                }
            }
        }
        JournalWriter orders3 = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orders3").$int("orderId").$int("customerId").$int("productId").$str("employeeId").$int("quantity").$double("price").$float("rate").recordCountHint(recordCount).$());
        orders3.close();
    }

    @Test
    public void testResampling2() throws Exception {
        this.assertThat("2014-05-04T08:00:00.000Z\t-18.041874103485\n2014-05-04T16:00:00.000Z\t-12.148285354848\n2014-05-05T00:00:00.000Z\t-10.773253435499\n2014-05-05T08:00:00.000Z\t0.750778769143\n", "select orderDate, vwap(price, quantity) from orders timestamp (orderDate) sample by 8h");
    }

    @Test
    public void testResamplingAmbiguousTimestamp() throws Exception {
        try {
            this.assertThat("", "select orderDate, employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders2 sample by 1d");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)97L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testResamplingAutoTimestamp() throws Exception {
        this.assertThat("2014-05-04T00:00:00.000Z\tTGPGWFFYU\t-63.253453401381\t-63.253453401381\n2014-05-04T00:00:00.000Z\tDEYYQEHBH\t17.232482911526\t17.232482911526\n2014-05-04T00:00:00.000Z\tSRYRFBVTM\t-10.581027815832\t-10.581027815832\n2014-05-04T00:00:00.000Z\tGZSXUXIBB\t1.191841183028\t1.191841183028\n2014-05-04T00:00:00.000Z\tUEDRQQULO\t-25.284387331977\t-25.284387331977\n2014-05-04T00:00:00.000Z\tFOWLPDXYS\t-21.110275361914\t-21.110275361914\n2014-05-04T00:00:00.000Z\tFJGETJRSZ\t-12.327370360108\t-12.327370360108\n2014-05-04T00:00:00.000Z\tBEOUOJSHR\t3.586645530510\t3.586645530510\n2014-05-04T00:00:00.000Z\tYRXPEHNRX\t-10.131327938006\t-10.131327938006\n2014-05-04T00:00:00.000Z\tVTJWCPSWH\t-24.329569665466\t-24.329569665466\n2014-05-05T00:00:00.000Z\tDEYYQEHBH\t-30.963486961448\t-30.963486961448\n2014-05-05T00:00:00.000Z\tSRYRFBVTM\t13.422138958032\t13.422138958032\n2014-05-05T00:00:00.000Z\tVTJWCPSWH\t0.595780540587\t0.595780540587\n2014-05-05T00:00:00.000Z\tBEOUOJSHR\t-31.682205368795\t-31.682205368795\n2014-05-05T00:00:00.000Z\tFJGETJRSZ\t-31.906856870748\t-31.906856870748\n2014-05-05T00:00:00.000Z\tGZSXUXIBB\t7.870801180456\t7.870801180456\n2014-05-05T00:00:00.000Z\tFOWLPDXYS\t-11.860556414848\t-11.860556414848\n2014-05-05T00:00:00.000Z\tYRXPEHNRX\t-8.573401980346\t-8.573401980346\n2014-05-05T00:00:00.000Z\tUEDRQQULO\t16.987375521363\t16.987375521363\n2014-05-05T00:00:00.000Z\tTGPGWFFYU\t17.260132823173\t17.260132823173\n", "select orderDate, employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders timestamp (orderDate) sample by 1d");
    }

    @Test
    public void testResamplingAvg() throws Exception {
        this.assertThat("2014-05-04T00:00:00.000Z\tTGPGWFFYU\t-41.304426677644\t-41.304426677644\n2014-05-04T00:00:00.000Z\tDEYYQEHBH\t7.372452128965\t7.372452128965\n2014-05-04T00:00:00.000Z\tSRYRFBVTM\t-12.203630788820\t-12.203630788820\n2014-05-04T00:00:00.000Z\tGZSXUXIBB\t4.115922051504\t4.115922051504\n2014-05-04T00:00:00.000Z\tUEDRQQULO\t-24.365014628709\t-24.365014628709\n2014-05-04T00:00:00.000Z\tFOWLPDXYS\t-29.996629348333\t-29.996629348333\n2014-05-04T00:00:00.000Z\tFJGETJRSZ\t-4.318969422717\t-4.318969422717\n2014-05-04T00:00:00.000Z\tBEOUOJSHR\t7.502717136654\t7.502717136654\n2014-05-04T00:00:00.000Z\tYRXPEHNRX\t0.601852660663\t0.601852660663\n2014-05-04T00:00:00.000Z\tVTJWCPSWH\t-9.734968411374\t-9.734968411374\n2014-05-05T00:00:00.000Z\tDEYYQEHBH\t-16.135037390878\t-16.135037390878\n2014-05-05T00:00:00.000Z\tSRYRFBVTM\t14.227762047291\t14.227762047291\n2014-05-05T00:00:00.000Z\tVTJWCPSWH\t-21.138005372460\t-21.138005372460\n2014-05-05T00:00:00.000Z\tBEOUOJSHR\t-20.797434613016\t-20.797434613016\n2014-05-05T00:00:00.000Z\tFJGETJRSZ\t-5.417172028476\t-5.417172028476\n2014-05-05T00:00:00.000Z\tGZSXUXIBB\t3.389333554052\t3.389333554052\n2014-05-05T00:00:00.000Z\tFOWLPDXYS\t-21.249544800002\t-21.249544800002\n2014-05-05T00:00:00.000Z\tYRXPEHNRX\t-12.965791501497\t-12.965791501497\n2014-05-05T00:00:00.000Z\tUEDRQQULO\t12.717803509177\t12.717803509177\n2014-05-05T00:00:00.000Z\tTGPGWFFYU\t-4.258237623021\t-4.258237623021\n", "select orderDate, employeeId, sum(price)/count(), avg(price) sum from orders2 timestamp(orderDate) sample by 1d");
    }

    @Test
    public void testResamplingBySymbol() throws Exception {
        ResamplingTest.assertSymbol("select employeeId, vwap(price, quantity) sum from orders4 sample by 1d", 0);
    }

    @Test
    public void testResamplingExplicitTimestamp() throws Exception {
        this.assertThat("2014-05-04T00:00:00.000Z\tTGPGWFFYU\t-63.253453401381\t-63.253453401381\n2014-05-04T00:00:00.000Z\tDEYYQEHBH\t17.232482911526\t17.232482911526\n2014-05-04T00:00:00.000Z\tSRYRFBVTM\t-10.581027815832\t-10.581027815832\n2014-05-04T00:00:00.000Z\tGZSXUXIBB\t1.191841183028\t1.191841183028\n2014-05-04T00:00:00.000Z\tUEDRQQULO\t-25.284387331977\t-25.284387331977\n2014-05-04T00:00:00.000Z\tFOWLPDXYS\t-21.110275361914\t-21.110275361914\n2014-05-04T00:00:00.000Z\tFJGETJRSZ\t-12.327370360108\t-12.327370360108\n2014-05-04T00:00:00.000Z\tBEOUOJSHR\t3.586645530510\t3.586645530510\n2014-05-04T00:00:00.000Z\tYRXPEHNRX\t-10.131327938006\t-10.131327938006\n2014-05-04T00:00:00.000Z\tVTJWCPSWH\t-24.329569665466\t-24.329569665466\n2014-05-05T00:00:00.000Z\tDEYYQEHBH\t-30.963486961448\t-30.963486961448\n2014-05-05T00:00:00.000Z\tSRYRFBVTM\t13.422138958032\t13.422138958032\n2014-05-05T00:00:00.000Z\tVTJWCPSWH\t0.595780540587\t0.595780540587\n2014-05-05T00:00:00.000Z\tBEOUOJSHR\t-31.682205368795\t-31.682205368795\n2014-05-05T00:00:00.000Z\tFJGETJRSZ\t-31.906856870748\t-31.906856870748\n2014-05-05T00:00:00.000Z\tGZSXUXIBB\t7.870801180456\t7.870801180456\n2014-05-05T00:00:00.000Z\tFOWLPDXYS\t-11.860556414848\t-11.860556414848\n2014-05-05T00:00:00.000Z\tYRXPEHNRX\t-8.573401980346\t-8.573401980346\n2014-05-05T00:00:00.000Z\tUEDRQQULO\t16.987375521363\t16.987375521363\n2014-05-05T00:00:00.000Z\tTGPGWFFYU\t17.260132823173\t17.260132823173\n", "select orderDate, employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders2 timestamp(orderDate) sample by 1d");
    }

    @Test
    public void testResamplingExplicitTimestampAsFunc() {
        try {
            this.expectFailure("select orderDate, employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders2 timestamp(orderDate()) sample by 1d");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)124L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testResamplingNoTimestamp() throws Exception {
        try {
            this.assertThat("", "select employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders3 sample by 1d");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)86L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testResamplingVariance() throws Exception {
        this.assertThat("2014-05-04T00:00:00.000Z\tTGPGWFFYU\t-41.304426677644\t-41.304426677644\t172487.097492439040\n2014-05-04T00:00:00.000Z\tDEYYQEHBH\t7.372452128965\t7.372452128965\t148077.744860982304\n2014-05-04T00:00:00.000Z\tSRYRFBVTM\t-12.203630788820\t-12.203630788820\t152042.353099020448\n2014-05-04T00:00:00.000Z\tGZSXUXIBB\t4.115922051504\t4.115922051504\t170953.021239990592\n2014-05-04T00:00:00.000Z\tUEDRQQULO\t-24.365014628709\t-24.365014628709\t151426.976280038816\n2014-05-04T00:00:00.000Z\tFOWLPDXYS\t-29.996629348333\t-29.996629348333\t138923.565569592720\n2014-05-04T00:00:00.000Z\tFJGETJRSZ\t-4.318969422717\t-4.318969422717\t152689.615652833824\n2014-05-04T00:00:00.000Z\tBEOUOJSHR\t7.502717136654\t7.502717136654\t151309.114422499264\n2014-05-04T00:00:00.000Z\tYRXPEHNRX\t0.601852660663\t0.601852660663\t164631.084324245504\n2014-05-04T00:00:00.000Z\tVTJWCPSWH\t-9.734968411374\t-9.734968411374\t163121.713218006048\n2014-05-05T00:00:00.000Z\tDEYYQEHBH\t-16.135037390878\t-16.135037390878\t157609.841614984256\n2014-05-05T00:00:00.000Z\tSRYRFBVTM\t14.227762047291\t14.227762047291\t158581.383371555040\n2014-05-05T00:00:00.000Z\tVTJWCPSWH\t-21.138005372460\t-21.138005372460\t159404.705680565472\n2014-05-05T00:00:00.000Z\tBEOUOJSHR\t-20.797434613016\t-20.797434613016\t168784.531816107744\n2014-05-05T00:00:00.000Z\tFJGETJRSZ\t-5.417172028476\t-5.417172028476\t159768.386499879616\n2014-05-05T00:00:00.000Z\tGZSXUXIBB\t3.389333554052\t3.389333554052\t149853.540099657824\n2014-05-05T00:00:00.000Z\tFOWLPDXYS\t-21.249544800002\t-21.249544800002\t153228.686138200064\n2014-05-05T00:00:00.000Z\tYRXPEHNRX\t-12.965791501497\t-12.965791501497\t174696.469778044480\n2014-05-05T00:00:00.000Z\tUEDRQQULO\t12.717803509177\t12.717803509177\t167741.670910154976\n2014-05-05T00:00:00.000Z\tTGPGWFFYU\t-4.258237623021\t-4.258237623021\t159549.212283462016\n", "select orderDate, employeeId, sum(price)/count(), avg(price), var(price) sum from orders2 timestamp(orderDate) sample by 1d");
    }
}

