/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.QueryParser;
import com.questdb.parser.sql.model.AnalyticColumn;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.parser.sql.model.QueryColumn;
import com.questdb.parser.sql.model.QueryModel;
import com.questdb.std.Chars;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class QueryParserTest
extends AbstractTest {
    private final QueryParser parser = new QueryParser();

    @Test
    public void testAliasWithSpace() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"x 'b a' where x > 1");
        Assert.assertEquals((Object)"b a", (Object)statement.getAlias().token);
    }

    @Test
    public void testAliasWithSpace2() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"(x where a > 1) 'b a' where x > 1");
        Assert.assertEquals((Object)"b a", (Object)statement.getAlias().token);
    }

    @Test
    public void testAliasWithSpacex() {
        try {
            this.parser.parse((CharSequence)"from x 'a b' where x > 1");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)7L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testAliasedAnalyticColumn() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b order by ts) from xyz");
        Assert.assertEquals((long)3L, (long)statement.getColumns().size());
        AnalyticColumn col = (AnalyticColumn)statement.getColumns().get(2);
        Assert.assertEquals((Object)"my", (Object)col.getAlias());
        Assert.assertEquals((long)8L, (long)col.getAst().type);
        Assert.assertEquals((long)1L, (long)col.getPartitionBy().size());
        Assert.assertEquals((Object)"b", (Object)((ExprNode)col.getPartitionBy().get((int)0)).token);
        Assert.assertEquals((long)1L, (long)col.getOrderBy().size());
        Assert.assertEquals((Object)"ts", (Object)((ExprNode)col.getOrderBy().get((int)0)).token);
    }

    @Test
    public void testAnalyticOrderDirection() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b order by ts desc, x asc, y) from xyz");
        Assert.assertEquals((long)3L, (long)statement.getColumns().size());
        AnalyticColumn col = (AnalyticColumn)statement.getColumns().get(2);
        Assert.assertEquals((Object)"my", (Object)col.getAlias());
        Assert.assertEquals((long)8L, (long)col.getAst().type);
        Assert.assertEquals((long)1L, (long)col.getPartitionBy().size());
        Assert.assertEquals((Object)"b", (Object)((ExprNode)col.getPartitionBy().get((int)0)).token);
        Assert.assertEquals((long)3L, (long)col.getOrderBy().size());
        Assert.assertEquals((Object)"ts", (Object)((ExprNode)col.getOrderBy().get((int)0)).token);
        Assert.assertEquals((long)1L, (long)col.getOrderByDirection().get(0));
        Assert.assertEquals((Object)"x", (Object)((ExprNode)col.getOrderBy().get((int)1)).token);
        Assert.assertEquals((long)0L, (long)col.getOrderByDirection().get(1));
        Assert.assertEquals((Object)"y", (Object)((ExprNode)col.getOrderBy().get((int)2)).token);
        Assert.assertEquals((long)0L, (long)col.getOrderByDirection().get(2));
    }

    @Test
    public void testCrossJoin() {
        try {
            this.parser.parse((CharSequence)"select x from a a cross join b on b.x = a.x");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)31L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"cannot"));
        }
    }

    @Test
    public void testCrossJoin2() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from a a cross join b z");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"a", (Object)statement.getAlias().token);
        Assert.assertEquals((long)2L, (long)statement.getJoinModels().size());
        Assert.assertEquals((long)3L, (long)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinType());
        Assert.assertNull((Object)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinCriteria());
    }

    @Test
    public void testCrossJoin3() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from a a cross join b z join c on a.x = c.x");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"a", (Object)statement.getAlias().token);
        Assert.assertEquals((long)3L, (long)statement.getJoinModels().size());
        Assert.assertEquals((long)3L, (long)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinType());
        Assert.assertNull((Object)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinCriteria());
        Assert.assertEquals((long)1L, (long)((QueryModel)statement.getJoinModels().getQuick(2)).getJoinType());
        Assert.assertNotNull((Object)((QueryModel)statement.getJoinModels().getQuick(2)).getJoinCriteria());
    }

    @Test
    public void testCrossJoinNoAlias() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from a a cross join b join c on a.x = c.x");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"a", (Object)statement.getAlias().token);
        Assert.assertEquals((long)3L, (long)statement.getJoinModels().size());
        Assert.assertEquals((long)3L, (long)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinType());
        Assert.assertNull((Object)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinCriteria());
        Assert.assertEquals((long)1L, (long)((QueryModel)statement.getJoinModels().getQuick(2)).getJoinType());
        Assert.assertNotNull((Object)((QueryModel)statement.getJoinModels().getQuick(2)).getJoinCriteria());
    }

    @Test
    public void testEmptyGroupBy() {
        try {
            this.parser.parse((CharSequence)"select x, y from tab sample by");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)28L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testEmptyOrderBy() {
        try {
            this.parser.parse((CharSequence)"select x, y from tab order by");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)27L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"end of input"));
        }
    }

    @Test
    public void testExtraComma2OrderByInAnalyticFunction() {
        try {
            this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b order by ts,) from xyz");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)53L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testExtraCommaOrderByInAnalyticFunction() {
        try {
            this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b order by ,ts) from xyz");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)50L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testExtraCommaPartitionByInAnalyticFunction() {
        try {
            this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b, order by ts) from xyz");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)48L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testInnerJoin() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from a a inner join b on b.x = a.x");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"a", (Object)statement.getAlias().token);
        Assert.assertEquals((long)2L, (long)statement.getJoinModels().size());
        Assert.assertEquals((long)1L, (long)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinType());
        Assert.assertEquals((Object)"b.xa.x=", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(1)).getJoinCriteria()));
    }

    @Test
    public void testInvalidGroupBy1() {
        try {
            this.parser.parse((CharSequence)"select x, y from tab sample by x,");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)32L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Unexpected"));
        }
    }

    @Test
    public void testInvalidGroupBy2() {
        try {
            this.parser.parse((CharSequence)"select x, y from (tab sample by x,)");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)33L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testInvalidGroupBy3() {
        try {
            this.parser.parse((CharSequence)"select x, y from tab sample by x, order by y");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)32L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testInvalidInnerJoin1() {
        try {
            this.parser.parse((CharSequence)"select x from a a inner join b z");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)31L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"'on'"));
        }
    }

    @Test
    public void testInvalidInnerJoin2() {
        try {
            this.parser.parse((CharSequence)"select x from a a inner join b z on");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)33L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Expression"));
        }
    }

    @Test
    public void testInvalidOrderBy1() {
        try {
            this.parser.parse((CharSequence)"select x, y from tab order by x,");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)31L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"end of input"));
        }
    }

    @Test
    public void testInvalidOrderBy2() {
        try {
            this.parser.parse((CharSequence)"select x, y from (tab order by x,)");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)33L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Expression expected"));
        }
    }

    @Test
    public void testInvalidOuterJoin1() {
        try {
            this.parser.parse((CharSequence)"select x from a a outer join b z");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)31L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"'on'"));
        }
    }

    @Test
    public void testInvalidOuterJoin2() {
        try {
            this.parser.parse((CharSequence)"select x from a a outer join b z on");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)33L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Expression"));
        }
    }

    @Test
    public void testInvalidSubQuery() {
        try {
            this.parser.parse((CharSequence)"select x,y from (tab where x = 100) latest by x");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)36L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"latest"));
        }
    }

    @Test
    public void testJoin1() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x, y from (select x from tab t2 latest by x where x > 100) t1 join tab2 xx2 on tab2.x = t1.x join tab3 on xx2.x > tab3.b join (select x,y from tab4 latest by z where a > b) x4 on x4.x = t1.y where y > 0");
        Assert.assertEquals((Object)"t1", (Object)statement.getAlias().token);
        Assert.assertEquals((long)4L, (long)statement.getJoinModels().size());
        Assert.assertNotNull((Object)statement.getNestedModel());
        Assert.assertNull((Object)statement.getJournalName());
        Assert.assertEquals((Object)"y0>", (Object)TestUtils.toRpn(statement.getWhereClause()));
        Assert.assertEquals((Object)"tab", (Object)TestUtils.toRpn(statement.getNestedModel().getJournalName()));
        Assert.assertEquals((Object)"t2", (Object)statement.getNestedModel().getAlias().token);
        Assert.assertEquals((long)1L, (long)statement.getNestedModel().getJoinModels().size());
        Assert.assertEquals((Object)"xx2", (Object)((QueryModel)statement.getJoinModels().getQuick((int)1)).getAlias().token);
        Assert.assertNull((Object)((QueryModel)statement.getJoinModels().getQuick(2)).getAlias());
        Assert.assertEquals((Object)"x4", (Object)((QueryModel)statement.getJoinModels().getQuick((int)3)).getAlias().token);
        Assert.assertNotNull((Object)((QueryModel)statement.getJoinModels().getQuick(3)).getNestedModel());
        Assert.assertEquals((Object)"tab2", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(1)).getJournalName()));
        Assert.assertEquals((Object)"tab3", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(2)).getJournalName()));
        Assert.assertNull((Object)((QueryModel)statement.getJoinModels().getQuick(3)).getJournalName());
        Assert.assertEquals((Object)"tab2.xt1.x=", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(1)).getJoinCriteria()));
        Assert.assertEquals((Object)"xx2.xtab3.b>", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(2)).getJoinCriteria()));
        Assert.assertEquals((Object)"x4.xt1.y=", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(3)).getJoinCriteria()));
        Assert.assertEquals((Object)"ab>", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(3)).getNestedModel().getWhereClause()));
        Assert.assertEquals((Object)"z", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(3)).getNestedModel().getLatestBy()));
    }

    @Test
    public void testJoin2() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from ((tab join tab2 on tab.x=tab2.x) join tab3 on tab3.x = tab2.x)");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((long)1L, (long)statement.getJoinModels().size());
        Assert.assertNotNull((Object)statement.getNestedModel());
        Assert.assertEquals((long)2L, (long)statement.getNestedModel().getJoinModels().size());
        Assert.assertEquals((Object)"tab3", (Object)TestUtils.toRpn(((QueryModel)statement.getNestedModel().getJoinModels().getQuick(1)).getJournalName()));
        Assert.assertEquals((Object)"tab3.xtab2.x=", (Object)TestUtils.toRpn(((QueryModel)statement.getNestedModel().getJoinModels().getQuick(1)).getJoinCriteria()));
        Assert.assertEquals((long)0L, (long)statement.getNestedModel().getColumns().size());
        Assert.assertNotNull((Object)statement.getNestedModel().getNestedModel());
        Assert.assertEquals((Object)"tab", (Object)TestUtils.toRpn(statement.getNestedModel().getNestedModel().getJournalName()));
        Assert.assertEquals((long)2L, (long)statement.getNestedModel().getNestedModel().getJoinModels().size());
        Assert.assertEquals((Object)"tab2", (Object)TestUtils.toRpn(((QueryModel)statement.getNestedModel().getNestedModel().getJoinModels().getQuick(1)).getJournalName()));
        Assert.assertEquals((Object)"tab.xtab2.x=", (Object)TestUtils.toRpn(((QueryModel)statement.getNestedModel().getNestedModel().getJoinModels().getQuick(1)).getJoinCriteria()));
    }

    @Test
    public void testLexerReset() {
        for (int i = 0; i < 10; ++i) {
            try {
                this.parser.parse((CharSequence)"select \n-- ltod(Date)\ncount() \n-- from acc\nfrom acc(Date) sample by 1d\n-- where x = 10\n");
                Assert.fail();
                continue;
            }
            catch (ParserException e) {
                TestUtils.assertEquals((CharSequence)"Unexpected token: Date", QueryError.getMessage());
            }
        }
    }

    @Test
    public void testMissingWhere() {
        try {
            this.parser.parse((CharSequence)"select id, x + 10, x from tab id ~ 'HBRO'");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)33L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testMixedFieldsSubQuery() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x, y from (select z from tab t2 latest by x where x > 100) t1 where y > 0");
        Assert.assertNotNull((Object)statement);
        Assert.assertNotNull((Object)statement.getNestedModel());
        Assert.assertNull((Object)statement.getJournalName());
        Assert.assertEquals((Object)"t1", (Object)statement.getAlias().token);
        Assert.assertEquals((Object)"tab", (Object)TestUtils.toRpn(statement.getNestedModel().getJournalName()));
        Assert.assertEquals((Object)"t2", (Object)statement.getNestedModel().getAlias().token);
        Assert.assertEquals((Object)"x100>", (Object)TestUtils.toRpn(statement.getNestedModel().getWhereClause()));
        Assert.assertEquals((Object)"x", (Object)TestUtils.toRpn(statement.getNestedModel().getLatestBy()));
        Assert.assertEquals((long)2L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get((int)0)).getAst().token);
        Assert.assertEquals((Object)"y", (Object)((QueryColumn)statement.getColumns().get((int)1)).getAst().token);
        Assert.assertEquals((long)1L, (long)statement.getNestedModel().getColumns().size());
        Assert.assertEquals((Object)"z", (Object)((QueryColumn)statement.getNestedModel().getColumns().get((int)0)).getAst().token);
    }

    @Test
    public void testMostRecentWhereClause() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a+b*c x, sum(z)+25 ohoh from zyzy latest by x where a in (x,y) and b = 10");
        Assert.assertEquals((Object)"zyzy", (Object)statement.getJournalName().token);
        Assert.assertEquals((long)2L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"ohoh", (Object)((QueryColumn)statement.getColumns().get(1)).getAlias());
        Assert.assertEquals((Object)"axyinb10=and", (Object)TestUtils.toRpn(statement.getWhereClause()));
        Assert.assertEquals((Object)"x", (Object)TestUtils.toRpn(statement.getLatestBy()));
    }

    @Test
    public void testMultipleExpressions() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a+b*c x, sum(z)+25 ohoh from zyzy");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"zyzy", (Object)statement.getJournalName().token);
        Assert.assertEquals((long)2L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"ohoh", (Object)((QueryColumn)statement.getColumns().get(1)).getAlias());
    }

    @Test
    public void testOneAnalyticColumn() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a,b, f(c) over (partition by b order by ts) from xyz");
        Assert.assertEquals((long)3L, (long)statement.getColumns().size());
        AnalyticColumn col = (AnalyticColumn)statement.getColumns().get(2);
        Assert.assertEquals((long)8L, (long)col.getAst().type);
        Assert.assertEquals((long)1L, (long)col.getPartitionBy().size());
        Assert.assertEquals((Object)"b", (Object)((ExprNode)col.getPartitionBy().get((int)0)).token);
        Assert.assertEquals((long)1L, (long)col.getOrderBy().size());
        Assert.assertEquals((Object)"ts", (Object)((ExprNode)col.getOrderBy().get((int)0)).token);
    }

    @Test
    public void testOptionalSelect() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"tab t2 latest by x where x > 100");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"tab", (Object)TestUtils.toRpn(statement.getJournalName()));
        Assert.assertEquals((Object)"t2", (Object)statement.getAlias().token);
        Assert.assertEquals((Object)"x100>", (Object)TestUtils.toRpn(statement.getWhereClause()));
        Assert.assertEquals((long)0L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)TestUtils.toRpn(statement.getLatestBy()));
    }

    @Test
    public void testOrderBy1() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x,y from tab order by x,y,z");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((long)3L, (long)statement.getOrderBy().size());
        Assert.assertEquals((Object)"x", (Object)TestUtils.toRpn((ExprNode)statement.getOrderBy().getQuick(0)));
        Assert.assertEquals((Object)"y", (Object)TestUtils.toRpn((ExprNode)statement.getOrderBy().getQuick(1)));
        Assert.assertEquals((Object)"z", (Object)TestUtils.toRpn((ExprNode)statement.getOrderBy().getQuick(2)));
    }

    @Test
    public void testOrderByExpression() {
        try {
            this.parser.parse((CharSequence)"select x, y from tab order by x+y");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)31L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testOuterJoin() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from a a outer join b on b.x = a.x");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"a", (Object)statement.getAlias().token);
        Assert.assertEquals((long)2L, (long)statement.getJoinModels().size());
        Assert.assertEquals((long)2L, (long)((QueryModel)statement.getJoinModels().getQuick(1)).getJoinType());
        Assert.assertEquals((Object)"b.xa.x=", (Object)TestUtils.toRpn(((QueryModel)statement.getJoinModels().getQuick(1)).getJoinCriteria()));
    }

    @Test
    public void testSampleBy1() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x,y from tab sample by 2m");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"2m", (Object)statement.getSampleBy().token);
    }

    @Test
    public void testSelectPlainColumns() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a,b,c from t");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((Object)"t", (Object)statement.getJournalName().token);
        Assert.assertEquals((long)3L, (long)statement.getColumns().size());
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((long)4L, (long)((QueryColumn)statement.getColumns().get((int)i)).getAst().type);
        }
    }

    @Test
    public void testSelectSingleExpression() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a+b*c x from t");
        Assert.assertNotNull((Object)statement);
        Assert.assertEquals((long)1L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"+", (Object)((QueryColumn)statement.getColumns().get((int)0)).getAst().token);
        Assert.assertEquals((Object)"t", (Object)statement.getJournalName().token);
    }

    @Test
    public void testSimpleSubquery() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"(x) where x > 1");
        Assert.assertNotNull((Object)statement.getNestedModel());
        Assert.assertEquals((Object)"x", (Object)statement.getNestedModel().getJournalName().token);
    }

    @Test
    public void testSingleJournalLimit() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x x, y y from tab where x > z limit 100");
        Assert.assertEquals((Object)"tab", (Object)statement.getJournalName().token);
        Assert.assertEquals((long)2L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"y", (Object)((QueryColumn)statement.getColumns().get(1)).getAlias());
        Assert.assertEquals((Object)"xz>", (Object)TestUtils.toRpn(statement.getWhereClause()));
        Assert.assertEquals((Object)"100", (Object)TestUtils.toRpn(statement.getLimitLo()));
    }

    @Test
    public void testSingleJournalLimitLoHi() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x x, y y from tab where x > z limit 100,200");
        Assert.assertEquals((Object)"tab", (Object)statement.getJournalName().token);
        Assert.assertEquals((long)2L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"y", (Object)((QueryColumn)statement.getColumns().get(1)).getAlias());
        Assert.assertEquals((Object)"xz>", (Object)TestUtils.toRpn(statement.getWhereClause()));
        Assert.assertEquals((Object)"100", (Object)TestUtils.toRpn(statement.getLimitLo()));
        Assert.assertEquals((Object)"200", (Object)TestUtils.toRpn(statement.getLimitHi()));
    }

    @Test
    public void testSingleJournalLimitLoHiExtraToken() {
        try {
            this.parser.parse((CharSequence)"select x x, y y from tab where x > z limit 100,200 b");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)51L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testSingleJournalNoWhereLimit() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x x, y y from tab limit 100");
        Assert.assertEquals((Object)"tab", (Object)statement.getJournalName().token);
        Assert.assertEquals((long)2L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"y", (Object)((QueryColumn)statement.getColumns().get(1)).getAlias());
        Assert.assertEquals((Object)"100", (Object)TestUtils.toRpn(statement.getLimitLo()));
    }

    @Test
    public void testSubQuery() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x, y from (select x from tab t2 latest by x where x > 100) t1 where y > 0");
        Assert.assertNotNull((Object)statement);
        Assert.assertNotNull((Object)statement.getNestedModel());
        Assert.assertNull((Object)statement.getJournalName());
        Assert.assertEquals((Object)"t1", (Object)statement.getAlias().token);
        Assert.assertEquals((Object)"tab", (Object)TestUtils.toRpn(statement.getNestedModel().getJournalName()));
        Assert.assertEquals((Object)"t2", (Object)statement.getNestedModel().getAlias().token);
        Assert.assertEquals((Object)"x100>", (Object)TestUtils.toRpn(statement.getNestedModel().getWhereClause()));
        Assert.assertEquals((Object)"x", (Object)TestUtils.toRpn(statement.getNestedModel().getLatestBy()));
    }

    @Test
    public void testSubqueryLimitLoHi() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"(select x x, y y from tab where x > z limit 100,200) where x = y limit 150");
        Assert.assertEquals((Object)"tab", (Object)statement.getNestedModel().getJournalName().token);
        Assert.assertEquals((long)2L, (long)statement.getNestedModel().getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getNestedModel().getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"y", (Object)((QueryColumn)statement.getNestedModel().getColumns().get(1)).getAlias());
        Assert.assertEquals((Object)"xz>", (Object)TestUtils.toRpn(statement.getNestedModel().getWhereClause()));
        Assert.assertEquals((Object)"100", (Object)TestUtils.toRpn(statement.getNestedModel().getLimitLo()));
        Assert.assertEquals((Object)"200", (Object)TestUtils.toRpn(statement.getNestedModel().getLimitHi()));
        Assert.assertEquals((Object)"150", (Object)TestUtils.toRpn(statement.getLimitLo()));
        Assert.assertNull((Object)statement.getLimitHi());
    }

    @Test
    public void testTimestampOnJournal() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from a b timestamp(x) where x > y");
        Assert.assertEquals((Object)"x", (Object)statement.getTimestamp().token);
        Assert.assertEquals((Object)"b", (Object)statement.getAlias().token);
        Assert.assertNotNull((Object)statement.getWhereClause());
    }

    @Test
    public void testTimestampOnSubquery() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select x from (a b) timestamp(x) where x > y");
        Assert.assertEquals((Object)"x", (Object)statement.getTimestamp().token);
        Assert.assertNotNull((Object)statement.getNestedModel());
        Assert.assertNotNull((Object)statement.getWhereClause());
    }

    @Test
    public void testTooManyColumnsEdgeInOrderBy() throws Exception {
        StringBuilder b = new StringBuilder();
        b.append("x order by ");
        for (int i = 0; i < 1559; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append('f').append(i);
        }
        QueryModel st = (QueryModel)this.parser.parse((CharSequence)b);
        Assert.assertEquals((long)1559L, (long)st.getOrderBy().size());
    }

    @Test
    public void testTooManyColumnsInOrderBy() {
        StringBuilder b = new StringBuilder();
        b.append("x order by ");
        for (int i = 0; i < 1560; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append('f').append(i);
        }
        try {
            this.parser.parse((CharSequence)b);
        }
        catch (ParserException e) {
            TestUtils.assertEquals((CharSequence)"Too many columns", QueryError.getMessage());
        }
    }

    @Test
    public void testTwoAnalyticColumns() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b order by ts), d(c) over() from xyz");
        Assert.assertEquals((long)4L, (long)statement.getColumns().size());
        AnalyticColumn col = (AnalyticColumn)statement.getColumns().get(2);
        Assert.assertEquals((Object)"my", (Object)col.getAlias());
        Assert.assertEquals((long)8L, (long)col.getAst().type);
        Assert.assertEquals((long)1L, (long)col.getPartitionBy().size());
        Assert.assertEquals((Object)"b", (Object)((ExprNode)col.getPartitionBy().get((int)0)).token);
        Assert.assertEquals((long)1L, (long)col.getOrderBy().size());
        Assert.assertEquals((Object)"ts", (Object)((ExprNode)col.getOrderBy().get((int)0)).token);
        col = (AnalyticColumn)statement.getColumns().get(3);
        Assert.assertEquals((Object)"d", (Object)col.getAst().token);
        Assert.assertNull((Object)col.getAlias());
        Assert.assertEquals((long)0L, (long)col.getPartitionBy().size());
        Assert.assertEquals((long)0L, (long)col.getOrderBy().size());
    }

    @Test
    public void testUnbalancedBracketInSubQuery() {
        try {
            this.parser.parse((CharSequence)"select x from (tab where x > 10 t1");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)32L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"expected"));
        }
    }

    @Test
    public void testUnderTerminatedOver() {
        try {
            this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b order by ts from xyz");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)53L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testUnderTerminatedOver2() {
        try {
            this.parser.parse((CharSequence)"select a,b, f(c) my over (partition by b order by ts");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)50L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testUnexpectedTokenInAnalyticFunction() {
        try {
            this.parser.parse((CharSequence)"select a,b, f(c) my over (by b order by ts) from xyz");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)26L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testWhereClause() throws Exception {
        QueryModel statement = (QueryModel)this.parser.parse((CharSequence)"select a+b*c x, sum(z)+25 ohoh from zyzy where a in (x,y) and b = 10");
        Assert.assertEquals((Object)"zyzy", (Object)statement.getJournalName().token);
        Assert.assertEquals((long)2L, (long)statement.getColumns().size());
        Assert.assertEquals((Object)"x", (Object)((QueryColumn)statement.getColumns().get(0)).getAlias());
        Assert.assertEquals((Object)"ohoh", (Object)((QueryColumn)statement.getColumns().get(1)).getAlias());
        Assert.assertEquals((Object)"axyinb10=and", (Object)TestUtils.toRpn(statement.getWhereClause()));
    }
}

