/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.model.Quote;
import com.questdb.parser.sql.ExprAstBuilder;
import com.questdb.parser.sql.ExprListener;
import com.questdb.parser.sql.ExprParser;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.parser.sql.PostOrderTreeTraversalAlgo;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.QueryFilterAnalyser;
import com.questdb.parser.sql.RpnBuilder;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.parser.sql.model.IntrinsicModel;
import com.questdb.std.Chars;
import com.questdb.std.Lexer;
import com.questdb.std.LongList;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ObjectPool;
import com.questdb.store.JournalWriter;
import com.questdb.store.RecordMetadata;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryFilterAnalyserTest
extends AbstractTest {
    private final RpnBuilder rpn = new RpnBuilder();
    private final ObjectPool<ExprNode> exprNodeObjectPool = new ObjectPool((ObjectFactory)ExprNode.FACTORY, 128);
    private final Lexer lexer = new Lexer();
    private final ExprParser p = new ExprParser(this.exprNodeObjectPool);
    private final ExprAstBuilder ast = new ExprAstBuilder();
    private final QueryFilterAnalyser e = new QueryFilterAnalyser();
    private final PostOrderTreeTraversalAlgo traversalAlgo = new PostOrderTreeTraversalAlgo();
    private final PostOrderTreeTraversalAlgo.Visitor rpnBuilderVisitor = this.rpn::onNode;
    private JournalWriter<Quote> w;

    @Before
    public void setUp() throws Exception {
        this.w = this.getFactory().writer(Quote.class);
        this.exprNodeObjectPool.clear();
        ExprParser.configureLexer((Lexer)this.lexer);
    }

    @Override
    @After
    public void tearDown() {
        this.w.close();
    }

    @Test
    public void testAndBranchWithNonIndexedField() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\") and bid > 100");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        this.assertFilter(m, "100bid>");
    }

    @Test
    public void testBadCountInInterval() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;10;z'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadDate() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.00z;30m'");
            Assert.fail();
        }
        catch (ParserException e1) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadDateInGreater() {
        try {
            this.modelOf("'2014-0x-01T12:30:00.000Z' > timestamp");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)0L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadDateInGreater2() {
        try {
            this.modelOf("timestamp > '2014-0x-01T12:30:00.000Z'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadDateInInterval() {
        try {
            this.modelOf("timestamp = '2014-0x-01T12:30:00.000Z'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadDateInLess1() {
        try {
            this.modelOf("timestamp < '2014-0x-01T12:30:00.000Z'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadDateInLess2() {
        try {
            this.modelOf("'2014-0x-01T12:30:00.000Z' < timestamp");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)0L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadEndDate() {
        try {
            this.modelOf("timestamp in (\"2014-01-02T12:30:00.000Z\", \"2014-01Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Unknown date format"));
        }
    }

    @Test
    public void testBadOperators() {
        this.testBadOperator(">");
        this.testBadOperator(">=");
        this.testBadOperator("<");
        this.testBadOperator("<=");
        this.testBadOperator("=");
        this.testBadOperator("!=");
    }

    @Test
    public void testBadPeriodInInterval() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;x;5'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadPeriodInInterval2() {
        try {
            this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;10x;5'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadRangeInInterval() {
        try {
            this.modelOf("timestamp = '2014-03-01T12:30:00.000Z;x'");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testBadStartDate() {
        try {
            this.modelOf("timestamp in (\"2014-01Z\", \"2014-01-02T12:30:00.000Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Unknown date format"));
        }
    }

    @Test
    public void testComplexInterval1() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00;2d'");
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:00.000Z, hi=2015-02-25T10:00:59.999Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;7d'");
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-03-02T10:00:55.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval3() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;15s'");
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:01:10.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval4() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m'");
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:30:55.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testComplexInterval5() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m' and timestamp != '2015-02-23T10:10:00.000Z'");
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:09:59.999Z},Interval{lo=2015-02-23T10:10:00.001Z, hi=2015-02-23T10:30:55.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertEquals((Object)"IntrinsicModel{keyValues=[], keyColumn='null', filter=null}", (Object)m.toString());
    }

    @Test
    public void testConstVsLambda() throws Exception {
        IntrinsicModel m = this.modelOf("ex in (1,2) and sym in (`xyz`)");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((long)1L, (long)m.keyValues.size());
        Assert.assertEquals((Object)"xyz", (Object)m.keyValues.get(0));
        Assert.assertTrue((boolean)m.keyValuesIsLambda);
        Assert.assertNotNull((Object)m.filter);
        Assert.assertEquals((Object)"ex12in", (Object)TestUtils.toRpn(m.filter));
    }

    @Test
    public void testConstVsLambda2() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (1,2) and sym in (`xyz`)");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((long)1L, (long)m.keyValues.size());
        Assert.assertEquals((Object)"xyz", (Object)m.keyValues.get(0));
        Assert.assertTrue((boolean)m.keyValuesIsLambda);
        Assert.assertNotNull((Object)m.filter);
        Assert.assertEquals((Object)"sym12in", (Object)TestUtils.toRpn(m.filter));
    }

    @Test
    public void testContradictingNullSearch() throws Exception {
        IntrinsicModel m = this.modelOf("sym = null and sym != null and ex != 'blah'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
        this.assertFilter(m, "'blah'ex!=");
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testDubiousEquals() throws Exception {
        IntrinsicModel m = this.modelOf("sum(ts) = sum(ts)");
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testDubiousGreater() throws Exception {
        IntrinsicModel m = this.modelOf("ts > ts");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testDubiousLess() throws Exception {
        IntrinsicModel m = this.modelOf("ts < ts");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testDubiousNotEquals() throws Exception {
        IntrinsicModel m = this.modelOf("ts != ts");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testEqualsChoiceOfColumns() throws Exception {
        IntrinsicModel m = this.modelOf("sym = 'X' and ex = 'Y'");
        this.assertFilter(m, "'Y'ex=");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[X]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsChoiceOfColumns2() throws Exception {
        IntrinsicModel m = this.modelOf("ex = 'Y' and sym = 'X'");
        this.assertFilter(m, "'Y'ex=");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[X]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsIndexedSearach() throws Exception {
        IntrinsicModel m = this.modelOf("sym ='X' and bid > 100.05");
        this.assertFilter(m, "100.05bid>");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[X]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsInvalidColumn() {
        try {
            this.modelOf("sym = 'X' and x = 'Y'");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)14L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testEqualsNull() throws Exception {
        IntrinsicModel m = this.modelOf("sym = null");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[null]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym = 'y'");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((Object)"[y]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[12]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testEqualsOverlapWithIn2() throws Exception {
        IntrinsicModel m = this.modelOf("sym = 'y' and sym in ('x','y')");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((Object)"[y]", (Object)m.keyValues.toString());
    }

    @Test
    public void testEqualsZeroOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym = 'z'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testEqualsZeroOverlapWithIn2() throws Exception {
        IntrinsicModel m = this.modelOf("sym = 'z' and sym in ('x','y')");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testExactDate() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp < '2015-05-11T08:00:55.000Z'");
        Assert.assertEquals((Object)"[Interval{lo=2015-05-10T15:03:10.000Z, hi=2015-05-10T15:03:10.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testExactDateVsInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-11'");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testFilterAndInterval() throws Exception {
        IntrinsicModel m = this.modelOf("bid > 100 and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        this.assertFilter(m, "100bid>");
    }

    @Test
    public void testFilterMultipleKeysAndInterval() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (\"a\", \"b\", \"c\") and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[a,b,c]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[8,13,18]", (Object)m.keyValuePositions.toString());
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testFilterOnIndexedFieldAndInterval() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a') and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[a]", (Object)m.keyValues.toString());
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testFilterOrInterval() throws Exception {
        IntrinsicModel m = this.modelOf("bid > 100 or timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        Assert.assertNull((Object)m.intervals);
        this.assertFilter(m, "\"2014-01-02T12:30:00.000Z\"\"2014-01-01T12:30:00.000Z\"timestampin100bid>or");
    }

    @Test
    public void testInNull() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('X', null, 'Y')");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[X,null,Y]", (Object)m.keyValues.toString());
    }

    @Test
    public void testInVsEqualInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and timestamp = '2014-01-01'");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-01T23:59:59.999Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIndexedFieldTooFewArgs2() throws Exception {
        this.assertFilter(this.modelOf("sym in (x)"), "xsymin");
    }

    @Test
    public void testIndexedFieldTooFewArgs3() {
        try {
            this.modelOf("sym in ()");
            Assert.fail((String)"exception expected");
        }
        catch (ParserException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Too few arguments"));
        }
    }

    @Test
    public void testIntervalGreater1() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and timestamp > '2014-01-01T15:30:00.000Z'");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T15:30:00.001Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalGreater2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp > '2014-01-01T15:30:00.000Z' and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z')");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T15:30:00.001Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalGreaterOrEq1() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and timestamp >= '2014-01-01T15:30:00.000Z'");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T15:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalGreaterOrEq2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp >= '2014-01-01T15:30:00.000Z' and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z')");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T15:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalSourceDay() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;30m;2d;5'");
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:30:55.000Z},Interval{lo=2015-02-25T10:00:55.000Z, hi=2015-02-25T10:30:55.000Z},Interval{lo=2015-02-27T10:00:55.000Z, hi=2015-02-27T10:30:55.000Z},Interval{lo=2015-03-01T10:00:55.000Z, hi=2015-03-01T10:30:55.000Z},Interval{lo=2015-03-03T10:00:55.000Z, hi=2015-03-03T10:30:55.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalSourceHour() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;10m;3h;10'");
        String expected = "[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:10:55.000Z},Interval{lo=2015-02-23T13:00:55.000Z, hi=2015-02-23T13:10:55.000Z},Interval{lo=2015-02-23T16:00:55.000Z, hi=2015-02-23T16:10:55.000Z},Interval{lo=2015-02-23T19:00:55.000Z, hi=2015-02-23T19:10:55.000Z},Interval{lo=2015-02-23T22:00:55.000Z, hi=2015-02-23T22:10:55.000Z},Interval{lo=2015-02-24T01:00:55.000Z, hi=2015-02-24T01:10:55.000Z},Interval{lo=2015-02-24T04:00:55.000Z, hi=2015-02-24T04:10:55.000Z},Interval{lo=2015-02-24T07:00:55.000Z, hi=2015-02-24T07:10:55.000Z},Interval{lo=2015-02-24T10:00:55.000Z, hi=2015-02-24T10:10:55.000Z},Interval{lo=2015-02-24T13:00:55.000Z, hi=2015-02-24T13:10:55.000Z}]";
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:10:55.000Z},Interval{lo=2015-02-23T13:00:55.000Z, hi=2015-02-23T13:10:55.000Z},Interval{lo=2015-02-23T16:00:55.000Z, hi=2015-02-23T16:10:55.000Z},Interval{lo=2015-02-23T19:00:55.000Z, hi=2015-02-23T19:10:55.000Z},Interval{lo=2015-02-23T22:00:55.000Z, hi=2015-02-23T22:10:55.000Z},Interval{lo=2015-02-24T01:00:55.000Z, hi=2015-02-24T01:10:55.000Z},Interval{lo=2015-02-24T04:00:55.000Z, hi=2015-02-24T04:10:55.000Z},Interval{lo=2015-02-24T07:00:55.000Z, hi=2015-02-24T07:10:55.000Z},Interval{lo=2015-02-24T10:00:55.000Z, hi=2015-02-24T10:10:55.000Z},Interval{lo=2015-02-24T13:00:55.000Z, hi=2015-02-24T13:10:55.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalSourceMin() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;15s;15m;5'");
        String expected = "[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:01:10.000Z},Interval{lo=2015-02-23T10:15:55.000Z, hi=2015-02-23T10:16:10.000Z},Interval{lo=2015-02-23T10:30:55.000Z, hi=2015-02-23T10:31:10.000Z},Interval{lo=2015-02-23T10:45:55.000Z, hi=2015-02-23T10:46:10.000Z},Interval{lo=2015-02-23T11:00:55.000Z, hi=2015-02-23T11:01:10.000Z}]";
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:01:10.000Z},Interval{lo=2015-02-23T10:15:55.000Z, hi=2015-02-23T10:16:10.000Z},Interval{lo=2015-02-23T10:30:55.000Z, hi=2015-02-23T10:31:10.000Z},Interval{lo=2015-02-23T10:45:55.000Z, hi=2015-02-23T10:46:10.000Z},Interval{lo=2015-02-23T11:00:55.000Z, hi=2015-02-23T11:01:10.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalSourceMonth() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;2h;2M;3'");
        String expected = "[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T12:00:55.000Z},Interval{lo=2015-04-23T10:00:55.000Z, hi=2015-04-23T12:00:55.000Z},Interval{lo=2015-06-23T10:00:55.000Z, hi=2015-06-23T12:00:55.000Z}]";
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T12:00:55.000Z},Interval{lo=2015-04-23T10:00:55.000Z, hi=2015-04-23T12:00:55.000Z},Interval{lo=2015-06-23T10:00:55.000Z, hi=2015-06-23T12:00:55.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalSourceSec() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;5s;30s;5'");
        String expected = "[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:01:00.000Z},Interval{lo=2015-02-23T10:01:25.000Z, hi=2015-02-23T10:01:30.000Z},Interval{lo=2015-02-23T10:01:55.000Z, hi=2015-02-23T10:02:00.000Z},Interval{lo=2015-02-23T10:02:25.000Z, hi=2015-02-23T10:02:30.000Z},Interval{lo=2015-02-23T10:02:55.000Z, hi=2015-02-23T10:03:00.000Z}]";
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-23T10:01:00.000Z},Interval{lo=2015-02-23T10:01:25.000Z, hi=2015-02-23T10:01:30.000Z},Interval{lo=2015-02-23T10:01:55.000Z, hi=2015-02-23T10:02:00.000Z},Interval{lo=2015-02-23T10:02:25.000Z, hi=2015-02-23T10:02:30.000Z},Interval{lo=2015-02-23T10:02:55.000Z, hi=2015-02-23T10:03:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalSourceYear() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-02-23T10:00:55.000Z;1d;1y;5'");
        String expected = "[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-24T10:00:55.000Z},Interval{lo=2016-02-23T10:00:55.000Z, hi=2016-02-24T10:00:55.000Z},Interval{lo=2017-02-23T10:00:55.000Z, hi=2017-02-24T10:00:55.000Z},Interval{lo=2018-02-23T10:00:55.000Z, hi=2018-02-24T10:00:55.000Z},Interval{lo=2019-02-23T10:00:55.000Z, hi=2019-02-24T10:00:55.000Z}]";
        Assert.assertEquals((Object)"[Interval{lo=2015-02-23T10:00:55.000Z, hi=2015-02-24T10:00:55.000Z},Interval{lo=2016-02-23T10:00:55.000Z, hi=2016-02-24T10:00:55.000Z},Interval{lo=2017-02-23T10:00:55.000Z, hi=2017-02-24T10:00:55.000Z},Interval{lo=2018-02-23T10:00:55.000Z, hi=2018-02-24T10:00:55.000Z},Interval{lo=2019-02-23T10:00:55.000Z, hi=2019-02-24T10:00:55.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testIntervalTooFewArgs() {
        try {
            this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Too few arg"));
        }
    }

    @Test
    public void testIntervalTooFewArgs2() {
        try {
            this.modelOf("timestamp in ()");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Too few arg"));
        }
    }

    @Test
    public void testIntervalTooManyArgs() {
        try {
            this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\", \"2014-01-03T12:30:00.000Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Too many arg"));
        }
    }

    @Test
    public void testIntrinsicPickup() throws Exception {
        this.assertFilter(this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;4' and sym in ('A', 'B') or ex = 'D'"), "'D'ex='B''A'symin'2014-06-20T13:25:00.000Z;10m;2d;4'timestamp=andor");
        this.assertFilter(this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;4' or ex = 'D' and sym in ('A', 'B')"), "'D'ex='2014-06-20T13:25:00.000Z;10m;2d;4'timestamp=or");
    }

    @Test(expected=ParserException.class)
    public void testInvalidIntervalSource1() throws Exception {
        this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d'");
    }

    @Test(expected=ParserException.class)
    public void testInvalidIntervalSource2() throws Exception {
        this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;4;4'");
    }

    @Test
    public void testLambdaVsConst() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (`xyz`) and ex in (1,2)");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((long)1L, (long)m.keyValues.size());
        Assert.assertEquals((Object)"xyz", (Object)m.keyValues.get(0));
        Assert.assertTrue((boolean)m.keyValuesIsLambda);
        Assert.assertNotNull((Object)m.filter);
        Assert.assertEquals((Object)"ex12in", (Object)TestUtils.toRpn(m.filter));
    }

    @Test
    public void testListOfValuesNegativeOverlap() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and sym in ('c')");
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testListOfValuesOverlapWithNotClause() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and not (sym in ('c', 'd', 'e'))");
        Assert.assertEquals((Object)"[a,z]", (Object)m.keyValues.toString());
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
    }

    @Test
    public void testListOfValuesOverlapWithNotClause2() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and not (sym in ('a', 'd', 'e'))");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((Object)"[z]", (Object)m.keyValues.toString());
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
    }

    @Test
    public void testListOfValuesPositiveOverlap() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', 'z') and sym in ('z')");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        Assert.assertEquals((Object)"[z]", (Object)m.keyValues.toString());
    }

    @Test
    public void testListOfValuesPositiveOverlapQuoteIndifference() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and sym in ('a', \"z\") and sym in ('z')");
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        Assert.assertEquals((Object)"[z]", (Object)m.keyValues.toString());
    }

    @Test
    public void testLiteralInInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", c)");
        Assert.assertNull((Object)m.intervals);
        this.assertFilter(m, "c\"2014-01-01T12:30:00.000Z\"timestampin");
    }

    @Test
    public void testLiteralInListOfValues() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (\"a\", z) and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertNull((Object)m.keyColumn);
        this.assertFilter(m, "z\"a\"symin");
    }

    @Test
    public void testLiteralInListOfValuesInvalidColumn() {
        try {
            this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and x in ('a', z)");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)74L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testManualInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp >= '2014-01-01T15:30:00.000Z' and timestamp < '2014-01-02T12:30:00.000Z'");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T15:30:00.000Z, hi=2014-01-02T12:29:59.999Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testManualIntervalInverted() throws Exception {
        IntrinsicModel m = this.modelOf("'2014-01-02T12:30:00.000Z' > timestamp and '2014-01-01T15:30:00.000Z' <= timestamp ");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T15:30:00.000Z, hi=2014-01-02T12:29:59.999Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testMultipleAnds() throws Exception {
        IntrinsicModel m = this.modelOf("a > 10 and b > 20 and (c > 100 and d < 20 and bid = 30)");
        this.assertFilter(m, "30bid=20d<100c>andand20b>10a>andand");
    }

    @Test
    public void testNestedFunctionTest() throws Exception {
        IntrinsicModel m = this.modelOf("substr(parse(x, 1, 3), 2, 4)");
        Assert.assertNull((Object)m.intervals);
        this.assertFilter(m, "4231xparsesubstr");
    }

    @Test
    public void testNoIntrinsics() throws Exception {
        IntrinsicModel m = this.modelOf("a > 10 or b > 20");
        Assert.assertNull((Object)m.intervals);
        Assert.assertNull((Object)m.keyColumn);
        this.assertFilter(m, "20b>10a>or");
    }

    @Test
    public void testNonLiteralColumn() {
        try {
            this.modelOf("10 in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Column name expected"));
        }
    }

    @Test
    public void testNotEqualsDoesNotOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym != 'z' and ex != 'blah'");
        this.assertFilter(m, "'blah'ex!=");
        Assert.assertEquals((Object)"[x,y]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[8,12]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testNotEqualsOverlapWithIn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('x','y') and sym != 'y' and ex != 'blah'");
        this.assertFilter(m, "'blah'ex!=");
        Assert.assertEquals((Object)"[x]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[8]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testOr() throws Exception {
        IntrinsicModel m = this.modelOf("(sym = 'X' or sym = 'Y') and bid > 10");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        this.assertFilter(m, "10bid>'Y'sym='X'sym=orand");
    }

    @Test
    public void testOrNullSearch() throws Exception {
        IntrinsicModel m = this.modelOf("sym = null or sym != null and ex != 'blah'");
        Assert.assertEquals((long)0L, (long)m.intrinsicValue);
        this.assertFilter(m, "'blah'ex!=nullsym!=nullsym=orand");
        Assert.assertEquals((Object)"[]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[]", (Object)m.keyValuePositions.toString());
    }

    @Test
    public void testPreferredColumn() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a', 'b') and ex in ('c') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110", "ex");
        this.assertFilter(m, "110ask<100bid>'b''a'syminandand");
        Assert.assertEquals((Object)"ex", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[c]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testPreferredColumn2() throws Exception {
        IntrinsicModel m = this.modelOf("ex in ('c') and sym in ('a', 'b') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110", "ex");
        this.assertFilter(m, "110ask<100bid>'b''a'syminandand");
        Assert.assertEquals((Object)"ex", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[c]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testPreferredColumn3() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a', 'b') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110", "ex");
        this.assertFilter(m, "110ask<100bid>'b''a'syminandand");
        Assert.assertNull((Object)m.keyColumn);
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testSimpleInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\")");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testSimpleLambda() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (`xyz`)");
        Assert.assertEquals((Object)"xyz", (Object)m.keyValues.get(0));
        Assert.assertTrue((boolean)m.keyValuesIsLambda);
    }

    @Test
    public void testSingleQuoteInterval() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z')");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertNull((Object)m.filter);
    }

    @Test
    public void testThreeIntrinsics() throws Exception {
        IntrinsicModel m = this.modelOf("sym in ('a', 'b') and ex in ('c') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110");
        this.assertFilter(m, "110ask<100bid>'c'exinandand");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[a,b]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testThreeIntrinsics2() throws Exception {
        IntrinsicModel m = this.modelOf("ex in ('c') and sym in ('a', 'b') and timestamp in ('2014-01-01T12:30:00.000Z', '2014-01-02T12:30:00.000Z') and bid > 100 and ask < 110");
        this.assertFilter(m, "110ask<100bid>'c'exinandand");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((Object)"[a,b]", (Object)m.keyValues.toString());
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T12:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testTwoDiffColLambdas() throws Exception {
        IntrinsicModel m = this.modelOf("sym in (`xyz`) and ex in (`kkk`)");
        Assert.assertEquals((Object)"sym", (Object)m.keyColumn);
        Assert.assertEquals((long)1L, (long)m.keyValues.size());
        Assert.assertEquals((Object)"xyz", (Object)m.keyValues.get(0));
        Assert.assertTrue((boolean)m.keyValuesIsLambda);
        Assert.assertNotNull((Object)m.filter);
        Assert.assertEquals((long)65L, (long)m.filter.rhs.type);
    }

    @Test
    public void testTwoExactMatchDifferentDates() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-11T15:03:10.000Z' and timestamp = '2015-05-11'");
        Assert.assertEquals((Object)"[]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testTwoExactSameDates() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-10T15:03:10.000Z' and timestamp = '2015-05-11'");
        Assert.assertEquals((Object)"[]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
        Assert.assertNull((Object)m.filter);
        Assert.assertEquals((long)2L, (long)m.intrinsicValue);
    }

    @Test
    public void testTwoIntervalSources() throws Exception {
        IntrinsicModel m = this.modelOf("timestamp = '2014-06-20T13:25:00.000Z;10m;2d;5' and timestamp = '2015-06-20T13:25:00.000Z;10m;2d;5'");
        Assert.assertEquals((Object)"[]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testTwoIntervals() throws Exception {
        IntrinsicModel m = this.modelOf("bid > 100 and timestamp in (\"2014-01-01T12:30:00.000Z\", \"2014-01-02T12:30:00.000Z\") and timestamp in (\"2014-01-01T16:30:00.000Z\", \"2014-01-05T12:30:00.000Z\")");
        Assert.assertEquals((Object)"[Interval{lo=2014-01-01T16:30:00.000Z, hi=2014-01-02T12:30:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)m.intervals));
    }

    @Test
    public void testTwoSameColLambdas() {
        try {
            this.modelOf("sym in (`xyz`) and sym in (`kkk`)");
            Assert.fail((String)"exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)4L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Multiple lambda"));
        }
    }

    private void assertFilter(IntrinsicModel m, CharSequence expected) throws ParserException {
        Assert.assertNotNull((Object)m.filter);
        TestUtils.assertEquals(expected, this.toRpn(m.filter));
    }

    private IntrinsicModel modelOf(CharSequence seq) throws ParserException {
        return this.modelOf(seq, null);
    }

    private IntrinsicModel modelOf(CharSequence seq, String preferredColumn) throws ParserException {
        this.lexer.setContent(seq);
        this.p.parseExpr(this.lexer, (ExprListener)this.ast);
        return this.e.extract(column -> column, this.ast.poll(), (RecordMetadata)this.w.getMetadata(), preferredColumn, this.w.getMetadata().getTimestampIndex());
    }

    private void testBadOperator(String op) {
        try {
            this.modelOf("sum(ts) " + op);
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)8L, (long)QueryError.getPosition());
        }
        try {
            this.modelOf(op + " sum(ts)");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)0L, (long)QueryError.getPosition());
        }
    }

    private CharSequence toRpn(ExprNode node) throws ParserException {
        this.rpn.reset();
        this.traversalAlgo.traverse(node, this.rpnBuilderVisitor);
        return this.rpn.rpn();
    }
}

