/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import org.junit.Test;

public class QueryDateTest
extends AbstractOptimiserTest {
    @Test
    public void testName() throws Exception {
        this.createTab();
        this.assertThat("10000\n", "select count() from tab where w = NaN");
    }

    private void createTab() throws JournalException, NumericException {
        try (JournalWriter w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("tab").$str("id").$double("x").$double("y").$date("z").$date("w").$ts());){
            Rnd rnd = new Rnd();
            long t = DateFormatUtils.parseDateTime((CharSequence)"2015-03-12T00:00:00.000Z");
            long time1 = DateFormatUtils.parseDateTime((CharSequence)"2015-10-03T00:00:00.000Z");
            for (int i = 0; i < 10000; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putStr(0, rnd.nextChars(15));
                ew.putDouble(1, rnd.nextDouble());
                if (rnd.nextPositiveInt() % 10 == 0) {
                    ew.putNull(2);
                } else {
                    ew.putDouble(2, rnd.nextDouble());
                }
                if (rnd.nextPositiveInt() % 10 == 0) {
                    ew.putNull(3);
                } else {
                    ew.putDate(3, time1 + rnd.nextLong() % 5000000L);
                }
                ew.putDate(5, t += 10L);
                ew.append();
            }
            w.commit();
        }
    }
}

