/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.std.Rnd;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import org.junit.BeforeClass;
import org.junit.Test;

public class NullCountingTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUp() throws Exception {
        int recordCount = 10000;
        int productCount = 200;
        int employeeCount = 10;
        try (JournalWriter orders = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orders").$int("orderId").$int("customerId").$str("productId").$sym("employeeId").$ts("orderDate").$int("quantity").$double("price").$float("rate").$long("x").recordCountHint(recordCount).$());){
            Rnd rnd = new Rnd();
            String[] employees = new String[employeeCount];
            for (int i = 0; i < employees.length; ++i) {
                employees[i] = rnd.nextPositiveInt() % 10 == 0 ? null : rnd.nextString(9);
            }
            String[] productId = new String[productCount];
            for (int i = 0; i < productId.length; ++i) {
                productId[i] = rnd.nextPositiveInt() % 30 == 0 ? null : rnd.nextString(9);
            }
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2014-05-04T10:30:00.000Z");
            int tsIncrement = 10000;
            int orderId = 0;
            for (int i = 0; i < recordCount; ++i) {
                JournalEntryWriter w = orders.entryWriter();
                w.putInt(0, ++orderId);
                w.putInt(1, rnd.nextPositiveInt() % 500);
                w.putStr(2, (CharSequence)productId[rnd.nextPositiveInt() % productCount]);
                w.putSym(3, (CharSequence)employees[rnd.nextPositiveInt() % employeeCount]);
                w.putDate(4, timestamp += (long)tsIncrement);
                w.putInt(5, rnd.nextPositiveInt() % 10 == 0 ? Integer.MIN_VALUE : rnd.nextPositiveInt());
                w.putDouble(6, rnd.nextPositiveInt() % 10 == 0 ? Double.NaN : rnd.nextDouble());
                w.putFloat(7, rnd.nextPositiveInt() % 10 == 0 ? Float.NaN : rnd.nextFloat());
                w.putLong(8, rnd.nextPositiveInt() % 10 == 0 ? Long.MIN_VALUE : rnd.nextLong());
                w.append();
            }
            orders.commit();
        }
    }

    @Test
    public void testCountDouble() throws Exception {
        this.assertThat("customerId\tcol0\tc\n437\t24\t2\n", "select customerId, count(), count() - count(price) c from orders where customerId = 437", true);
    }

    @Test
    public void testCountFloat() throws Exception {
        this.assertThat("customerId\tcol0\tc\n437\t24\t5\n", "select customerId, count(), count() - count(rate) c from orders where customerId = 437", true);
    }

    @Test
    public void testCountInt() throws Exception {
        this.assertThat("customerId\tcol0\tc\n437\t24\t4\n", "select customerId, count(), count() - count(quantity) c from orders where customerId = 437", true);
    }

    @Test
    public void testCountLong() throws Exception {
        this.assertThat("customerId\tcol0\tc\n437\t24\t3\n", "select customerId, count(), count() - count(x) c from orders where customerId = 437", true);
    }

    @Test
    public void testCountStr() throws Exception {
        this.assertThat("customerId\tcol0\tc\n437\t24\t1\n", "select customerId, count(), count() - count(productId) c from orders where customerId = 437", true);
    }

    @Test
    public void testCountSym() throws Exception {
        this.assertThat("customerId\tcol0\tc\n437\t24\t3\n", "select customerId, count(), count() - count(employeeId) c from orders where customerId = 437", true);
    }

    @Test
    public void testStrConcat() throws Exception {
        this.assertThat("customerId\tcol0\n437\tx-\n", "select customerId, 'x'+productId+'-' from orders where customerId = 437 and productId = null", true);
    }

    @Test
    public void testStrNotEqSym() throws Exception {
        this.assertThat("col0\n6327\n", "select count() from orders where productId != null and employeeId != null and quantity != NaN and price != NaN and x != NaN and productId != 'FCLTJCKFM' and quantity != 12570116270 and x != 2454524639747643470", true);
    }
}

