/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.std.NumericException;
import com.questdb.std.ObjHashSet;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import org.junit.BeforeClass;
import org.junit.Test;

public class NullAggregationTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUp() throws Exception {
        NullAggregationTest.createTabWithNaNs2();
    }

    @Test
    public void testNanCount() throws Exception {
        this.assertThat("NaN\tVEZDYHDHRFEVHKK\t5\nNaN\t\t99\n", "(select z, a, count() from tab) where z = NaN and (a ~ 'VE' or a = null)");
    }

    @Test
    public void testNullStringCount() throws Exception {
        this.assertThat("\t321\t4\n", "(select a, z, count() from tab) where z = 321 and a = null");
    }

    private static void createTabWithNaNs2() throws JournalException, NumericException {
        try (JournalWriter w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("tab").$str("id").$double("x").$double("y").$long("z").$int("w").$str("a").$ts());){
            Rnd rnd = new Rnd();
            int n = 128;
            ObjHashSet<String> names = NullAggregationTest.getNames(rnd, n);
            int mask = n - 1;
            long t = DateFormatUtils.parseDateTime((CharSequence)"2015-03-12T00:00:00.000Z");
            for (int i = 0; i < 10000; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putStr(0, (CharSequence)names.get(rnd.nextInt() & mask));
                ew.putDouble(1, rnd.nextDouble());
                if (rnd.nextPositiveInt() % 10 == 0) {
                    ew.putNull(2);
                } else {
                    ew.putDouble(2, rnd.nextDouble());
                }
                if (rnd.nextPositiveInt() % 10 == 0) {
                    ew.putNull(3);
                } else {
                    ew.putLong(3, rnd.nextLong() % 500L);
                }
                if (rnd.nextPositiveInt() % 10 == 0) {
                    ew.putNull(4);
                } else {
                    ew.putInt(4, rnd.nextInt() % 500);
                }
                if (rnd.nextPositiveInt() % 10 == 0) {
                    ew.putNull(5);
                } else {
                    ew.putStr(5, (CharSequence)names.get(rnd.nextInt() & mask));
                }
                ew.putDate(6, t += 3600000L);
                ew.append();
            }
            w.commit();
        }
    }

    private static ObjHashSet<String> getNames(Rnd r, int n) {
        ObjHashSet names = new ObjHashSet();
        for (int i = 0; i < n; ++i) {
            names.add((Object)r.nextString(15));
        }
        return names;
    }
}

