/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.parser.sql.QueryError;
import com.questdb.ql.NoRowIdRecordSource;
import com.questdb.ql.RecordSource;
import com.questdb.ql.join.HashJoinRecordSource;
import com.questdb.ql.map.RecordKeyCopierCompiler;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.Chars;
import com.questdb.std.IntHashSet;
import com.questdb.std.IntList;
import com.questdb.std.NumericException;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.MMappedSymbolTable;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.TestUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class JoinQueryTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUpClass() throws Exception {
        FACTORY_CONTAINER.getConfiguration().exists((CharSequence)"");
        JoinQueryTest.generateJoinData();
    }

    @Override
    @After
    public void tearDown() {
        Assert.assertEquals((long)0L, (long)FACTORY_CONTAINER.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)FACTORY_CONTAINER.getFactory().getBusyWriterCount());
    }

    @Test
    public void testAggregationSymbolBehaviour() throws Exception {
        JoinQueryTest.assertSymbol("select country, max(customerId) from customers", 0);
    }

    @Test
    public void testAllOrdersForACustomers() throws Exception {
        this.assertThat("32209860\t1\t1000\tMZPFIR\t2015-07-10T00:00:17.050Z\tOJXJCNBLYTOIYI\n1020826110\t1\t1884\tGRG\t2015-07-10T00:00:21.152Z\tQXOLEEXZ\n1921430865\t1\t1682\tXV\t2015-07-10T00:00:27.676Z\tMZCMZMHGTIQ\n355660772\t1\t1766\tOFN\t2015-07-10T00:00:33.004Z\tW\n1078912382\t1\t1296\tYBHPRQD\t2015-07-10T00:00:54.661Z\tYJZPHQDJKOM\n1173798559\t1\t387\t\t2015-07-10T00:01:00.700Z\tKZRCKS\n132190528\t1\t1088\t\t2015-07-10T00:01:07.110Z\tFBLGGTZEN\n385427654\t1\t1703\tXEMP\t2015-07-10T00:01:33.250Z\tMZCMZMHGTIQ\n", "orders where customerId = 1 ");
    }

    @Test
    public void testAmbiguousColumn() {
        try {
            this.assertPlan2("", "orders join customers on customerId = customerId");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)25L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Ambiguous"));
        }
    }

    @Test
    public void testAsOfJoinOrder() throws Exception {
        this.assertPlan2("{\n  \"op\": \"HashJoinRecordSource\",\n  \"master\": {\n    \"op\": \"AsOfPartitionedJoinRecordSource\",\n    \"master\": {\n      \"op\": \"JournalRecordSource\",\n      \"psrc\": {\n        \"op\": \"JournalPartitionSource\",\n        \"journal\": \"customers\"\n      },\n      \"rsrc\": {\n        \"op\": \"AllRowSource\"\n      }\n    },\n    \"slave\": {\n      \"op\": \"JournalRecordSource\",\n      \"psrc\": {\n        \"op\": \"JournalPartitionSource\",\n        \"journal\": \"employees\"\n      },\n      \"rsrc\": {\n        \"op\": \"AllRowSource\"\n      }\n    },\n    \"masterTsIndex\": 7,\n    \"slaveTsIndex\": 4\n  },\n  \"slave\": {\n    \"op\": \"JournalRecordSource\",\n    \"psrc\": {\n      \"op\": \"JournalPartitionSource\",\n      \"journal\": \"orders\"\n    },\n    \"rsrc\": {\n      \"op\": \"AllRowSource\"\n    }\n  },\n  \"joinOn\": [\n    [\n      \"customerId\"\n    ],\n    [\n      \"customerId\"\n    ]\n  ]\n}", "customers c asof join employees e on c.customerId = e.employeeId join orders o on c.customerId = o.customerId");
    }

    @Test
    public void testAsOfJoinSubQuery() throws Exception {
        this.assertPlan2("{\n  \"op\": \"HashJoinRecordSource\",\n  \"master\": {\n    \"op\": \"FilteredRecordSource\",\n    \"src\": {\n      \"op\": \"AsOfPartitionedJoinRecordSource\",\n      \"master\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"customers\"\n        },\n        \"rsrc\": {\n          \"op\": \"AllRowSource\"\n        }\n      },\n      \"slave\": {\n        \"op\": \"RBTreeSortedRecordSource\",\n        \"byRowId\": true,\n        \"src\": {\n          \"op\": \"SelectedColumnsRecordSource\",\n          \"src\": {\n            \"op\": \"VirtualColumnRecordSource\",\n            \"src\": {\n              \"op\": \"JournalRecordSource\",\n              \"psrc\": {\n                \"op\": \"JournalPartitionSource\",\n                \"journal\": \"employees\"\n              },\n              \"rsrc\": {\n                \"op\": \"FilteredRowSource\",\n                \"rsrc\": {\n                  \"op\": \"AllRowSource\"\n                }\n              }\n            }\n          }\n        }\n      },\n      \"masterTsIndex\": 7,\n      \"slaveTsIndex\": 3\n    },\n    \"filter\": \"e.blah \\u003d \\u0027y\\u0027\"\n  },\n  \"slave\": {\n    \"op\": \"JournalRecordSource\",\n    \"psrc\": {\n      \"op\": \"JournalPartitionSource\",\n      \"journal\": \"orders\"\n    },\n    \"rsrc\": {\n      \"op\": \"AllRowSource\"\n    }\n  },\n  \"joinOn\": [\n    [\n      \"customerId\"\n    ],\n    [\n      \"customerId\"\n    ]\n  ]\n}", "customers c asof join (select '1' blah, lastName, employeeId, timestamp from employees order by lastName) e on c.customerId = e.employeeId join orders o on c.customerId = o.customerId where e.lastName = 'x' and e.blah = 'y'");
    }

    @Test
    public void testAsOfJoinSubQuerySimpleAlias() throws Exception {
        this.assertPlan2("{\n  \"op\": \"AsOfPartitionedJoinRecordSource\",\n  \"master\": {\n    \"op\": \"JournalRecordSource\",\n    \"psrc\": {\n      \"op\": \"JournalPartitionSource\",\n      \"journal\": \"customers\"\n    },\n    \"rsrc\": {\n      \"op\": \"AllRowSource\"\n    }\n  },\n  \"slave\": {\n    \"op\": \"RBTreeSortedRecordSource\",\n    \"byRowId\": true,\n    \"src\": {\n      \"op\": \"SelectedColumnsRecordSource\",\n      \"src\": {\n        \"op\": \"VirtualColumnRecordSource\",\n        \"src\": {\n          \"op\": \"JournalRecordSource\",\n          \"psrc\": {\n            \"op\": \"JournalPartitionSource\",\n            \"journal\": \"employees\"\n          },\n          \"rsrc\": {\n            \"op\": \"AllRowSource\"\n          }\n        }\n      }\n    }\n  },\n  \"masterTsIndex\": 7,\n  \"slaveTsIndex\": 3\n}", "customers c asof join (select '1' blah, lastName, employeeId customerId, timestamp from employees order by lastName) a on (customerId)");
    }

    @Test
    public void testAsOfJoinSubQuerySimpleNoAlias() throws Exception {
        this.assertPlan2("{\n  \"op\": \"AsOfPartitionedJoinRecordSource\",\n  \"master\": {\n    \"op\": \"JournalRecordSource\",\n    \"psrc\": {\n      \"op\": \"JournalPartitionSource\",\n      \"journal\": \"customers\"\n    },\n    \"rsrc\": {\n      \"op\": \"AllRowSource\"\n    }\n  },\n  \"slave\": {\n    \"op\": \"RBTreeSortedRecordSource\",\n    \"byRowId\": true,\n    \"src\": {\n      \"op\": \"SelectedColumnsRecordSource\",\n      \"src\": {\n        \"op\": \"VirtualColumnRecordSource\",\n        \"src\": {\n          \"op\": \"JournalRecordSource\",\n          \"psrc\": {\n            \"op\": \"JournalPartitionSource\",\n            \"journal\": \"employees\"\n          },\n          \"rsrc\": {\n            \"op\": \"AllRowSource\"\n          }\n        }\n      }\n    }\n  },\n  \"masterTsIndex\": 7,\n  \"slaveTsIndex\": 3\n}", "customers c asof join (select '1' blah, lastName, employeeId customerId, timestamp from employees order by lastName) on (customerId)");
    }

    @Test
    public void testAsOfJoinSymbolBehaviour() throws Exception {
        JoinQueryTest.assertSymbol("select c.customerId, country from customers c asof join employees e on c.customerId = e.employeeId join orders o on c.customerId = o.customerId", 1);
    }

    @Test
    public void testCount() throws Exception {
        this.assertThat("162\t1\n209\t1\n233\t1\n381\t1\n396\t1\n410\t1\n805\t1\n810\t1\n1162\t1\n1344\t1\n1406\t1\n1414\t1\n1422\t1\n1523\t1\n1567\t1\n1589\t1\n1689\t1\n1734\t1\n1913\t1\n2172\t1\n2312\t1\n2378\t1\n2385\t1\n2990\t1\n3036\t1\n3171\t1\n3213\t1\n3222\t1\n3226\t1\n3270\t1\n3383\t1\n3476\t1\n3478\t1\n3502\t1\n3589\t1\n3663\t1\n3703\t1\n3751\t1\n3891\t1\n3935\t1\n4041\t1\n4059\t1\n4132\t1\n4412\t1\n4432\t1\n4745\t1\n4839\t1\n4934\t1\n4963\t1\n4981\t1\n5207\t1\n5288\t1\n5387\t1\n5445\t1\n5653\t1\n5684\t1\n5956\t1\n6006\t1\n6039\t1\n6122\t1\n6468\t1\n6486\t1\n6678\t1\n6691\t1\n6728\t1\n6826\t1\n6926\t1\n7021\t1\n7053\t1\n7056\t1\n7122\t1\n7175\t1\n7262\t1\n7347\t1\n7473\t1\n7478\t1\n7497\t1\n7513\t1\n7644\t1\n7737\t1\n7911\t1\n7961\t1\n7968\t1\n7976\t1\n8074\t1\n8113\t1\n8121\t1\n8130\t1\n8199\t1\n8284\t1\n8320\t1\n8379\t1\n8532\t1\n8549\t1\n8567\t1\n8821\t1\n9021\t1\n9180\t1\n9752\t1\n9754\t1\n9782\t1\n9977\t1\n9992\t1\n", "select c.customerId, count() from customers c outer join orders o on c.customerId = o.customerId  where o.customerId = NaN");
    }

    @Test
    public void testDuplicateAlias() {
        try {
            this.assertPlan2("", "customers a cross join orders a");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)30L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Duplicate"));
        }
    }

    @Test
    public void testDuplicateJournals() throws Exception {
        this.assertPlan2("{\n  \"op\": \"CrossJoinRecordSource\",\n  \"master\": {\n    \"op\": \"JournalRecordSource\",\n    \"psrc\": {\n      \"op\": \"JournalPartitionSource\",\n      \"journal\": \"customers\"\n    },\n    \"rsrc\": {\n      \"op\": \"AllRowSource\"\n    }\n  },\n  \"slave\": {\n    \"op\": \"JournalRecordSource\",\n    \"psrc\": {\n      \"op\": \"JournalPartitionSource\",\n      \"journal\": \"customers\"\n    },\n    \"rsrc\": {\n      \"op\": \"AllRowSource\"\n    }\n  }\n}", "customers cross join customers");
    }

    @Test
    public void testEqualsConstantTransitivityLhs() throws Exception {
        this.assertPlan("+ 0[ cross ] c (filter: 100 = c.customerId)\n+ 1[ outer ] o (filter: o.customerId = 100) ON o.customerId = c.customerId\n\n", "customers c outer join orders o on c.customerId = o.customerId where 100 = c.customerId");
    }

    @Test
    public void testEqualsConstantTransitivityRhs() throws Exception {
        this.assertPlan("+ 0[ cross ] c (filter: c.customerId = 100)\n+ 1[ outer ] o (filter: o.customerId = 100) ON o.customerId = c.customerId\n\n", "customers c outer join orders o on c.customerId = o.customerId where c.customerId = 100");
    }

    @Test
    public void testExceptionOnIntLatestByWithoutFilter() throws Exception {
        try {
            this.assertThat("", "orders latest by customerId");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)17L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Only SYM columns"));
        }
    }

    @Test
    public void testFilterOnSubquery() throws Exception {
        this.assertEmpty("(select customerId, customerName, count() count from customers) c outer join orders o on c.customerId = o.customerId  where o.orderId = NaN and c.customerId > 400 and c.customerId < 1200 and count > 1 order by c.customerId");
    }

    @Test
    public void testGenericPreFilterPlacement() throws Exception {
        this.assertPlan("+ 0[ cross ] customers (filter: customerName ~ 'WTBHZVPVZZ')\n+ 1[ inner ] orders ON orders.customerId = customers.customerId\n\n", "select customerName, orderId, productId from customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ'");
    }

    @Test
    public void testInnerJoin() throws Exception {
        String expected = "customerId\tcustomerName\tcontactName\taddress\tcity\tpostalCode\tcountry\ttimestamp\torderId\tcustomerId\tproductId\temployeeId\torderDate\tshipper\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1605271283\t9619\t486\t\t2015-07-10T00:00:29.443Z\tYM\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t401073894\t9619\t1645\tDND\t2015-07-10T00:00:31.115Z\tFNMURHFGESODNWN\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t921021073\t9619\t1860\tSR\t2015-07-10T00:00:41.263Z\tOJXJCNBLYTOIYI\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1986641415\t9619\t935\tUFUC\t2015-07-10T00:00:50.470Z\tFREQGOPJK\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1635896684\t9619\t228\tRQLVWE\t2015-07-10T00:00:51.036Z\tMZCMZMHGTIQ\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t189633559\t9619\t830\tRQMR\t2015-07-10T00:01:20.166Z\tQPL\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t960875992\t9619\t960\t\t2015-07-10T00:01:29.735Z\tYJZPHQDJKOM\n";
        this.assertThat("customerId\tcustomerName\tcontactName\taddress\tcity\tpostalCode\tcountry\ttimestamp\torderId\tcustomerId\tproductId\temployeeId\torderDate\tshipper\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1605271283\t9619\t486\t\t2015-07-10T00:00:29.443Z\tYM\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t401073894\t9619\t1645\tDND\t2015-07-10T00:00:31.115Z\tFNMURHFGESODNWN\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t921021073\t9619\t1860\tSR\t2015-07-10T00:00:41.263Z\tOJXJCNBLYTOIYI\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1986641415\t9619\t935\tUFUC\t2015-07-10T00:00:50.470Z\tFREQGOPJK\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1635896684\t9619\t228\tRQLVWE\t2015-07-10T00:00:51.036Z\tMZCMZMHGTIQ\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t189633559\t9619\t830\tRQMR\t2015-07-10T00:01:20.166Z\tQPL\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t960875992\t9619\t960\t\t2015-07-10T00:01:29.735Z\tYJZPHQDJKOM\n", "customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ'", true);
    }

    @Test
    public void testInnerJoinEqualsConstant() throws Exception {
        String expected = "9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1605271283\t9619\t486\t\t2015-07-10T00:00:29.443Z\tYM\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t401073894\t9619\t1645\tDND\t2015-07-10T00:00:31.115Z\tFNMURHFGESODNWN\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t921021073\t9619\t1860\tSR\t2015-07-10T00:00:41.263Z\tOJXJCNBLYTOIYI\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1986641415\t9619\t935\tUFUC\t2015-07-10T00:00:50.470Z\tFREQGOPJK\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1635896684\t9619\t228\tRQLVWE\t2015-07-10T00:00:51.036Z\tMZCMZMHGTIQ\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t189633559\t9619\t830\tRQMR\t2015-07-10T00:01:20.166Z\tQPL\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t960875992\t9619\t960\t\t2015-07-10T00:01:29.735Z\tYJZPHQDJKOM\n";
        this.assertThat("9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1605271283\t9619\t486\t\t2015-07-10T00:00:29.443Z\tYM\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t401073894\t9619\t1645\tDND\t2015-07-10T00:00:31.115Z\tFNMURHFGESODNWN\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t921021073\t9619\t1860\tSR\t2015-07-10T00:00:41.263Z\tOJXJCNBLYTOIYI\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1986641415\t9619\t935\tUFUC\t2015-07-10T00:00:50.470Z\tFREQGOPJK\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1635896684\t9619\t228\tRQLVWE\t2015-07-10T00:00:51.036Z\tMZCMZMHGTIQ\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t189633559\t9619\t830\tRQMR\t2015-07-10T00:01:20.166Z\tQPL\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t960875992\t9619\t960\t\t2015-07-10T00:01:29.735Z\tYJZPHQDJKOM\n", "customers join orders on customers.customerId = orders.customerId where customerName = 'WTBHZVPVZZ'");
        this.assertString("customers join orders on customers.customerId = orders.customerId where customerName = 'WTBHZVPVZZ'", 1);
        this.assertString("customers join orders on customers.customerId = orders.customerId where customerName = 'WTBHZVPVZZ'", 11);
    }

    @Test
    public void testInnerJoinEqualsConstantLhs() throws Exception {
        String expected = "9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1605271283\t9619\t486\t\t2015-07-10T00:00:29.443Z\tYM\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t401073894\t9619\t1645\tDND\t2015-07-10T00:00:31.115Z\tFNMURHFGESODNWN\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t921021073\t9619\t1860\tSR\t2015-07-10T00:00:41.263Z\tOJXJCNBLYTOIYI\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1986641415\t9619\t935\tUFUC\t2015-07-10T00:00:50.470Z\tFREQGOPJK\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1635896684\t9619\t228\tRQLVWE\t2015-07-10T00:00:51.036Z\tMZCMZMHGTIQ\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t189633559\t9619\t830\tRQMR\t2015-07-10T00:01:20.166Z\tQPL\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t960875992\t9619\t960\t\t2015-07-10T00:01:29.735Z\tYJZPHQDJKOM\n";
        this.assertThat("9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1605271283\t9619\t486\t\t2015-07-10T00:00:29.443Z\tYM\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t401073894\t9619\t1645\tDND\t2015-07-10T00:00:31.115Z\tFNMURHFGESODNWN\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t921021073\t9619\t1860\tSR\t2015-07-10T00:00:41.263Z\tOJXJCNBLYTOIYI\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1986641415\t9619\t935\tUFUC\t2015-07-10T00:00:50.470Z\tFREQGOPJK\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t1635896684\t9619\t228\tRQLVWE\t2015-07-10T00:00:51.036Z\tMZCMZMHGTIQ\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t189633559\t9619\t830\tRQMR\t2015-07-10T00:01:20.166Z\tQPL\n9619\tWTBHZVPVZZ\tT\t\tBMUPYPIZEPQKHZNGZGBUWDS\tPNKVDJOF\tFLRBROMNXKU\t2015-07-10T00:00:09.619Z\t960875992\t9619\t960\t\t2015-07-10T00:01:29.735Z\tYJZPHQDJKOM\n", "customers join orders on customers.customerId = orders.customerId where 'WTBHZVPVZZ' = customerName");
    }

    @Test
    public void testInnerJoinSubQuery() throws Exception {
        String expected = "WTBHZVPVZZ\tBOKHCKYDMWZ\t1605271283\nWTBHZVPVZZ\tKD\t401073894\nWTBHZVPVZZ\tBWJG\t921021073\nWTBHZVPVZZ\tK\t1986641415\nWTBHZVPVZZ\tBXWG\t1635896684\nWTBHZVPVZZ\tKRBCWYMNOQS\t189633559\nWTBHZVPVZZ\tFEOLY\t960875992\n";
        this.assertThat("WTBHZVPVZZ\tBOKHCKYDMWZ\t1605271283\nWTBHZVPVZZ\tKD\t401073894\nWTBHZVPVZZ\tBWJG\t921021073\nWTBHZVPVZZ\tK\t1986641415\nWTBHZVPVZZ\tBXWG\t1635896684\nWTBHZVPVZZ\tKRBCWYMNOQS\t189633559\nWTBHZVPVZZ\tFEOLY\t960875992\n", "select customerName, productName, orderId from (select customerName, orderId, productId from customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ') x join products p on p.productId = x.productId");
        this.assertThat("WTBHZVPVZZ\tBOKHCKYDMWZ\t1605271283\nWTBHZVPVZZ\tKD\t401073894\nWTBHZVPVZZ\tBWJG\t921021073\nWTBHZVPVZZ\tK\t1986641415\nWTBHZVPVZZ\tBXWG\t1635896684\nWTBHZVPVZZ\tKRBCWYMNOQS\t189633559\nWTBHZVPVZZ\tFEOLY\t960875992\n", "select customerName, productName, orderId  from customers join orders o on customers.customerId = o.customerId  join products p on p.productId = o.productId where customerName ~ 'WTBHZVPVZZ'");
    }

    @Test
    public void testInnerJoinSymbol() throws Exception {
        JoinQueryTest.assertSymbol("select country from customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ'", 0);
    }

    @Test
    public void testIntrinsicFalse() throws Exception {
        this.assertEmpty("select customerName, productName, orderId  from customers join orders o on customers.customerId = o.customerId  join products p on p.productId = o.productId where customerName ~ 'WTBHZVPVZZ' and 1 > 1");
    }

    @Test
    public void testInvalidAlias() {
        try {
            this.assertPlan2("", "orders join customers on orders.customerId = c.customerId");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)45L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"alias"));
        }
    }

    @Test
    public void testInvalidColumn() {
        try {
            this.assertPlan2("", "orders join customers on customerIdx = customerId");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)25L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Invalid column"));
        }
    }

    @Test
    public void testInvalidSelectColumn() {
        try {
            this.expectFailure("select c.customerId, orderIdx, o.productId from customers c join (orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o on c.customerId = o.customerId");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)21L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Invalid column"));
        }
        try {
            this.expectFailure("select c.customerId, orderId, o.productId2 from customers c join (orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o on c.customerId = o.customerId");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)30L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Invalid column"));
        }
        try {
            this.expectFailure("select c.customerId, orderId, o2.productId from customers c join (orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o on c.customerId = o.customerId");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)30L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Invalid column"));
        }
    }

    @Test
    public void testInvalidTableName() {
        try {
            this.assertPlan2("", "orders join customer on customerId = customerId");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Journal does not exist"));
        }
    }

    @Test
    public void testJoinColumnAlias() throws Exception {
        this.assertThat("162\tNaN\t1\n209\tNaN\t1\n233\tNaN\t1\n381\tNaN\t1\n396\tNaN\t1\n410\tNaN\t1\n805\tNaN\t1\n810\tNaN\t1\n1162\tNaN\t1\n1344\tNaN\t1\n", "select c.customerId, o.customerId kk, count() from customers c outer join orders o on c.customerId = o.customerId  where kk = NaN limit 10");
    }

    @Test
    public void testJoinCycle() throws Exception {
        this.assertPlan("+ 0[ cross ] orders\n+ 1[ inner ] customers ON customers.customerId = orders.customerId\n+ 2[ inner ] d (filter: d.orderId = d.productId) ON d.productId = orders.orderId\n+ 3[ inner ] suppliers ON suppliers.supplier = orders.orderId\n+ 4[ inner ] products ON products.productId = orders.orderId and products.supplier = suppliers.supplier\n\n", "orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = orders.orderId and orders.orderId = products.productId join suppliers on products.supplier = suppliers.supplier join products on d.productId = products.productId and orders.orderId = products.productId where orders.orderId = suppliers.supplier");
    }

    @Test
    public void testJoinGroupBy() throws Exception {
        this.assertThat("ZHCN\t2.541666666667\nZEQGMPLUCFTL\t2.549034175334\nZKX\t2.485995457986\nZRPFMDVVG\t2.508350730689\nZV\t2.485329103886\nZEPIHVLTOVLJUM\t2.485179407176\nZGKC\t2.525787965616\nZHEI\t2.464574898785\nZULIG\t2.471938775510\nZMZV\t2.470260223048\nZI\t2.508435582822\nZYNPPBX\t2.454467353952\nZEOCVFFKMEKPFOY\t2.414400000000\n", "select country, avg(quantity) from orders o join customers c on c.customerId = o.customerId join orderDetails d on o.orderId = d.orderId where country ~ '^Z'");
    }

    @Test
    public void testJoinGroupByFilter() throws Exception {
        this.assertThat("ZHCN\t2.541666666667\nZEQGMPLUCFTL\t2.549034175334\nZKX\t2.485995457986\nZRPFMDVVG\t2.508350730689\nZV\t2.485329103886\nZEPIHVLTOVLJUM\t2.485179407176\nZGKC\t2.525787965616\nZHEI\t2.464574898785\nZULIG\t2.471938775510\nZMZV\t2.470260223048\nZI\t2.508435582822\nZYNPPBX\t2.454467353952\nZEOCVFFKMEKPFOY\t2.414400000000\n", "(select country, avg(quantity) avg from orders o join customers c on c.customerId = o.customerId join orderDetails d on o.orderId = d.orderId where country ~ '^Z') where avg > 2");
    }

    @Test
    public void testJoinImpliedCrosses() throws Exception {
        this.assertPlan("+ 3[ cross ] products\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n+ 0[ cross ] orders\n+ 1[ cross ] customers\n+ 2[ cross ] d\n\n", "orders join customers on 1=1 join orderDetails d on 2=2 join products on 3=3 join suppliers on products.supplier = suppliers.supplier");
    }

    @Test
    public void testJoinMultipleFields() throws Exception {
        this.assertPlan("+ 0[ cross ] orders\n+ 1[ inner ] customers ON customers.customerId = orders.customerId\n+ 2[ inner ] d (filter: d.productId = d.orderId) ON d.productId = customers.customerId and d.orderId = orders.orderId\n+ 3[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinNoRowid() throws Exception {
        String expected = "100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t104281903\t100\t1138\tKWK\t2015-07-10T00:00:14.518Z\tFBLGGTZEN\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1191623531\t100\t1210\tSR\t2015-07-10T00:00:18.175Z\tYM\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1662742408\t100\t1828\tQH\t2015-07-10T00:00:19.509Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t220389\t100\t1293\tDGEEWB\t2015-07-10T00:00:56.196Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t798408721\t100\t803\tZIHLGS\t2015-07-10T00:00:56.977Z\tVTNNKVOLHLLNN\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t966974434\t100\t870\tJEOBQ\t2015-07-10T00:00:57.981Z\tW\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t258318715\t100\t1036\tOPWOGS\t2015-07-10T00:01:00.608Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1528068156\t100\t400\tYBQE\t2015-07-10T00:01:20.643Z\tQXOLEEXZ\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1935884354\t100\t1503\tD\t2015-07-10T00:01:43.507Z\tRZVZJQRNYSRKZSJ\n";
        final RecordSource m = this.compileSource("customers where customerName ~ 'PJFSREKEUNMKWOF'");
        NoRowIdRecordSource s = new NoRowIdRecordSource().of(this.compileSource("orders"));
        HashJoinRecordSource r = new HashJoinRecordSource(m, new IntList(){
            {
                this.add(m.getMetadata().getColumnIndex((CharSequence)"customerId"));
            }
        }, (RecordSource)s, new IntList((RecordSource)s){
            final /* synthetic */ RecordSource val$s;
            {
                this.val$s = recordSource;
                this.add(this.val$s.getMetadata().getColumnIndex((CharSequence)"customerId"));
            }
        }, false, 0x400000, 0x400000, 0x100000, new RecordKeyCopierCompiler(new BytecodeAssembler()));
        sink.clear();
        printer.print((RecordSource)r, (ReaderFactory)FACTORY_CONTAINER.getFactory());
        TestUtils.assertEquals((CharSequence)"100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t104281903\t100\t1138\tKWK\t2015-07-10T00:00:14.518Z\tFBLGGTZEN\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1191623531\t100\t1210\tSR\t2015-07-10T00:00:18.175Z\tYM\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1662742408\t100\t1828\tQH\t2015-07-10T00:00:19.509Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t220389\t100\t1293\tDGEEWB\t2015-07-10T00:00:56.196Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t798408721\t100\t803\tZIHLGS\t2015-07-10T00:00:56.977Z\tVTNNKVOLHLLNN\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t966974434\t100\t870\tJEOBQ\t2015-07-10T00:00:57.981Z\tW\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t258318715\t100\t1036\tOPWOGS\t2015-07-10T00:01:00.608Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1528068156\t100\t400\tYBQE\t2015-07-10T00:01:20.643Z\tQXOLEEXZ\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1935884354\t100\t1503\tD\t2015-07-10T00:01:43.507Z\tRZVZJQRNYSRKZSJ\n", (CharSequence)sink);
        this.assertThat("100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t104281903\t100\t1138\tKWK\t2015-07-10T00:00:14.518Z\tFBLGGTZEN\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1191623531\t100\t1210\tSR\t2015-07-10T00:00:18.175Z\tYM\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1662742408\t100\t1828\tQH\t2015-07-10T00:00:19.509Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t220389\t100\t1293\tDGEEWB\t2015-07-10T00:00:56.196Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t798408721\t100\t803\tZIHLGS\t2015-07-10T00:00:56.977Z\tVTNNKVOLHLLNN\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t966974434\t100\t870\tJEOBQ\t2015-07-10T00:00:57.981Z\tW\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t258318715\t100\t1036\tOPWOGS\t2015-07-10T00:01:00.608Z\tEYBI\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1528068156\t100\t400\tYBQE\t2015-07-10T00:01:20.643Z\tQXOLEEXZ\n100\tPJFSREKEUNMKWOF\tUVKWCCVTJSKMXVEGPIG\t\tVMY\tRT\tEYYPDVRGRQG\t2015-07-10T00:00:00.100Z\t1935884354\t100\t1503\tD\t2015-07-10T00:01:43.507Z\tRZVZJQRNYSRKZSJ\n", "customers c join orders o on c.customerId = o.customerId where customerName ~ 'PJFSREKEUNMKWOF'");
    }

    @Test
    public void testJoinOneFieldToTwo() throws Exception {
        this.assertPlan("+ 0[ cross ] orders (filter: orders.customerId = orders.orderId)\n+ 1[ inner ] customers ON customers.customerId = orders.orderId\n+ 2[ inner ] d (filter: d.productId = d.orderId) ON d.orderId = customers.customerId\n+ 3[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = orders.orderId and d.orderId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinOneFieldToTwoAcross() throws Exception {
        this.assertPlan("+ 0[ cross ] orders (filter: orders.customerId = orders.orderId)\n+ 1[ inner ] customers ON customers.customerId = orders.orderId\n+ 2[ inner ] d (filter: d.productId = d.orderId) ON d.orderId = customers.customerId\n+ 3[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "orders join customers on orders.customerId = customers.customerId join orderDetails d on orders.orderId = d.orderId and d.orderId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinOneFieldToTwoAcross2() throws Exception {
        this.assertPlan("+ 0[ cross ] orders (filter: orders.customerId = orders.orderId)\n+ 1[ inner ] customers ON customers.customerId = orders.orderId\n+ 2[ inner ] d (filter: d.productId = d.orderId) ON d.orderId = orders.orderId\n+ 3[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = customers.customerId and orders.orderId = d.orderId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinOneFieldToTwoReorder() throws Exception {
        this.assertPlan("+ 0[ cross ] orders (filter: orders.orderId = orders.customerId)\n+ 1[ inner ] d (filter: d.productId = d.orderId) ON d.orderId = orders.customerId\n+ 2[ inner ] customers ON customers.customerId = orders.customerId\n+ 3[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "orders join orderDetails d on d.orderId = orders.orderId and d.orderId = customers.customerId join customers on orders.customerId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinReorder() throws Exception {
        this.assertPlan("+ 0[ cross ] orders\n+ 2[ inner ] d (filter: d.productId = d.orderId) ON d.orderId = orders.orderId\n+ 1[ inner ] customers ON customers.customerId = d.productId\n+ 3[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "orders join customers on 1=1 join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinReorder3() throws Exception {
        this.assertPlan("+ 0[ cross ] orders\n+ 2[ inner ] shippers ON shippers.shipper = orders.orderId\n+ 3[ inner ] d (filter: d.productId = d.orderId) ON d.productId = shippers.shipper and d.orderId = orders.orderId\n+ 5[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n+ 1[ cross ] customers\n\n", "orders outer join customers on 1=1 join shippers on shippers.shipper = orders.orderId join orderDetails d on d.orderId = orders.orderId and d.productId = shippers.shipper join suppliers on products.supplier = suppliers.supplier join products on d.productId = products.productId where d.productId = d.orderId");
    }

    @Test
    public void testJoinReorderRoot() throws Exception {
        this.assertPlan("+ 0[ cross ] customers\n+ 2[ inner ] d (filter: d.productId = d.orderId) ON d.productId = customers.customerId\n+ 1[ inner ] orders ON orders.orderId = d.orderId\n+ 3[ inner ] products ON products.productId = d.productId\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "customers cross join orders join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinReorderRoot2() throws Exception {
        this.assertPlan("+ 0[ cross ] orders\n+ 2[ inner ] shippers ON shippers.shipper = orders.orderId\n+ 3[ inner ] d (filter: d.productId = d.orderId) ON d.productId = shippers.shipper and d.orderId = orders.orderId\n+ 4[ inner ] products ON products.productId = d.productId\n+ 5[ inner ] suppliers ON suppliers.supplier = products.supplier\n+ 1[ cross ] customers\n\n", "orders outer join customers on 1=1 join shippers on shippers.shipper = orders.orderId join orderDetails d on d.orderId = orders.orderId and d.productId = shippers.shipper join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId");
    }

    @Test
    public void testJoinSubQuery() throws Exception {
        this.assertPlan("+ 0[ cross ] orders\n+ 1[ inner ] {\n  customers (filter: customerName ~ 'X')\n} ON customerName = orderId\n\n", "orders cross join (select customerId, customerName from customers where customerName ~ 'X') where orderId = customerName");
    }

    @Test
    public void testJoinSymbolBehaviour() throws Exception {
        JoinQueryTest.assertSymbol("select customers.customerId, country from customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ'", 1);
    }

    @Test
    public void testJoinSymbolBehaviourOnSecondaryJournal() throws Exception {
        JoinQueryTest.assertSymbol("select customerName, productName, orderId, category from (select customerName, orderId, productId from customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ') x join products p on p.productId = x.productId", 3);
    }

    @Test
    public void testJoinWithFilter() throws Exception {
        this.assertPlan("+ 0[ cross ] customers\n+ 2[ inner ] d (filter: d.productId = d.orderId) ON d.productId = customers.customerId\n+ 1[ inner ] orders ON orders.orderId = d.orderId (post-filter: d.quantity < orders.orderId)\n+ 3[ inner ] products ON products.productId = d.productId (post-filter: products.price > d.quantity or d.orderId = orders.orderId)\n+ 4[ inner ] suppliers ON suppliers.supplier = products.supplier\n\n", "customers cross join orders join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId and (products.price > d.quantity or d.orderId = orders.orderId) and d.quantity < orders.orderId");
    }

    @Test
    public void testLambdaAmbiguousColumn() throws Exception {
        try {
            this.assertThat("", "orders latest by customerId where customerId in (`select customerName, city from customers where customerName ~ 'PJFSREKEUNMKWOF'`)");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)45L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Ambiguous"));
        }
    }

    @Test
    public void testLambdaJoin() throws Exception {
        String expected = "100\t1935884354\t1503\n";
        this.assertThat("100\t1935884354\t1503\n", "select c.customerId, orderId, o.productId from customers c join (orders o latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o on c.customerId = o.customerId");
        this.assertThat("100\t1935884354\t1503\n", "select c.customerId, orderId, productId from (orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o join customers c on c.customerId = o.customerId");
    }

    @Test
    public void testLatestByAll() throws Exception {
        String expected = "MUOHOMFQCDD\t1608\tDOT\nKUTGTZHMB\t1643\tDPR\nPT\t1676\tFVUNIEULONLYL\nCOX\t1699\tDSVJ\nUGSNVUPXB\t1706\tRQRGEVSIPBSFRYM\nIIKEBMITV\t1710\tIIIBVNVUJTHWQ\nUHSSLJ\t1729\tD\nJKNSQ\t1749\tDNSNKZB\nREDL\t1767\tCMLIBRH\nOH\t1776\tEGUJODLWDVJVX\nM\t1783\tQTUR\nJSZMYJJIBDSU\t1804\tG\nMG\t1807\tYGEHXEXM\nYOVV\t1811\tUUIVXRHT\nFO\t1821\tMNWSTEFB\nXCU\t1825\tWZECVHPTYUR\nGIP\t1827\tCUVSRL\nMNIKCUJZCRZGKS\t1828\tUOPESHYBD\nYCNDZMMOZCGUC\t1838\tIQEZNHNY\nMS\t1839\tLQKSGHFNX\nTDELODUR\t1854\tEFXWHJNIQID\nLKIRSRSPUZBBCEC\t1857\tMIRPINQNRWTCQS\nDXDCMGXTPLYG\t1858\tMHGTEG\nIDHRPVQMUXXUT\t1863\tOLLLGPDLQXH\nZEMF\t1876\tBGCSFVFWNIHB\nDFPWOO\t1883\tEKHB\nYYCZINRXDDRNDYI\t1884\tKHB\nFUXEJFTGSLMCBRD\t1892\tBMFKMQVMISRBNY\nLKXJVOSTCS\t1893\tIONB\nGFYMHDPSOJRN\t1894\tBYVNBCLWIHEXQKD\nOWBWL\t1899\tRRGTYZCK\nVSQCTTQBVGX\t1902\tPDJKHSVTO\nIEDGIJKTTTRJ\t1907\tUCVMSJCIECUI\nOOUFTRGFOBQUP\t1908\tYL\nWPWKGPBPIHSBPJ\t1911\tXGNE\nWD\t1912\tDTOXEJHZ\nEYSOWXFLJQFTLN\t1914\t\nOZEZYTXUQLHDVC\t1915\tUYZZDUILRHK\nKXEFLBSJMNF\t1918\tBNCMT\nN\t1922\tVPZD\nF\t1927\tD\nLFQNDNRHKUHE\t1928\tN\nWN\t1929\tXFBBIQRKHEBQSTN\nTCHHKFDBOXM\t1930\tMGYVMSEPBBB\nLPLSXBYJGV\t1935\tWBDRRIS\nQZFCS\t1937\tX\nTHTMCQK\t1939\tCFXMDHZ\nTYWWTQU\t1942\tBQQFDLT\nJZQXFVV\t1944\tIJDBKIPXC\nTBPHWXMBYPD\t1945\t\nGROTGCLGILNCXPT\t1946\tEOVGVPEHSZQJGNI\nFLDYOSB\t1947\tXIDPTECSRNIULZ\nZZCPO\t1950\tBYYJGDD\n\t1951\tXV\nLH\t1952\tWLXTV\nYETNJDK\t1954\tPKNNWLYVDNKL\nGKXFPXPTF\t1955\tPXWIS\nBRLOQYMWFYXR\t1956\tYQMHJ\nEHGNU\t1957\tMMP\nXCGSWYUBPLZIJL\t1958\tZKCCOQKVQYJXWNN\nPIBVSPPGQB\t1960\tOKPMW\nGEH\t1961\t\nFMLZJIGGOB\t1962\tE\nEHQCMNSGOLUIYW\t1964\tSQCIDHXLLWYISI\nXMCKQC\t1965\tCQ\nYNMHE\t1966\tUPO\nXSDHPJYW\t1967\tK\nBSFFBELM\t1968\tUSEMYWS\nTCBNLUQQJENUFQ\t1969\tXRFZVXFB\nUQ\t1970\tLLMBHWNPHYKUSO\nVWSMJLRTLFSE\t1971\tQBYOW\nYEPEDZMXGGPQTII\t1976\tTCIG\nLR\t1977\tPGITMNW\nIEMVKIGGP\t1978\tGTQBME\nOQUNHZBRZUI\t1979\tEQYIBLXWRSNYPIP\nFTZVJOBSP\t1980\tBVNQH\nRNUP\t1981\tOJXCLDL\nTRTVIJESSO\t1982\tNCVTU\nTRG\t1983\tTWVBETYKOND\nDJSBQG\t1984\tTXOFKCYGYDEFOB\nXOIUNEHDUX\t1986\tRRFMGRBSVEPTB\nPR\t1988\tBE\nIONUQQEHIBISBCY\t1989\tKCDZDQYFLUCTFVB\nLKJB\t1991\tSNJ\nEWJW\t1992\tQIZYFCPJ\nCZGMSTWGT\t1993\tEQIGJH\nQNNJITVR\t1994\tGVEMJRFNNF\nMTRDCBLINP\t1995\tDOOJRCCWOILYMCF\nZPZTFEXCNCWZU\t1996\tHFXCG\nEDXZVBDN\t1997\tUOG\nZZKOWPSRXENWCD\t1998\tGT\nXCWMTXCFEOZVK\t1999\tRBVPSFMZUGSTDID\n";
        this.assertThat("MUOHOMFQCDD\t1608\tDOT\nKUTGTZHMB\t1643\tDPR\nPT\t1676\tFVUNIEULONLYL\nCOX\t1699\tDSVJ\nUGSNVUPXB\t1706\tRQRGEVSIPBSFRYM\nIIKEBMITV\t1710\tIIIBVNVUJTHWQ\nUHSSLJ\t1729\tD\nJKNSQ\t1749\tDNSNKZB\nREDL\t1767\tCMLIBRH\nOH\t1776\tEGUJODLWDVJVX\nM\t1783\tQTUR\nJSZMYJJIBDSU\t1804\tG\nMG\t1807\tYGEHXEXM\nYOVV\t1811\tUUIVXRHT\nFO\t1821\tMNWSTEFB\nXCU\t1825\tWZECVHPTYUR\nGIP\t1827\tCUVSRL\nMNIKCUJZCRZGKS\t1828\tUOPESHYBD\nYCNDZMMOZCGUC\t1838\tIQEZNHNY\nMS\t1839\tLQKSGHFNX\nTDELODUR\t1854\tEFXWHJNIQID\nLKIRSRSPUZBBCEC\t1857\tMIRPINQNRWTCQS\nDXDCMGXTPLYG\t1858\tMHGTEG\nIDHRPVQMUXXUT\t1863\tOLLLGPDLQXH\nZEMF\t1876\tBGCSFVFWNIHB\nDFPWOO\t1883\tEKHB\nYYCZINRXDDRNDYI\t1884\tKHB\nFUXEJFTGSLMCBRD\t1892\tBMFKMQVMISRBNY\nLKXJVOSTCS\t1893\tIONB\nGFYMHDPSOJRN\t1894\tBYVNBCLWIHEXQKD\nOWBWL\t1899\tRRGTYZCK\nVSQCTTQBVGX\t1902\tPDJKHSVTO\nIEDGIJKTTTRJ\t1907\tUCVMSJCIECUI\nOOUFTRGFOBQUP\t1908\tYL\nWPWKGPBPIHSBPJ\t1911\tXGNE\nWD\t1912\tDTOXEJHZ\nEYSOWXFLJQFTLN\t1914\t\nOZEZYTXUQLHDVC\t1915\tUYZZDUILRHK\nKXEFLBSJMNF\t1918\tBNCMT\nN\t1922\tVPZD\nF\t1927\tD\nLFQNDNRHKUHE\t1928\tN\nWN\t1929\tXFBBIQRKHEBQSTN\nTCHHKFDBOXM\t1930\tMGYVMSEPBBB\nLPLSXBYJGV\t1935\tWBDRRIS\nQZFCS\t1937\tX\nTHTMCQK\t1939\tCFXMDHZ\nTYWWTQU\t1942\tBQQFDLT\nJZQXFVV\t1944\tIJDBKIPXC\nTBPHWXMBYPD\t1945\t\nGROTGCLGILNCXPT\t1946\tEOVGVPEHSZQJGNI\nFLDYOSB\t1947\tXIDPTECSRNIULZ\nZZCPO\t1950\tBYYJGDD\n\t1951\tXV\nLH\t1952\tWLXTV\nYETNJDK\t1954\tPKNNWLYVDNKL\nGKXFPXPTF\t1955\tPXWIS\nBRLOQYMWFYXR\t1956\tYQMHJ\nEHGNU\t1957\tMMP\nXCGSWYUBPLZIJL\t1958\tZKCCOQKVQYJXWNN\nPIBVSPPGQB\t1960\tOKPMW\nGEH\t1961\t\nFMLZJIGGOB\t1962\tE\nEHQCMNSGOLUIYW\t1964\tSQCIDHXLLWYISI\nXMCKQC\t1965\tCQ\nYNMHE\t1966\tUPO\nXSDHPJYW\t1967\tK\nBSFFBELM\t1968\tUSEMYWS\nTCBNLUQQJENUFQ\t1969\tXRFZVXFB\nUQ\t1970\tLLMBHWNPHYKUSO\nVWSMJLRTLFSE\t1971\tQBYOW\nYEPEDZMXGGPQTII\t1976\tTCIG\nLR\t1977\tPGITMNW\nIEMVKIGGP\t1978\tGTQBME\nOQUNHZBRZUI\t1979\tEQYIBLXWRSNYPIP\nFTZVJOBSP\t1980\tBVNQH\nRNUP\t1981\tOJXCLDL\nTRTVIJESSO\t1982\tNCVTU\nTRG\t1983\tTWVBETYKOND\nDJSBQG\t1984\tTXOFKCYGYDEFOB\nXOIUNEHDUX\t1986\tRRFMGRBSVEPTB\nPR\t1988\tBE\nIONUQQEHIBISBCY\t1989\tKCDZDQYFLUCTFVB\nLKJB\t1991\tSNJ\nEWJW\t1992\tQIZYFCPJ\nCZGMSTWGT\t1993\tEQIGJH\nQNNJITVR\t1994\tGVEMJRFNNF\nMTRDCBLINP\t1995\tDOOJRCCWOILYMCF\nZPZTFEXCNCWZU\t1996\tHFXCG\nEDXZVBDN\t1997\tUOG\nZZKOWPSRXENWCD\t1998\tGT\nXCWMTXCFEOZVK\t1999\tRBVPSFMZUGSTDID\n", "select supplier, productId, productName from products latest by supplier");
    }

    @Test
    public void testLatestOrderForACustomers() throws Exception {
        this.assertThat("385427654\t1\t1703\tXEMP\t2015-07-10T00:01:33.250Z\tMZCMZMHGTIQ\n", "orders latest by customerId where customerId = 1 and employeeId = 'XEMP'");
    }

    @Test
    public void testLatestOrderForACustomersNoFilter() throws Exception {
        try {
            this.assertThat("", "orders latest by customerId where employeeId = 'XEMP'");
            Assert.fail((String)"Exception expected");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)17L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)Chars.contains((CharSequence)QueryError.getMessage(), (CharSequence)"Filter on int"));
        }
    }

    @Test
    public void testLatestOrderForListOfCustomers() throws Exception {
        this.assertThat("385427654\t1\t1703\tXEMP\t2015-07-10T00:01:33.250Z\tMZCMZMHGTIQ\n607937606\t2\t548\tOVU\t2015-07-10T00:01:49.101Z\tRZVZJQRNYSRKZSJ\n855411970\t3\t1829\tBRSYPN\t2015-07-10T00:01:51.990Z\tOJXJCNBLYTOIYI\n", "orders latest by customerId where customerId in (1,2,3)");
    }

    @Test
    public void testLimit() throws Exception {
        this.assertThat("1406\tVQHYIIQL\tKJE\t\tDYQFLMPNGEJKKJCRCKNPUTHTVNYXM\tDFDISBFBRCCQDV\tXTGNJ\t2015-07-10T00:00:01.406Z\tNaN\tNaN\tNaN\t\t\t\n1414\tDHMTF\tRTGV\t\tHMDJSBGPXQTKPGGWFSTJSKSZSBEPDVNMFEVEMQCOHDBK\tJKBVDSERXZ\tOEENNEBQQEMXD\t2015-07-10T00:00:01.414Z\tNaN\tNaN\tNaN\t\t\t\n1422\tEKVFCZGGCKCHK\tEEGCRISJP\t\tILWBREVXDHHWPREIFCMLRXSWMFWEKIOTXUPRNGEPIJVNKTXHNKYITYG\tYYBJER\tCNSFFLTRY\t2015-07-10T00:00:01.422Z\tNaN\tNaN\tNaN\t\t\t\n1523\tV\tODSBTX\t\tECUZSRJCTRJLH\tVBNHX\tZHEI\t2015-07-10T00:00:01.523Z\tNaN\tNaN\tNaN\t\t\t\n1567\tBWPEIFNITZK\tBIJXCYTOHOQT\t\tYZMMSEZIPCOCZZUFYIVELTS\tFVPDDGSEK\tUN\t2015-07-10T00:00:01.567Z\tNaN\tNaN\tNaN\t\t\t\n", "customers c outer join orders o on c.customerId = o.customerId  where orderId = NaN limit 10,15");
    }

    @Test
    public void testMultipleWithClauseReuse() throws Exception {
        this.assertThat("1\t\tKZBSS\t2015-07-10T00:00:10.102Z\t1\t\tKZBSS\t2015-07-10T00:00:10.102Z\n1\t\tKZBSS\t2015-07-10T00:00:10.102Z\t1\t\tUBKVY\t2015-07-10T00:00:10.121Z\n1\t\tKZBSS\t2015-07-10T00:00:10.102Z\t1\t\tN\t2015-07-10T00:00:10.142Z\n1\t\tKZBSS\t2015-07-10T00:00:10.102Z\t1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\n1\t\tKZBSS\t2015-07-10T00:00:10.102Z\t1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\n1\t\tUBKVY\t2015-07-10T00:00:10.121Z\t1\t\tKZBSS\t2015-07-10T00:00:10.102Z\n1\t\tUBKVY\t2015-07-10T00:00:10.121Z\t1\t\tUBKVY\t2015-07-10T00:00:10.121Z\n1\t\tUBKVY\t2015-07-10T00:00:10.121Z\t1\t\tN\t2015-07-10T00:00:10.142Z\n1\t\tUBKVY\t2015-07-10T00:00:10.121Z\t1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\n1\t\tUBKVY\t2015-07-10T00:00:10.121Z\t1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\n1\t\tN\t2015-07-10T00:00:10.142Z\t1\t\tKZBSS\t2015-07-10T00:00:10.102Z\n1\t\tN\t2015-07-10T00:00:10.142Z\t1\t\tUBKVY\t2015-07-10T00:00:10.121Z\n1\t\tN\t2015-07-10T00:00:10.142Z\t1\t\tN\t2015-07-10T00:00:10.142Z\n1\t\tN\t2015-07-10T00:00:10.142Z\t1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\n1\t\tN\t2015-07-10T00:00:10.142Z\t1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\n1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\t1\t\tKZBSS\t2015-07-10T00:00:10.102Z\n1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\t1\t\tUBKVY\t2015-07-10T00:00:10.121Z\n1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\t1\t\tN\t2015-07-10T00:00:10.142Z\n1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\t1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\n1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\t1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\n1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\t1\t\tKZBSS\t2015-07-10T00:00:10.102Z\n1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\t1\t\tUBKVY\t2015-07-10T00:00:10.121Z\n1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\t1\t\tN\t2015-07-10T00:00:10.142Z\n1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\t1\t\tMTEVNUE\t2015-07-10T00:00:10.165Z\n1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\t1\t\tRKMLOG\t2015-07-10T00:00:10.168Z\n", "with o as (select '1' blah, lastName, employeeId customerId, timestamp from employees order by lastName limit 5)o cross join o");
    }

    @Test
    public void testNullInsteadOfNaN() throws Exception {
        this.assertThat("1406\tVQHYIIQL\tKJE\t\tDYQFLMPNGEJKKJCRCKNPUTHTVNYXM\tDFDISBFBRCCQDV\tXTGNJ\t2015-07-10T00:00:01.406Z\tNaN\tNaN\tNaN\t\t\t\n1414\tDHMTF\tRTGV\t\tHMDJSBGPXQTKPGGWFSTJSKSZSBEPDVNMFEVEMQCOHDBK\tJKBVDSERXZ\tOEENNEBQQEMXD\t2015-07-10T00:00:01.414Z\tNaN\tNaN\tNaN\t\t\t\n1422\tEKVFCZGGCKCHK\tEEGCRISJP\t\tILWBREVXDHHWPREIFCMLRXSWMFWEKIOTXUPRNGEPIJVNKTXHNKYITYG\tYYBJER\tCNSFFLTRY\t2015-07-10T00:00:01.422Z\tNaN\tNaN\tNaN\t\t\t\n1523\tV\tODSBTX\t\tECUZSRJCTRJLH\tVBNHX\tZHEI\t2015-07-10T00:00:01.523Z\tNaN\tNaN\tNaN\t\t\t\n1567\tBWPEIFNITZK\tBIJXCYTOHOQT\t\tYZMMSEZIPCOCZZUFYIVELTS\tFVPDDGSEK\tUN\t2015-07-10T00:00:01.567Z\tNaN\tNaN\tNaN\t\t\t\n", "customers c outer join orders o on c.customerId = o.customerId  where orderId = null limit 10,15");
    }

    @Test
    public void testNullSymbol() throws Exception {
        this.assertEmpty("select country, avg(quantity) from orders o join customers c on c.customerId = o.customerId join orderDetails d on o.orderId = d.orderId where country = null");
    }

    @Test
    public void testOrderByOptimisation() throws Exception {
        String expected = "410\tUWWBTOWPJTW\tPYZZYPFVTUDCCBOGCSHVQDTJSKFDF\t\tEIUHQZLPDWWIMMRZPZPTWDWXVFRNXZERBBG\tMNJVHP\tJSMK\t2015-07-10T00:00:00.410Z\tNaN\tNaN\tNaN\t\t\t\n805\tJDD\tPBJDTSRWFDYKFUKNSMFUREMGUGV\t\tGU\tYZ\tOEENNEBQQEMXD\t2015-07-10T00:00:00.805Z\tNaN\tNaN\tNaN\t\t\t\n810\tJNDVPITEWCB\tWWTURRWZVQXZZYDGZNZCTQYIXQRLRW\t\tWMXWFJFIKXWTHBJGUTVIXQIVZYEBZYP\tEOGVU\tL\t2015-07-10T00:00:00.810Z\tNaN\tNaN\tNaN\t\t\t\n1162\tZJSXCVDFRBBYP\tEDBFKPKBHQB\t\tZPNNILHNWDCKSHXQXKXOKTYNYTUISPYKRXNBGPIHZNDPRHNPHYIHGHKKZQID\tSJE\tTFSNSXH\t2015-07-10T00:00:01.162Z\tNaN\tNaN\tNaN\t\t\t\n";
        String sql = "customers c outer join orders o on c.customerId = o.customerId  where o.orderId = NaN and c.customerId > 400 and c.customerId < 1200 order by c.customerId";
        this.assertThat(expected, sql);
        this.assertPlan2("{\n  \"op\": \"FilteredRecordSource\",\n  \"src\": {\n    \"op\": \"HashJoinRecordSource\",\n    \"master\": {\n      \"op\": \"RBTreeSortedRecordSource\",\n      \"byRowId\": true,\n      \"src\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"customers\"\n        },\n        \"rsrc\": {\n          \"op\": \"FilteredRowSource\",\n          \"rsrc\": {\n            \"op\": \"AllRowSource\"\n          }\n        }\n      }\n    },\n    \"slave\": {\n      \"op\": \"JournalRecordSource\",\n      \"psrc\": {\n        \"op\": \"JournalPartitionSource\",\n        \"journal\": \"orders\"\n      },\n      \"rsrc\": {\n        \"op\": \"AllRowSource\"\n      }\n    },\n    \"joinOn\": [\n      [\n        \"customerId\"\n      ],\n      [\n        \"customerId\"\n      ]\n    ]\n  },\n  \"filter\": \"o.orderId \\u003d NaN\"\n}", sql);
    }

    @Test
    public void testOrderByOptimisation2() throws Exception {
        String expected = "410\tUWWBTOWPJTW\tPYZZYPFVTUDCCBOGCSHVQDTJSKFDF\t\tEIUHQZLPDWWIMMRZPZPTWDWXVFRNXZERBBG\tMNJVHP\tJSMK\t2015-07-10T00:00:00.410Z\tNaN\tNaN\tNaN\t\t\t\n805\tJDD\tPBJDTSRWFDYKFUKNSMFUREMGUGV\t\tGU\tYZ\tOEENNEBQQEMXD\t2015-07-10T00:00:00.805Z\tNaN\tNaN\tNaN\t\t\t\n810\tJNDVPITEWCB\tWWTURRWZVQXZZYDGZNZCTQYIXQRLRW\t\tWMXWFJFIKXWTHBJGUTVIXQIVZYEBZYP\tEOGVU\tL\t2015-07-10T00:00:00.810Z\tNaN\tNaN\tNaN\t\t\t\n1162\tZJSXCVDFRBBYP\tEDBFKPKBHQB\t\tZPNNILHNWDCKSHXQXKXOKTYNYTUISPYKRXNBGPIHZNDPRHNPHYIHGHKKZQID\tSJE\tTFSNSXH\t2015-07-10T00:00:01.162Z\tNaN\tNaN\tNaN\t\t\t\n";
        String sql = "customers c outer join orders o on c.customerId = o.customerId  where o.orderId = NaN and c.customerId > 400 and c.customerId < 1200 order by o.customerId";
        this.assertThat(expected, sql);
        this.assertPlan2("{\n  \"op\": \"RBTreeSortedRecordSource\",\n  \"byRowId\": false,\n  \"src\": {\n    \"op\": \"FilteredRecordSource\",\n    \"src\": {\n      \"op\": \"HashJoinRecordSource\",\n      \"master\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"customers\"\n        },\n        \"rsrc\": {\n          \"op\": \"FilteredRowSource\",\n          \"rsrc\": {\n            \"op\": \"AllRowSource\"\n          }\n        }\n      },\n      \"slave\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"orders\"\n        },\n        \"rsrc\": {\n          \"op\": \"AllRowSource\"\n        }\n      },\n      \"joinOn\": [\n        [\n          \"customerId\"\n        ],\n        [\n          \"customerId\"\n        ]\n      ]\n    },\n    \"filter\": \"o.orderId \\u003d NaN\"\n  }\n}", sql);
    }

    @Test
    public void testOrderByOptimisation3() throws Exception {
        String expected = "410\tUWWBTOWPJTW\n805\tJDD\n810\tJNDVPITEWCB\n1162\tZJSXCVDFRBBYP\n";
        String sql = "select c.customerId x, c.customerName from customers c outer join orders o on c.customerId = o.customerId  where o.orderId = NaN and c.customerId > 400 and c.customerId < 1200 order by x";
        this.assertThat(expected, sql);
        this.assertPlan2("{\n  \"op\": \"SelectedColumnsRecordSource\",\n  \"src\": {\n    \"op\": \"FilteredRecordSource\",\n    \"src\": {\n      \"op\": \"HashJoinRecordSource\",\n      \"master\": {\n        \"op\": \"RBTreeSortedRecordSource\",\n        \"byRowId\": true,\n        \"src\": {\n          \"op\": \"JournalRecordSource\",\n          \"psrc\": {\n            \"op\": \"JournalPartitionSource\",\n            \"journal\": \"customers\"\n          },\n          \"rsrc\": {\n            \"op\": \"FilteredRowSource\",\n            \"rsrc\": {\n              \"op\": \"AllRowSource\"\n            }\n          }\n        }\n      },\n      \"slave\": {\n        \"op\": \"JournalRecordSource\",\n        \"psrc\": {\n          \"op\": \"JournalPartitionSource\",\n          \"journal\": \"orders\"\n        },\n        \"rsrc\": {\n          \"op\": \"AllRowSource\"\n        }\n      },\n      \"joinOn\": [\n        [\n          \"customerId\"\n        ],\n        [\n          \"customerId\"\n        ]\n      ]\n    },\n    \"filter\": \"o.orderId \\u003d NaN\"\n  }\n}", sql);
    }

    @Test
    public void testOuterData() throws Exception {
        String expected = "162\tGMRIFLMITGDYEV\t\t\tSPEKZKSGOBNGGYCMQDTJB\tBL\tVFZF\t2015-07-10T00:00:00.162Z\tNaN\tNaN\tNaN\t\t\t\n209\tFBWP\tYENLEZTSMCKFERVG\t\tDZDUV\tCYYVYQ\tJSMK\t2015-07-10T00:00:00.209Z\tNaN\tNaN\tNaN\t\t\t\n233\tQWZMQEFI\tTDFXHNFPWKMILOGWL\t\tDHCYX\tCUYVUVQRY\tGIJYDVRV\t2015-07-10T00:00:00.233Z\tNaN\tNaN\tNaN\t\t\t\n381\tVYPDCYB\tBYTCJGCTLGGHVJXGRILSCO\t\tIGMKIOPKMYIHL\tVEMYSYSTQEL\tQHNOJIGFINKGQVZ\t2015-07-10T00:00:00.381Z\tNaN\tNaN\tNaN\t\t\t\n396\tKDNTVGUZLQQPM\tDHUJJIJMEXUJSTGUGVUKEWQPQUYC\t\tUZVVKSKZJOPLFKJDKGYWDVYCBRNKJOHMUUKV\tRTVTODMNWELRV\tBUYZVQ\t2015-07-10T00:00:00.396Z\tNaN\tNaN\tNaN\t\t\t\n410\tUWWBTOWPJTW\tPYZZYPFVTUDCCBOGCSHVQDTJSKFDF\t\tEIUHQZLPDWWIMMRZPZPTWDWXVFRNXZERBBG\tMNJVHP\tJSMK\t2015-07-10T00:00:00.410Z\tNaN\tNaN\tNaN\t\t\t\n805\tJDD\tPBJDTSRWFDYKFUKNSMFUREMGUGV\t\tGU\tYZ\tOEENNEBQQEMXD\t2015-07-10T00:00:00.805Z\tNaN\tNaN\tNaN\t\t\t\n810\tJNDVPITEWCB\tWWTURRWZVQXZZYDGZNZCTQYIXQRLRW\t\tWMXWFJFIKXWTHBJGUTVIXQIVZYEBZYP\tEOGVU\tL\t2015-07-10T00:00:00.810Z\tNaN\tNaN\tNaN\t\t\t\n1162\tZJSXCVDFRBBYP\tEDBFKPKBHQB\t\tZPNNILHNWDCKSHXQXKXOKTYNYTUISPYKRXNBGPIHZNDPRHNPHYIHGHKKZQID\tSJE\tTFSNSXH\t2015-07-10T00:00:01.162Z\tNaN\tNaN\tNaN\t\t\t\n1344\tZGY\tQN\t\tNROGZBSXJTNYED\tGGCOBQZUM\tBOQMYSSMP\t2015-07-10T00:00:01.344Z\tNaN\tNaN\tNaN\t\t\t\n1406\tVQHYIIQL\tKJE\t\tDYQFLMPNGEJKKJCRCKNPUTHTVNYXM\tDFDISBFBRCCQDV\tXTGNJ\t2015-07-10T00:00:01.406Z\tNaN\tNaN\tNaN\t\t\t\n1414\tDHMTF\tRTGV\t\tHMDJSBGPXQTKPGGWFSTJSKSZSBEPDVNMFEVEMQCOHDBK\tJKBVDSERXZ\tOEENNEBQQEMXD\t2015-07-10T00:00:01.414Z\tNaN\tNaN\tNaN\t\t\t\n1422\tEKVFCZGGCKCHK\tEEGCRISJP\t\tILWBREVXDHHWPREIFCMLRXSWMFWEKIOTXUPRNGEPIJVNKTXHNKYITYG\tYYBJER\tCNSFFLTRY\t2015-07-10T00:00:01.422Z\tNaN\tNaN\tNaN\t\t\t\n1523\tV\tODSBTX\t\tECUZSRJCTRJLH\tVBNHX\tZHEI\t2015-07-10T00:00:01.523Z\tNaN\tNaN\tNaN\t\t\t\n1567\tBWPEIFNITZK\tBIJXCYTOHOQT\t\tYZMMSEZIPCOCZZUFYIVELTS\tFVPDDGSEK\tUN\t2015-07-10T00:00:01.567Z\tNaN\tNaN\tNaN\t\t\t\n1589\tQJZGPSXOHTWXD\tEKVIBQFPUIPNFOGDPVUUUQ\t\tX\tBGDBEDEFD\tBCZIOLYLPG\t2015-07-10T00:00:01.589Z\tNaN\tNaN\tNaN\t\t\t\n1689\tWQ\tWZOHOOLBREWPFXYMVTDRBND\t\tGORYPTSTPHWOCVTZWOMURLEHZWCMOFQFYWNXDGNZKSFQUSMOVSWPCONS\tSWBCPLXVLMQ\tTOGM\t2015-07-10T00:00:01.689Z\tNaN\tNaN\tNaN\t\t\t\n1734\tPSBRCYXIJLGOC\tDNBEWBWJPMCRQBTOOJPMFWVCPYZVRK\t\tZNQJZSPFSMRNBSCSVJMGLUWTWYFNIKBBKL\tHEGJPSFHUWOTUIL\tOWLPDXYSBEOUOJ\t2015-07-10T00:00:01.734Z\tNaN\tNaN\tNaN\t\t\t\n1913\tBYYTTZDNBCBLR\tPXLCJNSUGIWGJWLYEQ\t\tCHUQVSFDBBLSEMNFVNGZMTYTMK\tIZTBCTJ\tGLHMLLEOY\t2015-07-10T00:00:01.913Z\tNaN\tNaN\tNaN\t\t\t\n2172\t\tSRXYONINGWNLG\t\tXYNFIBOCMCXCKDWDROMMCGKRWNNPZNKBELQJVSVGWUMYCKJFCBDBCVZPO\tWLZXCZYXJXQWZL\tMQH\t2015-07-10T00:00:02.172Z\tNaN\tNaN\tNaN\t\t\t\n2312\tZIBIM\tRINZFPZU\t\tKNPETVEWYFUGELZUNMEZVGRQJUYZSBETJSEDWFVROCMWRMLLHMVKXNGRIMPF\tZWWINRXPMIGS\tNIMYFF\t2015-07-10T00:00:02.312Z\tNaN\tNaN\tNaN\t\t\t\n2378\tLSKKQ\tSSULKFTWUSZQLMBPDRIOYBHT\t\tHWCEGCCJCFVKJFTPTTNVCZVMVQUOITXQWKSSOLGOZSQXWZT\tHSOQYCWEROZ\tPKLHTIIG\t2015-07-10T00:00:02.378Z\tNaN\tNaN\tNaN\t\t\t\n2385\tVJDLICNNECMY\tHMDUCFWCSXVFG\t\tEHBOTVVKOGHHKICBOPWMBHOKLPDCNX\tWUW\tZMZV\t2015-07-10T00:00:02.385Z\tNaN\tNaN\tNaN\t\t\t\n2990\tDJUPSVOGIUEDG\tGTMXBMRHDSULOUIHTKXHLONPZ\t\tVRYBNVGGYPCFCZFCOCVOULWXREBBQMWJMDT\tVESFSEMNXOUSI\tZEQGMPLUCFTL\t2015-07-10T00:00:02.990Z\tNaN\tNaN\tNaN\t\t\t\n3036\tNBOKZPH\tSOXIOEC\t\tPHVNUNBYMROWMLWTKZIOQIZHHWVCBYWRVY\tWOVJTL\tUZY\t2015-07-10T00:00:03.036Z\tNaN\tNaN\tNaN\t\t\t\n3171\tFJBUXYJCC\tFSCJELZPZCWRHKFRVIR\t\tXEWJYQDVHIPWPHDZKPEDGFYPNNNVPWLYLN\tJEOUSRULHULNDLC\tOZZVDZJMYIC\t2015-07-10T00:00:03.171Z\tNaN\tNaN\tNaN\t\t\t\n3213\tLCOTYSUBPNV\tEHIDIOWKZJQNRVBLWXFCHQVO\t\tTITHBMKLEOOKZFSYVZUCDXHDTJJYRHNVWIPVELVFQPXQDSHZIQQJFXMOFJRTOZ\tCMJSTVNPFNWPPBW\tUZY\t2015-07-10T00:00:03.213Z\tNaN\tNaN\tNaN\t\t\t\n3222\tLHXREYVN\tLKXQVJZUVWJIGUBKGBUGKRON\t\t\tHDRD\tOEZBRQ\t2015-07-10T00:00:03.222Z\tNaN\tNaN\tNaN\t\t\t\n3226\tKXZMMCGO\tQPW\t\tWKOLUQVELGJURZBQTWMSBSSSZYVCWIYKVQEFUZDBWJWTXGI\t\tQHNOJIGFINKGQVZ\t2015-07-10T00:00:03.226Z\tNaN\tNaN\tNaN\t\t\t\n3270\tNDRWGFXTNNTQB\tCGYIEZEQJEJPLPBHGFBVEBQYWCMG\t\tDOMUIZPVKDENO\tHXTNWWFVY\tTI\t2015-07-10T00:00:03.270Z\tNaN\tNaN\tNaN\t\t\t\n3383\tWMTZDJKNXCYCG\tFSUHTMXYEG\t\tEPFM\tXNMJINXIJM\tTOGM\t2015-07-10T00:00:03.383Z\tNaN\tNaN\tNaN\t\t\t\n3476\tDPCRPYJGXJPBUOD\tKITKUVSLNTJTPEFOTSPPQU\t\tWKTXNKOKJOJTLFNXTZTZZJPS\tRIWLMOI\tB\t2015-07-10T00:00:03.476Z\tNaN\tNaN\tNaN\t\t\t\n3478\tWTYRQ\tG\t\tVTDFWKVOOUSTQBWBNTZWMNCIWGZDWHKQYEODUUEMWWQBD\tXJ\tEYYPDVRGRQG\t2015-07-10T00:00:03.478Z\tNaN\tNaN\tNaN\t\t\t\n3502\tVWXXO\tSXJIBJXMHDTEJLKIIRELKZC\t\tSRSHKSEONQCYOFIMHBKGZKHMFE\tIQBSTDTCDNQE\tFNWGRMD\t2015-07-10T00:00:03.502Z\tNaN\tNaN\tNaN\t\t\t\n3589\tJOQQE\tKRUHSSEWMBELUIM\t\tEBMHCMDMDFSKYPDVYH\tYDMFRUNZIUXLB\tUHNBCCPM\t2015-07-10T00:00:03.589Z\tNaN\tNaN\tNaN\t\t\t\n3663\tUDX\tHXMRSDUZYTPYUYBC\t\tQDUTVPDLFNFHQZZGCELWJZIPRBSORVECERSVKCNGFWSDZHPDK\tWKOUXMRBLX\tHQQUW\t2015-07-10T00:00:03.663Z\tNaN\tNaN\tNaN\t\t\t\n3703\tUDRFDIXFY\tSGU\t\tRYFLDHPETQWIKEWYKDWQEX\tFQTJW\tEBNDCQCEHNO\t2015-07-10T00:00:03.703Z\tNaN\tNaN\tNaN\t\t\t\n3751\tEL\tTZXHXHPTEWHNUQWBYV\t\tHQGMTGIIZBMQPNMJMHFGLUXWJVHPXVXDYNSSDCBKOSUTN\tLHPWO\t\t2015-07-10T00:00:03.751Z\tNaN\tNaN\tNaN\t\t\t\n3891\tWMJFMFIY\tRELGTJVOIDJ\t\tXDQMLYFXJI\tNERDCGSGIWS\tWUVMBPSVEZDYHDH\t2015-07-10T00:00:03.891Z\tNaN\tNaN\tNaN\t\t\t\n3935\tMPPLRO\tPLFVGXOJQWZUVOOBRMGKCKMFTTINB\t\tTIMNMLWUZSMHNHYUYYRPKR\tDXWLZFL\tTI\t2015-07-10T00:00:03.935Z\tNaN\tNaN\tNaN\t\t\t\n4041\tHSNIJKWXG\tUJYWZE\t\tDVWYVDMCGKDCVRBVVZELVKOKJKYRXNQTFURDIBSZDNGWUJVNVUMVLJBI\tDOIKCLGLLTB\tTFSNSXH\t2015-07-10T00:00:04.041Z\tNaN\tNaN\tNaN\t\t\t\n4059\tULPIS\t\t\tWXPNLDBUVDW\tSBDCUXKKC\tBUYZVQ\t2015-07-10T00:00:04.059Z\tNaN\tNaN\tNaN\t\t\t\n4132\tBWHGDEXNZMBFKTH\tZNVYO\t\tMQKEHUWPEEKEHHNBUPRMSQIHBBJNOHRRBSXGYWU\tYBVJTLPSLKVXZNM\t\t2015-07-10T00:00:04.132Z\tNaN\tNaN\tNaN\t\t\t\n4412\tKSLZBHBGLU\tYJOWHLNKRGBMTYILPWINI\t\tSISKLWIGOZRWPSGZD\tPZEGSDJ\tPKLHTIIG\t2015-07-10T00:00:04.412Z\tNaN\tNaN\tNaN\t\t\t\n4432\tK\tPXOFTVRRDMQYG\t\tSQCZOONVRVXHDCUSRWWJVGEDCKYJMG\tCWRO\tLU\t2015-07-10T00:00:04.432Z\tNaN\tNaN\tNaN\t\t\t\n4745\tDYPIOX\t\t\tYUWUIQCFHKERXRUYHKIJRWGLEHMBURBIBHCLBHOPC\tFFREMYVLF\tIHYBTVZNCLN\t2015-07-10T00:00:04.745Z\tNaN\tNaN\tNaN\t\t\t\n4839\tFNJOWUJCQHYQ\tZTG\t\tTEIKMXBOWWEQBLZZZLEGWTFEVHZBHNEXBUWPSCS\tBCHPCUEDKSQ\tVRB\t2015-07-10T00:00:04.839Z\tNaN\tNaN\tNaN\t\t\t\n4934\tMHZTPC\tNFCFMZDOTVPXCFNOZJRWEQY\t\tYQEGLX\tVSVLHDNIKPWNOX\tMZCCYVBDMQEH\t2015-07-10T00:00:04.934Z\tNaN\tNaN\tNaN\t\t\t\n4963\tET\t\t\tLZTCYZKKVFOYHPGETSYSPFMKNULYMRISCWICQIOBWSPSMINXBYKXVZHKMRMYZ\tKCYKZDQ\tERSMKRZUDJGNNDE\t2015-07-10T00:00:04.963Z\tNaN\tNaN\tNaN\t\t\t\n4981\tOEGWN\tELCMYM\t\tUIOWZGCEXXZNBYPOXEUJCMIHBHKIRBDVOXUZMTVOQYUTUJL\tVSISP\tFNWGRMD\t2015-07-10T00:00:04.981Z\tNaN\tNaN\tNaN\t\t\t\n5207\tZNKCJHXBWEYN\tJEJEHFREXOVGPH\t\tEVCHKS\tXVQYLMJELWJLHS\t\t2015-07-10T00:00:05.207Z\tNaN\tNaN\tNaN\t\t\t\n5288\tIXH\tSLTVJIGLBMTCUXPMSWOEDT\t\tWYRNJECJSCPQDSHDJKTOTIUIPTNBYXTRZUMKGEZNPFLFTELYBSGI\tNOCZPXX\tHRI\t2015-07-10T00:00:05.288Z\tNaN\tNaN\tNaN\t\t\t\n5387\tSSPKDHERWUNX\tSGJMTMDPMSUPETCMIQE\t\tFBICHHGNEVNKVGJVI\tHFVYNKH\tINLKFNUH\t2015-07-10T00:00:05.387Z\tNaN\tNaN\tNaN\t\t\t\n5445\tR\tOJKCNJSMEQYCSKCKQRQWGEDD\t\tDQKRXXFOC\tGGSOBQQHR\tEJRMDIKDI\t2015-07-10T00:00:05.445Z\tNaN\tNaN\tNaN\t\t\t\n5653\tCE\tWPDTMIXZNQIIUVIXUNYECF\t\tLGOQPTMORXJFRXYOPEQXGERTXUTEIPJQJFCWKIITNBPOVKFQI\tXUOCLBYIB\tBBUKOJ\t2015-07-10T00:00:05.653Z\tNaN\tNaN\tNaN\t\t\t\n5684\t\tQJIDXPOCPTYYURUKSMCRMJMQQJB\t\tW\tISOXFJGEOHFCR\t\t2015-07-10T00:00:05.684Z\tNaN\tNaN\tNaN\t\t\t\n5956\tFPXYZW\tHWYQKHYTDVPVLLDYOPITHLLJG\t\tKFWQUXKKOTUIUHXELOOKDJIJROU\tSRCTDZS\tZYNPPBX\t2015-07-10T00:00:05.956Z\tNaN\tNaN\tNaN\t\t\t\n6006\tV\tMSKSWOFNYUKWNBKRFWOONIONILJJEMG\t\tCWHSYMVZMCDHWSSQTTEXRCVSKXCBYEYIHTXVMCJCPBOFIFKKXNGIEO\tTDVGHGKIVGU\tZHCN\t2015-07-10T00:00:06.006Z\tNaN\tNaN\tNaN\t\t\t\n6039\tFXNPVVURFMOLR\tOHBKYKVDMRSOSRCSEWEJKCFJJLXDQM\t\tNMZSWWPQUFIRDJOGGDZCIPYWLVPLYTWECLKE\tKCMOCZMMCDIL\tHSQSPZ\t2015-07-10T00:00:06.039Z\tNaN\tNaN\tNaN\t\t\t\n6122\tSRHNNUBREDEWYQL\tUNVYXEFBXLJUIBCIZUB\t\tHCPVXCIBOCQPPWQUPOBEEHTNDJQWFMPRTUQIXBORZXTYN\tZKHUJELJITS\tUN\t2015-07-10T00:00:06.122Z\tNaN\tNaN\tNaN\t\t\t\n6468\tSZTUTU\tQPXBOTFQLQXYDLW\t\tSLQTFNGHYIVHDSUWWNVTBBVYPHKIHVIEHTXPHIWSCWGLNEVPCIITFFCQI\tMSMIMLWZJCL\tJWCPSWHYRXPEHN\t2015-07-10T00:00:06.468Z\tNaN\tNaN\tNaN\t\t\t\n6486\tUXUCRDEQ\tCSOUCDKZHSFLLFMSJKCHTZKP\t\tLJKCIGNLIWJRFLMFDQBNIBZUQECN\tWTRPRCHCD\tHQQUW\t2015-07-10T00:00:06.486Z\tNaN\tNaN\tNaN\t\t\t\n6678\tTYJDHKUNEO\tCFZRMGKKQOMGMEGKMNVFVZSFQNIQUDO\t\tMIZDRNOJDELNJPNHVLTPFRTLVZUFNTSOGZZCNYBHSVWGNNIP\tNJDIVGC\tMRT\t2015-07-10T00:00:06.678Z\tNaN\tNaN\tNaN\t\t\t\n6691\tWGXLXNKO\tLBYMWEZCHRSNYPTCCXKRLQB\t\tDHBHVQPYOEDJSOKKDZTUNHRMZYQZWBHMBUXPN\tYSYUCK\tOUICWEKGHV\t2015-07-10T00:00:06.691Z\tNaN\tNaN\tNaN\t\t\t\n6728\tHSFLSXTYEWWWMD\tSXVIHKWQQBSUYEKLTRVMQFZO\t\tIGOQUCGCKOJSSRVJWBCPYYNEWTQKCTCERGHDDGWKLOXBFDEKPKRMDKKENJFN\tRZ\tZRPFMDVVG\t2015-07-10T00:00:06.728Z\tNaN\tNaN\tNaN\t\t\t\n6826\tVJDZ\tMGXBJXCFJHWCFDOTZLCPJSLFXTYIM\t\tTVPRLEMKQZZIIPCFGUKKKOBNTRPYVHMRUDUDSGZXTIFXWRFULWVWOHHJDZ\tCR\tVMC\t2015-07-10T00:00:06.826Z\tNaN\tNaN\tNaN\t\t\t\n6926\tZYESDDCGOGFUO\tWRDFOEFONJSPFGTUCKMIZWXIE\t\tVFJBNWHQVHMPJKSTXZXPQTOIMSJNCNRLUGQW\tIYFKD\tTI\t2015-07-10T00:00:06.926Z\tNaN\tNaN\tNaN\t\t\t\n7021\tNLKYHGO\tRHGHYBZOMJJBVLGGPHG\t\tFJQMODHRBKVLZWSJUWMLJFVUKIZJVZBBFNMXZOQJFWZDVYQCQXRUSBSDOIBLSS\tPQVCYTWYLEK\tOEZBRQ\t2015-07-10T00:00:07.021Z\tNaN\tNaN\tNaN\t\t\t\n7053\tWNSMHNXS\tOBSJHVQXMOJ\t\tEFVJTGURNJJZJIMUREPGMEJXDXDERDRXIMFZHYCZVKTDTBPYJQQPGYLIKPPBL\tPOWZIJQNISFYFN\tLPTYXYGY\t2015-07-10T00:00:07.053Z\tNaN\tNaN\tNaN\t\t\t\n7056\tGTLEUE\tQWBCXBXNDFRPOQLROOEXRSFPUSFN\t\tROFOTIRXJTZWT\tBVTVUBQ\tWUVMBPSVEZDYHDH\t2015-07-10T00:00:07.056Z\tNaN\tNaN\tNaN\t\t\t\n7122\tVCCO\tOJDYZWTUYNGWQNWEGOXYMJ\t\tPTWRSXZVZRNYUQDXLLOQVRMNLZUQRYIIYYJZBZGBKBRELDNPCM\tWCECUHSTCHICVIW\tIHZBWWXF\t2015-07-10T00:00:07.122Z\tNaN\tNaN\tNaN\t\t\t\n7175\t\tSMSPDCSPNTOUVUVWG\t\tMWVXGQOPEFIW\tRTCGYGSMWYFHIK\tUXI\t2015-07-10T00:00:07.175Z\tNaN\tNaN\tNaN\t\t\t\n7262\tVIXUVVWCWWTZVTT\tRHWJQEDZTDLZZODEC\t\tJMYKVBGFRCCVBPIYJFGUO\tZINNITZWLZJ\tLPTYXYGY\t2015-07-10T00:00:07.262Z\tNaN\tNaN\tNaN\t\t\t\n7347\tVJDIMVDXSZJGONW\tQEHBEOGUKYJKMDKXYVTB\t\tMKOZKMNYESGUFQEWJJONMJXZGYKDZOFNIYCVCIIBPDKRMFXJURGLV\tXKRKNOBFOHRVHHK\tHSQSPZ\t2015-07-10T00:00:07.347Z\tNaN\tNaN\tNaN\t\t\t\n7473\tEIZFIQOXKQTL\tRMTGUNFYICLTNRPOINOKISQR\t\tUTKENDEUCPB\tDDQ\tQXSPEPTTKIB\t2015-07-10T00:00:07.473Z\tNaN\tNaN\tNaN\t\t\t\n7478\tVKQEOSR\tCNBBUPHUEXWJURYENCJMSSZLDOUET\t\tDLEJKKEWPSMEVYFWRXFIISVPMQWCPJR\tXGXTKBZLML\tZYNPPBX\t2015-07-10T00:00:07.478Z\tNaN\tNaN\tNaN\t\t\t\n7497\tLFQGLDWFRXXG\tMOTZVCZZCSN\t\tPLZSQJTXPZBYGCNVCLJJYZWVCDLBEQOLFDGEQIHMGQKTXOEWYHEWVYXCOGWJMCU\tHUSKKOVGLEYFTS\tVELLKKHTWNWI\t2015-07-10T00:00:07.497Z\tNaN\tNaN\tNaN\t\t\t\n7513\tV\tNPKCEVYISMIEZ\t\tSHKVNSEIDEJZYBDRJXJXUHFWPHQDJGYGUBFWHHBPZXPTUZNZBZQM\t\tGSTEQODRZEIWFOQ\t2015-07-10T00:00:07.513Z\tNaN\tNaN\tNaN\t\t\t\n7644\tPGZGVZCOFMMUE\tDKDC\t\tQSTEVZPEHUZVOWSTSWXBTUWEGQQIPN\tSQQGPYG\tUOUIGENFELWWRSL\t2015-07-10T00:00:07.644Z\tNaN\tNaN\tNaN\t\t\t\n7737\tIXTXWXNRTEV\tOLMYQTMBOETE\t\tCSINBVKDS\tSVZXEVCRGW\tXGZMDJTHMHZN\t2015-07-10T00:00:07.737Z\tNaN\tNaN\tNaN\t\t\t\n7911\tB\tHBDFCVYUERTYMXRVDKJHWG\t\tUXZBGJRUXHSDUDRIOCUIICKOZSVXHDYXEKDDVFTPGRQWIZYIOBMZFMYHZH\tLNXNEFZQJYO\tJBF\t2015-07-10T00:00:07.911Z\tNaN\tNaN\tNaN\t\t\t\n7961\tFLBPTOLRBCSL\tXUE\t\tXGHYVHINXWPB\tYTMTUHYYRKUHLUQ\tVFZF\t2015-07-10T00:00:07.961Z\tNaN\tNaN\tNaN\t\t\t\n7968\tRXSC\tHGHZDQS\t\tEGRPGPPRXJUPJLGCRETXZNNHBPNWRFBBHEMODPJZLDYKWBY\tIK\tRGOONFCLTJCKFMQ\t2015-07-10T00:00:07.968Z\tNaN\tNaN\tNaN\t\t\t\n7976\tDEXNQWBDJQEHUM\tQIFWWFNVZUZJNJQ\t\tKOIY\tWV\tFSUWPNXHQUT\t2015-07-10T00:00:07.976Z\tNaN\tNaN\tNaN\t\t\t\n8074\tBFGSXPKVKURV\t\t\tTIGRLGDVMMCIMHXICXJWRWLPKCRQRQFIOTGHXHGVDIRMRUMV\tF\tPJEUKW\t2015-07-10T00:00:08.074Z\tNaN\tNaN\tNaN\t\t\t\n8113\tDDGFSZHOG\tPBV\t\tXFBTRICSWEOBKHUFDRSNFDEXDFTMEHBKQPKRRQFPTZKFRXRGJWE\tFTID\t\t2015-07-10T00:00:08.113Z\tNaN\tNaN\tNaN\t\t\t\n8121\tELZPVWLPQQO\tIJHLCIPMKJBHKRNYRRIBCWQTWHFMC\t\tJSCYBPOMOFRYEFHZNYNTTMLGFJHLLKIKMOMC\tLDGWBHIQNE\tINLKFNUH\t2015-07-10T00:00:08.121Z\tNaN\tNaN\tNaN\t\t\t\n8130\tSYGBYFSNQOT\tINUCPVCRKPQSKZOSNQQSLKDELFSVVDI\t\tXQGGHWGJZDKHLDCJSBQYKXZUMWQLHUOTDZCEJRZPF\tYXKQOIT\tZI\t2015-07-10T00:00:08.130Z\tNaN\tNaN\tNaN\t\t\t\n8199\tJWFODJS\tOMOIJIUGNUZMSXEK\t\tIFRCSLFUDRPRMLHTBXLFOVRZNTENWJMKFHOZEGVBX\tLFEQGRKKBPMI\tGSTEQODRZEIWFOQ\t2015-07-10T00:00:08.199Z\tNaN\tNaN\tNaN\t\t\t\n8284\t\tJKYMSFW\t\tFZQPSJETVHJVVOIZRITTFEPZMEJHDXYGHWDNUEIIEXCFVTV\tMRMRGTUFNZHXKQY\tFEVHK\t2015-07-10T00:00:08.284Z\tNaN\tNaN\tNaN\t\t\t\n8320\tWGCFDLNDIEW\tORDODPC\t\tTTHPTKYEYYP\tXOYOEMXIEGP\tOVFDBZWNI\t2015-07-10T00:00:08.320Z\tNaN\tNaN\tNaN\t\t\t\n8379\tQQPSQOPG\tVLSFYVGGHMGVPIGUJCBZS\t\tZCRHPDJMWNSLOMQZXPNFMHGZKLUNEUUDMYBXWRFYRPIFIRSSEEINLIHHXSHZEZZ\tEW\tWUVMBPSVEZDYHDH\t2015-07-10T00:00:08.379Z\tNaN\tNaN\tNaN\t\t\t\n8532\tCGOSJWM\tGZEFSMRLMUULNJDSOKJOR\t\t\tSHXMT\tHNZH\t2015-07-10T00:00:08.532Z\tNaN\tNaN\tNaN\t\t\t\n8549\tXKGGQNZPZXDWF\tNFEBNUVEQJOPWKHYEXVWEMHNQKD\t\tLQRZKJEGFWQIEHNDQNSLLEJKYHHGCEF\t\tJFRPXZSF\t2015-07-10T00:00:08.549Z\tNaN\tNaN\tNaN\t\t\t\n8567\tRUDDLZNHGVHZO\tKOZOOJWDDO\t\tRMJURFHFUWRFYYROGJUKEKJTIOKSOMWQCIGBXGTHJJBHFFFEUXJQPOGQL\tFFKJOOXKH\tRJUEBWV\t2015-07-10T00:00:08.567Z\tNaN\tNaN\tNaN\t\t\t\n8821\tZ\tHEDEUYVXYULDEDVOZTIXLRHX\t\tLBZKRTLMHHZQYJTHVKTHTQCZUTYNTSRIEFIVJIT\tBUOIOYPUMWUHEI\tTOGM\t2015-07-10T00:00:08.821Z\tNaN\tNaN\tNaN\t\t\t\n9021\tMSM\tMJWVDCOWPQFCDB\t\tEFTSFYICZHJLOPKNJTSKMGPBIZUTTXSZCIBKIMNHPEEX\tMIKOFVNI\tVFZF\t2015-07-10T00:00:09.021Z\tNaN\tNaN\tNaN\t\t\t\n9180\tDX\tLMHJXBDPMRECNYXZ\t\tTYDLLXJTKOFTUPQXUSEWRSQCLENIOMZPSW\tYS\t\t2015-07-10T00:00:09.180Z\tNaN\tNaN\tNaN\t\t\t\n9752\t\tKIJZZXFXHTCOEJPWMICBQOXQQQPBGF\t\tSWSMBCZIORTGCWCFVXSYKTLDCDLJQEKZLJVTLIJSLXH\tCSRXHZCODL\tGSTEQODRZEIWFOQ\t2015-07-10T00:00:09.752Z\tNaN\tNaN\tNaN\t\t\t\n9754\tVBUNKYVVGQLKQCD\tBOOFXUSIVEHEJIOTLOYTCCKIVVUHQ\t\tFGFXYRFCNLJEWVEQYHNESWJRBYQBQP\tIPEWMGFDPQH\tXLQLUUZIZKMFCKV\t2015-07-10T00:00:09.754Z\tNaN\tNaN\tNaN\t\t\t\n9782\tOIGUBDZRIHVSSH\tFKXP\t\tYCDPIVPZVGZOTUBFPLOVJRWTQLQW\tRVYMWKMJEYMFNNL\tEVQTQ\t2015-07-10T00:00:09.782Z\tNaN\tNaN\tNaN\t\t\t\n9977\tINDD\tMIRNGQQJMVOHKXHIYFMUMLXDGEQIEGT\t\tXULPFZVERXTYXHEIXXTUSJFKTHCHSXYTBLILZKTHJTFSFQPTUZHIURBOMPGHUR\tMUIYMRYE\tWLZKDMPVR\t2015-07-10T00:00:09.977Z\tNaN\tNaN\tNaN\t\t\t\n9992\tHTEOO\tFEVRVVUBNQZINQYGSBOXQGTVNRLXE\t\tHJBNFHODEFEMCKSVYWTQPMEVLLSJINDCHSPTIZDB\tDXIUYZNJ\tORD\t2015-07-10T00:00:09.992Z\tNaN\tNaN\tNaN\t\t\t\n";
        this.assertThat("162\tGMRIFLMITGDYEV\t\t\tSPEKZKSGOBNGGYCMQDTJB\tBL\tVFZF\t2015-07-10T00:00:00.162Z\tNaN\tNaN\tNaN\t\t\t\n209\tFBWP\tYENLEZTSMCKFERVG\t\tDZDUV\tCYYVYQ\tJSMK\t2015-07-10T00:00:00.209Z\tNaN\tNaN\tNaN\t\t\t\n233\tQWZMQEFI\tTDFXHNFPWKMILOGWL\t\tDHCYX\tCUYVUVQRY\tGIJYDVRV\t2015-07-10T00:00:00.233Z\tNaN\tNaN\tNaN\t\t\t\n381\tVYPDCYB\tBYTCJGCTLGGHVJXGRILSCO\t\tIGMKIOPKMYIHL\tVEMYSYSTQEL\tQHNOJIGFINKGQVZ\t2015-07-10T00:00:00.381Z\tNaN\tNaN\tNaN\t\t\t\n396\tKDNTVGUZLQQPM\tDHUJJIJMEXUJSTGUGVUKEWQPQUYC\t\tUZVVKSKZJOPLFKJDKGYWDVYCBRNKJOHMUUKV\tRTVTODMNWELRV\tBUYZVQ\t2015-07-10T00:00:00.396Z\tNaN\tNaN\tNaN\t\t\t\n410\tUWWBTOWPJTW\tPYZZYPFVTUDCCBOGCSHVQDTJSKFDF\t\tEIUHQZLPDWWIMMRZPZPTWDWXVFRNXZERBBG\tMNJVHP\tJSMK\t2015-07-10T00:00:00.410Z\tNaN\tNaN\tNaN\t\t\t\n805\tJDD\tPBJDTSRWFDYKFUKNSMFUREMGUGV\t\tGU\tYZ\tOEENNEBQQEMXD\t2015-07-10T00:00:00.805Z\tNaN\tNaN\tNaN\t\t\t\n810\tJNDVPITEWCB\tWWTURRWZVQXZZYDGZNZCTQYIXQRLRW\t\tWMXWFJFIKXWTHBJGUTVIXQIVZYEBZYP\tEOGVU\tL\t2015-07-10T00:00:00.810Z\tNaN\tNaN\tNaN\t\t\t\n1162\tZJSXCVDFRBBYP\tEDBFKPKBHQB\t\tZPNNILHNWDCKSHXQXKXOKTYNYTUISPYKRXNBGPIHZNDPRHNPHYIHGHKKZQID\tSJE\tTFSNSXH\t2015-07-10T00:00:01.162Z\tNaN\tNaN\tNaN\t\t\t\n1344\tZGY\tQN\t\tNROGZBSXJTNYED\tGGCOBQZUM\tBOQMYSSMP\t2015-07-10T00:00:01.344Z\tNaN\tNaN\tNaN\t\t\t\n1406\tVQHYIIQL\tKJE\t\tDYQFLMPNGEJKKJCRCKNPUTHTVNYXM\tDFDISBFBRCCQDV\tXTGNJ\t2015-07-10T00:00:01.406Z\tNaN\tNaN\tNaN\t\t\t\n1414\tDHMTF\tRTGV\t\tHMDJSBGPXQTKPGGWFSTJSKSZSBEPDVNMFEVEMQCOHDBK\tJKBVDSERXZ\tOEENNEBQQEMXD\t2015-07-10T00:00:01.414Z\tNaN\tNaN\tNaN\t\t\t\n1422\tEKVFCZGGCKCHK\tEEGCRISJP\t\tILWBREVXDHHWPREIFCMLRXSWMFWEKIOTXUPRNGEPIJVNKTXHNKYITYG\tYYBJER\tCNSFFLTRY\t2015-07-10T00:00:01.422Z\tNaN\tNaN\tNaN\t\t\t\n1523\tV\tODSBTX\t\tECUZSRJCTRJLH\tVBNHX\tZHEI\t2015-07-10T00:00:01.523Z\tNaN\tNaN\tNaN\t\t\t\n1567\tBWPEIFNITZK\tBIJXCYTOHOQT\t\tYZMMSEZIPCOCZZUFYIVELTS\tFVPDDGSEK\tUN\t2015-07-10T00:00:01.567Z\tNaN\tNaN\tNaN\t\t\t\n1589\tQJZGPSXOHTWXD\tEKVIBQFPUIPNFOGDPVUUUQ\t\tX\tBGDBEDEFD\tBCZIOLYLPG\t2015-07-10T00:00:01.589Z\tNaN\tNaN\tNaN\t\t\t\n1689\tWQ\tWZOHOOLBREWPFXYMVTDRBND\t\tGORYPTSTPHWOCVTZWOMURLEHZWCMOFQFYWNXDGNZKSFQUSMOVSWPCONS\tSWBCPLXVLMQ\tTOGM\t2015-07-10T00:00:01.689Z\tNaN\tNaN\tNaN\t\t\t\n1734\tPSBRCYXIJLGOC\tDNBEWBWJPMCRQBTOOJPMFWVCPYZVRK\t\tZNQJZSPFSMRNBSCSVJMGLUWTWYFNIKBBKL\tHEGJPSFHUWOTUIL\tOWLPDXYSBEOUOJ\t2015-07-10T00:00:01.734Z\tNaN\tNaN\tNaN\t\t\t\n1913\tBYYTTZDNBCBLR\tPXLCJNSUGIWGJWLYEQ\t\tCHUQVSFDBBLSEMNFVNGZMTYTMK\tIZTBCTJ\tGLHMLLEOY\t2015-07-10T00:00:01.913Z\tNaN\tNaN\tNaN\t\t\t\n2172\t\tSRXYONINGWNLG\t\tXYNFIBOCMCXCKDWDROMMCGKRWNNPZNKBELQJVSVGWUMYCKJFCBDBCVZPO\tWLZXCZYXJXQWZL\tMQH\t2015-07-10T00:00:02.172Z\tNaN\tNaN\tNaN\t\t\t\n2312\tZIBIM\tRINZFPZU\t\tKNPETVEWYFUGELZUNMEZVGRQJUYZSBETJSEDWFVROCMWRMLLHMVKXNGRIMPF\tZWWINRXPMIGS\tNIMYFF\t2015-07-10T00:00:02.312Z\tNaN\tNaN\tNaN\t\t\t\n2378\tLSKKQ\tSSULKFTWUSZQLMBPDRIOYBHT\t\tHWCEGCCJCFVKJFTPTTNVCZVMVQUOITXQWKSSOLGOZSQXWZT\tHSOQYCWEROZ\tPKLHTIIG\t2015-07-10T00:00:02.378Z\tNaN\tNaN\tNaN\t\t\t\n2385\tVJDLICNNECMY\tHMDUCFWCSXVFG\t\tEHBOTVVKOGHHKICBOPWMBHOKLPDCNX\tWUW\tZMZV\t2015-07-10T00:00:02.385Z\tNaN\tNaN\tNaN\t\t\t\n2990\tDJUPSVOGIUEDG\tGTMXBMRHDSULOUIHTKXHLONPZ\t\tVRYBNVGGYPCFCZFCOCVOULWXREBBQMWJMDT\tVESFSEMNXOUSI\tZEQGMPLUCFTL\t2015-07-10T00:00:02.990Z\tNaN\tNaN\tNaN\t\t\t\n3036\tNBOKZPH\tSOXIOEC\t\tPHVNUNBYMROWMLWTKZIOQIZHHWVCBYWRVY\tWOVJTL\tUZY\t2015-07-10T00:00:03.036Z\tNaN\tNaN\tNaN\t\t\t\n3171\tFJBUXYJCC\tFSCJELZPZCWRHKFRVIR\t\tXEWJYQDVHIPWPHDZKPEDGFYPNNNVPWLYLN\tJEOUSRULHULNDLC\tOZZVDZJMYIC\t2015-07-10T00:00:03.171Z\tNaN\tNaN\tNaN\t\t\t\n3213\tLCOTYSUBPNV\tEHIDIOWKZJQNRVBLWXFCHQVO\t\tTITHBMKLEOOKZFSYVZUCDXHDTJJYRHNVWIPVELVFQPXQDSHZIQQJFXMOFJRTOZ\tCMJSTVNPFNWPPBW\tUZY\t2015-07-10T00:00:03.213Z\tNaN\tNaN\tNaN\t\t\t\n3222\tLHXREYVN\tLKXQVJZUVWJIGUBKGBUGKRON\t\t\tHDRD\tOEZBRQ\t2015-07-10T00:00:03.222Z\tNaN\tNaN\tNaN\t\t\t\n3226\tKXZMMCGO\tQPW\t\tWKOLUQVELGJURZBQTWMSBSSSZYVCWIYKVQEFUZDBWJWTXGI\t\tQHNOJIGFINKGQVZ\t2015-07-10T00:00:03.226Z\tNaN\tNaN\tNaN\t\t\t\n3270\tNDRWGFXTNNTQB\tCGYIEZEQJEJPLPBHGFBVEBQYWCMG\t\tDOMUIZPVKDENO\tHXTNWWFVY\tTI\t2015-07-10T00:00:03.270Z\tNaN\tNaN\tNaN\t\t\t\n3383\tWMTZDJKNXCYCG\tFSUHTMXYEG\t\tEPFM\tXNMJINXIJM\tTOGM\t2015-07-10T00:00:03.383Z\tNaN\tNaN\tNaN\t\t\t\n3476\tDPCRPYJGXJPBUOD\tKITKUVSLNTJTPEFOTSPPQU\t\tWKTXNKOKJOJTLFNXTZTZZJPS\tRIWLMOI\tB\t2015-07-10T00:00:03.476Z\tNaN\tNaN\tNaN\t\t\t\n3478\tWTYRQ\tG\t\tVTDFWKVOOUSTQBWBNTZWMNCIWGZDWHKQYEODUUEMWWQBD\tXJ\tEYYPDVRGRQG\t2015-07-10T00:00:03.478Z\tNaN\tNaN\tNaN\t\t\t\n3502\tVWXXO\tSXJIBJXMHDTEJLKIIRELKZC\t\tSRSHKSEONQCYOFIMHBKGZKHMFE\tIQBSTDTCDNQE\tFNWGRMD\t2015-07-10T00:00:03.502Z\tNaN\tNaN\tNaN\t\t\t\n3589\tJOQQE\tKRUHSSEWMBELUIM\t\tEBMHCMDMDFSKYPDVYH\tYDMFRUNZIUXLB\tUHNBCCPM\t2015-07-10T00:00:03.589Z\tNaN\tNaN\tNaN\t\t\t\n3663\tUDX\tHXMRSDUZYTPYUYBC\t\tQDUTVPDLFNFHQZZGCELWJZIPRBSORVECERSVKCNGFWSDZHPDK\tWKOUXMRBLX\tHQQUW\t2015-07-10T00:00:03.663Z\tNaN\tNaN\tNaN\t\t\t\n3703\tUDRFDIXFY\tSGU\t\tRYFLDHPETQWIKEWYKDWQEX\tFQTJW\tEBNDCQCEHNO\t2015-07-10T00:00:03.703Z\tNaN\tNaN\tNaN\t\t\t\n3751\tEL\tTZXHXHPTEWHNUQWBYV\t\tHQGMTGIIZBMQPNMJMHFGLUXWJVHPXVXDYNSSDCBKOSUTN\tLHPWO\t\t2015-07-10T00:00:03.751Z\tNaN\tNaN\tNaN\t\t\t\n3891\tWMJFMFIY\tRELGTJVOIDJ\t\tXDQMLYFXJI\tNERDCGSGIWS\tWUVMBPSVEZDYHDH\t2015-07-10T00:00:03.891Z\tNaN\tNaN\tNaN\t\t\t\n3935\tMPPLRO\tPLFVGXOJQWZUVOOBRMGKCKMFTTINB\t\tTIMNMLWUZSMHNHYUYYRPKR\tDXWLZFL\tTI\t2015-07-10T00:00:03.935Z\tNaN\tNaN\tNaN\t\t\t\n4041\tHSNIJKWXG\tUJYWZE\t\tDVWYVDMCGKDCVRBVVZELVKOKJKYRXNQTFURDIBSZDNGWUJVNVUMVLJBI\tDOIKCLGLLTB\tTFSNSXH\t2015-07-10T00:00:04.041Z\tNaN\tNaN\tNaN\t\t\t\n4059\tULPIS\t\t\tWXPNLDBUVDW\tSBDCUXKKC\tBUYZVQ\t2015-07-10T00:00:04.059Z\tNaN\tNaN\tNaN\t\t\t\n4132\tBWHGDEXNZMBFKTH\tZNVYO\t\tMQKEHUWPEEKEHHNBUPRMSQIHBBJNOHRRBSXGYWU\tYBVJTLPSLKVXZNM\t\t2015-07-10T00:00:04.132Z\tNaN\tNaN\tNaN\t\t\t\n4412\tKSLZBHBGLU\tYJOWHLNKRGBMTYILPWINI\t\tSISKLWIGOZRWPSGZD\tPZEGSDJ\tPKLHTIIG\t2015-07-10T00:00:04.412Z\tNaN\tNaN\tNaN\t\t\t\n4432\tK\tPXOFTVRRDMQYG\t\tSQCZOONVRVXHDCUSRWWJVGEDCKYJMG\tCWRO\tLU\t2015-07-10T00:00:04.432Z\tNaN\tNaN\tNaN\t\t\t\n4745\tDYPIOX\t\t\tYUWUIQCFHKERXRUYHKIJRWGLEHMBURBIBHCLBHOPC\tFFREMYVLF\tIHYBTVZNCLN\t2015-07-10T00:00:04.745Z\tNaN\tNaN\tNaN\t\t\t\n4839\tFNJOWUJCQHYQ\tZTG\t\tTEIKMXBOWWEQBLZZZLEGWTFEVHZBHNEXBUWPSCS\tBCHPCUEDKSQ\tVRB\t2015-07-10T00:00:04.839Z\tNaN\tNaN\tNaN\t\t\t\n4934\tMHZTPC\tNFCFMZDOTVPXCFNOZJRWEQY\t\tYQEGLX\tVSVLHDNIKPWNOX\tMZCCYVBDMQEH\t2015-07-10T00:00:04.934Z\tNaN\tNaN\tNaN\t\t\t\n4963\tET\t\t\tLZTCYZKKVFOYHPGETSYSPFMKNULYMRISCWICQIOBWSPSMINXBYKXVZHKMRMYZ\tKCYKZDQ\tERSMKRZUDJGNNDE\t2015-07-10T00:00:04.963Z\tNaN\tNaN\tNaN\t\t\t\n4981\tOEGWN\tELCMYM\t\tUIOWZGCEXXZNBYPOXEUJCMIHBHKIRBDVOXUZMTVOQYUTUJL\tVSISP\tFNWGRMD\t2015-07-10T00:00:04.981Z\tNaN\tNaN\tNaN\t\t\t\n5207\tZNKCJHXBWEYN\tJEJEHFREXOVGPH\t\tEVCHKS\tXVQYLMJELWJLHS\t\t2015-07-10T00:00:05.207Z\tNaN\tNaN\tNaN\t\t\t\n5288\tIXH\tSLTVJIGLBMTCUXPMSWOEDT\t\tWYRNJECJSCPQDSHDJKTOTIUIPTNBYXTRZUMKGEZNPFLFTELYBSGI\tNOCZPXX\tHRI\t2015-07-10T00:00:05.288Z\tNaN\tNaN\tNaN\t\t\t\n5387\tSSPKDHERWUNX\tSGJMTMDPMSUPETCMIQE\t\tFBICHHGNEVNKVGJVI\tHFVYNKH\tINLKFNUH\t2015-07-10T00:00:05.387Z\tNaN\tNaN\tNaN\t\t\t\n5445\tR\tOJKCNJSMEQYCSKCKQRQWGEDD\t\tDQKRXXFOC\tGGSOBQQHR\tEJRMDIKDI\t2015-07-10T00:00:05.445Z\tNaN\tNaN\tNaN\t\t\t\n5653\tCE\tWPDTMIXZNQIIUVIXUNYECF\t\tLGOQPTMORXJFRXYOPEQXGERTXUTEIPJQJFCWKIITNBPOVKFQI\tXUOCLBYIB\tBBUKOJ\t2015-07-10T00:00:05.653Z\tNaN\tNaN\tNaN\t\t\t\n5684\t\tQJIDXPOCPTYYURUKSMCRMJMQQJB\t\tW\tISOXFJGEOHFCR\t\t2015-07-10T00:00:05.684Z\tNaN\tNaN\tNaN\t\t\t\n5956\tFPXYZW\tHWYQKHYTDVPVLLDYOPITHLLJG\t\tKFWQUXKKOTUIUHXELOOKDJIJROU\tSRCTDZS\tZYNPPBX\t2015-07-10T00:00:05.956Z\tNaN\tNaN\tNaN\t\t\t\n6006\tV\tMSKSWOFNYUKWNBKRFWOONIONILJJEMG\t\tCWHSYMVZMCDHWSSQTTEXRCVSKXCBYEYIHTXVMCJCPBOFIFKKXNGIEO\tTDVGHGKIVGU\tZHCN\t2015-07-10T00:00:06.006Z\tNaN\tNaN\tNaN\t\t\t\n6039\tFXNPVVURFMOLR\tOHBKYKVDMRSOSRCSEWEJKCFJJLXDQM\t\tNMZSWWPQUFIRDJOGGDZCIPYWLVPLYTWECLKE\tKCMOCZMMCDIL\tHSQSPZ\t2015-07-10T00:00:06.039Z\tNaN\tNaN\tNaN\t\t\t\n6122\tSRHNNUBREDEWYQL\tUNVYXEFBXLJUIBCIZUB\t\tHCPVXCIBOCQPPWQUPOBEEHTNDJQWFMPRTUQIXBORZXTYN\tZKHUJELJITS\tUN\t2015-07-10T00:00:06.122Z\tNaN\tNaN\tNaN\t\t\t\n6468\tSZTUTU\tQPXBOTFQLQXYDLW\t\tSLQTFNGHYIVHDSUWWNVTBBVYPHKIHVIEHTXPHIWSCWGLNEVPCIITFFCQI\tMSMIMLWZJCL\tJWCPSWHYRXPEHN\t2015-07-10T00:00:06.468Z\tNaN\tNaN\tNaN\t\t\t\n6486\tUXUCRDEQ\tCSOUCDKZHSFLLFMSJKCHTZKP\t\tLJKCIGNLIWJRFLMFDQBNIBZUQECN\tWTRPRCHCD\tHQQUW\t2015-07-10T00:00:06.486Z\tNaN\tNaN\tNaN\t\t\t\n6678\tTYJDHKUNEO\tCFZRMGKKQOMGMEGKMNVFVZSFQNIQUDO\t\tMIZDRNOJDELNJPNHVLTPFRTLVZUFNTSOGZZCNYBHSVWGNNIP\tNJDIVGC\tMRT\t2015-07-10T00:00:06.678Z\tNaN\tNaN\tNaN\t\t\t\n6691\tWGXLXNKO\tLBYMWEZCHRSNYPTCCXKRLQB\t\tDHBHVQPYOEDJSOKKDZTUNHRMZYQZWBHMBUXPN\tYSYUCK\tOUICWEKGHV\t2015-07-10T00:00:06.691Z\tNaN\tNaN\tNaN\t\t\t\n6728\tHSFLSXTYEWWWMD\tSXVIHKWQQBSUYEKLTRVMQFZO\t\tIGOQUCGCKOJSSRVJWBCPYYNEWTQKCTCERGHDDGWKLOXBFDEKPKRMDKKENJFN\tRZ\tZRPFMDVVG\t2015-07-10T00:00:06.728Z\tNaN\tNaN\tNaN\t\t\t\n6826\tVJDZ\tMGXBJXCFJHWCFDOTZLCPJSLFXTYIM\t\tTVPRLEMKQZZIIPCFGUKKKOBNTRPYVHMRUDUDSGZXTIFXWRFULWVWOHHJDZ\tCR\tVMC\t2015-07-10T00:00:06.826Z\tNaN\tNaN\tNaN\t\t\t\n6926\tZYESDDCGOGFUO\tWRDFOEFONJSPFGTUCKMIZWXIE\t\tVFJBNWHQVHMPJKSTXZXPQTOIMSJNCNRLUGQW\tIYFKD\tTI\t2015-07-10T00:00:06.926Z\tNaN\tNaN\tNaN\t\t\t\n7021\tNLKYHGO\tRHGHYBZOMJJBVLGGPHG\t\tFJQMODHRBKVLZWSJUWMLJFVUKIZJVZBBFNMXZOQJFWZDVYQCQXRUSBSDOIBLSS\tPQVCYTWYLEK\tOEZBRQ\t2015-07-10T00:00:07.021Z\tNaN\tNaN\tNaN\t\t\t\n7053\tWNSMHNXS\tOBSJHVQXMOJ\t\tEFVJTGURNJJZJIMUREPGMEJXDXDERDRXIMFZHYCZVKTDTBPYJQQPGYLIKPPBL\tPOWZIJQNISFYFN\tLPTYXYGY\t2015-07-10T00:00:07.053Z\tNaN\tNaN\tNaN\t\t\t\n7056\tGTLEUE\tQWBCXBXNDFRPOQLROOEXRSFPUSFN\t\tROFOTIRXJTZWT\tBVTVUBQ\tWUVMBPSVEZDYHDH\t2015-07-10T00:00:07.056Z\tNaN\tNaN\tNaN\t\t\t\n7122\tVCCO\tOJDYZWTUYNGWQNWEGOXYMJ\t\tPTWRSXZVZRNYUQDXLLOQVRMNLZUQRYIIYYJZBZGBKBRELDNPCM\tWCECUHSTCHICVIW\tIHZBWWXF\t2015-07-10T00:00:07.122Z\tNaN\tNaN\tNaN\t\t\t\n7175\t\tSMSPDCSPNTOUVUVWG\t\tMWVXGQOPEFIW\tRTCGYGSMWYFHIK\tUXI\t2015-07-10T00:00:07.175Z\tNaN\tNaN\tNaN\t\t\t\n7262\tVIXUVVWCWWTZVTT\tRHWJQEDZTDLZZODEC\t\tJMYKVBGFRCCVBPIYJFGUO\tZINNITZWLZJ\tLPTYXYGY\t2015-07-10T00:00:07.262Z\tNaN\tNaN\tNaN\t\t\t\n7347\tVJDIMVDXSZJGONW\tQEHBEOGUKYJKMDKXYVTB\t\tMKOZKMNYESGUFQEWJJONMJXZGYKDZOFNIYCVCIIBPDKRMFXJURGLV\tXKRKNOBFOHRVHHK\tHSQSPZ\t2015-07-10T00:00:07.347Z\tNaN\tNaN\tNaN\t\t\t\n7473\tEIZFIQOXKQTL\tRMTGUNFYICLTNRPOINOKISQR\t\tUTKENDEUCPB\tDDQ\tQXSPEPTTKIB\t2015-07-10T00:00:07.473Z\tNaN\tNaN\tNaN\t\t\t\n7478\tVKQEOSR\tCNBBUPHUEXWJURYENCJMSSZLDOUET\t\tDLEJKKEWPSMEVYFWRXFIISVPMQWCPJR\tXGXTKBZLML\tZYNPPBX\t2015-07-10T00:00:07.478Z\tNaN\tNaN\tNaN\t\t\t\n7497\tLFQGLDWFRXXG\tMOTZVCZZCSN\t\tPLZSQJTXPZBYGCNVCLJJYZWVCDLBEQOLFDGEQIHMGQKTXOEWYHEWVYXCOGWJMCU\tHUSKKOVGLEYFTS\tVELLKKHTWNWI\t2015-07-10T00:00:07.497Z\tNaN\tNaN\tNaN\t\t\t\n7513\tV\tNPKCEVYISMIEZ\t\tSHKVNSEIDEJZYBDRJXJXUHFWPHQDJGYGUBFWHHBPZXPTUZNZBZQM\t\tGSTEQODRZEIWFOQ\t2015-07-10T00:00:07.513Z\tNaN\tNaN\tNaN\t\t\t\n7644\tPGZGVZCOFMMUE\tDKDC\t\tQSTEVZPEHUZVOWSTSWXBTUWEGQQIPN\tSQQGPYG\tUOUIGENFELWWRSL\t2015-07-10T00:00:07.644Z\tNaN\tNaN\tNaN\t\t\t\n7737\tIXTXWXNRTEV\tOLMYQTMBOETE\t\tCSINBVKDS\tSVZXEVCRGW\tXGZMDJTHMHZN\t2015-07-10T00:00:07.737Z\tNaN\tNaN\tNaN\t\t\t\n7911\tB\tHBDFCVYUERTYMXRVDKJHWG\t\tUXZBGJRUXHSDUDRIOCUIICKOZSVXHDYXEKDDVFTPGRQWIZYIOBMZFMYHZH\tLNXNEFZQJYO\tJBF\t2015-07-10T00:00:07.911Z\tNaN\tNaN\tNaN\t\t\t\n7961\tFLBPTOLRBCSL\tXUE\t\tXGHYVHINXWPB\tYTMTUHYYRKUHLUQ\tVFZF\t2015-07-10T00:00:07.961Z\tNaN\tNaN\tNaN\t\t\t\n7968\tRXSC\tHGHZDQS\t\tEGRPGPPRXJUPJLGCRETXZNNHBPNWRFBBHEMODPJZLDYKWBY\tIK\tRGOONFCLTJCKFMQ\t2015-07-10T00:00:07.968Z\tNaN\tNaN\tNaN\t\t\t\n7976\tDEXNQWBDJQEHUM\tQIFWWFNVZUZJNJQ\t\tKOIY\tWV\tFSUWPNXHQUT\t2015-07-10T00:00:07.976Z\tNaN\tNaN\tNaN\t\t\t\n8074\tBFGSXPKVKURV\t\t\tTIGRLGDVMMCIMHXICXJWRWLPKCRQRQFIOTGHXHGVDIRMRUMV\tF\tPJEUKW\t2015-07-10T00:00:08.074Z\tNaN\tNaN\tNaN\t\t\t\n8113\tDDGFSZHOG\tPBV\t\tXFBTRICSWEOBKHUFDRSNFDEXDFTMEHBKQPKRRQFPTZKFRXRGJWE\tFTID\t\t2015-07-10T00:00:08.113Z\tNaN\tNaN\tNaN\t\t\t\n8121\tELZPVWLPQQO\tIJHLCIPMKJBHKRNYRRIBCWQTWHFMC\t\tJSCYBPOMOFRYEFHZNYNTTMLGFJHLLKIKMOMC\tLDGWBHIQNE\tINLKFNUH\t2015-07-10T00:00:08.121Z\tNaN\tNaN\tNaN\t\t\t\n8130\tSYGBYFSNQOT\tINUCPVCRKPQSKZOSNQQSLKDELFSVVDI\t\tXQGGHWGJZDKHLDCJSBQYKXZUMWQLHUOTDZCEJRZPF\tYXKQOIT\tZI\t2015-07-10T00:00:08.130Z\tNaN\tNaN\tNaN\t\t\t\n8199\tJWFODJS\tOMOIJIUGNUZMSXEK\t\tIFRCSLFUDRPRMLHTBXLFOVRZNTENWJMKFHOZEGVBX\tLFEQGRKKBPMI\tGSTEQODRZEIWFOQ\t2015-07-10T00:00:08.199Z\tNaN\tNaN\tNaN\t\t\t\n8284\t\tJKYMSFW\t\tFZQPSJETVHJVVOIZRITTFEPZMEJHDXYGHWDNUEIIEXCFVTV\tMRMRGTUFNZHXKQY\tFEVHK\t2015-07-10T00:00:08.284Z\tNaN\tNaN\tNaN\t\t\t\n8320\tWGCFDLNDIEW\tORDODPC\t\tTTHPTKYEYYP\tXOYOEMXIEGP\tOVFDBZWNI\t2015-07-10T00:00:08.320Z\tNaN\tNaN\tNaN\t\t\t\n8379\tQQPSQOPG\tVLSFYVGGHMGVPIGUJCBZS\t\tZCRHPDJMWNSLOMQZXPNFMHGZKLUNEUUDMYBXWRFYRPIFIRSSEEINLIHHXSHZEZZ\tEW\tWUVMBPSVEZDYHDH\t2015-07-10T00:00:08.379Z\tNaN\tNaN\tNaN\t\t\t\n8532\tCGOSJWM\tGZEFSMRLMUULNJDSOKJOR\t\t\tSHXMT\tHNZH\t2015-07-10T00:00:08.532Z\tNaN\tNaN\tNaN\t\t\t\n8549\tXKGGQNZPZXDWF\tNFEBNUVEQJOPWKHYEXVWEMHNQKD\t\tLQRZKJEGFWQIEHNDQNSLLEJKYHHGCEF\t\tJFRPXZSF\t2015-07-10T00:00:08.549Z\tNaN\tNaN\tNaN\t\t\t\n8567\tRUDDLZNHGVHZO\tKOZOOJWDDO\t\tRMJURFHFUWRFYYROGJUKEKJTIOKSOMWQCIGBXGTHJJBHFFFEUXJQPOGQL\tFFKJOOXKH\tRJUEBWV\t2015-07-10T00:00:08.567Z\tNaN\tNaN\tNaN\t\t\t\n8821\tZ\tHEDEUYVXYULDEDVOZTIXLRHX\t\tLBZKRTLMHHZQYJTHVKTHTQCZUTYNTSRIEFIVJIT\tBUOIOYPUMWUHEI\tTOGM\t2015-07-10T00:00:08.821Z\tNaN\tNaN\tNaN\t\t\t\n9021\tMSM\tMJWVDCOWPQFCDB\t\tEFTSFYICZHJLOPKNJTSKMGPBIZUTTXSZCIBKIMNHPEEX\tMIKOFVNI\tVFZF\t2015-07-10T00:00:09.021Z\tNaN\tNaN\tNaN\t\t\t\n9180\tDX\tLMHJXBDPMRECNYXZ\t\tTYDLLXJTKOFTUPQXUSEWRSQCLENIOMZPSW\tYS\t\t2015-07-10T00:00:09.180Z\tNaN\tNaN\tNaN\t\t\t\n9752\t\tKIJZZXFXHTCOEJPWMICBQOXQQQPBGF\t\tSWSMBCZIORTGCWCFVXSYKTLDCDLJQEKZLJVTLIJSLXH\tCSRXHZCODL\tGSTEQODRZEIWFOQ\t2015-07-10T00:00:09.752Z\tNaN\tNaN\tNaN\t\t\t\n9754\tVBUNKYVVGQLKQCD\tBOOFXUSIVEHEJIOTLOYTCCKIVVUHQ\t\tFGFXYRFCNLJEWVEQYHNESWJRBYQBQP\tIPEWMGFDPQH\tXLQLUUZIZKMFCKV\t2015-07-10T00:00:09.754Z\tNaN\tNaN\tNaN\t\t\t\n9782\tOIGUBDZRIHVSSH\tFKXP\t\tYCDPIVPZVGZOTUBFPLOVJRWTQLQW\tRVYMWKMJEYMFNNL\tEVQTQ\t2015-07-10T00:00:09.782Z\tNaN\tNaN\tNaN\t\t\t\n9977\tINDD\tMIRNGQQJMVOHKXHIYFMUMLXDGEQIEGT\t\tXULPFZVERXTYXHEIXXTUSJFKTHCHSXYTBLILZKTHJTFSFQPTUZHIURBOMPGHUR\tMUIYMRYE\tWLZKDMPVR\t2015-07-10T00:00:09.977Z\tNaN\tNaN\tNaN\t\t\t\n9992\tHTEOO\tFEVRVVUBNQZINQYGSBOXQGTVNRLXE\t\tHJBNFHODEFEMCKSVYWTQPMEVLLSJINDCHSPTIZDB\tDXIUYZNJ\tORD\t2015-07-10T00:00:09.992Z\tNaN\tNaN\tNaN\t\t\t\n", "customers c outer join orders o on c.customerId = o.customerId  where o.orderId = NaN");
    }

    @Test
    public void testOuterExistence1() throws Exception {
        this.assertPlan("+ 0[ cross ] c\n+ 1[ outer ] o ON o.customerId = c.customerId (post-filter: null = orderId)\n\n", "customers c outer join orders o on c.customerId = o.customerId where null = orderId");
    }

    @Test
    public void testOuterExistence2() throws Exception {
        this.assertPlan("+ 0[ cross ] c\n+ 1[ outer ] o ON o.customerId = c.customerId (post-filter: orderId = null)\n\n", "customers c outer join orders o on c.customerId = o.customerId where orderId = null");
    }

    @Test
    public void testOuterExistence3() throws Exception {
        this.assertPlan("+ 0[ cross ] c\n+ 1[ outer ] o ON o.customerId = c.customerId (post-filter: orderId = NaN)\n\n", "customers c outer join orders o on c.customerId = o.customerId where orderId = NaN");
    }

    @Test
    public void testOuterJoin() throws Exception {
        this.assertThat("ZKX\tGZW\t857841416\t1083\nZKX\tGZW\t1032890405\tNaN\nZKX\tGZW\t783791714\t927\nZKX\tGZW\t783791714\t586\nZKX\tGZW\t783791714\t1065\nZKX\tGZW\t1662033722\t542\nZKX\tGZW\t1662033722\t389\nZKX\tGZW\t337191226\t1472\nZKX\tGZW\t337191226\t1577\nZKX\tGZW\t337191226\t393\nZKX\tGZW\t1360393259\t1615\nZKX\tGZW\t1360393259\t778\nZKX\tGZW\t163580596\t1256\nZKX\tGZW\t163580596\t1017\nZKX\tGZW\t163580596\t612\nZKX\tGZW\t1569321724\t1464\nZKX\tGZW\t115845726\t1922\nZKX\tGZW\t115845726\t1360\nZKX\tGZW\t115845726\t1192\nZKX\tGZW\t115845726\t1485\nZKX\tGZW\t1565417569\t1122\nZKX\tGZW\t1565417569\t1803\nZKX\tGZW\t1678218138\t1686\nZKX\tGZW\t1678218138\t969\nZKX\tGZW\t1315811593\t1398\nZKX\tGZW\t1315811593\t25\n", "select country, customerName, o.orderId, d.productId from orders o outer join customers c on c.customerId = o.customerId outer join (orderDetails where orderId != 1032890405) d on o.orderId = d.orderId where country ~ '^Z' and customerName = 'GZW'");
    }

    @Test
    public void testRegexConstantTransitivityRhs() throws Exception {
        this.assertPlan("+ 0[ cross ] c (filter: c.customerId ~ '100')\n+ 1[ outer ] o (filter: o.customerId ~ '100') ON o.customerId = c.customerId\n\n", "customers c outer join orders o on c.customerId = o.customerId where c.customerId ~ '100'");
    }

    @Test
    public void testSearchUnIndexedSymbol() throws Exception {
        this.assertThat("DJSBQG\tDRNUY\tMJSMUTZN\tYHGWBYMZE\tTZ\tNYRZLCBDM\tTEMGDPQYTYUTOPS\t2015-07-10T00:00:12.100Z\n", "suppliers where supplier = 'DJSBQG'");
    }

    @Test
    public void testSimpleIntLambda() throws Exception {
        String expected = "1935884354\t100\t1503\tD\t2015-07-10T00:01:43.507Z\tRZVZJQRNYSRKZSJ\n";
        this.assertThat("1935884354\t100\t1503\tD\t2015-07-10T00:01:43.507Z\tRZVZJQRNYSRKZSJ\n", "orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)");
        this.assertThat("1935884354\t100\t1503\tD\t2015-07-10T00:01:43.507Z\tRZVZJQRNYSRKZSJ\n", "orders latest by customerId where customerId = 100");
    }

    @Test
    public void testSimpleStrToStrLambda() throws Exception {
        this.assertThat("751505590\t9029\t1516\tFQP\t2015-07-10T00:01:52.290Z\tYGFSMEVDSIYC\n", "orders latest by employeeId where employeeId in (`employees where firstName = 'DU'`)");
    }

    @Test
    public void testSimpleStrToSymLambda() throws Exception {
        this.assertThat("751505590\t9029\t1516\tFQP\t2015-07-10T00:01:52.290Z\tYGFSMEVDSIYC\n", "orders latest by employeeId where employeeId in (`select _atos(employeeId) from employees where firstName = 'DU'`)");
    }

    @Test
    public void testSimpleSymToStrLambda() throws Exception {
        this.assertThat("1946\tEOVGVPEHSZQJGNI\tGROTGCLGILNCXPT\tCOHPFXH\t0.175451457500\t2015-07-10T00:00:14.146Z\n", "products latest by supplier where supplier in (`select _stoa(supplier) from suppliers where contactName = 'PHT'`)");
    }

    @Test
    public void testSimpleSymToSymLambda() throws Exception {
        this.assertThat("1946\tEOVGVPEHSZQJGNI\tGROTGCLGILNCXPT\tCOHPFXH\t0.175451457500\t2015-07-10T00:00:14.146Z\n", "products latest by supplier where supplier in (`suppliers where contactName = 'PHT'`)");
    }

    @Test
    public void testSimpleSymToSymLambdaAliased() throws Exception {
        this.assertThat("1946\tGROTGCLGILNCXPT\n", "select productId, supplier s from products latest by s where s in (`suppliers where contactName = 'PHT'`)");
    }

    @Test
    public void testSymRegex() {
        try {
            this.expectFailure("select country, avg(quantity) from orders o join customers c on c.customerId = o.customerId join orderDetails d on o.orderId = d.orderId where country ~ null");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)153L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testSymRegexSyntaxError() {
        try {
            this.expectFailure("select country, avg(quantity) from orders o join customers c on c.customerId = o.customerId join orderDetails d on o.orderId = d.orderId where country ~ '^Z)'");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)156L, (long)QueryError.getPosition());
            Assert.assertTrue((boolean)QueryError.getMessage().toString().contains("Regex syntax"));
        }
    }

    @Test
    public void testThreeWayNoSelect() throws Exception {
        this.assertThat("customerId\tcustomerName\tcontactName\taddress\tcity\tpostalCode\tcountry\ttimestamp\torderId\tcustomerId\tproductId\temployeeId\torderDate\tshipper\tproductId\tproductName\tsupplier\tcategory\tprice\ttimestamp\n2\tQELQ\tWQGMZBPHETSLOIMSUFXYIWEODDBH\t\tVGXYHJUXBWYWRLHUHJECIDLRBIDSTDTFBY\tS\tDCQSCMONRC\t2015-07-10T00:00:00.002Z\t1575627983\t2\t1923\t\t2015-07-10T00:00:31.796Z\tFBLGGTZEN\t1923\tVXZESTU\tLFQNDNRHKUHE\tDDKZCNBOGWTL\t992.000000000000\t2015-07-10T00:00:14.123Z\n2\tQELQ\tWQGMZBPHETSLOIMSUFXYIWEODDBH\t\tVGXYHJUXBWYWRLHUHJECIDLRBIDSTDTFBY\tS\tDCQSCMONRC\t2015-07-10T00:00:00.002Z\t1628627044\t2\t1881\tRIXTM\t2015-07-10T00:00:37.249Z\tYGFSMEVDSIYC\t1881\tDJHDQX\tFUXEJFTGSLMCBRD\tKFGXCKKLNVVIQ\t0.000000000000\t2015-07-10T00:00:14.081Z\n2\tQELQ\tWQGMZBPHETSLOIMSUFXYIWEODDBH\t\tVGXYHJUXBWYWRLHUHJECIDLRBIDSTDTFBY\tS\tDCQSCMONRC\t2015-07-10T00:00:00.002Z\t541627843\t2\t1216\tUJ\t2015-07-10T00:00:43.578Z\tQPL\t1216\tHZBDMUQLOTHMCHO\tZZCPO\tKSEOSRN\t-234.332031250000\t2015-07-10T00:00:13.416Z\n2\tQELQ\tWQGMZBPHETSLOIMSUFXYIWEODDBH\t\tVGXYHJUXBWYWRLHUHJECIDLRBIDSTDTFBY\tS\tDCQSCMONRC\t2015-07-10T00:00:00.002Z\t1502016981\t2\t516\tRK\t2015-07-10T00:00:48.192Z\tOJXJCNBLYTOIYI\t516\tBJUHPV\tUHSSLJ\tQR\t279.675109863281\t2015-07-10T00:00:12.716Z\n2\tQELQ\tWQGMZBPHETSLOIMSUFXYIWEODDBH\t\tVGXYHJUXBWYWRLHUHJECIDLRBIDSTDTFBY\tS\tDCQSCMONRC\t2015-07-10T00:00:00.002Z\t1370796605\t2\t1242\t\t2015-07-10T00:00:55.216Z\tYJZPHQDJKOM\t1242\tFLTGLC\tF\tSQDBRUMST\t0.000001773577\t2015-07-10T00:00:13.442Z\n", "customers outer join orders o on customers.customerId = o.customerId  join products p on o.productId = p.productId limit 25,30", true);
    }

    @Test
    public void testThreeWaySelectAlias() throws Exception {
        this.assertThat("c.customerId\to.customerId\tp.productId\torderId\n2\t2\t1923\t1575627983\n2\t2\t1881\t1628627044\n2\t2\t1216\t541627843\n2\t2\t516\t1502016981\n2\t2\t1242\t1370796605\n", "select c.customerId, o.customerId, p.productId, orderId  from customers c outer join orders o on c.customerId = o.customerId  join products p on o.productId = p.productId limit 25,30", true);
    }

    @Test
    public void testThreeWaySelectNoAlias() throws Exception {
        this.assertThat("customers.customerId\to.customerId\tp.productId\torderId\n2\t2\t1923\t1575627983\n2\t2\t1881\t1628627044\n2\t2\t1216\t541627843\n2\t2\t516\t1502016981\n2\t2\t1242\t1370796605\n", "select customers.customerId, o.customerId, p.productId, orderId  from customers outer join orders o on customers.customerId = o.customerId  join products p on o.productId = p.productId limit 25,30", true);
    }

    @Test
    public void testWithClauseErrorOffset() {
        try {
            this.expectFailure("with o as (select '1' blah, lastName, employeeId customerId, timestamp from employees where lastName ~ '(' order by lastName), a as (select '1' blah, lastName, employeeId customerId, timestamp from employees where lastName ~ 'UBB' order by lastName) select lastName from a x join o on (customerId)");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)106L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testWithClauseInJoin() throws Exception {
        this.assertPlan2("{\n  \"op\": \"AsOfPartitionedJoinRecordSource\",\n  \"master\": {\n    \"op\": \"JournalRecordSource\",\n    \"psrc\": {\n      \"op\": \"JournalPartitionSource\",\n      \"journal\": \"customers\"\n    },\n    \"rsrc\": {\n      \"op\": \"AllRowSource\"\n    }\n  },\n  \"slave\": {\n    \"op\": \"RBTreeSortedRecordSource\",\n    \"byRowId\": true,\n    \"src\": {\n      \"op\": \"SelectedColumnsRecordSource\",\n      \"src\": {\n        \"op\": \"VirtualColumnRecordSource\",\n        \"src\": {\n          \"op\": \"JournalRecordSource\",\n          \"psrc\": {\n            \"op\": \"JournalPartitionSource\",\n            \"journal\": \"employees\"\n          },\n          \"rsrc\": {\n            \"op\": \"AllRowSource\"\n          }\n        }\n      }\n    }\n  },\n  \"masterTsIndex\": 7,\n  \"slaveTsIndex\": 3\n}", "with o as (select '1' blah, lastName, employeeId customerId, timestamp from employees order by lastName)customers c asof join o on (customerId)");
    }

    private static void generateJoinData() throws JournalException, NumericException {
        try (JournalWriter customers = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("customers").$int("customerId").$str("customerName").$str("contactName").$str("address").$str("city").$str("postalCode").$sym("country").$ts());
             JournalWriter categories = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("categories").$sym("category").index().buckets(100).$str("description").$ts());
             JournalWriter employees = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("employees").$str("employeeId").index().buckets(2048).$str("firstName").$str("lastName").$date("birthday").$ts());
             JournalWriter orderDetails = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orderDetails").$int("orderDetailId").$int("orderId").$int("productId").$int("quantity").$ts());
             JournalWriter orders = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orders").$int("orderId").$int("customerId").index().$int("productId").$str("employeeId").index().$ts("orderDate").$sym("shipper").$());
             JournalWriter products = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("products").$int("productId").$str("productName").$sym("supplier").index().buckets(100).$sym("category").index().buckets(100).$double("price").$ts());
             JournalWriter shippers = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("shippers").$sym("shipper").$str("phone").$ts());
             JournalWriter suppliers = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("suppliers").$sym("supplier").buckets(100).$str("contactName").$str("address").$str("city").$str("postalCode").$sym("country").index().$str("phone").$ts());){
            JournalEntryWriter w;
            int i;
            JournalEntryWriter w2;
            int i2;
            JournalEntryWriter w3;
            int i3;
            Rnd rnd = new Rnd();
            long time = DateFormatUtils.parseDateTime((CharSequence)"2015-07-10T00:00:00.000Z");
            int countryCount = 196;
            ObjList countries = new ObjList();
            for (int i4 = 0; i4 < countryCount; ++i4) {
                countries.add((Object)rnd.nextString(rnd.nextInt() & 0xF));
            }
            IntHashSet blackList = new IntHashSet();
            int customerCount = 10000;
            for (i3 = 0; i3 < customerCount; ++i3) {
                if (rnd.nextPositiveInt() % 100 == 0) {
                    blackList.add(i3);
                }
                w3 = customers.entryWriter();
                w3.putInt(0, i3);
                w3.putStr(1, rnd.nextChars(rnd.nextInt() & 0xF));
                w3.putStr(2, rnd.nextChars(rnd.nextInt() & 0x1F));
                w3.putStr(4, rnd.nextChars(rnd.nextInt() & 0x3F));
                w3.putStr(5, rnd.nextChars(rnd.nextInt() & 0xF));
                w3.putSym(6, (CharSequence)countries.getQuick(rnd.nextPositiveInt() % 196));
                w3.putDate(7, time++);
                w3.append();
            }
            customers.commit();
            for (i3 = 0; i3 < 100; ++i3) {
                w3 = categories.entryWriter();
                w3.putSym(0, rnd.nextChars(rnd.nextInt() & 0xF));
                w3.putStr(1, rnd.nextChars(rnd.nextInt() & 0x3F));
                w3.putDate(2, time++);
                w3.append();
            }
            categories.commit();
            int employeeCount = 2000;
            for (i2 = 0; i2 < employeeCount; ++i2) {
                w2 = employees.entryWriter();
                w2.putStr(0, rnd.nextChars(rnd.nextInt() & 7));
                w2.putStr(1, rnd.nextChars(rnd.nextInt() & 0xF));
                w2.putStr(2, rnd.nextChars(rnd.nextInt() & 0xF));
                w2.putDate(3, 0L);
                w2.putDate(4, time++);
                w2.append();
            }
            employees.commit();
            for (i2 = 0; i2 < 100; ++i2) {
                w2 = suppliers.entryWriter();
                w2.putSym(0, rnd.nextChars(rnd.nextInt() & 0xF));
                w2.putStr(1, rnd.nextChars(rnd.nextInt() & 0xF));
                w2.putStr(2, rnd.nextChars(rnd.nextInt() & 0xF));
                w2.putStr(3, rnd.nextChars(rnd.nextInt() & 0xF));
                w2.putStr(4, rnd.nextChars(rnd.nextInt() & 7));
                w2.putSym(5, (CharSequence)countries.getQuick(rnd.nextPositiveInt() % countryCount));
                w2.putStr(6, rnd.nextChars(rnd.nextInt() & 0xF));
                w2.putDate(7, time++);
                w2.append();
            }
            suppliers.commit();
            MMappedSymbolTable categoryTab = categories.getSymbolTable("category");
            int categoryTabSize = categoryTab.size();
            MMappedSymbolTable supplierTab = suppliers.getSymbolTable("supplier");
            int supplierTabSize = supplierTab.size();
            int productCount = 2000;
            for (i = 0; i < productCount; ++i) {
                w = products.entryWriter();
                w.putInt(0, i);
                w.putStr(1, rnd.nextChars(rnd.nextInt() & 0xF));
                w.putSym(2, (CharSequence)supplierTab.value(rnd.nextPositiveInt() % supplierTabSize));
                w.putSym(3, (CharSequence)categoryTab.value(rnd.nextPositiveInt() % categoryTabSize));
                w.putDouble(4, rnd.nextDouble());
                w.putDate(5, time++);
                w.append();
            }
            products.commit();
            for (i = 0; i < 20; ++i) {
                w = shippers.entryWriter();
                w.putSym(0, rnd.nextChars(rnd.nextInt() & 0xF));
                w.putStr(1, rnd.nextChars(rnd.nextInt() & 7));
                w.append();
            }
            shippers.commit();
            MMappedSymbolTable shipperTab = shippers.getSymbolTable("shipper");
            int shipperTabSize = shipperTab.size();
            int d = 0;
            for (int i5 = 0; i5 < 100000; ++i5) {
                int customerId = rnd.nextPositiveInt() % customerCount;
                if (blackList.contains(customerId)) continue;
                int orderId = rnd.nextPositiveInt();
                JournalEntryWriter w4 = orders.entryWriter(time++);
                w4.putInt(0, orderId);
                w4.putInt(1, customerId);
                w4.putInt(2, rnd.nextPositiveInt() % productCount);
                w4.putStr(3, employees.getPartition(0, true).getFlyweightStr(rnd.nextPositiveLong() % (long)employeeCount, 0));
                w4.putSym(5, (CharSequence)shipperTab.value(rnd.nextPositiveInt() % shipperTabSize));
                w4.append();
                int k = (rnd.nextInt() & 3) + 1;
                for (int n = 0; n < k; ++n) {
                    JournalEntryWriter dw = orderDetails.entryWriter();
                    dw.putInt(0, ++d);
                    dw.putInt(1, orderId);
                    dw.putInt(2, rnd.nextPositiveInt() % productCount);
                    dw.putInt(3, (rnd.nextInt() & 3) + 1);
                    dw.append();
                }
            }
            orders.commit();
            orderDetails.commit();
        }
    }
}

