/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.ExprAstBuilder;
import com.questdb.parser.sql.ExprListener;
import com.questdb.parser.sql.ExprParser;
import com.questdb.parser.sql.PostOrderTreeTraversalAlgo;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.parser.sql.RpnBuilder;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.std.Lexer;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ObjectPool;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class InvertedBooleanOptimisationTest
extends AbstractTest {
    private final RpnBuilder rpn = new RpnBuilder();
    private final ObjectPool<ExprNode> exprNodeObjectPool = new ObjectPool((ObjectFactory)ExprNode.FACTORY, 128);
    private final Lexer lexer = new Lexer();
    private final ExprParser p = new ExprParser(this.exprNodeObjectPool);
    private final ExprAstBuilder ast = new ExprAstBuilder();
    private final PostOrderTreeTraversalAlgo traversalAlgo = new PostOrderTreeTraversalAlgo();
    private final PostOrderTreeTraversalAlgo.Visitor rpnBuilderVisitor = this.rpn::onNode;
    private final QueryCompiler compiler = new QueryCompiler();

    @Before
    public void setUp() {
        this.exprNodeObjectPool.clear();
        ExprParser.configureLexer((Lexer)this.lexer);
    }

    @Test
    public void testDoubleInversion() throws Exception {
        this.assertOk("ba>", "not (not (a > b))");
    }

    @Test
    public void testFunction() throws Exception {
        this.assertOk("'b''a'ainnot", "not(a in ('a', 'b'))");
    }

    @Test
    public void testInvertAnd() throws Exception {
        this.assertOk("dc!=ba=or", "not (a != b and c = d)");
    }

    @Test
    public void testInvertAnd2() throws Exception {
        this.assertOk("'xyz'x~notdc!=ba=oror", "not (a != b and c = d and x ~ 'xyz')");
    }

    @Test
    public void testInvertEquals() throws Exception {
        this.assertOk("ba!=", "not (a = b)");
    }

    @Test
    public void testInvertGreater() throws Exception {
        this.assertOk("ba<=", "not (a > b)");
    }

    @Test
    public void testInvertGreaterOrEqual() throws Exception {
        this.assertOk("ba<", "not (a >= b)");
    }

    @Test
    public void testInvertLess() throws Exception {
        this.assertOk("ba>=", "not (a < b)");
    }

    @Test
    public void testInvertLessOrEqual() throws Exception {
        this.assertOk("ba>", "not (a <= b)");
    }

    @Test
    public void testInvertNotEquals() throws Exception {
        this.assertOk("ba=", "not (a != b)");
    }

    @Test
    public void testInvertOr() throws Exception {
        this.assertOk("dc<=ba<=and", "not (a > b or c > d)");
    }

    @Test
    public void testInvertOrAndAnd() throws Exception {
        this.assertOk("10c!=dc>ba<=andor", "not (a > b or not(c > d) and c = 10)");
    }

    @Test
    public void testLiteral() throws Exception {
        this.assertOk("anot", "not(a)");
    }

    @Test
    public void testNoInversion() throws Exception {
        this.assertOk("cb+a>", "(a > (b + c))");
    }

    private void assertOk(CharSequence expected, String expression) throws ParserException {
        this.lexer.setContent((CharSequence)expression);
        this.p.parseExpr(this.lexer, (ExprListener)this.ast);
        ExprNode n = this.compiler.optimiseInvertedBooleans(this.ast.poll(), false);
        Assert.assertNotNull((Object)n);
        TestUtils.assertEquals(expected, this.toRpn(n));
    }

    private CharSequence toRpn(ExprNode node) throws ParserException {
        this.rpn.reset();
        this.traversalAlgo.traverse(node, this.rpnBuilderVisitor);
        return this.rpn.rpn();
    }
}

