/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.IntervalCompiler;
import com.questdb.std.LongList;
import com.questdb.std.time.DateFormatUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntervalCompilerTest {
    private final LongList a = new LongList();
    private final LongList b = new LongList();
    private final LongList out = new LongList();

    @Before
    public void setUp() {
        this.a.clear();
        this.b.clear();
        this.out.clear();
    }

    @Test
    public void testIntersectContain2() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T09:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:30:00.000Z"));
        this.assertIntersect("[Interval{lo=2016-03-10T10:00:00.000Z, hi=2016-03-10T12:00:00.000Z}]");
    }

    @Test
    public void testIntersectMergeOverlap() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.assertIntersect("[Interval{lo=2016-03-10T11:00:00.000Z, hi=2016-03-10T12:00:00.000Z}]");
    }

    @Test
    public void testIntersectMergeOverlap2() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.assertIntersect("[Interval{lo=2016-03-10T11:00:00.000Z, hi=2016-03-10T12:00:00.000Z}]");
    }

    @Test
    public void testIntersectNoOverlap() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T16:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:30:00.000Z"));
        this.assertIntersect("[]");
    }

    @Test
    public void testIntersectSame() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.assertIntersect("[Interval{lo=2016-03-10T10:00:00.000Z, hi=2016-03-10T12:00:00.000Z}]");
    }

    @Test
    public void testIntersectTwoOverlapOne2() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T16:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T15:00:00.000Z"));
        this.assertIntersect("[Interval{lo=2016-03-10T11:00:00.000Z, hi=2016-03-10T12:00:00.000Z},Interval{lo=2016-03-10T14:00:00.000Z, hi=2016-03-10T15:00:00.000Z}]");
    }

    @Test
    public void testParseLongInterval22() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2015-03-12T10:00:00.000Z, hi=2015-03-12T10:05:00.999Z},Interval{lo=2015-03-12T10:30:00.000Z, hi=2015-03-12T10:35:00.999Z},Interval{lo=2015-03-12T11:00:00.000Z, hi=2015-03-12T11:05:00.999Z},Interval{lo=2015-03-12T11:30:00.000Z, hi=2015-03-12T11:35:00.999Z},Interval{lo=2015-03-12T12:00:00.000Z, hi=2015-03-12T12:05:00.999Z},Interval{lo=2015-03-12T12:30:00.000Z, hi=2015-03-12T12:35:00.999Z},Interval{lo=2015-03-12T13:00:00.000Z, hi=2015-03-12T13:05:00.999Z},Interval{lo=2015-03-12T13:30:00.000Z, hi=2015-03-12T13:35:00.999Z},Interval{lo=2015-03-12T14:00:00.000Z, hi=2015-03-12T14:05:00.999Z},Interval{lo=2015-03-12T14:30:00.000Z, hi=2015-03-12T14:35:00.999Z}]", "2015-03-12T10:00:00;5m;30m;10");
    }

    @Test
    public void testParseLongInterval32() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-21T00:00:00.000Z, hi=2021-03-21T23:59:59.999Z}]", "2016-03-21;3y;6M;5");
    }

    @Test
    public void testParseShortDayErr() {
        this.assertIntervalError("2016-02-30");
    }

    @Test
    public void testParseShortDayErr2() {
        this.assertIntervalError("2016-02-3");
    }

    @Test
    public void testParseShortHourErr1() {
        this.assertIntervalError("2016-02-15T1");
    }

    @Test
    public void testParseShortHourErr2() {
        this.assertIntervalError("2016-02-15T31");
    }

    @Test
    public void testParseShortHourErr3() {
        this.assertIntervalError("2016-02-15X1");
    }

    @Test
    public void testParseShortInterval1() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-01-01T00:00:00.000Z, hi=2016-12-31T23:59:59.999Z}]", "2016");
    }

    @Test
    public void testParseShortInterval2() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-01T00:00:00.000Z, hi=2016-03-31T23:59:59.999Z}]", "2016-03");
    }

    @Test
    public void testParseShortInterval3() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-21T00:00:00.000Z, hi=2016-03-21T23:59:59.999Z}]", "2016-03-21");
    }

    @Test
    public void testParseShortInterval32() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-21T00:00:00.000Z, hi=2016-03-21T23:59:59.999Z}]", "2016-03-21");
    }

    @Test
    public void testParseShortInterval4() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-21T10:00:00.000Z, hi=2016-03-21T10:59:59.999Z}]", "2016-03-21T10");
    }

    @Test
    public void testParseShortInterval5() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-21T10:30:00.000Z, hi=2016-03-21T10:30:59.999Z}]", "2016-03-21T10:30");
    }

    @Test
    public void testParseShortInterval6() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-21T10:30:40.000Z, hi=2016-03-21T10:30:40.999Z}]", "2016-03-21T10:30:40");
    }

    @Test
    public void testParseShortInterval7() throws Exception {
        IntervalCompilerTest.assertShortInterval("[Interval{lo=2016-03-21T10:30:40.100Z, hi=2016-03-21T10:30:40.100Z}]", "2016-03-21T10:30:40.100Z");
    }

    @Test
    public void testParseShortMilliErr() {
        this.assertIntervalError("2016-03-21T10:31:61.23");
    }

    @Test
    public void testParseShortMinErr() {
        this.assertIntervalError("2016-03-21T10:3");
    }

    @Test
    public void testParseShortMinErr2() {
        this.assertIntervalError("2016-03-21T10:69");
    }

    @Test
    public void testParseShortMonthErr() {
        this.assertIntervalError("2016-1");
    }

    @Test
    public void testParseShortMonthErr2() {
        this.assertIntervalError("2016x11");
    }

    @Test
    public void testParseShortMonthRange() {
        this.assertIntervalError("2016-66");
    }

    @Test
    public void testParseShortSecErr() {
        this.assertIntervalError("2016-03-21T10:31:61");
    }

    @Test
    public void testParseShortSecErr1() {
        this.assertIntervalError("2016-03-21T10:31:1");
    }

    @Test
    public void testParseShortYearErr() {
        this.assertIntervalError("201");
    }

    @Test
    public void testSubtractClipNone() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T15:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T13:30:00.000Z"));
        IntervalCompiler.subtract((LongList)this.a, (LongList)this.b, (LongList)this.out);
        Assert.assertEquals((Object)"[Interval{lo=2016-03-10T10:00:00.000Z, hi=2016-03-10T12:00:00.000Z},Interval{lo=2016-03-10T14:00:00.000Z, hi=2016-03-10T15:00:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)this.out));
    }

    @Test
    public void testSubtractClipTwo() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T15:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:30:00.000Z"));
        IntervalCompiler.subtract((LongList)this.a, (LongList)this.b, (LongList)this.out);
        Assert.assertEquals((Object)"[Interval{lo=2016-03-10T10:00:00.000Z, hi=2016-03-10T10:59:59.999Z},Interval{lo=2016-03-10T14:30:00.001Z, hi=2016-03-10T15:00:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)this.out));
    }

    @Test
    public void testSubtractConsume() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T14:00:00.000Z"));
        IntervalCompiler.subtract((LongList)this.a, (LongList)this.b, (LongList)this.out);
        Assert.assertEquals((Object)"[]", (Object)IntervalCompiler.asIntervalStr((LongList)this.out));
    }

    @Test
    public void testSubtractMakeHole() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:30:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T11:30:00.000Z"));
        IntervalCompiler.subtract((LongList)this.a, (LongList)this.b, (LongList)this.out);
        Assert.assertEquals((Object)"[Interval{lo=2016-03-10T10:00:00.000Z, hi=2016-03-10T10:29:59.999Z},Interval{lo=2016-03-10T11:30:00.001Z, hi=2016-03-10T12:00:00.000Z}]", (Object)IntervalCompiler.asIntervalStr((LongList)this.out));
    }

    @Test
    public void testSubtractSame() throws Exception {
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.a.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T10:00:00.000Z"));
        this.b.add(DateFormatUtils.parseDateTime((CharSequence)"2016-03-10T12:00:00.000Z"));
        IntervalCompiler.subtract((LongList)this.a, (LongList)this.b, (LongList)this.out);
        Assert.assertEquals((Object)"[]", (Object)IntervalCompiler.asIntervalStr((LongList)this.out));
    }

    private static void assertShortInterval(String expected, String interval) throws ParserException {
        LongList out = new LongList();
        IntervalCompiler.parseIntervalEx((CharSequence)interval, (int)0, (int)interval.length(), (int)0, (LongList)out);
        Assert.assertEquals((Object)expected, (Object)IntervalCompiler.asIntervalStr((LongList)out));
    }

    private void assertIntersect(String expected) {
        IntervalCompiler.intersect((LongList)this.a, (LongList)this.b, (LongList)this.out);
        Assert.assertEquals((Object)expected, (Object)IntervalCompiler.asIntervalStr((LongList)this.out));
    }

    private void assertIntervalError(String interval) {
        try {
            IntervalCompiler.parseIntervalEx((CharSequence)interval, (int)0, (int)interval.length(), (int)0, (LongList)this.out);
            Assert.fail();
        }
        catch (ParserException parserException) {
            // empty catch block
        }
    }
}

