/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.ExprListener;
import com.questdb.parser.sql.ExprParser;
import com.questdb.parser.sql.QueryError;
import com.questdb.parser.sql.RpnBuilder;
import com.questdb.parser.sql.model.ExprNode;
import com.questdb.std.Lexer;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ObjectPool;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ExprParserTest {
    private final ObjectPool<ExprNode> exprNodeObjectPool = new ObjectPool((ObjectFactory)ExprNode.FACTORY, 128);
    private final Lexer lexer = new Lexer();
    private final ExprParser parser = new ExprParser(this.exprNodeObjectPool);

    @Before
    public void setUp() {
        this.exprNodeObjectPool.clear();
        ExprParser.configureLexer((Lexer)this.lexer);
    }

    @Test
    public void testCommaExit() throws Exception {
        this.x("abxybzc*+", "a + b * c(b(x,y),z),");
    }

    @Test
    public void testComplexUnary1() throws Exception {
        this.x("4xyc-^", "4^-c(x,y)");
    }

    @Test
    public void testComplexUnary2() throws Exception {
        this.x("ab^-", "-a^b");
    }

    @Test
    public void testEqualPrecedence() throws Exception {
        this.x("abc^^", "a^b^c");
    }

    @Test
    public void testExprCompiler() throws Exception {
        this.x("ac098dzf+1234x+", "a+f(c,d(0,9,8),z)+x(1,2,3,4)");
    }

    @Test
    public void testIn() throws Exception {
        this.x("abcin", "a in (b,c)");
    }

    @Test
    public void testInOperator() throws Exception {
        this.x("a10=bxyinand", "a = 10 and b in (x,y)");
    }

    @Test
    public void testLambda() throws Exception {
        this.x("a`blah blah`inyand", "a in (`blah blah`) and y");
    }

    @Test
    public void testLiteralAndConstant() throws Exception {
        this.x("'a b'x", "x 'a b'");
    }

    @Test
    public void testLiteralExit() throws Exception {
        this.x("abxybzc*+", "a + b * c(b(x,y),z) lit");
    }

    @Test
    public void testMissingArgAtBraceError() {
        try {
            this.x("", "x * 4 + c(x,y,)");
            Assert.fail((String)"Expected syntax exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)14L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testMissingArgError() {
        try {
            this.x("", "x * 4 + c(x,,y)");
            Assert.fail((String)"Expected syntax exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)12L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testNestedFunctions() throws Exception {
        this.x("48yfrz", "z(4, r(f(8,y)))");
    }

    @Test
    public void testNestedOperator() throws Exception {
        this.x("ac4*db+", "a + b( c * 4, d)");
    }

    @Test
    public void testNoArgFunction() throws Exception {
        this.x("ab4*+", "a+b()*4");
    }

    @Test
    public void testSimple() throws Exception {
        this.x("abxyc*2/+", "a + b * c(x,y)/2");
    }

    @Test
    public void testSimpleLiteralExit() throws Exception {
        this.x("a", "a lit");
    }

    @Test
    public void testUnary() throws Exception {
        this.x("4c-*", "4 * -c");
    }

    @Test
    public void testUnbalancedLeftBrace() {
        try {
            this.x("", "a+b(5,c(x,y)");
            Assert.fail((String)"Expected exception");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)3L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testUnbalancedRightBraceExit() throws Exception {
        this.x("a5xycb+", "a+b(5,c(x,y)))");
    }

    private void x(CharSequence expectedRpn, String content) throws ParserException {
        RpnBuilder r = new RpnBuilder();
        this.lexer.setContent((CharSequence)content);
        this.parser.parseExpr(this.lexer, (ExprListener)r);
        TestUtils.assertEquals(expectedRpn, r.rpn());
    }
}

