/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.parser.sql.QueryError;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class DateFunctionTest
extends AbstractOptimiserTest {
    @Test
    public void testCannotParse() throws Exception {
        this.assertThat("\n", "select toDate('2017', 'MM/y') from dual");
        this.assertThat("\n", "select TO_DATE('2017', 'MM/y') from dual");
    }

    @Test
    public void testDefaultLocale() throws Exception {
        this.assertThat("2017-03-01T00:00:00.000Z\n", "select toDate('03/2017', 'MM/y') from dual");
        this.assertThat("2017-03-01T00:00:00.000Z\n", "select TO_DATE('03/2017', 'MM/y') from dual");
    }

    @Test
    public void testParseWithLocale() throws Exception {
        this.assertThat("2017-04-01T00:00:00.000Z\n", "select toDate('Abril 2017', 'MMM y', 'es') from dual");
        this.assertThat("2017-04-01T00:00:00.000Z\n", "select TO_DATE('Abril 2017', 'MMM y', 'es') from dual");
    }

    @Test
    public void testToChar() throws Exception {
        this.assertThat("20-03-2015\n", "select TO_CHAR(TO_DATE('2015-03-20T15:25:40.567Z'), 'dd-MM-y') from dual");
    }

    @Test
    public void testToCharTZ() throws Exception {
        this.assertThat("20-03-2015 08:25:40.567 PDT\n", "select TO_CHAR(TO_DATE('2015-03-20T15:25:40.567Z'), 'dd-MM-y HH:mm:ss.SSS Z', 'PDT') from dual");
        this.assertThat("20-03-2015 21:25:40.567 +0600\n", "select TO_CHAR(TO_DATE('2015-03-20T15:25:40.567Z'), 'dd-MM-y HH:mm:ss.SSS Z', '+0600') from dual");
    }

    @Test
    public void testToCharTZLocale() throws Exception {
        this.assertThat("\u041f\u0442, 20 \u043c\u0430\u0440 2015 08:25:40.567 PDT\n", "select TO_CHAR(TO_DATE('2015-03-20T15:25:40.567Z'), 'E, dd MMM y HH:mm:ss.SSS Z', 'PDT', 'ru') from dual");
    }

    @Test
    public void testWrongLocale() {
        try {
            this.expectFailure("select toDate('Abril 2017', 'MMM y', 'wrong') from dual");
            Assert.fail();
        }
        catch (ParserException e) {
            Assert.assertEquals((long)37L, (long)QueryError.getPosition());
            TestUtils.assertEquals((CharSequence)"Invalid locale", QueryError.getMessage());
        }
    }
}

