/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.questdb.ex.ParserException;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.parser.sql.QueryError;
import com.questdb.std.Rnd;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AggregationTest
extends AbstractOptimiserTest {
    @BeforeClass
    public static void setUp() throws Exception {
        JournalEntryWriter w;
        int i;
        Rnd rnd;
        int recordCount = 10000;
        int employeeCount = 10;
        try (JournalWriter orders = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("orders").$int("orderId").$int("customerId").$int("productId").$str("employeeId").$ts("orderDate").$int("quantity").$double("price").$float("rate").recordCountHint(recordCount).$());){
            rnd = new Rnd();
            String[] employees = new String[employeeCount];
            for (int i2 = 0; i2 < employees.length; ++i2) {
                employees[i2] = rnd.nextString(9);
            }
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2014-05-04T10:30:00.000Z");
            int tsIncrement = 10000;
            int orderId = 0;
            for (i = 0; i < recordCount; ++i) {
                w = orders.entryWriter();
                w.putInt(0, ++orderId);
                w.putInt(1, rnd.nextPositiveInt() % 500);
                w.putInt(2, rnd.nextPositiveInt() % 200);
                w.putStr(3, (CharSequence)employees[rnd.nextPositiveInt() % employeeCount]);
                w.putDate(4, timestamp += (long)tsIncrement);
                w.putInt(5, rnd.nextPositiveInt());
                w.putDouble(6, rnd.nextDouble());
                w.putFloat(7, rnd.nextFloat());
                w.append();
            }
            orders.commit();
        }
        var3_3 = null;
        try (JournalWriter stars = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("stars").$int("galaxy").$int("star").$double("diameter").$());){
            rnd = new Rnd();
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2014-05-04T10:30:00.000Z");
            int tsIncrement = 10000;
            for (int i3 = 0; i3 < recordCount; ++i3) {
                JournalEntryWriter w2 = stars.entryWriter(timestamp += (long)tsIncrement);
                w2.putInt(0, rnd.nextPositiveInt() % 10);
                w2.putInt(1, rnd.nextPositiveInt());
                int dividend = rnd.nextPositiveInt() % 10;
                w2.putDouble(2, Double.MAX_VALUE / (double)(dividend == 0 ? 1 : dividend));
                w2.append();
            }
            stars.commit();
        }
        catch (Throwable rnd2) {
            var3_3 = rnd2;
            throw rnd2;
        }
        stars = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure("stars2").$int("galaxy").$int("star").$double("diameter").$());
        var3_3 = null;
        try {
            rnd = new Rnd();
            double r = Math.sqrt(Double.MAX_VALUE);
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2014-05-04T10:30:00.000Z");
            int tsIncrement = 10000;
            for (i = 0; i < recordCount; ++i) {
                w = stars.entryWriter(timestamp += (long)tsIncrement);
                w.putInt(0, rnd.nextPositiveInt() % 10);
                w.putInt(1, rnd.nextPositiveInt());
                int dividend = rnd.nextPositiveInt() % 10;
                w.putDouble(2, r / (double)(dividend == 0 ? 1 : dividend));
                w.append();
            }
            stars.commit();
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (stars != null) {
                if (var3_3 != null) {
                    try {
                        stars.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    stars.close();
                }
            }
        }
    }

    @Test
    public void testAggregateExpression() throws Exception {
        this.assertThat("employeeId\tsum\tsum2\tx\nTGPGWFFYU\t97328\t-21968.018329648252\t75359.981670351760\nDEYYQEHBH\t95288\t-4394.647402081921\t90893.352597918080\nSRYRFBVTM\t96798\t1945.437433247252\t98743.437433247248\nGZSXUXIBB\t97026\t3710.011166965701\t100736.011166965712\nUEDRQQULO\t104395\t-5341.399618807004\t99053.600381192992\nFOWLPDXYS\t98350\t-25051.961159685804\t73298.038840314192\nFJGETJRSZ\t103481\t-5023.046150211212\t98457.953849788784\nBEOUOJSHR\t96459\t-7031.317012047984\t89427.682987952016\nYRXPEHNRX\t96407\t-5897.650745672292\t90509.349254327712\nVTJWCPSWH\t102802\t-15878.443493302174\t86923.556506697824\n", "select employeeId, sum(productId) sum, sum(price) sum2, sum(price)+sum(productId) x from orders", true);
    }

    @Test
    public void testAvg() throws Exception {
        this.assertThat("employeeId\tcol0\tcol1\tcol2\nTGPGWFFYU\t-22.347933193945\t1.0571239707599186E9\t0.497876154503\nDEYYQEHBH\t-4.416731057369\t1.0578515420281407E9\t0.493395281078\nSRYRFBVTM\t2.007675369708\t1.0974368837843137E9\t0.506477851617\nGZSXUXIBB\t3.736164317186\t1.099431249958711E9\t0.504398549131\nUEDRQQULO\t-5.160772578557\t1.1102616773748791E9\t0.498863287248\nFOWLPDXYS\t-25.305011272410\t1.096727898191919E9\t0.502265356225\nFJGETJRSZ\t-4.886231663630\t1.0819423916371596E9\t0.493707956565\nBEOUOJSHR\t-7.182141993920\t1.0689834824116446E9\t0.500621256716\nYRXPEHNRX\t-5.903554299972\t1.0714308772062062E9\t0.507052500028\nVTJWCPSWH\t-15.430946057631\t1.0903374433984451E9\t0.493997276119\n", "select employeeId, avg(price), avg(quantity), avg(rate) from orders", true);
    }

    @Test
    public void testAvgConst() throws Exception {
        this.assertThat("employeeId\tcol0\nTGPGWFFYU\t100.300000000002\nDEYYQEHBH\t100.300000000002\nSRYRFBVTM\t100.300000000002\nGZSXUXIBB\t100.300000000002\nUEDRQQULO\t100.300000000002\nFOWLPDXYS\t100.300000000002\nFJGETJRSZ\t100.300000000002\nBEOUOJSHR\t100.300000000002\nYRXPEHNRX\t100.300000000002\nVTJWCPSWH\t100.300000000002\n", "select employeeId, avg(100.3) from orders", true);
    }

    @Test
    public void testAvgOverflow() throws Exception {
        this.assertThat("0\t6.873337142147506E307\n1\t6.873164995098181E307\n2\t6.942020245747746E307\n8\t7.080135168048353E307\n4\t7.139261077288051E307\n5\t6.98887936996273E307\n7\t6.903112119100632E307\n9\t6.731706356699814E307\n6\t7.051044382735928E307\n3\t7.088674983313755E307\n", "select galaxy, avg(diameter) d from stars");
    }

    @Test
    public void testCount() throws Exception {
        this.assertThat("TGPGWFFYU\t983\nDEYYQEHBH\t995\nSRYRFBVTM\t969\nGZSXUXIBB\t993\nUEDRQQULO\t1035\nFOWLPDXYS\t990\nFJGETJRSZ\t1028\nBEOUOJSHR\t979\nYRXPEHNRX\t999\nVTJWCPSWH\t1029\n", "select employeeId, count() from orders");
    }

    @Test
    public void testFirstDouble() throws Exception {
        this.assertThat("TGPGWFFYU\t172.796875000000\nDEYYQEHBH\t424.828125000000\nSRYRFBVTM\t153.473033905029\nGZSXUXIBB\t632.921875000000\nUEDRQQULO\t0.000000009901\nFOWLPDXYS\t0.003103211522\nFJGETJRSZ\t1.229880273342\nBEOUOJSHR\t364.462486267090\nYRXPEHNRX\t0.000000261681\nVTJWCPSWH\t-144.421875000000\n", "select employeeId, first(price) f from orders");
    }

    @Test
    public void testFirstFloat() throws Exception {
        this.assertThat("TGPGWFFYU\t0.5832\nDEYYQEHBH\t0.2858\nSRYRFBVTM\t0.3455\nGZSXUXIBB\t0.5619\nUEDRQQULO\t0.1498\nFOWLPDXYS\t0.2931\nFJGETJRSZ\t0.7276\nBEOUOJSHR\t0.2870\nYRXPEHNRX\t0.8434\nVTJWCPSWH\t0.5373\n", "select employeeId, first(rate) f from orders");
    }

    @Test
    public void testFirstInt() throws Exception {
        this.assertThat("TGPGWFFYU\t1920890138\nDEYYQEHBH\t98924388\nSRYRFBVTM\t1876812930\nGZSXUXIBB\t572338288\nUEDRQQULO\t712702244\nFOWLPDXYS\t2060263242\nFJGETJRSZ\t544695670\nBEOUOJSHR\t923501161\nYRXPEHNRX\t230430837\nVTJWCPSWH\t1960168360\n", "select employeeId, first(quantity) f from orders");
    }

    @Test
    public void testFirstLong() throws Exception {
        this.assertThat("TGPGWFFYU\t2014-05-04T10:30:10.000Z\nDEYYQEHBH\t2014-05-04T10:30:30.000Z\nSRYRFBVTM\t2014-05-04T10:30:40.000Z\nGZSXUXIBB\t2014-05-04T10:30:50.000Z\nUEDRQQULO\t2014-05-04T10:31:20.000Z\nFOWLPDXYS\t2014-05-04T10:31:30.000Z\nFJGETJRSZ\t2014-05-04T10:31:50.000Z\nBEOUOJSHR\t2014-05-04T10:32:50.000Z\nYRXPEHNRX\t2014-05-04T10:33:10.000Z\nVTJWCPSWH\t2014-05-04T10:34:10.000Z\n", "select employeeId, toDate(first(orderDate)) f from orders");
    }

    @Test
    public void testLSumInt() throws Exception {
        this.assertThat("TGPGWFFYU\t1039152863257\t-229222375\nDEYYQEHBH\t1052562284318\t295296798\nSRYRFBVTM\t1063416340387\t-1735549021\nGZSXUXIBB\t1091735231209\t813538025\nUEDRQQULO\t1149120836083\t-1930399245\nFOWLPDXYS\t1085760619210\t-866106678\nFJGETJRSZ\t1112236778603\t-159751061\nBEOUOJSHR\t1046534829281\t-1437190943\nYRXPEHNRX\t1070359446329\t912589625\nVTJWCPSWH\t1121957229257\t970765001\n", "select employeeId, lsum(quantity) s, sum(quantity) s2 from orders");
    }

    @Test
    public void testLastDouble() throws Exception {
        this.assertThat("employeeId\tcol0\tcol1\tcol2\tcol3\tcol5\tcol6\nTGPGWFFYU\t0.005398272420\t0.4752\t1801096068\t2014-05-05T14:14:10.000Z\t2014-05-04T10:30:10.000Z\t2014-05-05T14:14:10.000Z\nDEYYQEHBH\t858.651367187500\t0.6052\t253116346\t2014-05-05T14:16:20.000Z\t2014-05-04T10:30:30.000Z\t2014-05-05T14:16:20.000Z\nSRYRFBVTM\t21.549713134766\t0.4888\t1518306371\t2014-05-05T14:14:50.000Z\t2014-05-04T10:30:40.000Z\t2014-05-05T14:14:50.000Z\nGZSXUXIBB\t328.000000000000\t0.5024\t1896175587\t2014-05-05T14:16:30.000Z\t2014-05-04T10:30:50.000Z\t2014-05-05T14:16:30.000Z\nUEDRQQULO\t-651.000000000000\t0.4547\t260995870\t2014-05-05T14:16:40.000Z\t2014-05-04T10:31:20.000Z\t2014-05-05T14:16:40.000Z\nFOWLPDXYS\t-727.085937500000\t0.4486\t2005631\t2014-05-05T14:16:10.000Z\t2014-05-04T10:31:30.000Z\t2014-05-05T14:16:10.000Z\nFJGETJRSZ\t116.035564422607\t0.6497\t987587702\t2014-05-05T14:13:20.000Z\t2014-05-04T10:31:50.000Z\t2014-05-05T14:13:20.000Z\nBEOUOJSHR\t-233.000000000000\t0.2665\t1504681377\t2014-05-05T14:14:30.000Z\t2014-05-04T10:32:50.000Z\t2014-05-05T14:14:30.000Z\nYRXPEHNRX\t0.000003891365\t0.6637\t1081845029\t2014-05-05T14:12:10.000Z\t2014-05-04T10:33:10.000Z\t2014-05-05T14:12:10.000Z\nVTJWCPSWH\t124.287727355957\t0.5628\t414901203\t2014-05-05T14:15:10.000Z\t2014-05-04T10:34:10.000Z\t2014-05-05T14:15:10.000Z\n", "select employeeId, last(price), last(rate), last(quantity), toDate(dtol(last(orderDate))), min(orderDate), max(orderDate) from orders", true);
    }

    @Test
    public void testResampling() throws Exception {
        this.assertThat("2014-05-04T00:00:00.000Z\tTGPGWFFYU\t-63.253453401381\t-63.253453401381\n2014-05-04T00:00:00.000Z\tDEYYQEHBH\t17.232482911526\t17.232482911526\n2014-05-04T00:00:00.000Z\tSRYRFBVTM\t-10.581027815832\t-10.581027815832\n2014-05-04T00:00:00.000Z\tGZSXUXIBB\t1.191841183028\t1.191841183028\n2014-05-04T00:00:00.000Z\tUEDRQQULO\t-25.284387331977\t-25.284387331977\n2014-05-04T00:00:00.000Z\tFOWLPDXYS\t-21.110275361914\t-21.110275361914\n2014-05-04T00:00:00.000Z\tFJGETJRSZ\t-12.327370360108\t-12.327370360108\n2014-05-04T00:00:00.000Z\tBEOUOJSHR\t3.586645530510\t3.586645530510\n2014-05-04T00:00:00.000Z\tYRXPEHNRX\t-10.131327938006\t-10.131327938006\n2014-05-04T00:00:00.000Z\tVTJWCPSWH\t-24.329569665466\t-24.329569665466\n2014-05-05T00:00:00.000Z\tDEYYQEHBH\t-30.963486961448\t-30.963486961448\n2014-05-05T00:00:00.000Z\tSRYRFBVTM\t13.422138958032\t13.422138958032\n2014-05-05T00:00:00.000Z\tVTJWCPSWH\t0.595780540587\t0.595780540587\n2014-05-05T00:00:00.000Z\tBEOUOJSHR\t-31.682205368795\t-31.682205368795\n2014-05-05T00:00:00.000Z\tFJGETJRSZ\t-31.906856870748\t-31.906856870748\n2014-05-05T00:00:00.000Z\tGZSXUXIBB\t7.870801180456\t7.870801180456\n2014-05-05T00:00:00.000Z\tFOWLPDXYS\t-11.860556414848\t-11.860556414848\n2014-05-05T00:00:00.000Z\tYRXPEHNRX\t-8.573401980346\t-8.573401980346\n2014-05-05T00:00:00.000Z\tUEDRQQULO\t16.987375521363\t16.987375521363\n2014-05-05T00:00:00.000Z\tTGPGWFFYU\t17.260132823173\t17.260132823173\n", "select orderDate, employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders sample by 1d");
    }

    @Test
    public void testResampling2() throws Exception {
        this.assertThat("2014-05-04T08:00:00.000Z\t-18.041874103485\n2014-05-04T16:00:00.000Z\t-12.148285354848\n2014-05-05T00:00:00.000Z\t-10.773253435499\n2014-05-05T08:00:00.000Z\t0.750778769143\n", "select orderDate, vwap(price, quantity) from orders sample by 8h");
    }

    @Test
    public void testResamplingAliasClash() {
        try {
            this.expectFailure("select dtoa4(orderDate) orderDate, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders sample by 1d");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)24L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testResamplingNoAggregates() {
        try {
            this.expectFailure("select orderDate, price+quantity from orders sample by 8h");
        }
        catch (ParserException e) {
            Assert.assertEquals((long)55L, (long)QueryError.getPosition());
        }
    }

    @Test
    public void testResamplingTimestampRename() throws Exception {
        this.assertThat("2014-05-04T08:00:00.000Z\t-18.041874103485\n2014-05-04T16:00:00.000Z\t-12.148285354848\n2014-05-05T00:00:00.000Z\t-10.773253435499\n2014-05-05T08:00:00.000Z\t0.750778769143\n", "select orderDate ts, vwap(price, quantity) from orders sample by 8h");
    }

    @Test
    public void testRowIdCompliance() throws Exception {
        AggregationTest.assertRowId("select employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders", "employeeId");
    }

    @Test
    public void testStdDevOverflow() throws Exception {
        this.assertThat("0\t1.9559640924336714E307\t4.4226282824059176E153\n1\t1.879534937588584E307\t4.335360351330191E153\n2\t1.9686634860114622E307\t4.436962346032995E153\n8\t2.0009174148155284E307\t4.473161538347937E153\n4\t2.0331647100026274E307\t4.5090627740170434E153\n5\t1.951822822449265E307\t4.417943891053015E153\n7\t1.931400940102605E307\t4.3947706881049034E153\n9\t1.841320042762572E307\t4.291060524815016E153\n6\t1.9512460199745866E307\t4.4172910476609834E153\n3\t1.9942851937157214E307\t4.4657420365665115E153\n", "select galaxy, var(diameter), stddev(diameter) d from stars2");
    }

    @Test
    public void testSumConst() throws Exception {
        this.assertThat("employeeId\tsum\tcol0\tcol1\nTGPGWFFYU\t983\t10\t20\nDEYYQEHBH\t995\t10\t20\nSRYRFBVTM\t969\t10\t20\nGZSXUXIBB\t993\t10\t20\nUEDRQQULO\t1035\t10\t20\nFOWLPDXYS\t990\t10\t20\nFJGETJRSZ\t1028\t10\t20\nBEOUOJSHR\t979\t10\t20\nYRXPEHNRX\t999\t10\t20\nVTJWCPSWH\t1029\t10\t20\n", "select employeeId, sum(1) sum, min(10), max(20) from orders", true);
    }

    @Test
    public void testSumDouble() throws Exception {
        this.assertThat("employeeId\tsum\tcol0\tcol1\nTGPGWFFYU\t-21968.018329648252\t-1024.000000000000\t1017.000000000000\nDEYYQEHBH\t-4394.647402081921\t-1024.000000000000\t1014.750000000000\nSRYRFBVTM\t1945.437433247252\t-1024.000000000000\t1014.000000000000\nGZSXUXIBB\t3710.011166965701\t-1024.000000000000\t1000.750000000000\nUEDRQQULO\t-5341.399618807004\t-1024.000000000000\t1023.335937500000\nFOWLPDXYS\t-25051.961159685804\t-1024.000000000000\t1022.250000000000\nFJGETJRSZ\t-5023.046150211212\t-1024.000000000000\t1016.937500000000\nBEOUOJSHR\t-7031.317012047984\t-1024.000000000000\t1016.375000000000\nYRXPEHNRX\t-5897.650745672292\t-1024.000000000000\t1020.442382812500\nVTJWCPSWH\t-15878.443493302174\t-1024.000000000000\t1016.000000000000\n", "select employeeId, sum(price) sum, min(price), max(price) from orders", true);
    }

    @Test
    public void testSumFloat() throws Exception {
        this.assertThat("TGPGWFFYU\t489.412259876728\t0.017976403236\t0.994569778442\nDEYYQEHBH\t490.928304672241\t0.002583622932\t0.990825176239\nSRYRFBVTM\t490.777038216591\t0.015948891640\t0.996204674244\nGZSXUXIBB\t500.867759287357\t0.023229062557\t0.984000325203\nUEDRQQULO\t516.323502302170\t0.005706131458\t0.984908044338\nFOWLPDXYS\t497.242702662945\t0.020444750786\t0.967337131500\nFJGETJRSZ\t507.531779348850\t0.006864905357\t0.970933258533\nBEOUOJSHR\t490.108210325241\t0.014558494091\t0.981236577034\nYRXPEHNRX\t506.545447528362\t0.022396981716\t0.979304194450\nVTJWCPSWH\t508.323197126389\t0.015372276306\t0.997526228428\n", "select employeeId, sum(rate), min(rate), max(rate) s from orders");
    }

    @Test
    public void testSumInt() throws Exception {
        this.assertThat("employeeId\tsum\tcol0\tcol1\nTGPGWFFYU\t97328\t0\t199\nDEYYQEHBH\t95288\t0\t199\nSRYRFBVTM\t96798\t0\t199\nGZSXUXIBB\t97026\t0\t199\nUEDRQQULO\t104395\t0\t199\nFOWLPDXYS\t98350\t0\t199\nFJGETJRSZ\t103481\t0\t199\nBEOUOJSHR\t96459\t0\t199\nYRXPEHNRX\t96407\t0\t199\nVTJWCPSWH\t102802\t0\t199\n", "select employeeId, sum(productId) sum, min(productId), max(productId) from orders", true);
    }

    @Test
    public void testVWapConst() throws Exception {
        this.assertThat("TGPGWFFYU\t-21.643293565756\t10.000000000000\nDEYYQEHBH\t-6.467001028408\t10.000000000000\nSRYRFBVTM\t2.393438946531\t10.000000000000\nGZSXUXIBB\t4.741280909223\t10.000000000000\nUEDRQQULO\t-3.726755343047\t10.000000000000\nFOWLPDXYS\t-16.216304999514\t10.000000000000\nFJGETJRSZ\t-22.689574330892\t10.000000000000\nBEOUOJSHR\t-15.105882600563\t10.000000000000\nYRXPEHNRX\t-9.386559884214\t10.000000000000\nVTJWCPSWH\t-12.402215320133\t10.000000000000\n", "select employeeId, sum(price*quantity)/lsum(quantity), vwap(10, 20) sum from orders");
    }

    @Test
    public void testVWapDoubleDouble() throws Exception {
        this.assertThat("TGPGWFFYU\t-21.643293565756\t-21.643293565756\nDEYYQEHBH\t-6.467001028408\t-6.467001028408\nSRYRFBVTM\t2.393438946531\t2.393438946531\nGZSXUXIBB\t4.741280909223\t4.741280909223\nUEDRQQULO\t-3.726755343047\t-3.726755343047\nFOWLPDXYS\t-16.216304999514\t-16.216304999514\nFJGETJRSZ\t-22.689574330892\t-22.689574330892\nBEOUOJSHR\t-15.105882600563\t-15.105882600563\nYRXPEHNRX\t-9.386559884214\t-9.386559884214\nVTJWCPSWH\t-12.402215320133\t-12.402215320133\n", "select employeeId, sum(price*quantity)/lsum(quantity), vwap(price, quantity) sum from orders");
    }

    @Test
    public void testVarianceOverflow() throws Exception {
        this.assertThat("0\tNaN\n1\tNaN\n2\tNaN\n8\tNaN\n4\tNaN\n5\tNaN\n7\tNaN\n9\tNaN\n6\tNaN\n3\tNaN\n", "select galaxy, var(diameter) d from stars");
    }

    @Test
    public void testVarianceOverflow2() throws Exception {
        this.assertThat("0\t1.9559640924336714E307\n1\t1.879534937588584E307\n2\t1.9686634860114622E307\n8\t2.0009174148155284E307\n4\t2.0331647100026274E307\n5\t1.951822822449265E307\n7\t1.931400940102605E307\n9\t1.841320042762572E307\n6\t1.9512460199745866E307\n3\t1.9942851937157214E307\n", "select galaxy, var(diameter) d from stars2");
    }
}

