/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.sql;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParser;
import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.ex.ParserException;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.std.AssociativeCache;
import com.questdb.std.Misc;
import com.questdb.std.Unsafe;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.RecordMetadata;
import com.questdb.store.SymbolTable;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.test.tools.FactoryContainer;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.ClassRule;

public abstract class AbstractOptimiserTest {
    @ClassRule
    public static final FactoryContainer FACTORY_CONTAINER = new FactoryContainer();
    protected static final StringSink sink = new StringSink();
    protected static final RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
    protected static final QueryCompiler compiler;
    private static final AssociativeCache<RecordSource> cache;
    private static final Gson gson;
    private static final JsonParser jp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertSymbol(String query, int columnIndex) throws ParserException {
        try (RecordSource src = compiler.compile(FACTORY_CONTAINER.getFactory(), (CharSequence)query);){
            RecordCursor cursor = src.prepareCursor((ReaderFactory)FACTORY_CONTAINER.getFactory());
            try {
                SymbolTable tab = cursor.getStorageFacade().getSymbolTable(columnIndex);
                while (cursor.hasNext()) {
                    Record r = (Record)cursor.next();
                    TestUtils.assertEquals(r.getSym(columnIndex), tab.value(r.getInt(columnIndex)));
                }
            }
            finally {
                cursor.releaseCursor();
            }
        }
    }

    @After
    public void tearDown() {
        Assert.assertEquals((long)0L, (long)FACTORY_CONTAINER.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)FACTORY_CONTAINER.getFactory().getBusyReaderCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void assertRowId(String query, String longColumn) throws ParserException {
        RecordSource src = compiler.compile(FACTORY_CONTAINER.getFactory(), (CharSequence)query);
        try {
            RecordCursor cursor = src.prepareCursor((ReaderFactory)FACTORY_CONTAINER.getFactory());
            try {
                Record record;
                int dateIndex = src.getMetadata().getColumnIndex((CharSequence)longColumn);
                HashMap<Long, Long> map = new HashMap<Long, Long>();
                long count = 0L;
                while (cursor.hasNext()) {
                    record = (Record)cursor.next();
                    map.put(record.getRowId(), record.getLong(dateIndex));
                    ++count;
                }
                Assert.assertTrue((count > 0L ? 1 : 0) != 0);
                record = cursor.newRecord();
                for (Map.Entry e : map.entrySet()) {
                    Assert.assertEquals((long)((Long)e.getValue()), (long)cursor.recordAt(((Long)e.getKey()).longValue()).getLong(dateIndex));
                    cursor.recordAt(record, ((Long)e.getKey()).longValue());
                    Assert.assertEquals((long)((Long)e.getValue()), (long)record.getLong(dateIndex));
                }
            }
            finally {
                cursor.releaseCursor();
            }
        }
        finally {
            Misc.free((Object)src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertEmpty(String query) throws ParserException {
        try (RecordSource src = compiler.compile(FACTORY_CONTAINER.getFactory(), (CharSequence)query);){
            RecordCursor cursor = src.prepareCursor((ReaderFactory)FACTORY_CONTAINER.getFactory());
            try {
                Assert.assertFalse((boolean)cursor.hasNext());
            }
            finally {
                cursor.releaseCursor();
            }
        }
    }

    protected void assertPlan(String expected, String query) throws ParserException {
        TestUtils.assertEquals((CharSequence)expected, compiler.plan(FACTORY_CONTAINER.getFactory(), (CharSequence)query));
    }

    protected void assertPlan2(CharSequence expected, CharSequence query) throws ParserException {
        sink.clear();
        try (RecordSource recordSource = compiler.compile(FACTORY_CONTAINER.getFactory(), query);){
            recordSource.toSink((CharSink)sink);
            String s = gson.toJson(jp.parse(sink.toString()));
            TestUtils.assertEquals(expected, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertString(String query, int columnIndex) throws ParserException {
        try (RecordSource rs = compiler.compile(FACTORY_CONTAINER.getFactory(), (CharSequence)query);){
            RecordCursor cursor = rs.prepareCursor((ReaderFactory)FACTORY_CONTAINER.getFactory());
            try {
                while (cursor.hasNext()) {
                    Record r = (Record)cursor.next();
                    int len = r.getStrLen(columnIndex);
                    CharSequence s = r.getFlyweightStr(columnIndex);
                    if (s != null) {
                        CharSequence csB = r.getFlyweightStrB(columnIndex);
                        TestUtils.assertEquals(s, csB);
                        Assert.assertEquals((long)len, (long)s.length());
                        Assert.assertNotSame((Object)s, (Object)csB);
                        continue;
                    }
                    Assert.assertEquals((long)-1L, (long)len);
                    Assert.assertNull((Object)r.getFlyweightStr(columnIndex));
                    Assert.assertNull((Object)r.getFlyweightStrB(columnIndex));
                }
            }
            finally {
                cursor.releaseCursor();
            }
        }
    }

    protected void assertThat(String expected, String query) throws Exception {
        this.assertThat(expected, query, false);
    }

    protected void assertThat(String expected, String query, boolean header) throws Exception {
        FACTORY_CONTAINER.getFactory().getConfiguration().releaseThreadLocals();
        TestUtils.assertMemoryLeak(() -> {
            this.assertThat0(expected, query, header);
            this.assertThat0(expected, query, header);
            Misc.free((Object)cache.poll((CharSequence)query));
            FACTORY_CONTAINER.getFactory().getConfiguration().releaseThreadLocals();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertThat(String expected, RecordSource rs, boolean header) throws IOException {
        RecordCursor cursor = rs.prepareCursor((ReaderFactory)FACTORY_CONTAINER.getFactory());
        try {
            this.assertThat(expected, cursor, rs.getMetadata(), header);
        }
        finally {
            cursor.releaseCursor();
        }
        TestUtils.assertStrings(rs, (ReaderFactory)FACTORY_CONTAINER.getFactory());
    }

    protected void assertThat(CharSequence expected, RecordCursor cursor, RecordMetadata metadata, boolean header) throws IOException {
        sink.clear();
        printer.print(cursor, header, metadata);
        TestUtils.assertEquals(expected, (CharSequence)sink);
        cursor.toTop();
        sink.clear();
        printer.print(cursor, header, metadata);
        TestUtils.assertEquals(expected, (CharSequence)sink);
    }

    private void assertThat0(String expected, String query, boolean header) throws ParserException, IOException {
        RecordSource rs = (RecordSource)cache.peek((CharSequence)query);
        if (rs == null) {
            rs = compiler.compile(FACTORY_CONTAINER.getFactory(), (CharSequence)query);
            cache.put((CharSequence)query, (Object)rs);
        }
        this.assertThat(expected, rs, header);
    }

    protected RecordSource compileSource(CharSequence query) throws ParserException {
        return compiler.compile(FACTORY_CONTAINER.getFactory(), query);
    }

    protected void expectFailure(CharSequence query) throws ParserException {
        FACTORY_CONTAINER.getFactory().getConfiguration().releaseThreadLocals();
        long memUsed = Unsafe.getMemUsed();
        try {
            compiler.compile(FACTORY_CONTAINER.getFactory(), query);
            Assert.fail();
        }
        catch (ParserException e) {
            FACTORY_CONTAINER.getFactory().getConfiguration().releaseThreadLocals();
            Assert.assertEquals((long)memUsed, (long)Unsafe.getMemUsed());
            throw e;
        }
        finally {
            FACTORY_CONTAINER.getFactory().getConfiguration().releaseThreadLocals();
        }
    }

    static {
        cache = new AssociativeCache(8, 16);
        gson = new GsonBuilder().setPrettyPrinting().create();
        jp = new JsonParser();
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.dateLocaleFactory = DateLocaleFactory.INSTANCE;
        env.dateFormatFactory = new DateFormatFactory();
        compiler = new QueryCompiler(env);
    }
}

