/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.plaintext;

import com.questdb.ql.RecordSource;
import com.questdb.store.Journal;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadata;
import com.questdb.store.util.ExportManager;
import com.questdb.store.util.ImportManager;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class PlainTextLexerTest
extends AbstractTest {
    @Test
    public void testForcedHeader() throws Exception {
        String file = this.getClass().getResource("/csv/test-explicit-headers.csv").getFile();
        ImportManager.importFile((Factory)this.getFactory(), (String)file, (char)',', null, (int)20, (boolean)true);
        String expected = "ABC\txy\ta\tbrown fox jumped over the fence\tGROUP1\nCDE\tbb\tb\tsentence 1\nsentence 2\tGROUP1\n";
        this.assertThat("ABC\txy\ta\tbrown fox jumped over the fence\tGROUP1\nCDE\tbb\tb\tsentence 1\nsentence 2\tGROUP1\n", "'test-explicit-headers.csv'", false);
    }

    @Test
    public void testImport() throws Exception {
        String file = this.getClass().getResource("/csv/test-import.csv").getFile();
        ImportManager.importFile((Factory)this.getFactory(), (String)file, (char)',', null, (boolean)false);
        String location = "test-import.csv";
        Assert.assertEquals((long)1L, (long)this.getFactory().getConfiguration().exists((CharSequence)location));
        try (Journal r = this.getFactory().reader(location);){
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)10L, (long)m.getColumnCount());
            Assert.assertEquals((long)7L, (long)m.getColumnQuick((int)0).type);
            Assert.assertEquals((long)3L, (long)m.getColumnQuick((int)1).type);
            Assert.assertEquals((long)3L, (long)m.getColumnQuick((int)2).type);
            Assert.assertEquals((long)6L, (long)m.getColumnQuick((int)3).type);
            Assert.assertEquals((long)10L, (long)m.getColumnQuick((int)4).type);
            Assert.assertEquals((long)10L, (long)m.getColumnQuick((int)5).type);
            Assert.assertEquals((long)10L, (long)m.getColumnQuick((int)6).type);
            Assert.assertEquals((long)7L, (long)m.getColumnQuick((int)7).type);
            Assert.assertEquals((long)0L, (long)m.getColumnQuick((int)8).type);
            Assert.assertEquals((long)4L, (long)m.getColumnQuick((int)9).type);
        }
        File actual = new File(this.getFactory().getConfiguration().getJournalBase(), "exp.csv");
        File expected = new File(this.getClass().getResource("/csv/test-export-expected.csv").getFile());
        try (RecordSource rs = this.compile("'" + location + "'");){
            ExportManager.export((RecordSource)rs, (ReaderFactory)this.getFactory(), (File)actual, (char)',');
            TestUtils.assertEquals(expected, actual);
        }
    }

    @Test
    public void testImportMalformedQuote() throws Exception {
        String file = this.getClass().getResource("/csv/test-import-malformed.csv").getFile();
        ImportManager.importFile((Factory)this.getFactory(), (String)file, (char)',', null, (boolean)false);
        String location = "test-import-malformed.csv";
        Assert.assertEquals((long)1L, (long)this.factoryContainer.getConfiguration().exists((CharSequence)location));
        try (Journal r = this.getFactory().reader(location);){
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)10L, (long)m.getColumnCount());
            Assert.assertEquals((long)7L, (long)m.getColumnQuick((int)0).type);
            Assert.assertEquals((long)7L, (long)m.getColumnQuick((int)1).type);
            Assert.assertEquals((long)3L, (long)m.getColumnQuick((int)2).type);
            Assert.assertEquals((long)6L, (long)m.getColumnQuick((int)3).type);
            Assert.assertEquals((long)10L, (long)m.getColumnQuick((int)4).type);
            Assert.assertEquals((long)10L, (long)m.getColumnQuick((int)5).type);
            Assert.assertEquals((long)10L, (long)m.getColumnQuick((int)6).type);
            Assert.assertEquals((long)7L, (long)m.getColumnQuick((int)7).type);
            Assert.assertEquals((long)0L, (long)m.getColumnQuick((int)8).type);
            Assert.assertEquals((long)4L, (long)m.getColumnQuick((int)9).type);
        }
        File actual = new File(this.factoryContainer.getConfiguration().getJournalBase(), "exp.csv");
        File expected = new File(this.getClass().getResource("/csv/test-import-malformed-expected.csv").getFile());
        try (RecordSource rs = this.compile("'" + location + "'");){
            ExportManager.export((RecordSource)rs, (ReaderFactory)this.getFactory(), (File)actual, (char)',');
            TestUtils.assertEquals(expected, actual);
        }
    }

    @Test
    public void testImportNan() throws Exception {
        String file = this.getClass().getResource("/csv/test-import-nan.csv").getFile();
        ImportManager.importFile((Factory)this.getFactory(), (String)file, (char)',', null, (int)20, (boolean)false);
        String expected = "CMP1\t7\t4486\tNaN\t2015-02-05T19:15:09.000Z\nCMP2\t8\t5256\tNaN\t2015-05-05T19:15:09.000Z\nCMP2\t2\t6675\tNaN\t2015-05-07T19:15:09.000Z\n";
        this.assertThat("CMP1\t7\t4486\tNaN\t2015-02-05T19:15:09.000Z\nCMP2\t8\t5256\tNaN\t2015-05-05T19:15:09.000Z\nCMP2\t2\t6675\tNaN\t2015-05-07T19:15:09.000Z\n", "select StrSym, IntSym, IntCol, DoubleCol, IsoDate from 'test-import-nan.csv' where DoubleCol = NaN");
    }

    @Test
    public void testImportSchema() throws Exception {
        String file = this.getClass().getResource("/csv/test-import.csv").getFile();
        String schema = "[{\"name\":\"IntSym\", \"type\":\"SYMBOL\"}, {\"name\":\"Fmt2Date\", \"type\":\"STRING\"}]";
        ImportManager.importFile((Factory)this.getFactory(), (String)file, (char)',', (CharSequence)schema, (boolean)false);
        String location = "test-import.csv";
        Assert.assertEquals((long)1L, (long)this.getFactory().getConfiguration().exists((CharSequence)location));
        try (Journal r = this.getFactory().reader(location);){
            JournalMetadata m = r.getMetadata();
            Assert.assertEquals((long)8L, (long)m.getColumnQuick((int)1).type);
            Assert.assertEquals((long)7L, (long)m.getColumnQuick((int)6).type);
        }
    }
}

