/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser.plaintext;

import com.questdb.parser.plaintext.PlainTextDelimiterLexer;
import com.questdb.std.ByteBuffers;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class PlainTextDelimiterLexerTest {
    private static final int maxLen = 0x1000000;
    private final PlainTextDelimiterLexer p = (PlainTextDelimiterLexer)PlainTextDelimiterLexer.FACTORY.newInstance();
    private long address;
    private int len;
    private RandomAccessFile raf;

    @After
    public void tearDown() throws Exception {
        this.close();
    }

    @Test
    public void testCsv() throws Exception {
        this.open("/csv/test-import.csv");
        this.p.of(this.address, this.len);
        Assert.assertEquals((long)44L, (long)this.p.getDelimiter());
        Assert.assertEquals((double)0.0, (double)this.p.getStdDev(), (double)1.0E-7);
        Assert.assertEquals((long)105L, (long)this.p.getAvgRecLen());
    }

    @Test
    public void testRandomText() throws Exception {
        this.open("/site/public/upload.html");
        this.p.of(this.address, this.len);
        Assert.assertTrue((this.p.getStdDev() > 1.0 ? 1 : 0) != 0);
    }

    private void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    private void open(String resource) throws IOException {
        URL url = this.getClass().getResource(resource);
        if (url == null) {
            throw new IllegalArgumentException("Not found: " + resource);
        }
        String file = url.getFile();
        this.raf = new RandomAccessFile(file, "r");
        FileChannel channel = this.raf.getChannel();
        this.len = 0x1000000L < this.raf.length() ? 0x1000000 : (int)this.raf.length();
        MappedByteBuffer b = channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.len);
        this.address = ByteBuffers.getAddress((ByteBuffer)b);
    }
}

