/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.parser;

import com.questdb.BootstrapEnv;
import com.questdb.cutlass.json.JsonException;
import com.questdb.cutlass.json.JsonLexer;
import com.questdb.cutlass.json.JsonParser;
import com.questdb.parser.ImportedColumnMetadata;
import com.questdb.parser.JsonSchemaParser;
import com.questdb.std.ObjList;
import com.questdb.std.Unsafe;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.std.time.TimeZoneRuleFactory;
import com.questdb.test.tools.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class JsonSchemaParserTest {
    private static final JsonLexer LEXER = new JsonLexer(1024, 4096);
    private static JsonSchemaParser jsonSchemaParser;
    private static String defaultLocaleId;

    @BeforeClass
    public static void setUpClass() {
        BootstrapEnv env = new BootstrapEnv();
        env.dateFormatFactory = new DateFormatFactory();
        env.dateLocaleFactory = new DateLocaleFactory(new TimeZoneRuleFactory());
        defaultLocaleId = env.dateLocaleFactory.getDefaultDateLocale().getId();
        jsonSchemaParser = new JsonSchemaParser(env);
    }

    @AfterClass
    public static void tearDown() {
        LEXER.close();
    }

    @Before
    public void setUp() {
        LEXER.clear();
        jsonSchemaParser.clear();
    }

    @Test
    public void testArrayProperty() {
        this.assertFailure("[\n{\"name\": \"x\", \"type\": \"DOUBLE\", \"pattern\":\"xyz\", \"locale\": []}\n]", 62, "Unexpected array");
    }

    @Test
    public void testCorrectSchema() throws Exception {
        String in = "[\n{\"name\": \"x\", \"type\": \"INT\", \"pattern\":\"xyz\", \"locale\": \"en-US\"},\n{\"name\": \"y\", \"type\": \"DATE\", \"pattern\":\"xyz\"}\n]";
        ObjList<ImportedColumnMetadata> metadata = this.parseMetadata(in);
        Assert.assertEquals((long)2L, (long)metadata.size());
        Assert.assertEquals((Object)"ImportedColumnMetadata{importedColumnType=INT, pattern=xyz, dateLocale=en-US, name=x}", (Object)((ImportedColumnMetadata)metadata.get(0)).toString());
        Assert.assertEquals((Object)("ImportedColumnMetadata{importedColumnType=DATE, pattern=xyz, dateLocale=" + defaultLocaleId + ", name=y}"), (Object)((ImportedColumnMetadata)metadata.get(1)).toString());
    }

    @Test
    public void testEmptyList() throws Exception {
        Assert.assertEquals((long)0L, (long)this.parseMetadata("[]").size());
    }

    @Test
    public void testEmptyObject() {
        try {
            this.parseMetadata("[{}]");
            Assert.fail();
        }
        catch (JsonException e) {
            Assert.assertEquals((long)3L, (long)e.getPosition());
        }
    }

    @Test
    public void testMissingName() {
        this.assertFailure("[\n{\"name\": \"x\", \"type\": \"INT\", \"pattern\":\"xyz\", \"locale\": \"en-GB\"},\n{\"type\": \"DOUBLE\", \"pattern\":\"xyz\"}\n]", 103, "Missing 'name' property");
    }

    @Test
    public void testMissingType() {
        this.assertFailure("[\n{\"name\": \"x\", \"pattern\":\"xyz\", \"locale\": \"en-GB\"},\n{\"name\": \"y\", \"type\": \"DOUBLE\", \"pattern\":\"xyz\"}\n]", 51, "Missing 'type' property");
    }

    @Test
    public void testNonArray() {
        this.assertFailure("{}", 1, "Unexpected object");
    }

    @Test
    public void testNonObjectArrayMember() {
        this.assertFailure("[2,\n{\"name\": \"x\", \"type\": \"DOUBLE\", \"pattern\":\"xyz\"}\n]", 2, "Must be an object");
    }

    @Test
    public void testWrongDateLocale() {
        this.assertFailure("[\n{\"name\": \"x\", \"type\": \"DOUBLE\", \"pattern\":\"xyz\", \"locale\": \"enk\"}\n]", 63, "Invalid date locale");
    }

    @Test
    public void testWrongType() {
        this.assertFailure("[\n{\"name\": \"y\", \"type\": \"ABC\", \"pattern\":\"xyz\"}\n]", 26, "Invalid type");
    }

    private void assertFailure(String in, int position, CharSequence text) {
        try {
            this.parseMetadata(in);
            Assert.fail();
        }
        catch (JsonException e) {
            TestUtils.assertEquals(text, e.getFlyweightMessage());
            Assert.assertEquals((long)position, (long)e.getPosition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjList<ImportedColumnMetadata> parseMetadata(CharSequence in) throws JsonException {
        long buf = TestUtils.toMemory(in);
        try {
            LEXER.parse(buf, (long)in.length(), (JsonParser)jsonSchemaParser);
            ObjList objList = jsonSchemaParser.getMetadata();
            return objList;
        }
        finally {
            Unsafe.free((long)buf, (long)in.length());
        }
    }
}

