/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.google.gson.GsonBuilder;
import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.net.http.HttpServer;
import com.questdb.net.http.QueryResponse;
import com.questdb.net.http.SimpleUrlMatcher;
import com.questdb.net.http.handlers.CsvHandler;
import com.questdb.net.http.handlers.ExistenceCheckHandler;
import com.questdb.net.http.handlers.QueryHandler;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.Files;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.HttpTestUtils;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.net.URLEncoder;
import java.sql.Timestamp;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class QueryHandlerTest
extends AbstractOptimiserTest {
    @ClassRule
    public static final TemporaryFolder temp = new TemporaryFolder();
    private static HttpServer server;
    private static QueryHandler handler;

    @BeforeClass
    public static void setUp() throws Exception {
        ServerConfiguration serverConfiguration = new ServerConfiguration();
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = serverConfiguration;
        env.configuration.setHttpThreads(1);
        env.factory = FACTORY_CONTAINER.getFactory();
        handler = new QueryHandler(env);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/js", handler);
                this.put("/chk", new ExistenceCheckHandler(env));
                this.put("/csv", new CsvHandler(env));
            }
        };
        server = new HttpServer(env);
        server.start();
        QueryHandlerTest.generateJournal();
    }

    @AfterClass
    public static void tearDown2() {
        server.halt();
        Assert.assertEquals((long)0L, (long)FACTORY_CONTAINER.getFactory().getBusyReaderCount());
        Assert.assertEquals((long)0L, (long)FACTORY_CONTAINER.getFactory().getBusyWriterCount());
    }

    @Override
    @After
    public void tearDown() {
    }

    @Test
    public void testDDLCsv() throws Exception {
        File f = temp.newFile();
        String url = "http://localhost:9000/csv?query=" + URLEncoder.encode("create table y(a INT)", "UTF-8");
        HttpTestUtils.download(HttpTestUtils.clientBuilder(false), url, f);
        String response = Files.readStringFromFile((File)f);
        Assert.assertTrue((boolean)response.contains("\"ddl\":\"OK\"}"));
    }

    @Test
    public void testDDLError() throws Exception {
        String response = QueryHandlerTest.downloadStr("create table x (a xyz, b DOUBLE)", -1, -1, false, false, temp);
        Assert.assertEquals((Object)"{\"query\":\"create table x (a xyz, b DOUBLE)\",\"error\":\"Unsupported type\",\"position\":18}", (Object)response);
    }

    @Test
    public void testDDLSimple() throws Exception {
        String response = QueryHandlerTest.downloadStr("create table x (a INT, b DOUBLE)", -1, -1, false, false, temp);
        Assert.assertEquals((Object)"{\"ddl\":\"OK\"}", (Object)response);
    }

    @Test
    public void testJournalDoesNotExist() throws Exception {
        File f = temp.newFile();
        String url = "http://localhost:9000/chk?j=tab2";
        HttpTestUtils.download(HttpTestUtils.clientBuilder(false), url, f);
        TestUtils.assertEquals((CharSequence)"Does not exist\r\n", Files.readStringFromFile((File)f));
    }

    @Test
    public void testJournalExist() throws Exception {
        File f = temp.newFile();
        String url = "http://localhost:9000/chk?j=tab";
        HttpTestUtils.download(HttpTestUtils.clientBuilder(false), url, f);
        TestUtils.assertEquals((CharSequence)"Exists\r\n", Files.readStringFromFile((File)f));
    }

    @Test
    public void testJournalExistJson() throws Exception {
        File f = temp.newFile();
        String url = "http://localhost:9000/chk?j=tab&f=json";
        HttpTestUtils.download(HttpTestUtils.clientBuilder(false), url, f);
        TestUtils.assertEquals((CharSequence)"{\"status\":\"Exists\"}", Files.readStringFromFile((File)f));
    }

    @Test
    public void testJsonChunkOverflow() throws Exception {
        int count = 10000;
        QueryHandlerTest.generateJournal("large", count);
        QueryResponse queryResponse = QueryHandlerTest.download("large");
        Assert.assertEquals((long)count, (long)queryResponse.dataset.size());
    }

    @Test
    public void testJsonEmpty() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("tab", 0, 0);
        Assert.assertEquals((long)0L, (long)queryResponse.dataset.size());
    }

    @Test
    public void testJsonEmpty0() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("tab where 1 = 2", 0, 0);
        Assert.assertEquals((long)0L, (long)queryResponse.dataset.size());
    }

    @Test
    public void testJsonEmptyQuery() throws Exception {
        Assert.assertNull(QueryHandlerTest.download((String)"", (int)0, (int)0).dataset);
    }

    @Test
    public void testJsonEncodeControlChars() throws Exception {
        StringBuilder allChars = new StringBuilder();
        for (char c = '\u0000'; c < '\ud800'; c = (char)(c + '\u0001')) {
            allChars.append(c);
        }
        String allCharString = allChars.toString();
        QueryHandlerTest.generateJournal("xyz", allCharString, 1.900232E-10, 2.598E20, Long.MAX_VALUE, Integer.MIN_VALUE, new Timestamp(0L));
        String query = "select id from xyz \n limit 1";
        QueryResponse queryResponse = QueryHandlerTest.download(query);
        Assert.assertEquals((Object)query, (Object)queryResponse.query);
        for (int i = 0; i < allCharString.length(); ++i) {
            Assert.assertTrue((String)("result len is less than " + i), (i < queryResponse.dataset.get(0)[0].length() ? 1 : 0) != 0);
            Assert.assertEquals((String)(i + ""), (long)allCharString.charAt(i), (long)queryResponse.dataset.get(0)[0].charAt(i));
        }
    }

    @Test
    public void testJsonEncodeNumbers() throws Exception {
        QueryHandlerTest.generateJournal("nums", null, 1.900232E-10, Double.MAX_VALUE, Long.MAX_VALUE, Integer.MIN_VALUE, new Timestamp(10L));
        QueryResponse queryResponse = QueryHandlerTest.download("nums limit 20");
        Assert.assertEquals((Object)"0.0000000002", (Object)queryResponse.dataset.get(0)[1]);
        Assert.assertEquals((Object)"1.7976931348623157E308", (Object)queryResponse.dataset.get(0)[2]);
        Assert.assertEquals((Object)"9223372036854775807", (Object)queryResponse.dataset.get(0)[3]);
        Assert.assertNull((Object)queryResponse.dataset.get(0)[4]);
        Assert.assertEquals((Object)"1970-01-01T00:00:00.010Z", (Object)queryResponse.dataset.get(0)[5]);
        Assert.assertEquals((Object)"id4", (Object)queryResponse.dataset.get(4)[0]);
        Assert.assertNull((Object)queryResponse.dataset.get(4)[2]);
    }

    @Test
    public void testJsonInvertedLimit() throws Exception {
        String query = "tab limit 10";
        QueryResponse queryResponse = QueryHandlerTest.download(query, 10, 5);
        Assert.assertEquals((long)0L, (long)queryResponse.dataset.size());
    }

    @Test
    public void testJsonLimits() throws Exception {
        String query = "tab";
        QueryResponse r = QueryHandlerTest.download(query, 2, 4);
        Assert.assertEquals((long)2L, (long)r.dataset.size());
        Assert.assertEquals((Object)"id2", (Object)r.dataset.get(0)[0]);
        Assert.assertEquals((Object)"id3", (Object)r.dataset.get(1)[0]);
    }

    @Test
    public void testJsonPooling() throws Exception {
        QueryResponse queryResponse1 = QueryHandlerTest.download("tab limit 10");
        QueryResponse queryResponse2 = QueryHandlerTest.download("tab limit 10");
        QueryResponse queryResponse3 = QueryHandlerTest.download("tab limit 10");
        QueryResponse queryResponse4 = QueryHandlerTest.download("tab limit 10");
        Assert.assertEquals((long)10L, (long)queryResponse1.dataset.size());
        Assert.assertEquals((long)10L, (long)queryResponse2.dataset.size());
        Assert.assertEquals((long)10L, (long)queryResponse3.dataset.size());
        Assert.assertEquals((long)10L, (long)queryResponse4.dataset.size());
        Assert.assertTrue((handler.getCacheHits() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((handler.getCacheMisses() > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testJsonSimple() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("select 1 z from tab limit 10");
        Assert.assertEquals((long)10L, (long)queryResponse.dataset.size());
    }

    @Test
    public void testJsonSimpleNoMeta() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("select 1 z from tab limit 10", 0, 10, true, false, temp);
        Assert.assertEquals((long)10L, (long)queryResponse.dataset.size());
        Assert.assertNull((Object)queryResponse.query);
    }

    @Test
    public void testJsonSimpleNoMetaAndCount() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("select 1 z from tab", 0, 10, true, true, temp);
        Assert.assertEquals((long)10L, (long)queryResponse.dataset.size());
        Assert.assertEquals((long)1000L, (long)queryResponse.count);
        Assert.assertNull((Object)queryResponse.query);
    }

    @Test
    public void testJsonTakeLimit() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("tab limit 10", 2, -1);
        Assert.assertEquals((long)2L, (long)queryResponse.dataset.size());
    }

    @Test
    public void testOrderByEmpty() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("tab where 1 = 2 order by y", 0, 1000);
        Assert.assertEquals((long)0L, (long)queryResponse.dataset.size());
    }

    @Test
    public void testRename() throws Exception {
        QueryHandlerTest.generateJournal("tab3", new QueryResponse.Tab[0], 100);
        String query = "tab3 limit 10";
        QueryResponse queryResponse = QueryHandlerTest.download(query, 0, 5);
        Assert.assertEquals((long)5L, (long)queryResponse.dataset.size());
        QueryHandlerTest.download("rename table tab3 to tab2");
        TestUtils.assertEquals((CharSequence)"{\"query\":\"tab3 limit 10\",\"error\":\"Journal does not exist\",\"position\":0}", QueryHandlerTest.downloadStr(query, 0, 5, true, false, temp));
    }

    private static void generateJournal(String name, QueryResponse.Tab[] recs, int count) throws JournalException, NumericException {
        try (JournalWriter w = FACTORY_CONTAINER.getFactory().writer((MetadataBuilder)new JournalStructure(name).$sym("id").$double("x").$double("y").$long("z").$int("w").$ts());){
            Rnd rnd = new Rnd();
            long t = DateFormatUtils.parseDateTime((CharSequence)"2015-03-12T00:00:00.000Z");
            for (int i = 0; i < count; ++i) {
                JournalEntryWriter ew = w.entryWriter();
                ew.putSym(0, (CharSequence)(recs.length > i ? recs[i].id : "id" + i));
                ew.putDouble(1, recs.length > i ? recs[i].x : rnd.nextDouble());
                if (recs.length > i) {
                    ew.putDouble(2, recs[i].y);
                    ew.putLong(3, recs[i].z);
                } else {
                    if (rnd.nextPositiveInt() % 10 == 0) {
                        ew.putNull(2);
                    } else {
                        ew.putDouble(2, rnd.nextDouble());
                    }
                    if (rnd.nextPositiveInt() % 10 == 0) {
                        ew.putNull(3);
                    } else {
                        ew.putLong(3, rnd.nextLong() % 500L);
                    }
                }
                ew.putInt(4, recs.length > i ? recs[i].w : rnd.nextInt() % 500);
                ew.putDate(5, recs.length > i ? recs[i].timestamp.getTime() : t);
                t += 10L;
                ew.append();
            }
            w.commit();
        }
    }

    static QueryResponse download(String queryUrl, TemporaryFolder temp) throws Exception {
        return QueryHandlerTest.download(queryUrl, -1, -1, false, false, temp);
    }

    static void generateJournal(String name, int count) throws JournalException, NumericException {
        QueryHandlerTest.generateJournal(name, new QueryResponse.Tab[0], count);
    }

    static void generateJournal(String name, String id, double x, double y, long z, int w, Timestamp timestamp) throws JournalException, NumericException {
        QueryResponse.Tab record = new QueryResponse.Tab();
        record.id = id;
        record.x = x;
        record.y = y;
        record.z = z;
        record.w = w;
        record.timestamp = timestamp;
        QueryHandlerTest.generateJournal(name, new QueryResponse.Tab[]{record}, 1000);
    }

    private static String downloadStr(String queryUrl, int limitFrom, int limitTo, boolean noMeta, boolean count, TemporaryFolder temp) throws Exception {
        File f = temp.newFile();
        String url = "http://localhost:9000/js?query=" + URLEncoder.encode(queryUrl, "UTF-8");
        if (limitFrom >= 0) {
            url = url + "&limit=" + limitFrom;
        }
        if (limitTo >= 0) {
            url = url + "," + limitTo;
        }
        if (noMeta) {
            url = url + "&nm=true";
        }
        if (count) {
            url = url + "&count=true";
        }
        HttpTestUtils.download(HttpTestUtils.clientBuilder(false), url, f);
        return Files.readStringFromFile((File)f);
    }

    private static QueryResponse download(String queryUrl, int limitFrom, int limitTo, boolean noMeta, boolean count, TemporaryFolder temp) throws Exception {
        return (QueryResponse)new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").create().fromJson(QueryHandlerTest.downloadStr(queryUrl, limitFrom, limitTo, noMeta, count, temp), QueryResponse.class);
    }

    private static void generateJournal() throws JournalException, NumericException {
        QueryHandlerTest.generateJournal("tab", new QueryResponse.Tab[0], 1000);
    }

    private static QueryResponse download(String queryUrl) throws Exception {
        return QueryHandlerTest.download(queryUrl, temp);
    }

    private static QueryResponse download(String queryUrl, int limitFrom, int limitTo) throws Exception {
        return QueryHandlerTest.download(queryUrl, limitFrom, limitTo, false, false, temp);
    }
}

