/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.google.gson.JsonSyntaxException;
import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.net.http.HttpServer;
import com.questdb.net.http.QueryResponse;
import com.questdb.net.http.SimpleUrlMatcher;
import com.questdb.net.http.handlers.QueryHandler;
import com.questdb.net.http.handlers.QueryHandlerTest;
import com.questdb.parser.sql.AbstractOptimiserTest;
import java.sql.Timestamp;
import org.apache.http.MalformedChunkCodingException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class QueryHandlerSmallBufferTest
extends AbstractOptimiserTest {
    @ClassRule
    public static final TemporaryFolder temp = new TemporaryFolder();
    private static final int RECORD_COUNT = 10000;
    private static HttpServer server;
    private static QueryHandler handler;

    @BeforeClass
    public static void setUp() throws Exception {
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.configuration.setHttpBufRespContent(128);
        env.factory = FACTORY_CONTAINER.getFactory();
        handler = new QueryHandler(env);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/js", handler);
            }
        };
        server = new HttpServer(env);
        server.start();
        QueryHandlerTest.generateJournal("large", 10000);
    }

    @AfterClass
    public static void tearDown2() {
        server.halt();
    }

    @Test(expected=MalformedChunkCodingException.class)
    public void testColumnValueTooLargeForBuffer() throws Exception {
        StringBuilder allChars = new StringBuilder();
        for (char c = '\u0000'; c < '\ud800'; c = (char)(c + '\u0001')) {
            allChars.append(c);
        }
        String allCharString = allChars.toString();
        QueryHandlerTest.generateJournal("xyz", allCharString, 4.900232E-10, 2.598E20, Long.MAX_VALUE, Integer.MIN_VALUE, new Timestamp(-102023L));
        String query = "select x, id from xyz \n limit 1";
        QueryHandlerTest.download(query, temp);
    }

    @Test
    public void testJsonChunkOverflow() throws Exception {
        QueryResponse queryResponse = QueryHandlerTest.download("large", temp);
        Assert.assertEquals((long)10000L, (long)queryResponse.dataset.size());
    }

    @Test(expected=JsonSyntaxException.class)
    public void testQuerySizeTooLargeForBuffer() throws Exception {
        StringBuilder b1 = new StringBuilder();
        StringBuilder b2 = new StringBuilder();
        StringBuilder b = b1;
        StringBuilder t = b2;
        b.append("large where z = 409");
        for (int i = 0; i < 10000; ++i) {
            t.append('(').append((CharSequence)b).append(") where z = 409");
            StringBuilder z = t;
            t = b;
            b = z;
            t.setLength(0);
        }
        QueryHandlerTest.download(b.toString(), temp);
    }
}

