/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http.handlers;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.handlers.CsvHandler;
import com.questdb.net.http.handlers.QueryHandler;
import com.questdb.net.http.handlers.QueryHandlerTest;
import com.questdb.parser.sql.AbstractOptimiserTest;
import com.questdb.std.NetworkChannel;
import com.questdb.std.time.MillisecondClockImpl;
import com.questdb.test.tools.TestChannel;
import com.questdb.test.tools.TestUtils;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryHandlerConsistencyTest
extends AbstractOptimiserTest {
    private static final String QUERY1 = "GET /js?query=%27xyz%27&limit=0%2C1000&count=true HTTP/1.1\nHost: localhost:9000\r\nConnection: keep-alive\r\nAccept: */*\r\nX-Requested-With: XMLHttpRequest\r\nUser-Agent: Mozilla/5.0 (Macintosh; Intel Mac OS X 10_11_4) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.102 Safari/537.36\r\nReferer: http://localhost:9000/index.html\r\nAccept-Encoding: gzip, deflate, sdch\r\nAccept-Language: en-US,en;q=0.8,ru;q=0.6\r\nCookie: _ga=GA1.1.825719031.1458963361\r\n\r\n";

    @BeforeClass
    public static void setUp() throws Exception {
        QueryHandlerTest.generateJournal("xyz", 100);
    }

    @Test
    public void testCsvHandlerConsistency() throws Exception {
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = FACTORY_CONTAINER.getFactory();
        this.testHandler((ContextHandler)new CsvHandler(env));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCsvOutput() throws Exception {
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = FACTORY_CONTAINER.getFactory();
        CsvHandler handler = new CsvHandler(env);
        handler.setupThread();
        TestChannel channel = new TestChannel(QUERY1);
        String expected = "\"id\",\"x\",\"y\",\"z\",\"w\",\"timestamp\"\r\nid0,0.0000000019,0.0000011892,-498,171,\"2015-03-12T00:00:00.000Z\"\r\nid1,0.0066887384,0.0244944207,-339,12,\"2015-03-12T00:00:00.010Z\"\r\nid2,-432.0000000000,0.2932029516,216,-197,\"2015-03-12T00:00:00.020Z\"\r\nid3,768.0000000000,,-227,-464,\"2015-03-12T00:00:00.030Z\"\r\nid4,7.0894718170,0.0000007417,353,228,\"2015-03-12T00:00:00.040Z\"\r\nid5,920.6250000000,,197,0,\"2015-03-12T00:00:00.050Z\"\r\nid6,13.7327423096,54.0429687500,-40,-247,\"2015-03-12T00:00:00.060Z\"\r\nid7,12.9238665104,,-339,-319,\"2015-03-12T00:00:00.070Z\"\r\nid8,384.0723876953,0.0005276347,10,2,\"2015-03-12T00:00:00.080Z\"\r\nid9,0.0000000173,,-359,263,\"2015-03-12T00:00:00.090Z\"\r\nid10,0.0115543692,0.0473926794,409,167,\"2015-03-12T00:00:00.100Z\"\r\nid11,0.0011654748,0.0000000089,-211,-395,\"2015-03-12T00:00:00.110Z\"\r\nid12,0.0000001961,-484.0000000000,356,124,\"2015-03-12T00:00:00.120Z\"\r\nid13,0.5831662863,942.8994140625,247,1,\"2015-03-12T00:00:00.130Z\"\r\nid14,-249.0703125000,-735.6542968750,288,-121,\"2015-03-12T00:00:00.140Z\"\r\nid15,-607.9462890625,,327,-319,\"2015-03-12T00:00:00.150Z\"\r\nid16,0.0004250098,0.0000015750,-311,-302,\"2015-03-12T00:00:00.160Z\"\r\nid17,0.0000000921,-186.0000000000,,-113,\"2015-03-12T00:00:00.170Z\"\r\nid18,0.0000000209,0.0154700107,191,-260,\"2015-03-12T00:00:00.180Z\"\r\nid19,0.0608360972,0.0073713257,-168,355,\"2015-03-12T00:00:00.190Z\"\r\nid20,768.0000000000,300.1632385254,31,282,\"2015-03-12T00:00:00.200Z\"\r\nid21,770.3593750000,0.4610133618,-42,-332,\"2015-03-12T00:00:00.210Z\"\r\nid22,0.0000002364,0.0002006101,-208,-190,\"2015-03-12T00:00:00.220Z\"\r\nid23,0.1907100230,0.0004840687,410,-392,\"2015-03-12T00:00:00.230Z\"\r\nid24,-663.0000000000,0.0000302110,-199,428,\"2015-03-12T00:00:00.240Z\"\r\nid25,0.0000261224,-296.5444335938,-20,-320,\"2015-03-12T00:00:00.250Z\"\r\nid26,-100.0000000000,-915.7968750000,,85,\"2015-03-12T00:00:00.260Z\"\r\nid27,0.0000025266,,38,-213,\"2015-03-12T00:00:00.270Z\"\r\nid28,0.0000320606,0.0006038445,243,-32,\"2015-03-12T00:00:00.280Z\"\r\nid29,-352.0000000000,0.0000710208,172,-261,\"2015-03-12T00:00:00.290Z\"\r\nid30,238.6328125000,134.6630859375,-379,-352,\"2015-03-12T00:00:00.300Z\"\r\nid31,0.0000001943,0.0003494991,416,-97,\"2015-03-12T00:00:00.310Z\"\r\nid32,0.0000000139,-1024.0000000000,-200,348,\"2015-03-12T00:00:00.320Z\"\r\nid33,128.0000000000,0.0011758586,-20,392,\"2015-03-12T00:00:00.330Z\"\r\nid34,26.6128172874,,,169,\"2015-03-12T00:00:00.340Z\"\r\nid35,-224.0770263672,599.0283203125,207,-340,\"2015-03-12T00:00:00.350Z\"\r\nid36,0.0175354201,832.0000000000,,32,\"2015-03-12T00:00:00.360Z\"\r\nid37,3.9599943161,-69.9140625000,-497,-220,\"2015-03-12T00:00:00.370Z\"\r\nid38,-200.0000000000,-568.0000000000,-434,76,\"2015-03-12T00:00:00.380Z\"\r\nid39,708.4023437500,0.0000000019,,-478,\"2015-03-12T00:00:00.390Z\"\r\nid40,585.2304687500,736.0000000000,140,-237,\"2015-03-12T00:00:00.400Z\"\r\nid41,0.0000000141,0.0046403678,-126,-91,\"2015-03-12T00:00:00.410Z\"\r\nid42,15.7132420540,-1018.5878906250,389,399,\"2015-03-12T00:00:00.420Z\"\r\nid43,386.8437500000,296.6113433838,,-4,\"2015-03-12T00:00:00.430Z\"\r\nid44,5.5901532173,-640.0000000000,,-494,\"2015-03-12T00:00:00.440Z\"\r\nid45,0.0000002490,0.0000024573,,321,\"2015-03-12T00:00:00.450Z\"\r\nid46,0.0000021166,488.0937500000,-10,387,\"2015-03-12T00:00:00.460Z\"\r\nid47,0.0000000154,0.0256510917,342,-229,\"2015-03-12T00:00:00.470Z\"\r\nid48,0.0000430228,0.6112449020,-26,-472,\"2015-03-12T00:00:00.480Z\"\r\nid49,0.0000124788,,343,147,\"2015-03-12T00:00:00.490Z\"\r\nid50,0.0454099961,1.4611321092,-236,-164,\"2015-03-12T00:00:00.500Z\"\r\nid51,0.0050167134,77.8403434753,-498,-177,\"2015-03-12T00:00:00.510Z\"\r\nid52,-416.0000000000,0.0000363594,-478,-425,\"2015-03-12T00:00:00.520Z\"\r\nid53,0.0046469892,281.7617187500,361,-201,\"2015-03-12T00:00:00.530Z\"\r\nid54,-33.7500000000,-690.2343750000,-356,64,\"2015-03-12T00:00:00.540Z\"\r\nid55,0.0000000000,0.0000001103,,-380,\"2015-03-12T00:00:00.550Z\"\r\nid56,8.0390167236,-857.6875000000,499,-275,\"2015-03-12T00:00:00.560Z\"\r\nid57,21.3488283157,-448.0000000000,120,459,\"2015-03-12T00:00:00.570Z\"\r\nid58,0.0000000025,,,49,\"2015-03-12T00:00:00.580Z\"\r\nid59,300.0937500000,,-98,-30,\"2015-03-12T00:00:00.590Z\"\r\nid60,501.0677947998,0.0030514880,432,-306,\"2015-03-12T00:00:00.600Z\"\r\nid61,0.1273584887,,-244,-311,\"2015-03-12T00:00:00.610Z\"\r\nid62,740.9882812500,0.0000000720,468,14,\"2015-03-12T00:00:00.620Z\"\r\nid63,0.0406596940,0.0000005046,223,403,\"2015-03-12T00:00:00.630Z\"\r\nid64,0.0000491961,-272.0000000000,-281,80,\"2015-03-12T00:00:00.640Z\"\r\nid65,0.3140142038,512.0000000000,-225,-148,\"2015-03-12T00:00:00.650Z\"\r\nid66,0.0055695465,0.0273376359,195,-193,\"2015-03-12T00:00:00.660Z\"\r\nid67,-512.0000000000,-844.0000000000,-135,307,\"2015-03-12T00:00:00.670Z\"\r\nid68,428.0000000000,-608.0000000000,-76,415,\"2015-03-12T00:00:00.680Z\"\r\nid69,-512.0000000000,894.7187500000,402,-362,\"2015-03-12T00:00:00.690Z\"\r\nid70,-283.1583251953,832.0000000000,367,-372,\"2015-03-12T00:00:00.700Z\"\r\nid71,1.1517004967,97.2561187744,-76,-457,\"2015-03-12T00:00:00.710Z\"\r\nid72,768.0000000000,768.0000000000,403,399,\"2015-03-12T00:00:00.720Z\"\r\nid73,32.0000000000,174.4927864075,448,-158,\"2015-03-12T00:00:00.730Z\"\r\nid74,934.1573791504,4.1113085747,380,320,\"2015-03-12T00:00:00.740Z\"\r\nid75,-228.0015869141,0.0066470259,132,105,\"2015-03-12T00:00:00.750Z\"\r\nid76,0.0021495742,0.0000005019,-91,-31,\"2015-03-12T00:00:00.760Z\"\r\nid77,19.7567439079,0.0000903588,412,-435,\"2015-03-12T00:00:00.770Z\"\r\nid78,-1018.3125000000,0.0000000076,-371,60,\"2015-03-12T00:00:00.780Z\"\r\nid79,-998.3625488281,380.4352569580,430,150,\"2015-03-12T00:00:00.790Z\"\r\nid80,0.0000762123,-864.8203125000,-327,-106,\"2015-03-12T00:00:00.800Z\"\r\nid81,288.0000000000,-64.0000000000,-170,385,\"2015-03-12T00:00:00.810Z\"\r\nid82,6.0128862858,-498.3359375000,405,-87,\"2015-03-12T00:00:00.820Z\"\r\nid83,64.0000000000,,414,-99,\"2015-03-12T00:00:00.830Z\"\r\nid84,18.8347930908,-768.0000000000,271,-29,\"2015-03-12T00:00:00.840Z\"\r\nid85,0.0025632520,640.0000000000,187,-300,\"2015-03-12T00:00:00.850Z\"\r\nid86,0.0000000072,768.0000000000,-161,165,\"2015-03-12T00:00:00.860Z\"\r\nid87,0.0000997469,74.7576007843,-139,25,\"2015-03-12T00:00:00.870Z\"\r\nid88,8.9508481026,15.2402491570,270,331,\"2015-03-12T00:00:00.880Z\"\r\nid89,0.0407589767,0.0025454164,-15,18,\"2015-03-12T00:00:00.890Z\"\r\nid90,-642.0000000000,0.0191786536,-164,57,\"2015-03-12T00:00:00.900Z\"\r\nid91,391.0000000000,0.0000766759,-308,94,\"2015-03-12T00:00:00.910Z\"\r\nid92,0.0000116505,-220.9241943359,-207,-221,\"2015-03-12T00:00:00.920Z\"\r\nid93,0.0000000039,-486.9859619141,-479,393,\"2015-03-12T00:00:00.930Z\"\r\nid94,0.0000383980,0.3997064978,,-338,\"2015-03-12T00:00:00.940Z\"\r\nid95,-628.5000000000,,352,-462,\"2015-03-12T00:00:00.950Z\"\r\nid96,-125.0000000000,849.2207031250,490,132,\"2015-03-12T00:00:00.960Z\"\r\nid97,-162.5000000000,815.0000000000,-297,-414,\"2015-03-12T00:00:00.970Z\"\r\nid98,0.0001471960,0.2934677303,-284,-357,\"2015-03-12T00:00:00.980Z\"\r\nid99,-384.0000000000,0.0000000980,-264,355,\"2015-03-12T00:00:00.990Z\"\r\n";
        try {
            channel.reset();
            try (IOContext context = new IOContext((NetworkChannel)channel, new ServerConfiguration(), MillisecondClockImpl.INSTANCE);){
                context.request.read();
                handler.handle(context);
                TestUtils.assertEquals((CharSequence)expected, channel.getOutput());
            }
        }
        finally {
            channel.free();
        }
    }

    @Test
    public void testQueryHandlerConsistency() throws Exception {
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = FACTORY_CONTAINER.getFactory();
        this.testHandler((ContextHandler)new QueryHandler(env));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHandler(ContextHandler handler) throws Exception {
        TestChannel channel = new TestChannel(QUERY1);
        String expected = null;
        handler.setupThread();
        try {
            ServerConfiguration configuration = new ServerConfiguration();
            for (int i = 128; i < 7500; ++i) {
                channel.reset();
                configuration.setHttpBufRespContent(i);
                try (IOContext context = new IOContext((NetworkChannel)channel, configuration, MillisecondClockImpl.INSTANCE);){
                    context.request.read();
                    handler.handle(context);
                    if (expected != null) {
                        TestUtils.assertEquals(expected, channel.getOutput());
                        continue;
                    }
                    expected = channel.getOutput().toString();
                    continue;
                }
            }
        }
        finally {
            channel.free();
        }
    }
}

