/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Misc;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class UrlDecodeTest {
    private final ObjectPool<DirectByteCharSequence> pool = new ObjectPool((ObjectFactory)DirectByteCharSequence.FACTORY, 16);
    private final CharSequenceObjHashMap<CharSequence> map = new CharSequenceObjHashMap();

    @Before
    public void setUp() {
        this.pool.clear();
        this.map.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDuplicateAmp() {
        String v = "x=a&&y==b";
        long p = TestUtils.toMemory(v);
        try {
            Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            TestUtils.assertEquals((CharSequence)"a", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b", (CharSequence)this.map.get((CharSequence)"y"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimple() {
        String v = "x=a&y=b";
        long p = TestUtils.toMemory(v);
        try {
            Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            TestUtils.assertEquals((CharSequence)"a", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b", (CharSequence)this.map.get((CharSequence)"y"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleQuote() {
        String v = "x=%27a%27&y==b";
        long p = TestUtils.toMemory(v);
        try {
            int o = Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            DirectByteCharSequence cs = new DirectByteCharSequence().of(p, p + (long)v.length() - (long)o);
            TestUtils.assertEquals((CharSequence)"x='a'&y==b", (CharSequence)cs);
            TestUtils.assertEquals((CharSequence)"'a'", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b", (CharSequence)this.map.get((CharSequence)"y"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrailingEmpty() {
        String v = "x=a&y=b&z=";
        long p = TestUtils.toMemory(v);
        try {
            Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            TestUtils.assertEquals((CharSequence)"a", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b", (CharSequence)this.map.get((CharSequence)"y"));
            Assert.assertNull((Object)this.map.get((CharSequence)"z"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTrailingNull() {
        String v = "x=a&y=b&";
        long p = TestUtils.toMemory(v);
        try {
            Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            TestUtils.assertEquals((CharSequence)"a", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b", (CharSequence)this.map.get((CharSequence)"y"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLDec() {
        String v = "x=a&y=b+c%26&z=ab%20ba&w=2";
        long p = TestUtils.toMemory(v);
        try {
            Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            TestUtils.assertEquals((CharSequence)"a", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b c&", (CharSequence)this.map.get((CharSequence)"y"));
            TestUtils.assertEquals((CharSequence)"ab ba", (CharSequence)this.map.get((CharSequence)"z"));
            TestUtils.assertEquals((CharSequence)"2", (CharSequence)this.map.get((CharSequence)"w"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLDecSpace() {
        String v = "x=a&y=b+c&z=123";
        long p = TestUtils.toMemory(v);
        try {
            Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            TestUtils.assertEquals((CharSequence)"a", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b c", (CharSequence)this.map.get((CharSequence)"y"));
            TestUtils.assertEquals((CharSequence)"123", (CharSequence)this.map.get((CharSequence)"z"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testURLDecTrailingSpace() {
        String v = "x=a&y=b+c";
        long p = TestUtils.toMemory(v);
        try {
            Misc.urlDecode((long)p, (long)(p + (long)v.length()), this.map, this.pool);
            TestUtils.assertEquals((CharSequence)"a", (CharSequence)this.map.get((CharSequence)"x"));
            TestUtils.assertEquals((CharSequence)"b c", (CharSequence)this.map.get((CharSequence)"y"));
        }
        finally {
            Unsafe.free((long)p, (long)v.length());
        }
    }
}

