/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.net.http.RequestHeaderBuffer;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RequestHeaderBufferTest {
    private static final String request = "GET /status?x=1&a=%26b&c&d=x HTTP/1.1\r\nHost: localhost:9000\r\nConnection: keep-alive\r\nCache-Control: max-age=0\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8\r\nUser-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.48 Safari/537.36\r\nContent-Type: multipart/form-data; boundary=----WebKitFormBoundaryQ3pdBTBXxEFUWDML\r\nAccept-Encoding: gzip,deflate,sdch\r\nAccept-Language: en-US,en;q=0.8\r\nCookie: textwrapon=false; textautoformat=false; wysiwyg=textarea\r\n\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDanglingUrlParamWithoutValue() throws Exception {
        String request = "GET /status?accept HTTP/1.1\r\nHost: localhost:9000\r\n\r\n";
        ObjectPool pool = new ObjectPool((ObjectFactory)DirectByteCharSequence.FACTORY, 64);
        try (RequestHeaderBuffer hb = new RequestHeaderBuffer(4096, pool);){
            long p = TestUtils.toMemory(request);
            try {
                hb.write(p, request.length(), true);
                TestUtils.assertEquals((CharSequence)"", hb.getUrlParam((CharSequence)"accept"));
            }
            finally {
                Unsafe.free((long)p, (long)request.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSplitWrite() throws Exception {
        ObjectPool pool = new ObjectPool((ObjectFactory)DirectByteCharSequence.FACTORY, 64);
        try (RequestHeaderBuffer hb = new RequestHeaderBuffer(4096, pool);){
            long p = TestUtils.toMemory(request);
            try {
                int n = request.length();
                for (int i = 0; i < n; ++i) {
                    hb.clear();
                    hb.write(p, i, true);
                    hb.write(p + (long)i, n - i, true);
                    this.assertHeaders(hb);
                }
            }
            finally {
                Unsafe.free((long)p, (long)request.length());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrite() throws Exception {
        ObjectPool pool = new ObjectPool((ObjectFactory)DirectByteCharSequence.FACTORY, 64);
        try (RequestHeaderBuffer hb = new RequestHeaderBuffer(4096, pool);){
            long p = TestUtils.toMemory(request);
            try {
                hb.write(p, request.length(), true);
                this.assertHeaders(hb);
            }
            finally {
                Unsafe.free((long)p, (long)request.length());
            }
        }
    }

    private void assertHeaders(RequestHeaderBuffer hb) {
        TestUtils.assertEquals((CharSequence)"GET", hb.getMethod());
        TestUtils.assertEquals((CharSequence)"/status", hb.getUrl());
        TestUtils.assertEquals((CharSequence)"GET /status?x=1&a=&b&c&d=x HTTP/1.1", hb.getMethodLine());
        Assert.assertEquals((long)9L, (long)hb.size());
        TestUtils.assertEquals((CharSequence)"localhost:9000", hb.get((CharSequence)"Host"));
        TestUtils.assertEquals((CharSequence)"keep-alive", hb.get((CharSequence)"Connection"));
        TestUtils.assertEquals((CharSequence)"max-age=0", hb.get((CharSequence)"Cache-Control"));
        TestUtils.assertEquals((CharSequence)"text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8", hb.get((CharSequence)"Accept"));
        TestUtils.assertEquals((CharSequence)"Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.48 Safari/537.36", hb.get((CharSequence)"User-Agent"));
        TestUtils.assertEquals((CharSequence)"multipart/form-data; boundary=----WebKitFormBoundaryQ3pdBTBXxEFUWDML", hb.get((CharSequence)"Content-Type"));
        TestUtils.assertEquals((CharSequence)"gzip,deflate,sdch", hb.get((CharSequence)"Accept-Encoding"));
        TestUtils.assertEquals((CharSequence)"en-US,en;q=0.8", hb.get((CharSequence)"Accept-Language"));
        TestUtils.assertEquals((CharSequence)"textwrapon=false; textautoformat=false; wysiwyg=textarea", hb.get((CharSequence)"Cookie"));
        TestUtils.assertEquals((CharSequence)"1", hb.getUrlParam((CharSequence)"x"));
        TestUtils.assertEquals((CharSequence)"&b", hb.getUrlParam((CharSequence)"a"));
        TestUtils.assertEquals((CharSequence)"", hb.getUrlParam((CharSequence)"c"));
        Assert.assertNull((Object)hb.get((CharSequence)"xxx"));
    }
}

