/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.net.http.RangeParser;
import org.junit.Assert;
import org.junit.Test;

public class RangeParserTest {
    private final RangeParser parser = (RangeParser)RangeParser.FACTORY.newInstance();

    @Test
    public void testFmt1() {
        Assert.assertTrue((boolean)this.parser.of((CharSequence)"bytes=79990-"));
        Assert.assertEquals((long)79990L, (long)this.parser.getLo());
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.parser.getHi());
    }

    @Test
    public void testFmt2() {
        Assert.assertTrue((boolean)this.parser.of((CharSequence)"bytes=79990-43343245"));
        Assert.assertEquals((long)79990L, (long)this.parser.getLo());
        Assert.assertEquals((long)43343245L, (long)this.parser.getHi());
    }

    @Test
    public void testInvalid1() {
        Assert.assertFalse((boolean)this.parser.of((CharSequence)"zeroes=79990-43343245"));
    }

    @Test
    public void testInvalid2() {
        Assert.assertFalse((boolean)this.parser.of((CharSequence)"bytes=79990x-43343245"));
    }

    @Test
    public void testInvalid3() {
        Assert.assertFalse((boolean)this.parser.of((CharSequence)"bytes=7999-0-43343245"));
    }

    @Test
    public void testInvalid4() {
        Assert.assertFalse((boolean)this.parser.of((CharSequence)"bytes=7999"));
    }
}

