/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.net.http.IOContext;
import com.questdb.net.http.MultipartListener;
import com.questdb.net.http.MultipartParser;
import com.questdb.net.http.Request;
import com.questdb.net.http.RequestHeaderBuffer;
import com.questdb.std.ObjList;
import com.questdb.std.ObjectFactory;
import com.questdb.std.ObjectPool;
import com.questdb.std.Unsafe;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class MultipartParserTest {
    private static final String file = "<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>org.sandbox</groupId>\n    <artifactId>factor</artifactId>\n    <packaging>jar</packaging>\n    <version>1.0-SNAPSHOT</version>\n    <name>factor</name>\n    <url>http://maven.apache.org</url>\n    <dependencies>\n        <dependency>\n            <groupId>junit</groupId>\n            <artifactId>junit</artifactId>\n            <version>4.6</version>\n            <scope>test</scope>\n        </dependency>\n        <dependency>\n            <groupId>com.lmax</groupId>\n            <artifactId>disruptor</artifactId>\n            <version>3.2.0</version>\n        </dependency>\n        <dependency>\n            <groupId>net.openhft</groupId>\n            <artifactId>affinity</artifactId>\n            <version>2.0</version>\n        </dependency>\n    </dependencies>\n</project>\n";
    private static final String content = "------WebKitFormBoundaryxFKYDBybTLu2rb8P\r\nContent-Disposition: form-data; name=\"textline\"\r\n\r\n\r\n------WebKitFormBoundaryxFKYDBybTLu2rb8P\nContent-Disposition: form-data; name=\"textline2\"\n\r\n\r\n------WebKitFormBoundaryxFKYDBybTLu2rb8P\nContent-Disposition: form-data; name=\"datafile\"; filename=\"pom.xml\"\r\nContent-Type: text/xml\r\n\r\n<project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n         xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\">\n    <modelVersion>4.0.0</modelVersion>\n    <groupId>org.sandbox</groupId>\n    <artifactId>factor</artifactId>\n    <packaging>jar</packaging>\n    <version>1.0-SNAPSHOT</version>\n    <name>factor</name>\n    <url>http://maven.apache.org</url>\n    <dependencies>\n        <dependency>\n            <groupId>junit</groupId>\n            <artifactId>junit</artifactId>\n            <version>4.6</version>\n            <scope>test</scope>\n        </dependency>\n        <dependency>\n            <groupId>com.lmax</groupId>\n            <artifactId>disruptor</artifactId>\n            <version>3.2.0</version>\n        </dependency>\n        <dependency>\n            <groupId>net.openhft</groupId>\n            <artifactId>affinity</artifactId>\n            <version>2.0</version>\n        </dependency>\n    </dependencies>\n</project>\n\r\n------WebKitFormBoundaryxFKYDBybTLu2rb8P--\r\n";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParse() throws Exception {
        LineCollectingListener lsnr = new LineCollectingListener();
        ObjectPool pool = new ObjectPool((ObjectFactory)DirectByteCharSequence.FACTORY, 64);
        MultipartParser parser = new MultipartParser(1024, pool);
        Request.BoundaryAugmenter augmenter = new Request.BoundaryAugmenter();
        long p = TestUtils.toMemory(content);
        try {
            for (int i = 0; i < content.length(); ++i) {
                parser.of(augmenter.of((CharSequence)"----WebKitFormBoundaryxFKYDBybTLu2rb8P"));
                parser.parse(null, p, i, (MultipartListener)lsnr);
                parser.parse(null, p + (long)i, content.length() - i, (MultipartListener)lsnr);
                lsnr.assertLine();
                parser.clear();
                lsnr.clear();
            }
        }
        finally {
            Unsafe.free((long)p, (long)content.length());
        }
    }

    private static final class LineCollectingListener
    implements MultipartListener {
        private final ObjList<String> lines = new ObjList();

        private LineCollectingListener() {
        }

        public void assertLine() {
            Assert.assertEquals((long)3L, (long)this.lines.size());
            Assert.assertEquals((Object)"", (Object)this.lines.get(0));
            Assert.assertEquals((Object)"", (Object)this.lines.get(1));
            Assert.assertEquals((Object)MultipartParserTest.file, (Object)this.lines.get(2));
        }

        public void clear() {
            this.lines.clear();
        }

        public void onChunk(IOContext context, RequestHeaderBuffer hb, DirectByteCharSequence data, boolean continued) {
            if (continued) {
                String s = (String)this.lines.getLast();
                this.lines.setQuick(this.lines.size() - 1, (Object)(s + data.toString()));
            } else {
                this.lines.add((Object)data.toString());
            }
        }

        public void setup(IOContext context) {
        }
    }
}

