/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.http;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.ex.ResponseContentBufferTooSmallException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.net.ha.AbstractJournalTest;
import com.questdb.net.http.ChunkedResponse;
import com.questdb.net.http.ContextHandler;
import com.questdb.net.http.HttpServer;
import com.questdb.net.http.IOContext;
import com.questdb.net.http.SimpleUrlMatcher;
import com.questdb.net.http.handlers.ImportHandler;
import com.questdb.net.http.handlers.StaticContentHandler;
import com.questdb.net.http.handlers.UploadHandler;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.parser.typeprobe.TypeProbeCollection;
import com.questdb.ql.RecordSource;
import com.questdb.ql.RecordSourcePrinter;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.DateLocaleFactory;
import com.questdb.store.Journal;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.store.util.FileSink;
import com.questdb.test.tools.HttpTestUtils;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContextBuilder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class HttpServerTest
extends AbstractJournalTest {
    private static final Log LOG = LogFactory.getLog(HttpServerTest.class);
    private static final TypeProbeCollection TYPE_PROBE_COLLECTION = new TypeProbeCollection();
    private static final DateFormatFactory DATE_FORMAT_FACTORY = new DateFormatFactory();
    private static final String request = "GET /imp?x=1&z=2 HTTP/1.1\r\nHost: localhost:80\r\nConnection: keep-alive\r\nCache-Control: max-age=0\r\nAccept: text/html,application/xhtml+xml,application/xml;q=0.9,image/webp,*/*;q=0.8\r\nUser-Agent: Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.48 Safari/537.36\r\nAccept-Language: en-US,en;q=0.8\r\nCookie: textwrapon=false; textautoformat=false; wysiwyg=textarea\r\n\r\n";
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    public static HttpResponse get(String url) throws IOException {
        HttpGet post = new HttpGet(url);
        try (CloseableHttpClient client = HttpClients.createDefault();){
            CloseableHttpResponse closeableHttpResponse = client.execute((HttpUriRequest)post);
            return closeableHttpResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCompressedDownload() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        configuration.getSslConfig().setSecure(true);
        configuration.getSslConfig().setKeyStore((InputStream)new FileInputStream(HttpServerTest.resourceFile("/keystore/singlekey.ks")), "changeit");
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = configuration;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            HttpTestUtils.download(HttpServerTest.clientBuilder(true), "https://localhost:9000/upload.html", new File(this.temp.getRoot(), "upload.html"));
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentImport() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        CyclicBarrier barrier = new CyclicBarrier(2);
        CountDownLatch latch = new CountDownLatch(2);
        try {
            new Thread(() -> {
                try {
                    barrier.await();
                    Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp", null, null));
                    latch.countDown();
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }).start();
            new Thread(() -> {
                try {
                    barrier.await();
                    Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import-nan.csv", "http://localhost:9000/imp", null, null));
                    latch.countDown();
                }
                catch (Exception e) {
                    Assert.fail((String)e.getMessage());
                }
            }).start();
            latch.await();
            try (Journal r = this.getFactory().reader("test-import.csv");){
                Assert.assertEquals((String)"First failed", (long)129L, (long)r.size());
            }
            r = this.getFactory().reader("test-import-nan.csv");
            var6_6 = null;
            try {
                Assert.assertEquals((String)"Second failed", (long)129L, (long)r.size());
            }
            catch (Throwable throwable) {
                var6_6 = throwable;
                throw throwable;
            }
            finally {
                if (r != null) {
                    if (var6_6 != null) {
                        try {
                            r.close();
                        }
                        catch (Throwable throwable) {
                            var6_6.addSuppressed(throwable);
                        }
                    } else {
                        r.close();
                    }
                }
            }
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConnectionCount() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        env.configuration.setHttpMaxConnections(10);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            CloseableHttpClient c1 = HttpServerTest.clientBuilder(true).build();
            CloseableHttpClient c2 = HttpServerTest.clientBuilder(true).build();
            CloseableHttpClient c3 = HttpServerTest.clientBuilder(true).build();
            CloseableHttpClient c4 = HttpServerTest.clientBuilder(true).build();
            Assert.assertNotNull((Object)c1.execute((HttpUriRequest)new HttpGet("https://localhost:9000/upload.html")));
            Assert.assertEquals((long)1L, (long)server.getConnectionCount());
            Assert.assertNotNull((Object)c2.execute((HttpUriRequest)new HttpGet("https://localhost:9000/upload.html")));
            Assert.assertEquals((long)2L, (long)server.getConnectionCount());
            Assert.assertNotNull((Object)c3.execute((HttpUriRequest)new HttpGet("https://localhost:9000/upload.html")));
            Assert.assertEquals((long)3L, (long)server.getConnectionCount());
            Assert.assertNotNull((Object)c4.execute((HttpUriRequest)new HttpGet("https://localhost:9000/upload.html")));
            Assert.assertEquals((long)4L, (long)server.getConnectionCount());
            c1.close();
            c2.close();
            Thread.sleep(300L);
            Assert.assertEquals((long)2L, (long)server.getConnectionCount());
            c3.close();
            c4.close();
            Thread.sleep(300L);
            Assert.assertEquals((long)0L, (long)server.getConnectionCount());
        }
        finally {
            server.halt();
        }
    }

    @Test
    public void testDefaultDirIndex() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        env.configuration.getSslConfig().setSecure(false);
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            HttpTestUtils.download(HttpServerTest.clientBuilder(false), "http://localhost:9000/", new File(this.temp.getRoot(), "index.html"));
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFragmentedUrl() throws Exception {
        long tick = DateFormatUtils.parseDateTime((CharSequence)"2015-12-05T13:30:00.000Z");
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.matcher = new SimpleUrlMatcher();
        HttpServer server = new HttpServer(env);
        server.setClock(() -> tick);
        server.start();
        try (SocketChannel channel = this.openChannel();){
            int i;
            ByteBuffer buf = ByteBuffer.allocate(1024);
            ByteBuffer out = ByteBuffer.allocate(1024);
            int n = 5;
            for (i = 0; i < n; ++i) {
                buf.put((byte)request.charAt(i));
            }
            buf.flip();
            ByteBuffers.copy((ByteBuffer)buf, (WritableByteChannel)channel);
            buf.clear();
            for (i = n; i < request.length(); ++i) {
                buf.put((byte)request.charAt(i));
            }
            buf.flip();
            ByteBuffers.copy((ByteBuffer)buf, (WritableByteChannel)channel);
            channel.configureBlocking(false);
            ByteBuffers.copyGreedyNonBlocking((ReadableByteChannel)channel, (ByteBuffer)out, (int)100000);
            String expected = "HTTP/1.1 404 Not Found\r\nServer: questDB/1.0\r\nDate: Sat, 5 Dec 2015 13:30:00 GMT\r\nTransfer-Encoding: chunked\r\nContent-Type: text/html; charset=utf-8\r\n\r\nb\r\nNot Found\r\n\r\n0\r\n\r\n";
            Assert.assertEquals((long)"HTTP/1.1 404 Not Found\r\nServer: questDB/1.0\r\nDate: Sat, 5 Dec 2015 13:30:00 GMT\r\nTransfer-Encoding: chunked\r\nContent-Type: text/html; charset=utf-8\r\n\r\nb\r\nNot Found\r\n\r\n0\r\n\r\n".length(), (long)out.remaining());
            int k = "HTTP/1.1 404 Not Found\r\nServer: questDB/1.0\r\nDate: Sat, 5 Dec 2015 13:30:00 GMT\r\nTransfer-Encoding: chunked\r\nContent-Type: text/html; charset=utf-8\r\n\r\nb\r\nNot Found\r\n\r\n0\r\n\r\n".length();
            for (int i2 = 0; i2 < k; ++i2) {
                Assert.assertEquals((long)"HTTP/1.1 404 Not Found\r\nServer: questDB/1.0\r\nDate: Sat, 5 Dec 2015 13:30:00 GMT\r\nTransfer-Encoding: chunked\r\nContent-Type: text/html; charset=utf-8\r\n\r\nb\r\nNot Found\r\n\r\n0\r\n\r\n".charAt(i2), (long)out.get());
            }
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIdleTimeout() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        env.configuration.setHttpTimeout(500);
        env.configuration.getSslConfig().setSecure(false);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            Socket socket = new Socket("127.0.0.1", 9000);
            OutputStream os = socket.getOutputStream();
            Thread.sleep(600L);
            try {
                os.write(request.getBytes());
                for (int i = 0; i < 4096; ++i) {
                    os.write(99);
                }
                os.flush();
                Assert.fail((String)"Expected exception due to connection timeout");
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportAppend() throws Exception {
        AtomicInteger errors = new AtomicInteger();
        this.getFactory().setEventListener((factoryType, thread, name, event, segment, position) -> {
            if (event == 3) {
                errors.incrementAndGet();
            }
            return true;
        });
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp?fmt=json", null, null));
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp", null, null));
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            printer.print(qc.compile(this.getFactory(), (CharSequence)"select count(StrSym), count(IntSym), count(IntCol), count(long), count() from 'test-import.csv'"), (ReaderFactory)this.getFactory());
            TestUtils.assertEquals((CharSequence)"252\t252\t256\t258\t258\n", (CharSequence)sink);
        }
        finally {
            server.halt();
        }
        Assert.assertEquals((long)0L, (long)errors.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportForcedHeader() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-explicit-headers.csv", "http://localhost:9000/imp?name=test-import.csv&overwrite=true&durable=true&forceHeader=true", null, null));
            printer.print(qc.compile(this.getFactory(), (CharSequence)"select count() from 'test-import.csv'"), (ReaderFactory)this.getFactory());
            TestUtils.assertEquals((CharSequence)"2\n", (CharSequence)sink);
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportIntoBusyJournal() throws Exception {
        try (JournalWriter ignored = this.getFactory().writer((MetadataBuilder)new JournalStructure("test-import.csv").$int("x").$());){
            final BootstrapEnv env = new BootstrapEnv();
            env.configuration = new ServerConfiguration();
            env.factory = this.getFactory();
            env.typeProbeCollection = TYPE_PROBE_COLLECTION;
            env.matcher = new SimpleUrlMatcher(){
                {
                    this.put("/imp", new ImportHandler(env));
                }
            };
            HttpServer server = new HttpServer(env);
            server.start();
            StringBuilder response = new StringBuilder();
            try {
                Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp?fmt=json", null, response));
                TestUtils.assertEquals((CharSequence)"{\"status\":\"Journal exists and column count does not match\"}", response);
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Connection reset"));
            }
            finally {
                server.halt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportIntoBusyJournal2() throws Exception {
        Factory f = this.getFactory();
        try (JournalWriter w = f.writer((MetadataBuilder)new JournalStructure("small.csv").$int("X").$int("Y").$());){
            JournalEntryWriter ew = w.entryWriter();
            ew.putInt(0, 3);
            ew.putInt(1, 30);
            ew.append();
            w.commit();
            final BootstrapEnv env = new BootstrapEnv();
            env.configuration = new ServerConfiguration();
            env.factory = this.getFactory();
            env.typeProbeCollection = TYPE_PROBE_COLLECTION;
            env.matcher = new SimpleUrlMatcher(){
                {
                    this.put("/imp", new ImportHandler(env));
                }
            };
            HttpServer server = new HttpServer(env);
            server.start();
            StringBuilder response = new StringBuilder();
            try {
                Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/small.csv", "http://localhost:9000/imp?fmt=json", null, response));
                Assert.assertTrue((boolean)Chars.startsWith((CharSequence)response, (CharSequence)"{\"status\":\"com.questdb.ex.WriterBusyException\"}"));
            }
            catch (IOException e) {
                Assert.assertTrue((boolean)e.getMessage().contains("Connection reset"));
            }
            finally {
                server.halt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportNoHeader() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration();
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = configuration;
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-explicit-headers.csv", "http://localhost:9000/imp?name=test-import.csv&overwrite=true&durable=true", null, null));
            printer.print(qc.compile(this.getFactory(), (CharSequence)"select count() from 'test-import.csv'"), (ReaderFactory)this.getFactory());
            TestUtils.assertEquals((CharSequence)"3\n", (CharSequence)sink);
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportNumberPrefixedColumn() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration();
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = configuration;
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import-num-prefix.csv", "http://localhost:9000/imp?fmt=json", null, null));
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            try (RecordSource rs = qc.compile(env.factory, (CharSequence)"select count(StrSym), count(IntSym), count(_1IntCol), count(long), count() from 'test-import-num-prefix.csv'");){
                printer.print(rs, (ReaderFactory)env.factory);
            }
            TestUtils.assertEquals((CharSequence)"126\t126\t128\t129\t129\n", (CharSequence)sink);
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportNumericHeader() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-numeric-headers.csv", "http://localhost:9000/imp?name=test-import.csv&overwrite=true&durable=true&forceHeader=true", null, null));
            printer.print(qc.compile(this.getFactory(), (CharSequence)"select count() from 'test-import.csv'"), (ReaderFactory)this.getFactory());
            TestUtils.assertEquals((CharSequence)"2\n", (CharSequence)sink);
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportOverwrite() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration();
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = configuration;
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp", null, null));
            printer.print(qc.compile(this.getFactory(), (CharSequence)"select count() from 'test-import.csv'"), (ReaderFactory)this.getFactory());
            TestUtils.assertEquals((CharSequence)"129\n", (CharSequence)sink);
            sink.clear();
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-headers.csv", "http://localhost:9000/imp?name=test-import.csv&overwrite=true&durable=true", null, null));
            printer.print(qc.compile(this.getFactory(), (CharSequence)"select count() from 'test-import.csv'"), (ReaderFactory)this.getFactory());
            TestUtils.assertEquals((CharSequence)"5\n", (CharSequence)sink);
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportUnknownFormat() {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        StringBuilder response = new StringBuilder();
        try {
            Assert.assertEquals((long)400L, (long)HttpTestUtils.upload("/com/questdb/std/AssociativeCache.class", "http://localhost:9000/imp", null, response));
            TestUtils.assertEquals((CharSequence)"Unsupported Data Format", response);
        }
        catch (IOException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("Connection reset"));
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportUtf8() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import-utf8.csv", "http://localhost:9000/imp?overwrite=true&durable=true", null, null));
            printer.print(qc.compile(this.getFactory(), (CharSequence)"'test-import-utf8.csv'"), (ReaderFactory)this.getFactory());
            TestUtils.assertEquals((CharSequence)"\u0430\u0432\u0433\t\u0430\u0432\u0433\n", (CharSequence)sink);
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportWrongType() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.dateLocaleFactory = DateLocaleFactory.INSTANCE;
        env.dateFormatFactory = DATE_FORMAT_FACTORY;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp?fmt=json", "[{\"name\":\"IsoDate\", \"type\":\"DATE\"}, {\"name\":\"IntCol\", \"type\":\"DOUBLE\"}]", null));
            Assert.assertEquals((long)200L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp", "[{\"name\":\"IsoDate\", \"type\":\"DATE\"}]", null));
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            RecordSource src1 = qc.compile(env.factory, (CharSequence)"select count(StrSym), count(IntSym), count(IntCol), count(long), count() from 'test-import.csv'");
            try {
                printer.print(src1, (ReaderFactory)env.factory);
                TestUtils.assertEquals((CharSequence)"252\t252\t256\t258\t258\n", (CharSequence)sink);
            }
            finally {
                Misc.free((Object)src1);
            }
            RecordSource src2 = qc.compile(env.factory, (CharSequence)"'test-import.csv'");
            try {
                Assert.assertEquals((long)6L, (long)src2.getMetadata().getColumn((CharSequence)"IntCol").getType());
            }
            finally {
                Misc.free((Object)src2);
            }
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testImportWrongTypeStrictAtomicity() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.factory = this.getFactory();
        env.typeProbeCollection = TYPE_PROBE_COLLECTION;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/imp", new ImportHandler(env));
            }
        };
        env.dateLocaleFactory = DateLocaleFactory.INSTANCE;
        env.dateFormatFactory = DATE_FORMAT_FACTORY;
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            Assert.assertEquals((long)400L, (long)HttpTestUtils.upload("/csv/test-import.csv", "http://localhost:9000/imp?atomicity=strict", "[{\"name\":\"IsoDate\", \"type\":\"DATE\"}, {\"name\":\"IntCol\", \"type\":\"DATE\"}]", null));
            StringSink sink = new StringSink();
            RecordSourcePrinter printer = new RecordSourcePrinter((CharSink)sink);
            QueryCompiler qc = new QueryCompiler(env);
            RecordSource src1 = qc.compile(env.factory, (CharSequence)"select count() from 'test-import.csv'");
            try {
                printer.print(src1, (ReaderFactory)env.factory);
                TestUtils.assertEquals((CharSequence)"0\n", (CharSequence)sink);
            }
            finally {
                Misc.free((Object)src1);
            }
        }
        finally {
            server.halt();
        }
    }

    @Test
    public void testLargeChunkedPlainDownload() throws Exception {
        int count = 3;
        int sz = 16809980;
        ServerConfiguration conf = new ServerConfiguration();
        conf.setHttpBufRespContent(0x1008000);
        TestUtils.assertEquals(this.generateLarge(3, 16809980), this.downloadChunked(conf, 3, 16809980, false, false));
    }

    @Test
    public void testLargeChunkedPlainGzipDownload() throws Exception {
        int count = 3;
        int sz = 16809980;
        ServerConfiguration conf = new ServerConfiguration();
        conf.setHttpBufRespContent(0x1008000);
        TestUtils.assertEquals(this.generateLarge(3, 16809980), this.downloadChunked(conf, 3, 16809980, false, true));
    }

    @Test
    public void testLargeChunkedSSLDownload() throws Exception {
        int count = 3;
        int sz = 16809980;
        ServerConfiguration configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        configuration.getSslConfig().setSecure(true);
        configuration.getSslConfig().setKeyStore((InputStream)new FileInputStream(HttpServerTest.resourceFile("/keystore/singlekey.ks")), "changeit");
        configuration.setHttpBufRespContent(0x1008000);
        TestUtils.assertEquals(this.generateLarge(3, 16809980), this.downloadChunked(configuration, 3, 16809980, true, false));
    }

    @Test
    public void testLargeChunkedSSLGzipDownload() throws Exception {
        int count = 3;
        int sz = 16809980;
        ServerConfiguration configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        configuration.getSslConfig().setSecure(true);
        configuration.getSslConfig().setKeyStore((InputStream)new FileInputStream(HttpServerTest.resourceFile("/keystore/singlekey.ks")), "changeit");
        configuration.setHttpBufRespContent(0x1008000);
        TestUtils.assertEquals(this.generateLarge(3, 16809980), this.downloadChunked(configuration, 3, 16809980, true, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxConnections() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = configuration;
        env.configuration.setHttpMaxConnections(1);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        try {
            Assert.assertNotNull((Object)HttpServerTest.clientBuilder(true).build().execute((HttpUriRequest)new HttpGet("https://localhost:9000/upload.html")));
            try {
                HttpServerTest.clientBuilder(true).build().execute((HttpUriRequest)new HttpGet("https://localhost:9000/upload.html"));
                Assert.fail((String)"Expected server to reject connection");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        finally {
            server.halt();
        }
    }

    @Test
    public void testNativeConcurrentDownload() throws Exception {
        ServerConfiguration configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = configuration;
        env.configuration.getSslConfig().setSecure(false);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        this.assertConcurrentDownload(server, "http");
    }

    @Test
    public void testNativeNotModified() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        env.configuration.getSslConfig().setSecure(false);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        this.assertNotModified(new HttpServer(env));
    }

    @Test
    @Ignore
    public void testRangesNative() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration(new File(HttpServerTest.class.getResource("/site").getPath(), "conf/questdb.conf")){

            public File getHttpPublic() {
                return HttpServerTest.this.temp.getRoot();
            }
        };
        env.configuration.setHttpThreads(1);
        env.configuration.setHttpSoRetries(10);
        env.configuration.getSslConfig().setSecure(false);
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/upload", new UploadHandler(env.configuration.getHttpPublic()));
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        this.assertRanges(new HttpServer(env));
    }

    @Test
    public void testSslConcurrentDownload() throws Exception {
        final BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration(new File(HttpServerTest.resourceFile("/site"), "conf/questdb.conf"));
        env.configuration.getSslConfig().setSecure(true);
        env.configuration.getSslConfig().setKeyStore((InputStream)new FileInputStream(HttpServerTest.resourceFile("/keystore/singlekey.ks")), "changeit");
        env.matcher = new SimpleUrlMatcher(){
            {
                this.setDefaultHandler((ContextHandler)new StaticContentHandler(env));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        this.assertConcurrentDownload(server, "https");
    }

    @Test
    public void testStartStop() {
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.matcher = new SimpleUrlMatcher();
        HttpServer server = new HttpServer(env);
        server.start();
        server.halt();
    }

    @Test
    public void testUpload() throws Exception {
        final File dir = this.temp.newFolder();
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = new ServerConfiguration();
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/upload", new UploadHandler(dir));
            }
        };
        HttpServer server = new HttpServer(env);
        server.start();
        File expected = HttpServerTest.resourceFile("/csv/test-import.csv");
        File actual = new File(dir, "test-import.csv");
        HttpServerTest.upload(expected);
        TestUtils.assertEquals(expected, actual);
        server.halt();
    }

    private static HttpClientBuilder clientBuilder(boolean ssl) throws Exception {
        return ssl ? HttpServerTest.createHttpClient_AcceptsUntrustedCerts() : HttpClientBuilder.create();
    }

    private static HttpClientBuilder createHttpClient_AcceptsUntrustedCerts() throws Exception {
        HttpClientBuilder b = HttpClientBuilder.create();
        SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (arg0, arg1) -> true).build();
        b.setSSLContext(sslContext);
        SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (s, sslSession) -> true);
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)sslSocketFactory).build();
        b.setConnectionManager((HttpClientConnectionManager)new PoolingHttpClientConnectionManager(socketFactoryRegistry));
        return b;
    }

    private static File resourceFile(String resource) {
        return new File(HttpServerTest.class.getResource(resource).getFile());
    }

    private static void upload(File file) throws IOException {
        HttpPost post = new HttpPost("http://localhost:9000/upload");
        try (CloseableHttpClient client = HttpClients.createDefault();){
            MultipartEntityBuilder b = MultipartEntityBuilder.create();
            b.addPart("data", (ContentBody)new FileBody(file));
            post.setEntity(b.build());
            client.execute((HttpUriRequest)post);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertConcurrentDownload(HttpServer server, String proto) throws InterruptedException, IOException {
        try {
            File actual1 = new File(this.temp.getRoot(), "get.html");
            File actual2 = new File(this.temp.getRoot(), "post.html");
            File actual3 = new File(this.temp.getRoot(), "upload.html");
            CyclicBarrier barrier = new CyclicBarrier(3);
            CountDownLatch haltLatch = new CountDownLatch(3);
            AtomicInteger counter = new AtomicInteger(0);
            new Thread(() -> {
                try {
                    barrier.await();
                    HttpTestUtils.download(HttpServerTest.clientBuilder("https".equals(proto)), proto + "://localhost:9000/get.html", actual1);
                }
                catch (Exception e) {
                    counter.incrementAndGet();
                    e.printStackTrace();
                }
                finally {
                    haltLatch.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    barrier.await();
                    HttpTestUtils.download(HttpServerTest.clientBuilder("https".equals(proto)), proto + "://localhost:9000/post.html", actual2);
                }
                catch (Exception e) {
                    counter.incrementAndGet();
                    e.printStackTrace();
                }
                finally {
                    haltLatch.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    barrier.await();
                    HttpTestUtils.download(HttpServerTest.clientBuilder("https".equals(proto)), proto + "://localhost:9000/upload.html", actual3);
                }
                catch (Exception e) {
                    counter.incrementAndGet();
                    e.printStackTrace();
                }
                finally {
                    haltLatch.countDown();
                }
            }).start();
            haltLatch.await();
            Assert.assertEquals((long)0L, (long)counter.get());
            TestUtils.assertEquals(new File(HttpServerTest.class.getResource("/site/public/get.html").getPath()), actual1);
            TestUtils.assertEquals(new File(HttpServerTest.class.getResource("/site/public/post.html").getPath()), actual2);
            TestUtils.assertEquals(new File(HttpServerTest.class.getResource("/site/public/upload.html").getPath()), actual3);
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNotModified(HttpServer server) throws IOException {
        server.start();
        try {
            File out = new File(this.temp.getRoot(), "get.html");
            HttpGet get = new HttpGet("http://localhost:9000/get.html");
            try (CloseableHttpClient client = HttpClients.createDefault();){
                Header h;
                try (CloseableHttpResponse r = client.execute((HttpUriRequest)get);
                     FileOutputStream fos = new FileOutputStream(out);){
                    HttpTestUtils.copy(r.getEntity().getContent(), fos);
                    Assert.assertEquals((long)200L, (long)r.getStatusLine().getStatusCode());
                    h = HttpTestUtils.findHeader("ETag", r.getAllHeaders());
                }
                Assert.assertNotNull((Object)h);
                get.addHeader("If-None-Match", h.getValue());
                r = client.execute((HttpUriRequest)get);
                var8_7 = null;
                try {
                    Assert.assertEquals((long)304L, (long)r.getStatusLine().getStatusCode());
                }
                catch (Throwable throwable) {
                    var8_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (r != null) {
                        if (var8_7 != null) {
                            try {
                                r.close();
                            }
                            catch (Throwable throwable) {
                                var8_7.addSuppressed(throwable);
                            }
                        } else {
                            r.close();
                        }
                    }
                }
            }
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertRanges(HttpServer server) throws IOException {
        server.start();
        try {
            HttpTestUtils.upload("/large.csv", "http://localhost:9000/upload", null, null);
            File out = new File(this.temp.getRoot(), "out.csv");
            HttpGet get = new HttpGet("http://localhost:9000/large.csv?attachment");
            get.addHeader("Range", "xyz");
            try (CloseableHttpClient client = HttpClients.createDefault();){
                long size;
                try (CloseableHttpResponse r = client.execute((HttpUriRequest)get);){
                    Assert.assertEquals((long)416L, (long)r.getStatusLine().getStatusCode());
                }
                File f = HttpServerTest.resourceFile("/large.csv");
                try (FileInputStream is = new FileInputStream(f);){
                    size = is.available();
                }
                long part = size / 2L;
                try (FileOutputStream fos = new FileOutputStream(out);){
                    get.addHeader("Range", "bytes=0-" + part);
                    try (CloseableHttpResponse r = client.execute((HttpUriRequest)get);){
                        HttpTestUtils.copy(r.getEntity().getContent(), fos);
                        Assert.assertEquals((long)206L, (long)r.getStatusLine().getStatusCode());
                    }
                    get.addHeader("Range", "bytes=" + part + "-");
                    r = client.execute((HttpUriRequest)get);
                    var14_27 = null;
                    try {
                        HttpTestUtils.copy(r.getEntity().getContent(), fos);
                        Assert.assertEquals((long)206L, (long)r.getStatusLine().getStatusCode());
                    }
                    catch (Throwable throwable) {
                        var14_27 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (r != null) {
                            if (var14_27 != null) {
                                try {
                                    r.close();
                                }
                                catch (Throwable throwable) {
                                    var14_27.addSuppressed(throwable);
                                }
                            } else {
                                r.close();
                            }
                        }
                    }
                }
                TestUtils.assertEquals(f, out);
            }
        }
        finally {
            server.halt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File downloadChunked(ServerConfiguration conf, final int count, final int sz, boolean ssl, final boolean compressed) throws Exception {
        BootstrapEnv env = new BootstrapEnv();
        env.configuration = conf;
        env.matcher = new SimpleUrlMatcher(){
            {
                this.put("/test", new ContextHandler(){
                    private int counter = -1;

                    public void handle(IOContext context) throws IOException {
                        ChunkedResponse r = context.chunkedResponse();
                        r.setCompressed(compressed);
                        r.status(200, (CharSequence)"text/plain; charset=utf-8");
                        r.sendHeader();
                        this.counter = -1;
                        this.resume(context);
                    }

                    public void resume(IOContext context) throws IOException {
                        ChunkedResponse r = context.chunkedResponse();
                        for (int i = this.counter + 1; i < count; ++i) {
                            this.counter = i;
                            try {
                                for (int k = 0; k < sz; ++k) {
                                    Numbers.append((CharSink)r, (int)i);
                                }
                                r.put((CharSequence)"\r\n");
                            }
                            catch (ResponseContentBufferTooSmallException ignore) {
                                LOG.error().$((CharSequence)"Response content buffer is too small").$();
                            }
                            r.sendChunk();
                        }
                        r.done();
                    }

                    public void setupThread() {
                    }
                });
            }
        };
        HttpServer server = new HttpServer(env);
        File out = this.temp.newFile();
        server.start();
        try {
            HttpTestUtils.download(HttpServerTest.clientBuilder(ssl), (ssl ? "https" : "http") + "://localhost:9000/test", out);
        }
        finally {
            server.halt();
        }
        return out;
    }

    private File generateLarge(int count, int sz) throws IOException {
        File file = this.temp.newFile();
        try (FileSink sink = new FileSink(file);){
            for (int i = 0; i < count; ++i) {
                for (int k = 0; k < sz; ++k) {
                    Numbers.append((CharSink)sink, (int)i);
                }
                sink.put((CharSequence)"\r\n");
            }
        }
        return file;
    }

    private SocketChannel openChannel() throws IOException {
        InetSocketAddress address = new InetSocketAddress("localhost", 9000);
        NetworkChannel channel = SocketChannel.open().setOption((SocketOption)StandardSocketOptions.TCP_NODELAY, Boolean.TRUE);
        ((AbstractSelectableChannel)((Object)channel)).configureBlocking(false);
        try {
            ((SocketChannel)channel).connect(address);
            long t = System.currentTimeMillis();
            while (!((SocketChannel)channel).finishConnect()) {
                LockSupport.parkNanos(500000L);
                if (System.currentTimeMillis() - t <= 5000L) continue;
                throw new IOException("Connection timeout");
            }
            ((AbstractSelectableChannel)((Object)channel)).configureBlocking(true);
            return channel;
        }
        catch (IOException e) {
            ((AbstractInterruptibleChannel)((Object)channel)).close();
            throw e;
        }
    }
}

