/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.net.ha.MockByteChannel;
import com.questdb.net.ha.comsumer.VariableColumnDeltaConsumer;
import com.questdb.net.ha.producer.VariableColumnDeltaProducer;
import com.questdb.std.ex.JournalException;
import com.questdb.store.MemoryFile;
import com.questdb.store.VariableColumn;
import java.io.File;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class VariableColumnTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    private MemoryFile file;
    private MemoryFile file2;
    private MemoryFile indexFile;
    private MemoryFile indexFile2;
    private MockByteChannel channel;

    @After
    public void cleanup() {
        this.file.close();
        this.file2.close();
        this.indexFile.close();
        this.indexFile2.close();
    }

    @Before
    public void setUp() throws JournalException {
        this.file = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col.d"), 22, 2, false);
        this.file2 = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col2.d"), 18, 2, false);
        this.indexFile = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col.i"), 22, 2, false);
        this.indexFile2 = new MemoryFile(new File(this.temporaryFolder.getRoot(), "col2.i"), 18, 2, false);
        this.channel = new MockByteChannel();
    }

    @Test
    public void testConsumerEqualToProducer() {
        int i;
        VariableColumn col1 = new VariableColumn(this.file, this.indexFile);
        VariableColumn col2 = new VariableColumn(this.file2, this.indexFile2);
        VariableColumnDeltaProducer producer = new VariableColumnDeltaProducer(col1);
        int max = 150000;
        for (i = 0; i < max; ++i) {
            col1.putStr((CharSequence)("test123" + (max - i)));
            col1.commit();
        }
        for (i = 0; i < max; ++i) {
            col2.putStr((CharSequence)("test123" + (max - i)));
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertFalse((boolean)producer.hasContent());
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((Object)("test123" + (max - i)), (Object)col2.getStr((long)i));
        }
    }

    @Test
    public void testConsumerLargerThanProducer() {
        int i;
        VariableColumn col1 = new VariableColumn(this.file, this.indexFile);
        VariableColumn col2 = new VariableColumn(this.file2, this.indexFile2);
        VariableColumnDeltaProducer producer = new VariableColumnDeltaProducer(col1);
        int max = 150000;
        for (i = 0; i < max - 50000; ++i) {
            col1.putStr((CharSequence)("test123" + (max - i)));
            col1.commit();
        }
        for (i = 0; i < max; ++i) {
            col2.putStr((CharSequence)("test123" + (max - i)));
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertFalse((boolean)producer.hasContent());
    }

    @Test
    public void testConsumerReset() throws Exception {
        int i;
        VariableColumn col1 = new VariableColumn(this.file, this.indexFile);
        VariableColumn col2 = new VariableColumn(this.file2, this.indexFile2);
        VariableColumnDeltaConsumer consumer = new VariableColumnDeltaConsumer(col2);
        VariableColumnDeltaProducer producer = new VariableColumnDeltaProducer(col1);
        int max = 150000;
        for (i = 0; i < max; ++i) {
            col1.putStr((CharSequence)("test123" + (max - i)));
            col1.commit();
        }
        for (i = 0; i < max - 50000; ++i) {
            col2.putStr((CharSequence)("test123" + (max - i)));
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < 1000; ++i) {
            col1.putStr((CharSequence)("test123" + (max + 1000 - i)));
            col1.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((Object)("test123" + (max - i)), (Object)col2.getStr((long)i));
        }
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((Object)("test123" + (max + 1000 - i)), (Object)col2.getStr((long)(i + max)));
        }
    }

    @Test
    public void testConsumerSmallerThanProducer() throws Exception {
        int i;
        VariableColumn col1 = new VariableColumn(this.file, this.indexFile);
        VariableColumn col2 = new VariableColumn(this.file2, this.indexFile2);
        VariableColumnDeltaConsumer consumer = new VariableColumnDeltaConsumer(col2);
        VariableColumnDeltaProducer producer = new VariableColumnDeltaProducer(col1);
        int max = 150000;
        for (i = 0; i < max; ++i) {
            col1.putStr((CharSequence)("test123" + (max - i)));
            col1.commit();
        }
        for (i = 0; i < max - 50000; ++i) {
            col2.putStr((CharSequence)("test123" + (max - i)));
            col2.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((Object)("test123" + (max - i)), (Object)col2.getStr((long)i));
        }
    }

    @Test
    public void testEmptyConsumerAndPopulatedProducer() throws Exception {
        int i;
        VariableColumn col1 = new VariableColumn(this.file, this.indexFile);
        VariableColumn col2 = new VariableColumn(this.file2, this.indexFile2);
        VariableColumnDeltaConsumer consumer = new VariableColumnDeltaConsumer(col2);
        VariableColumnDeltaProducer producer = new VariableColumnDeltaProducer(col1);
        int max = 150000;
        for (i = 0; i < max; ++i) {
            col1.putStr((CharSequence)("test123" + (max - i)));
            col1.commit();
        }
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)col1.size(), (long)col2.size());
        for (i = 0; i < max; ++i) {
            Assert.assertEquals((Object)("test123" + (max - i)), (Object)col2.getStr((long)i));
        }
    }

    @Test
    public void testEmptyConsumerAndProducer() {
        VariableColumn col1 = new VariableColumn(this.file, this.indexFile);
        VariableColumn col2 = new VariableColumn(this.file2, this.indexFile2);
        VariableColumnDeltaProducer producer = new VariableColumnDeltaProducer(col1);
        producer.configure(col2.size(), col1.size());
        Assert.assertFalse((boolean)producer.hasContent());
        Assert.assertEquals((long)col1.size(), (long)col2.size());
    }

    @Test
    public void testNulls() throws Exception {
        VariableColumn col1 = new VariableColumn(this.file, this.indexFile);
        VariableColumn col2 = new VariableColumn(this.file2, this.indexFile2);
        VariableColumnDeltaConsumer consumer = new VariableColumnDeltaConsumer(col2);
        VariableColumnDeltaProducer producer = new VariableColumnDeltaProducer(col1);
        col1.putNull();
        col1.commit();
        producer.configure(col2.size(), col1.size());
        Assert.assertTrue((boolean)producer.hasContent());
        producer.write((WritableByteChannel)this.channel);
        consumer.read((ReadableByteChannel)this.channel);
        col2.commit();
        Assert.assertEquals((long)1L, (long)col1.size());
        Assert.assertEquals((long)1L, (long)col2.size());
    }
}

