/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.net.ha.config.ServerNode;
import com.questdb.store.JournalRuntimeException;
import org.junit.Assert;
import org.junit.Test;

public class ServerNodeTest {
    @Test(expected=JournalRuntimeException.class)
    public void testAddressValidation() {
        new ServerNode(0, "192.168:x");
    }

    @Test
    public void testHostAndPort() {
        ServerNode node = new ServerNode(0, "github.questdb.org:8080");
        Assert.assertEquals((Object)"github.questdb.org", (Object)node.getHostname());
        Assert.assertEquals((long)8080L, (long)node.getPort());
    }

    @Test
    public void testIPv4() {
        ServerNode node = new ServerNode(0, "192.168.1.10");
        Assert.assertEquals((Object)"192.168.1.10", (Object)node.getHostname());
    }

    @Test
    public void testIPv4AndPort() {
        ServerNode node = new ServerNode(0, "192.168.1.10:8080");
        Assert.assertEquals((Object)"192.168.1.10", (Object)node.getHostname());
        Assert.assertEquals((long)8080L, (long)node.getPort());
    }

    @Test
    public void testIPv6() {
        ServerNode node = new ServerNode(0, "[fe80::5fc:43c:eef0:5b8e%3]");
        Assert.assertEquals((Object)"fe80::5fc:43c:eef0:5b8e%3", (Object)node.getHostname());
    }

    @Test
    public void testIPv6AndPort() {
        ServerNode node = new ServerNode(0, "[fe80::5fc:43c:eef0:5b8e%3]:7090");
        Assert.assertEquals((Object)"fe80::5fc:43c:eef0:5b8e%3", (Object)node.getHostname());
        Assert.assertEquals((long)7090L, (long)node.getPort());
    }
}

