/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.JournalClient;
import com.questdb.net.ha.JournalServer;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.store.Journal;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.WriterFactory;
import com.questdb.store.factory.configuration.JournalConfigurationBuilder;
import com.questdb.test.tools.FactoryContainer;
import com.questdb.test.tools.TestUtils;
import java.io.InputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class SSLTest {
    @Rule
    public final FactoryContainer factoryContainer = new FactoryContainer(new JournalConfigurationBuilder(){
        {
            this.$(Quote.class).recordCountHint(2000).$sym("sym").valueCountHint(20).$sym("mode").$sym("ex");
        }
    });

    @After
    public void tearDown() {
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyWriterCount());
        Assert.assertEquals((long)0L, (long)this.getFactory().getBusyReaderCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testAuthBothCertsMissing() throws Exception {
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote");){
            JournalServer server = new JournalServer(new ServerConfig(){
                {
                    this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                    this.getSslConfig().setSecure(true);
                    this.getSslConfig().setRequireClientAuth(true);
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                        this.getSslConfig().setKeyStore(is, "changeit");
                    }
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, (ReaderFactory)this.getFactory());
            try {
                AtomicInteger serverErrorCount = new AtomicInteger();
                CountDownLatch terminated = new CountDownLatch(1);
                JournalClient client = new JournalClient(new ClientConfig("localhost"){
                    {
                        this.getSslConfig().setSecure(true);
                        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                            this.getSslConfig().setTrustStore(is, "changeit");
                        }
                    }
                }, (WriterFactory)this.getFactory(), null, evt -> {
                    switch (evt) {
                        case 1: {
                            serverErrorCount.incrementAndGet();
                            break;
                        }
                        case 256: {
                            terminated.countDown();
                            break;
                        }
                    }
                });
                server.publish(remote);
                server.start();
                client.subscribe(Quote.class, "remote", "local");
                client.start();
                Assert.assertTrue((boolean)terminated.await(5L, TimeUnit.SECONDS));
                Assert.assertEquals((long)0L, (long)server.getConnectedClients());
                Assert.assertFalse((boolean)client.isRunning());
                Assert.assertEquals((long)1L, (long)serverErrorCount.get());
            }
            finally {
                server.halt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClientAuth() throws Exception {
        int size = 2000;
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote");){
            JournalServer server = new JournalServer(new ServerConfig(){
                {
                    this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                    this.getSslConfig().setSecure(true);
                    this.getSslConfig().setRequireClientAuth(true);
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                        this.getSslConfig().setKeyStore(is, "changeit");
                    }
                    is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");
                    var3_3 = null;
                    try {
                        this.getSslConfig().setTrustStore(is, "changeit");
                    }
                    catch (Throwable throwable) {
                        var3_3 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (var3_3 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    var3_3.addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, (ReaderFactory)this.getFactory());
            try {
                JournalClient client = new JournalClient(new ClientConfig("localhost"){
                    {
                        this.getSslConfig().setSecure(true);
                        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                            this.getSslConfig().setKeyStore(is, "changeit");
                        }
                        is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");
                        var4_4 = null;
                        try {
                            this.getSslConfig().setTrustStore(is, "changeit");
                        }
                        catch (Throwable throwable) {
                            var4_4 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is != null) {
                                if (var4_4 != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable) {
                                        var4_4.addSuppressed(throwable);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                }, (WriterFactory)this.getFactory());
                server.publish(remote);
                server.start();
                client.subscribe(Quote.class, "remote", "local");
                client.start();
                TestUtils.generateQuoteData((JournalWriter<Quote>)remote, size);
                Thread.sleep(1000L);
                client.halt();
                try (Journal local = this.getFactory().reader(Quote.class, "local");){
                    TestUtils.assertDataEquals(remote, local);
                }
            }
            finally {
                server.halt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoCertTrustAllSSL() throws Exception {
        int size = 2000;
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote");){
            JournalServer server = new JournalServer(new ServerConfig(){
                {
                    this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                    this.getSslConfig().setSecure(true);
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                        this.getSslConfig().setKeyStore(is, "changeit");
                    }
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, (ReaderFactory)this.getFactory());
            try {
                JournalClient client = new JournalClient(new ClientConfig("localhost"){
                    {
                        this.getSslConfig().setSecure(true);
                        this.getSslConfig().setTrustAll(true);
                    }
                }, (WriterFactory)this.getFactory());
                server.publish(remote);
                server.start();
                client.subscribe(Quote.class, "remote", "local");
                client.start();
                TestUtils.generateQuoteData((JournalWriter<Quote>)remote, size);
                Thread.sleep(1000L);
                client.halt();
            }
            finally {
                server.halt();
            }
            try (Journal local = this.getFactory().reader(Quote.class, "local");){
                TestUtils.assertDataEquals(remote, local);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNonAuthClientTrustMissing() throws Exception {
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote");){
            JournalServer server = new JournalServer(new ServerConfig(){
                {
                    this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                    this.getSslConfig().setSecure(true);
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                        this.getSslConfig().setKeyStore(is, "changeit");
                    }
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, (ReaderFactory)this.getFactory());
            try {
                AtomicInteger serverErrorCount = new AtomicInteger();
                CountDownLatch terminated = new CountDownLatch(1);
                JournalClient client = new JournalClient(new ClientConfig("localhost"){
                    {
                        this.getSslConfig().setSecure(true);
                    }
                }, (WriterFactory)this.getFactory(), null, evt -> {
                    switch (evt) {
                        case 1: {
                            serverErrorCount.incrementAndGet();
                            break;
                        }
                        case 256: {
                            terminated.countDown();
                            break;
                        }
                    }
                });
                server.publish(remote);
                server.start();
                client.subscribe(Quote.class, "remote", "local");
                client.subscribe(Quote.class, "remote", "local");
                client.start();
                Assert.assertTrue((boolean)terminated.await(5L, TimeUnit.SECONDS));
                Assert.assertFalse((boolean)client.isRunning());
                Assert.assertEquals((long)1L, (long)serverErrorCount.get());
                client.halt();
            }
            finally {
                server.halt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServerTrustMissing() throws Exception {
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote");){
            JournalServer server = new JournalServer(new ServerConfig(){
                {
                    this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                    this.getSslConfig().setSecure(true);
                    this.getSslConfig().setRequireClientAuth(true);
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                        this.getSslConfig().setKeyStore(is, "changeit");
                    }
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, (ReaderFactory)this.getFactory());
            try {
                AtomicInteger serverErrorCount = new AtomicInteger();
                CountDownLatch terminated = new CountDownLatch(1);
                JournalClient client = new JournalClient(new ClientConfig("localhost"){
                    {
                        this.getSslConfig().setSecure(true);
                        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                            this.getSslConfig().setTrustStore(is, "changeit");
                        }
                        is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");
                        var4_4 = null;
                        try {
                            this.getSslConfig().setKeyStore(is, "changeit");
                        }
                        catch (Throwable throwable) {
                            var4_4 = throwable;
                            throw throwable;
                        }
                        finally {
                            if (is != null) {
                                if (var4_4 != null) {
                                    try {
                                        is.close();
                                    }
                                    catch (Throwable throwable) {
                                        var4_4.addSuppressed(throwable);
                                    }
                                } else {
                                    is.close();
                                }
                            }
                        }
                    }
                }, (WriterFactory)this.getFactory(), null, evt -> {
                    switch (evt) {
                        case 1: {
                            serverErrorCount.incrementAndGet();
                            break;
                        }
                        case 256: {
                            terminated.countDown();
                            break;
                        }
                    }
                });
                server.publish(remote);
                server.start();
                client.subscribe(Quote.class, "remote", "local");
                client.start();
                Assert.assertTrue((boolean)terminated.await(5L, TimeUnit.SECONDS));
                Assert.assertFalse((boolean)client.isRunning());
                Assert.assertEquals((long)1L, (long)serverErrorCount.get());
                client.halt();
            }
            finally {
                server.halt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSingleKeySSL() throws Exception {
        int size = 1000;
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote");){
            JournalServer server = new JournalServer(new ServerConfig(){
                {
                    this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(500L));
                    this.getSslConfig().setSecure(true);
                    try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                        this.getSslConfig().setKeyStore(is, "changeit");
                    }
                    this.setEnableMultiCast(false);
                    this.setHeartbeatFrequency(50L);
                }
            }, (ReaderFactory)this.getFactory());
            try {
                JournalClient client = new JournalClient(new ClientConfig("localhost"){
                    {
                        this.setTcpNoDelay(false);
                        try (InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("/keystore/singlekey.ks");){
                            this.getSslConfig().setTrustStore(is, "changeit");
                        }
                        this.getSslConfig().setSecure(true);
                    }
                }, (WriterFactory)this.getFactory());
                server.publish(remote);
                server.start();
                client.subscribe(Quote.class, "remote", "local");
                client.start();
                TestUtils.generateQuoteData((JournalWriter<Quote>)remote, size);
                Thread.sleep(500L);
                client.halt();
                try (Journal local = this.getFactory().reader(Quote.class, "local");){
                    TestUtils.assertDataEquals(remote, local);
                }
            }
            finally {
                server.halt();
            }
        }
    }

    private Factory getFactory() {
        return this.factoryContainer.getFactory();
    }
}

