/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.net.ha;

import com.questdb.model.Quote;
import com.questdb.net.ha.JournalClient;
import com.questdb.net.ha.JournalServer;
import com.questdb.net.ha.config.ClientConfig;
import com.questdb.net.ha.config.ServerConfig;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.JournalListener;
import com.questdb.store.JournalRuntimeException;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.WriterFactory;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class ReconnectTest
extends AbstractTest {
    @Test
    @Ignore
    public void testServerRestart() throws Exception {
        int size = 10000;
        try (JournalWriter remote = this.getFactory().writer(Quote.class, "remote", 20000);){
            JournalServer server = this.newServer();
            server.publish(remote);
            server.start();
            CountDownLatch connectedLatch = new CountDownLatch(1);
            JournalClient client = new JournalClient(new ClientConfig("localhost"){
                {
                    this.getReconnectPolicy().setLoginRetryCount(3);
                    this.getReconnectPolicy().setRetryCount(5);
                    this.getReconnectPolicy().setSleepBetweenRetriesMillis(TimeUnit.SECONDS.toMillis(1L));
                }
            }, (WriterFactory)this.getFactory(), null, evt -> {
                if (evt == 32) {
                    connectedLatch.countDown();
                }
            });
            final CountDownLatch latch = new CountDownLatch(1);
            this.getFactory().writer(Quote.class, "local").close();
            try (final Journal local = this.getFactory().reader(Quote.class, "local");){
                client.subscribe(Quote.class, "remote", "local", 20000, new JournalListener(){

                    public void onCommit() {
                        try {
                            if (local.refresh() && local.size() == 20000L) {
                                latch.countDown();
                            }
                        }
                        catch (JournalException e) {
                            throw new JournalRuntimeException((Throwable)e);
                        }
                    }

                    public void onEvent(int event) {
                    }
                });
                client.start();
                Assert.assertTrue((boolean)connectedLatch.await(5L, TimeUnit.SECONDS));
                TestUtils.generateQuoteData((JournalWriter<Quote>)remote, 10000, System.currentTimeMillis(), 1L);
                remote.commit();
                server.halt();
                server = this.newServer();
                server.publish(remote);
                server.start();
                TestUtils.generateQuoteData((JournalWriter<Quote>)remote, 10000, System.currentTimeMillis() + 20000L, 1L);
                remote.commit();
                latch.await();
                client.halt();
                server.halt();
                TestUtils.assertDataEquals(remote, local);
            }
        }
    }

    private JournalServer newServer() {
        return new JournalServer(new ServerConfig(){
            {
                this.setHeartbeatFrequency(TimeUnit.MILLISECONDS.toMillis(100L));
                this.setEnableMultiCast(false);
            }
        }, (ReaderFactory)this.getFactory());
    }
}

